/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.renderstuffs;

import java.util.Map;
import mrtjp.projectred.multipart.wiring.wires.TileWire;
import mrtjp.projectred.utils.codechicken.core.render.CCModel;
import mrtjp.projectred.utils.codechicken.core.render.IconTransformation;
import mrtjp.projectred.utils.codechicken.core.vec.Rotation;
import mrtjp.projectred.utils.codechicken.core.vec.Transformation;
import mrtjp.projectred.utils.codechicken.core.vec.TransformationList;
import mrtjp.projectred.utils.codechicken.core.vec.Translation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.Icon;

public class WireRenderAssistant {
    public double x;
    public double y;
    public double z;
    public int side;
    public int facing = -1;
    public float xOffset = 0.0f;
    public float yOffset = 0.0f;
    public float zOffset = 0.0f;
    public RenderBlocks renderBlocks;
    public Map model;
    public Icon wireIcon;
    public boolean isCenterCrossed;
    public boolean isCenterNS;
    public boolean isCenterWE;
    public boolean connectsCornerN;
    public boolean connectsCornerS;
    public boolean connectsCornerW;
    public boolean connectsCornerE;
    public boolean connectsInsideN;
    public boolean connectsInsideS;
    public boolean connectsInsideW;
    public boolean connectsInsideE;
    public boolean connectsN;
    public boolean connectsS;
    public boolean connectsW;
    public boolean connectsE;
    public boolean connectsInsideConnectorN;
    public boolean connectsInsideConnectorS;
    public boolean connectsInsideConnectorW;
    public boolean connectsInsideConnectorE;
    public int[][] sideMap = new int[][]{{-1, -1, 2, 3, 5, 4}, {-1, -1, 3, 2, 4, 5}, {-1, -1, 1, 0, 5, 4}, {-1, -1, 0, 1, 4, 5}, {-1, -1, 0, 1, 2, 3}, {-1, -1, 1, 0, 3, 2}};
    public int[] frontMap_NS = new int[]{2, 3, 1, 0, 0, 1};
    public int[] frontMap_WE = new int[]{5, 4, 5, 4, 2, 3};
    public boolean isJacketCenterCrossed;
    public boolean isJacketCenterNS;
    public boolean isJacketCenterWE;
    public boolean isJacketCenterUD;
    public boolean renderFrameEdges;
    public boolean jacketU;
    public boolean jacketD;
    public boolean jacketN;
    public boolean jacketS;
    public boolean jacketW;
    public boolean jacketE;

    public void setWireRenderState(TileWire t) {
        byte sideMask = t.getSideMask();
        this.connectsN = t.connectsInDirection(this.side, this.sideMap[this.side][2]);
        this.connectsS = t.connectsInDirection(this.side, this.sideMap[this.side][3]);
        this.connectsW = t.connectsInDirection(this.side, this.sideMap[this.side][4]);
        this.connectsE = t.connectsInDirection(this.side, this.sideMap[this.side][5]);
        this.isCenterCrossed = this.connectsN && this.connectsW || this.connectsN && this.connectsE || this.connectsS && this.connectsW || this.connectsS && this.connectsE;
        this.isCenterNS = !this.isCenterCrossed && (this.connectsN || this.connectsS) || !this.connectsN && !this.connectsS && !this.connectsW && !this.connectsE;
        this.isCenterWE = !this.isCenterCrossed && (this.connectsW || this.connectsE);
        this.connectsCornerN = this.side != 0 && this.side != 1 && t.connectsInDirectionAroundCorner(this.side, this.sideMap[this.side][2]);
        this.connectsCornerS = this.side != 0 && this.side != 1 && t.connectsInDirectionAroundCorner(this.side, this.sideMap[this.side][3]);
        this.connectsCornerW = this.side != 0 && this.side != 1 && t.connectsInDirectionAroundCorner(this.side, this.sideMap[this.side][4]);
        this.connectsCornerE = this.side != 0 && this.side != 1 && this.side != 2 && this.side != 3 && this.side != 4 && this.side != 5 && t.connectsInDirectionAroundCorner(this.side, this.sideMap[this.side][5]);
        this.connectsInsideN = (sideMask & 1 << this.sideMap[this.side][2]) != 0;
        this.connectsInsideS = (sideMask & 1 << this.sideMap[this.side][3]) != 0;
        this.connectsInsideW = (sideMask & 1 << this.sideMap[this.side][4]) != 0;
        this.connectsInsideE = (sideMask & 1 << this.sideMap[this.side][5]) != 0;
        this.connectsInsideConnectorN = this.isCenterCrossed && this.connectsN || this.isCenterNS;
        this.connectsInsideConnectorS = this.isCenterCrossed && this.connectsS || this.isCenterNS;
        this.connectsInsideConnectorW = this.isCenterCrossed && this.connectsW || this.isCenterWE;
        this.connectsInsideConnectorE = this.isCenterCrossed && this.connectsE || this.isCenterWE;
    }

    public void pushRender() {
        if (this.isCenterCrossed) {
            if (this.side == 1 || this.side == 3 || this.side == 4) {
                this.renderModelWE((CCModel)this.model.get("center_X"));
            } else {
                this.renderModelNS((CCModel)this.model.get("center_X"));
            }
        } else if (this.isCenterNS) {
            this.renderModelNS((CCModel)this.model.get("center_PN"));
        } else if (this.isCenterWE) {
            this.renderModelWE((CCModel)this.model.get("center_PN"));
        }
        if (this.connectsInsideConnectorN) {
            this.renderModelNS((CCModel)this.model.get("insideconnector_N"));
        }
        if (this.connectsInsideConnectorS) {
            this.renderModelNS((CCModel)this.model.get("insideconnector_P"));
        }
        if (this.connectsInsideConnectorW) {
            this.renderModelWE((CCModel)this.model.get("insideconnector_N"));
        }
        if (this.connectsInsideConnectorE) {
            this.renderModelWE((CCModel)this.model.get("insideconnector_P"));
        }
        if (this.connectsN) {
            if (this.connectsInsideN) {
                this.renderModelNS((CCModel)this.model.get("inin_N"));
            } else {
                this.renderModelNS((CCModel)this.model.get("inout_N"));
            }
        }
        if (this.connectsS) {
            if (this.connectsInsideS) {
                this.renderModelNS((CCModel)this.model.get("inin_P"));
            } else {
                this.renderModelNS((CCModel)this.model.get("inout_P"));
            }
        }
        if (this.connectsW) {
            if (this.connectsInsideW) {
                this.renderModelWE((CCModel)this.model.get("inin_N"));
            } else {
                this.renderModelWE((CCModel)this.model.get("inout_N"));
            }
        }
        if (this.connectsE) {
            if (this.connectsInsideE) {
                this.renderModelWE((CCModel)this.model.get("inin_P"));
            } else {
                this.renderModelWE((CCModel)this.model.get("inout_P"));
            }
        }
        if (this.connectsCornerN) {
            this.renderModelNS((CCModel)this.model.get("outsideconnector_N"));
        }
        if (this.connectsCornerS) {
            this.renderModelNS((CCModel)this.model.get("outsideconnector_P"));
        }
        if (this.connectsCornerW) {
            this.renderModelWE((CCModel)this.model.get("outsideconnector_N"));
        }
        if (this.connectsCornerE) {
            this.renderModelWE((CCModel)this.model.get("outsideconnector_P"));
        }
    }

    private void renderModelNS(CCModel cc) {
        if (cc == null) {
            System.out.println("Wire model is currupt or missing.");
            return;
        }
        TransformationList t = new TransformationList(new Transformation[0]);
        t.with(new Translation(0.5 + (double)this.xOffset, 0.0f + this.yOffset, 0.5 + (double)this.zOffset)).with(Rotation.getForSideFacing(this.side, this.facing > -1 ? this.facing : this.frontMap_NS[this.side])).with(new Translation(this.x, this.y, this.z));
        cc.render(0, cc.verts.length, t, new IconTransformation(this.renderBlocks != null && this.renderBlocks.field_78664_d != null ? this.renderBlocks.field_78664_d : this.wireIcon), null);
    }

    private void renderModelWE(CCModel cc) {
        if (cc == null) {
            System.out.println("Wire model is currupt or missing.");
            return;
        }
        TransformationList t = new TransformationList(new Transformation[0]);
        t.with(new Translation(0.5 + (double)this.xOffset, 0.0f + this.yOffset, 0.5 + (double)this.zOffset)).with(Rotation.getForSideFacing(this.side, this.facing > -1 ? this.facing : this.frontMap_WE[this.side])).with(new Translation(this.x, this.y, this.z));
        cc.render(0, cc.verts.length, t, new IconTransformation(this.renderBlocks != null && this.renderBlocks.field_78664_d != null ? this.renderBlocks.field_78664_d : this.wireIcon), null);
    }

    public void setJacketRender(TileWire t) {
        this.jacketD = t.wireConnectsInDirection(-1, 0);
        this.jacketU = t.wireConnectsInDirection(-1, 1);
        this.jacketN = t.wireConnectsInDirection(-1, 3);
        this.jacketS = t.wireConnectsInDirection(-1, 2);
        this.jacketW = t.wireConnectsInDirection(-1, 5);
        this.jacketE = t.wireConnectsInDirection(-1, 4);
        this.renderFrameEdges = true;
        int connections = 0;
        if (this.jacketD) {
            ++connections;
        }
        if (this.jacketU) {
            ++connections;
        }
        if (this.jacketN) {
            ++connections;
        }
        if (this.jacketS) {
            ++connections;
        }
        if (this.jacketW) {
            ++connections;
        }
        if (this.jacketE) {
            ++connections;
        }
        this.isJacketCenterCrossed = this.jacketD && (this.jacketN || this.jacketS || this.jacketW || this.jacketE) || this.jacketU && (this.jacketN || this.jacketS || this.jacketW || this.jacketE) || this.jacketN && (this.jacketU || this.jacketD || this.jacketW || this.jacketE) || this.jacketS && (this.jacketU || this.jacketD || this.jacketW || this.jacketE) || this.jacketW && (this.jacketN || this.jacketS || this.jacketU || this.jacketD) || this.jacketE && (this.jacketN || this.jacketS || this.jacketU || this.jacketD) || connections < 2;
        this.isJacketCenterUD = !this.isJacketCenterCrossed && this.jacketU && this.jacketD;
        this.isJacketCenterNS = !this.isJacketCenterCrossed && this.jacketN && this.jacketS;
        this.isJacketCenterWE = !this.isJacketCenterCrossed && this.jacketW && this.jacketE;
    }

    public void setInventoryJacketRender() {
        this.jacketE = true;
        this.jacketW = true;
        this.jacketS = true;
        this.jacketN = true;
        this.jacketD = true;
        this.jacketU = true;
        this.isJacketCenterCrossed = true;
        this.renderFrameEdges = false;
    }

    public void pushJacketFrameRender() {
        if (this.isJacketCenterCrossed) {
            this.renderJacketModel((CCModel)this.model.get("frame_center"));
        } else if (this.isJacketCenterUD) {
            this.renderJacketModel((CCModel)this.model.get("frame_center_UD"));
        } else if (this.isJacketCenterNS) {
            this.renderJacketModel((CCModel)this.model.get("frame_center_NS"));
        } else if (this.isJacketCenterWE) {
            this.renderJacketModel((CCModel)this.model.get("frame_center_WE"));
        }
        if (!this.renderFrameEdges) {
            return;
        }
        if (this.jacketU) {
            this.renderJacketModel((CCModel)this.model.get("frame_U"));
        }
        if (this.jacketD) {
            this.renderJacketModel((CCModel)this.model.get("frame_D"));
        }
        if (this.jacketN) {
            this.renderJacketModel((CCModel)this.model.get("frame_N"));
        }
        if (this.jacketS) {
            this.renderJacketModel((CCModel)this.model.get("frame_S"));
        }
        if (this.jacketW) {
            this.renderJacketModel((CCModel)this.model.get("frame_W"));
        }
        if (this.jacketE) {
            this.renderJacketModel((CCModel)this.model.get("frame_E"));
        }
    }

    public void pushJacketWireRender() {
        if (this.isJacketCenterCrossed) {
            this.renderJacketModel((CCModel)this.model.get("wire_center"));
        } else if (this.isJacketCenterUD) {
            this.renderJacketModel((CCModel)this.model.get("wire_center_UD"));
        } else if (this.isJacketCenterNS) {
            this.renderJacketModel((CCModel)this.model.get("wire_center_NS"));
        } else if (this.isJacketCenterWE) {
            this.renderJacketModel((CCModel)this.model.get("wire_center_WE"));
        }
        if (this.jacketU) {
            this.renderJacketModel((CCModel)this.model.get("wire_U"));
        }
        if (this.jacketD) {
            this.renderJacketModel((CCModel)this.model.get("wire_D"));
        }
        if (this.jacketN) {
            this.renderJacketModel((CCModel)this.model.get("wire_N"));
        }
        if (this.jacketS) {
            this.renderJacketModel((CCModel)this.model.get("wire_S"));
        }
        if (this.jacketW) {
            this.renderJacketModel((CCModel)this.model.get("wire_W"));
        }
        if (this.jacketE) {
            this.renderJacketModel((CCModel)this.model.get("wire_E"));
        }
    }

    public void renderJacketModel(CCModel cc) {
        if (cc == null) {
            System.out.println("Wire model is currupt or missing.");
            return;
        }
        TransformationList t = new TransformationList(new Transformation[0]);
        t.with(new Translation(0.5 + (double)this.xOffset, 0.0f + this.yOffset, 0.5 + (double)this.zOffset)).with(new Translation(this.x, this.y, this.z));
        cc.render(0, cc.verts.length, t, new IconTransformation(this.renderBlocks != null && this.renderBlocks.field_78664_d != null ? this.renderBlocks.field_78664_d : this.wireIcon), null);
    }
}

