/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.renderstuffs;

import java.util.Map;
import mrtjp.projectred.blocks.BlockLantern;
import mrtjp.projectred.utils.Color;
import mrtjp.projectred.utils.codechicken.core.render.CCModel;
import mrtjp.projectred.utils.codechicken.core.render.CCRenderState;
import mrtjp.projectred.utils.codechicken.core.vec.InvertX;
import mrtjp.projectred.utils.codechicken.core.vec.Rotation;
import mrtjp.projectred.utils.codechicken.core.vec.Translation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderEngine;
import org.lwjgl.opengl.GL11;

public class LanternModel {
    private Map models = CCModel.parseObjModels("/mods/projectred/textures/obj/lantern.obj", new InvertX());

    public LanternModel() {
        for (CCModel c : this.models.values()) {
            c.computeNormals();
            c.apply(new Translation(0.5, 0.0, 0.5));
        }
    }

    public void bindTextureForColorAndState(int color, boolean on) {
        String base = "/mods/projectred/textures/blocks/";
        String folder = on ? "lanternon/" : "lanternoff/";
        String file = BlockLantern.EnumLantern.get((int)color).unlocalName + (on ? "on" : "off");
        String loc = base + folder + file + ".png";
        CCRenderState.changeTexture(loc);
    }

    protected void bindTextureByName(String par1Str) {
        RenderEngine renderengine = Minecraft.func_71410_x().field_71446_o;
        if (renderengine != null) {
            renderengine.func_98187_b(par1Str);
        }
    }

    public void renderLampBulb(double x, double y, double z, int rotation, boolean isOn) {
        GL11.glPushMatrix();
        CCRenderState.reset();
        CCRenderState.useNormals(true);
        CCRenderState.startDrawing(4);
        ((CCModel)this.models.get("covertop")).copy().apply(new Translation(x, y, z)).render();
        ((CCModel)this.models.get("coverbottom")).copy().apply(new Translation(x, y, z)).render();
        ((CCModel)this.models.get("lamp")).copy().apply(new Translation(x, y, z)).render();
        if (rotation == 0) {
            ((CCModel)this.models.get("standbottom")).copy().apply(new Translation(x, y, z)).render();
            ((CCModel)this.models.get("goldringbottom")).copy().apply(new Translation(x, y, z)).render();
        } else if (rotation == 1) {
            ((CCModel)this.models.get("standtop")).copy().apply(new Translation(x, y, z)).render();
            ((CCModel)this.models.get("goldringtop")).copy().apply(new Translation(x, y, z)).render();
        } else {
            ((CCModel)this.models.get("standside")).copy().apply(Rotation.getForSideFacing(0, rotation)).apply(new Translation(x, y, z)).render();
            ((CCModel)this.models.get("goldringtop")).copy().apply(Rotation.getForSideFacing(0, rotation)).apply(new Translation(x, y, z)).render();
        }
        CCRenderState.draw();
        GL11.glPopMatrix();
    }

    public void renderInventory(double x, double y, double z, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        CCRenderState.reset();
        CCRenderState.useNormals(true);
        CCRenderState.startDrawing(4);
        ((CCModel)this.models.get("covertop")).render();
        ((CCModel)this.models.get("coverbottom")).render();
        ((CCModel)this.models.get("lamp")).render();
        ((CCModel)this.models.get("goldringtop")).render();
        CCRenderState.draw();
        GL11.glPopMatrix();
    }

    public void renderLampShade(double x, double y, double z, int tint) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glColor4f((float)Color.get((int)tint).r, (float)Color.get((int)tint).g, (float)Color.get((int)tint).b, (float)0.6f);
        GL11.glTranslated((double)x, (double)y, (double)z);
        CCRenderState.reset();
        CCRenderState.useNormals(true);
        CCRenderState.startDrawing(4);
        ((CCModel)this.models.get("lampshade")).render();
        CCRenderState.draw();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glDepthMask((boolean)true);
    }
}

