/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.network;

import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mrtjp.projectred.network.abstractpackets.ModernPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;

public class PacketHandler
implements IPacketHandler {
    public static List packetlist;
    public static Map packetmap;

    public static ModernPacket getPacket(Class clazz) {
        return ((ModernPacket)packetmap.get(clazz)).template();
    }

    public PacketHandler() {
        try {
            ArrayList classes = new ArrayList(ClassPath.from((ClassLoader)this.getClass().getClassLoader()).getTopLevelClassesRecursive("mrtjp.projectred.network.packets"));
            Collections.sort(classes, new Comparator(){

                public int compare(ClassPath.ClassInfo o1, ClassPath.ClassInfo o2) {
                    return o1.getSimpleName().compareTo(o2.getSimpleName());
                }
            });
            packetlist = new ArrayList(classes.size());
            packetmap = new HashMap(classes.size());
            int currentid = 0;
            System.out.println("Loading " + classes.size() + " Packets");
            for (ClassPath.ClassInfo c : classes) {
                Class cls = c.load();
                ModernPacket instance = (ModernPacket)cls.getConstructors()[0].newInstance(currentid);
                packetlist.add(instance);
                packetmap.put(cls, instance);
                ++currentid;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        PacketHandler.onPacketData(data, player);
    }

    public static void onPacketData(DataInputStream data, Player player) {
        try {
            int packetID = data.read();
            ModernPacket packet = ((ModernPacket)packetlist.get(packetID)).template();
            packet.readData(data);
            packet.processPacket((EntityPlayer)player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

