/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.wires;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.projectred.multipart.wiring.RotatedRenderer;
import mrtjp.projectred.multipart.wiring.wires.EnumWire;
import mrtjp.projectred.multipart.wiring.wires.TileWire;
import mrtjp.projectred.renderstuffs.RenderIDs;
import mrtjp.projectred.renderstuffs.WireRenderAssistant;
import mrtjp.projectred.utils.BasicRenderUtils;
import mrtjp.projectred.utils.codechicken.core.render.CCRenderState;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;

@SideOnly(value=Side.CLIENT)
public class WireRenderer
implements ISimpleBlockRenderingHandler {
    private RotatedRenderer rt = new RotatedRenderer();
    public static final WireRenderer instance = new WireRenderer();
    private WireRenderAssistant wra = new WireRenderAssistant();

    public void renderWorld(RenderBlocks render, EnumWire type, TileWire wt, int sideMask, boolean renderJacketed) {
        this.wra = new WireRenderAssistant();
        this.wra.x = wt.field_70329_l;
        this.wra.y = wt.field_70330_m;
        this.wra.z = wt.field_70327_n;
        this.wra.renderBlocks = render;
        this.wra.wireIcon = wt.getSpecialIconForRender() == null ? type.wireSprites[0] : wt.getSpecialIconForRender();
        Tessellator.field_78398_a.func_78370_a(255, 255, 255, 255);
        CCRenderState.reset();
        CCRenderState.setBrightness((IBlockAccess)wt.field_70331_k, wt.field_70329_l, wt.field_70330_m, wt.field_70327_n);
        if (wt.hasJacketedWire()) {
            this.wra.model = type.jacketMap;
            this.wra.setJacketRender(wt);
            this.wra.pushJacketFrameRender();
            CCRenderState.setColourOpaque(wt.getVisualWireColour());
            this.wra.pushJacketWireRender();
        }
        this.wra.model = type.wireMap;
        CCRenderState.setColourOpaque(wt.getVisualWireColour());
        for (int i = 0; i < 6; ++i) {
            if ((sideMask & 1 << i) == 0) continue;
            this.wra.side = i;
            this.wra.setWireRenderState(wt);
            this.wra.pushRender();
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks render) {
        TileWire wt = (TileWire)world.func_72796_p(x, y, z);
        EnumWire type = wt.getType();
        if (type == null) {
            return false;
        }
        byte sideMask = wt.getSideMask();
        this.renderWorld(render, type, wt, sideMask, wt.hasJacketedWire());
        return true;
    }

    public void renderInventoryBlock(Block block, int damageValue, int modelID, RenderBlocks render) {
        EnumWire type = EnumWire.WireDamageValues.getType(damageValue);
        if (type == null) {
            return;
        }
        this.wra = new WireRenderAssistant();
        this.wra.z = 0.0;
        this.wra.y = 0.0;
        this.wra.x = 0.0;
        this.wra.renderBlocks = render;
        this.wra.side = 0;
        this.wra.wireIcon = type.wireSprites[0];
        CCRenderState.reset();
        CCRenderState.useNormals(true);
        if (!EnumWire.WireDamageValues.isJacketed(damageValue)) {
            this.wra.model = type.wireMap;
            CCRenderState.startDrawing(7);
            BasicRenderUtils.setFullColor();
            BasicRenderUtils.setFullBrightness();
            CCRenderState.setColourOpaque(type.itemColour);
            this.wra.connectsN = true;
            this.wra.connectsS = true;
            this.wra.connectsW = true;
            this.wra.connectsE = true;
            this.wra.connectsInsideConnectorN = true;
            this.wra.connectsInsideConnectorS = true;
            this.wra.connectsInsideConnectorW = true;
            this.wra.connectsInsideConnectorE = true;
            this.wra.isCenterCrossed = true;
            this.wra.pushRender();
            CCRenderState.draw();
        } else if (EnumWire.WireDamageValues.isJacketed(damageValue)) {
            this.wra.model = type.jacketMap;
            this.wra.setInventoryJacketRender();
            CCRenderState.startDrawing(7);
            BasicRenderUtils.setFullColor();
            BasicRenderUtils.setFullBrightness();
            this.wra.pushJacketFrameRender();
            CCRenderState.setColourOpaque(type.itemColour);
            this.wra.pushJacketWireRender();
            CCRenderState.draw();
        }
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return RenderIDs.renderIdRedwire;
    }
}

