/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.wires;

import java.lang.reflect.Field;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.interfaces.wiring.IRedstoneEmitter;
import mrtjp.projectred.interfaces.wiring.IRedstoneUpdatable;
import mrtjp.projectred.interfaces.wiring.IRedstoneWire;
import mrtjp.projectred.multipart.wiring.CommandDebug;
import mrtjp.projectred.multipart.wiring.wires.TileWire;
import mrtjp.projectred.utils.BasicWireUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileRedAlloy
extends TileWire
implements IRedstoneEmitter,
IRedstoneWire {
    private short MAX_STRENGTH = (short)255;
    private short strength;
    private short strengthFromNonWireBlocks;
    protected boolean syncSignalStrength;
    protected boolean connectToBlockBelow;
    private boolean isUpdatingStrength;
    private boolean recursiveUpdatePending;
    private static boolean dontEmitPower = false;
    private static boolean blockUpdateCausedByAlloyWire = false;
    private static int[] canConnectRedstoneDirectionMap = new int[]{-1, -2, 0, 2, 1, 3};
    private static Field wiresProvidePower = BlockRedstoneWire.class.getDeclaredFields()[0];

    private int updateStrengthFromBlock(int x, int y, int z, int odir, int testside, int newStrength) {
        int thisStrength = this.getInputPowerStrength(this.field_70331_k, x, y, z, odir, testside, true);
        newStrength = Math.max(newStrength, Math.min(thisStrength - 1, this.MAX_STRENGTH));
        if (!this.field_70331_k.field_72995_K) {
            thisStrength = this.getInputPowerStrength(this.field_70331_k, x, y, z, odir, testside, false);
            this.strengthFromNonWireBlocks = (short)Math.max(this.strengthFromNonWireBlocks, Math.min(thisStrength - 1, this.MAX_STRENGTH));
        }
        return newStrength;
    }

    private int getStrengthFromSurroundingBlocks() {
        if (!this.field_70331_k.field_72995_K) {
            this.strengthFromNonWireBlocks = 0;
        }
        int newStrength = 0;
        for (int side = 0; side < 6; ++side) {
            int z;
            int y;
            int x;
            if (this.connectsInDirectionByJacketedWire(side)) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[side];
                x = this.field_70329_l + dir.offsetX;
                y = this.field_70330_m + dir.offsetY;
                z = this.field_70327_n + dir.offsetZ;
                newStrength = this.updateStrengthFromBlock(x, y, z, side ^ 1, -1, newStrength);
            }
            if (!this.isWirePresent(side)) continue;
            if (this.connectToBlockBelow) {
                ForgeDirection wdir = ForgeDirection.VALID_DIRECTIONS[side];
                x = this.field_70329_l + wdir.offsetX;
                y = this.field_70330_m + wdir.offsetY;
                z = this.field_70327_n + wdir.offsetZ;
                short thisStrength = BasicWireUtils.getPowerStrength(this.field_70331_k, x, y, z, wdir.ordinal() ^ 1, -1, false);
                newStrength = Math.max(newStrength, Math.min(thisStrength - 1, this.MAX_STRENGTH));
                if (!this.field_70331_k.field_72995_K) {
                    this.strengthFromNonWireBlocks = (short)Math.max(this.strengthFromNonWireBlocks, Math.min(thisStrength - 1, this.MAX_STRENGTH));
                }
            }
            for (int dir = 0; dir < 6; ++dir) {
                if (!this.connectsInDirection(side, dir)) continue;
                ForgeDirection fdir = ForgeDirection.VALID_DIRECTIONS[dir];
                int x2 = this.field_70329_l + fdir.offsetX;
                int y2 = this.field_70330_m + fdir.offsetY;
                int z2 = this.field_70327_n + fdir.offsetZ;
                int odir = dir ^ 1;
                int testside = side;
                if (this.connectsInDirectionAroundCorner(side, dir)) {
                    fdir = ForgeDirection.VALID_DIRECTIONS[side];
                    x2 += fdir.offsetX;
                    y2 += fdir.offsetY;
                    z2 += fdir.offsetZ;
                    odir = side ^ 1;
                    testside = dir ^ 1;
                }
                newStrength = this.updateStrengthFromBlock(x2, y2, z2, odir, testside, newStrength);
            }
        }
        if (this.field_70331_k.field_72995_K) {
            newStrength = Math.max(newStrength, this.strengthFromNonWireBlocks);
        }
        return newStrength;
    }

    protected int getInputPowerStrength(World worldObj, int x, int y, int z, int dir, int side, boolean countWires) {
        return BasicWireUtils.getPowerStrength(worldObj, x, y, z, dir, side, countWires);
    }

    private void updateConnectedWireSignal() {
        int notifiedSides = 0;
        if (CommandDebug.WIRE_DEBUG_PARTICLES) {
            this.debugEffect_bonemeal();
        }
        for (int side = 0; side < 6; ++side) {
            if (this.connectsInDirectionByJacketedWire(side) && (notifiedSides & 1 << side) == 0) {
                notifiedSides |= 1 << side;
                ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[side];
                int x = this.field_70329_l + fd.offsetX;
                int y = this.field_70330_m + fd.offsetY;
                int z = this.field_70327_n + fd.offsetZ;
                TileEntity t = this.field_70331_k.func_72796_p(x, y, z);
                if (t instanceof TileRedAlloy) {
                    ((TileRedAlloy)t).updateSignal(this);
                }
            }
            for (int dir = 0; dir < 6; ++dir) {
                TileWire t;
                if (!this.connectsInDirection(side, dir)) continue;
                ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[dir];
                int x = this.field_70329_l + fd.offsetX;
                int y = this.field_70330_m + fd.offsetY;
                int z = this.field_70327_n + fd.offsetZ;
                if (this.connectsInDirectionAroundCorner(side, dir)) {
                    fd = ForgeDirection.VALID_DIRECTIONS[side];
                    x += fd.offsetX;
                    y += fd.offsetY;
                    z += fd.offsetZ;
                } else {
                    if ((notifiedSides & 1 << dir) != 0) continue;
                    notifiedSides |= 1 << dir;
                }
                if (this.field_70331_k.func_72798_a(x, y, z) != ProjectRed.blockWire.field_71990_ca || !((t = (TileWire)this.field_70331_k.func_72796_p(x, y, z)) instanceof TileRedAlloy)) continue;
                ((TileRedAlloy)t).updateSignal(this);
            }
        }
    }

    protected void updateSignal(TileRedAlloy source) {
        if (this.field_70331_k.field_72995_K && !this.syncSignalStrength) {
            return;
        }
        if (this.isUpdatingStrength) {
            this.recursiveUpdatePending = true;
            return;
        }
        boolean wasFirstServerChange = !this.field_70331_k.field_72995_K && source == null;
        short oldStrengthFromNonWireBlocks = this.strengthFromNonWireBlocks;
        this.isUpdatingStrength = true;
        short startStrength = this.strength;
        do {
            this.recursiveUpdatePending = false;
            short prevStrength = this.strength;
            this.strength = 0;
            int newStrength = this.getStrengthFromSurroundingBlocks();
            if (newStrength < prevStrength) {
                this.updateConnectedWireSignal();
                newStrength = this.getStrengthFromSurroundingBlocks();
            }
            this.strength = (short)newStrength;
            if (this.strength == prevStrength) continue;
            this.updateConnectedWireSignal();
        } while (this.recursiveUpdatePending);
        this.isUpdatingStrength = false;
        if (this.strength != startStrength) {
            if (!this.field_70331_k.field_72995_K) {
                blockUpdateCausedByAlloyWire = true;
                this.notifyExtendedPowerableNeighbours();
                blockUpdateCausedByAlloyWire = false;
            }
            if (this.syncSignalStrength && (this.field_70331_k.field_72995_K || wasFirstServerChange || this.strengthFromNonWireBlocks != oldStrengthFromNonWireBlocks)) {
                if (!this.field_70331_k.field_72995_K && CommandDebug.WIRE_LAG_PARTICLES) {
                    this.debugEffect_bonemeal();
                }
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        } else if (this.syncSignalStrength && !this.field_70331_k.field_72995_K && oldStrengthFromNonWireBlocks != this.strengthFromNonWireBlocks) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (CommandDebug.WIRE_LAG_PARTICLES) {
                this.debugEffect_bonemeal();
            }
        }
    }

    @Override
    void onNeighbourBlockChange() {
        if (blockUpdateCausedByAlloyWire) {
            return;
        }
        super.onNeighbourBlockChange();
        this.updateSignal(null);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.strength = tag.func_74765_d("strength");
        this.strengthFromNonWireBlocks = tag.func_74765_d("strengthNWB");
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74777_a("strength", this.strength);
        tag.func_74777_a("strengthNWB", this.strengthFromNonWireBlocks);
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        super.onDataPacket(net, pkt);
        if (this.syncSignalStrength) {
            this.strength = pkt.field_73331_e.func_74765_d("_str");
            this.strengthFromNonWireBlocks = pkt.field_73331_e.func_74765_d("_snwb");
        }
        this.updateConnectedWireSignal();
    }

    @Override
    public Packet132TileEntityData getDescriptionPacket() {
        Packet132TileEntityData p = super.getDescriptionPacket();
        if (this.syncSignalStrength) {
            p.field_73331_e.func_74777_a("_str", this.strength);
            p.field_73331_e.func_74777_a("_snwb", this.strengthFromNonWireBlocks);
        }
        return p;
    }

    @Override
    protected boolean connects(int x, int y, int z, int wireSide, int direction) {
        Block b = Block.field_71973_m[this.field_70331_k.func_72798_a(x, y, z)];
        if (b == null) {
            return false;
        }
        if (b.func_71853_i()) {
            return true;
        }
        return direction >= 0 && direction < 6 && canConnectRedstoneDirectionMap[direction] != -2 && b.canConnectRedstone((IBlockAccess)this.field_70331_k, x, y, z, canConnectRedstoneDirectionMap[direction]);
    }

    public short getRedstoneSignalStrength() {
        return dontEmitPower ? (short)0 : this.strength;
    }

    @Override
    public short getEmittedSignalStrength(int side, int dir) {
        return this.connectsInDirection(side, dir) ? this.getRedstoneSignalStrength() : (short)0;
    }

    public boolean canProvideStrongPowerInDirection(int dir) {
        try {
            return this.connectToBlockBelow && this.isWirePresent(dir) && wiresProvidePower.getBoolean(Block.field_72075_av);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void notifyExtendedPowerableNeighbours() {
        boolean any = false;
        for (int k = 0; k < 6; ++k) {
            TileEntity te;
            Block block;
            ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[k];
            int x = this.field_70329_l + fd.offsetX;
            int y = this.field_70330_m + fd.offsetY;
            int z = this.field_70327_n + fd.offsetZ;
            boolean causedBlockUpdate = false;
            if (this.canProvideWeakPowerInDirection(k)) {
                causedBlockUpdate = true;
                this.field_70331_k.func_72821_m(x, y, z, ProjectRed.blockWire.field_71990_ca);
            }
            if (this.canProvideStrongPowerInDirection(k)) {
                causedBlockUpdate = true;
                this.field_70331_k.func_72898_h(x, y, z, ProjectRed.blockWire.field_71990_ca);
            }
            if (!causedBlockUpdate && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(x, y, z)]) != null && block.hasTileEntity(this.field_70331_k.func_72805_g(x, y, z)) && (te = this.field_70331_k.func_72796_p(x, y, z)) instanceof IRedstoneUpdatable) {
                ((IRedstoneUpdatable)te).onRedstoneInputChanged();
            }
            any |= causedBlockUpdate;
        }
        if (this.canProvideWeakPowerInDirection(4)) {
            any = true;
            this.field_70331_k.func_72821_m(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        }
        if (this.canProvideWeakPowerInDirection(5)) {
            any = true;
            this.field_70331_k.func_72821_m(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        }
        if (this.canProvideWeakPowerInDirection(0)) {
            any = true;
            this.field_70331_k.func_72821_m(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        }
        if (this.canProvideWeakPowerInDirection(1)) {
            any = true;
            this.field_70331_k.func_72821_m(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        }
        if (this.canProvideWeakPowerInDirection(2)) {
            any = true;
            this.field_70331_k.func_72821_m(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, ProjectRed.blockWire.field_71990_ca);
        }
        if (this.canProvideWeakPowerInDirection(3)) {
            any = true;
            this.field_70331_k.func_72821_m(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, ProjectRed.blockWire.field_71990_ca);
        }
        if (this.canProvideStrongPowerInDirection(4)) {
            any = true;
            this.field_70331_k.func_72898_h(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        }
        if (this.canProvideStrongPowerInDirection(5)) {
            any = true;
            this.field_70331_k.func_72898_h(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        }
        if (this.canProvideStrongPowerInDirection(0)) {
            any = true;
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        }
        if (this.canProvideStrongPowerInDirection(1)) {
            any = true;
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        }
        if (this.canProvideStrongPowerInDirection(2)) {
            any = true;
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, ProjectRed.blockWire.field_71990_ca);
        }
        if (this.canProvideStrongPowerInDirection(3)) {
            any = true;
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, ProjectRed.blockWire.field_71990_ca);
        }
        if (any && CommandDebug.WIRE_LAG_PARTICLES) {
            this.debugEffect_fireburst();
        }
    }

    public boolean canProvideWeakPowerInDirection(int dir) {
        try {
            if ((this.getSideMask() & ~(1 << (dir ^ 1))) == 0 && !this.hasJacketedWire()) {
                return false;
            }
            return wiresProvidePower.getBoolean(Block.field_72075_av);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte getVanillaRedstoneStrength() {
        return (byte)(this.getRedstoneSignalStrength() / 17);
    }

    @Override
    protected boolean debug(EntityPlayer ply) {
        ply.func_70006_a((this.field_70331_k.field_72995_K ? "Client" : "Server") + " signal strength: " + this.strength + ", nwb: " + this.strengthFromNonWireBlocks);
        super.debug(ply);
        return true;
    }

    @Override
    protected boolean canConnectToWire(TileWire wire) {
        return wire instanceof TileRedAlloy;
    }

    @Override
    public void onRedstoneInputChanged() {
        this.updateSignal(null);
    }

    static {
        try {
            wiresProvidePower.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (wiresProvidePower.getType() != Boolean.TYPE) {
            throw new AssertionError((Object)"field order changed; fix me");
        }
    }
}

