/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.wires;

import mrtjp.projectred.interfaces.wiring.IBundledEmitter;
import mrtjp.projectred.interfaces.wiring.IBundledUpdatable;
import mrtjp.projectred.interfaces.wiring.IInsulatedRedstoneWire;
import mrtjp.projectred.multipart.wiring.wires.EnumWire;
import mrtjp.projectred.multipart.wiring.wires.TileBundled;
import mrtjp.projectred.multipart.wiring.wires.TileRedAlloy;
import mrtjp.projectred.multipart.wiring.wires.TileWire;
import mrtjp.projectred.utils.BasicWireUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class TileInsulatedRedAlloy
extends TileRedAlloy
implements IBundledUpdatable,
IInsulatedRedstoneWire {
    public TileInsulatedRedAlloy() {
        this.syncSignalStrength = true;
    }

    @Override
    protected boolean canConnectToWire(TileWire wire) {
        if (wire.getType() == EnumWire.RED_ALLOY || wire instanceof TileBundled) {
            return true;
        }
        return wire.getType() == this.getType();
    }

    @Override
    public boolean canProvideWeakPowerInDirection(int dir) {
        return this.connectsInDirection(dir) && super.canProvideWeakPowerInDirection(dir);
    }

    @Override
    public boolean canProvideStrongPowerInDirection(int dir) {
        return false;
    }

    @Override
    protected int getInputPowerStrength(World worldObj, int x, int y, int z, int dir, int side, boolean countWires) {
        int rv = BasicWireUtils.getPowerStrength(worldObj, x, y, z, dir, side, countWires);
        if (rv > 0) {
            return rv;
        }
        TileEntity te = worldObj.func_72796_p(x, y, z);
        if (te instanceof IBundledEmitter) {
            int colour = this.getInsulatedWireColour();
            byte[] bcStrengthArray = ((IBundledEmitter)te).getBundledCableStrength(side, dir);
            if (bcStrengthArray != null) {
                int bcStrength = bcStrengthArray[colour] & 0xFF;
                rv = Math.max(rv, bcStrength);
            }
        }
        return rv;
    }

    @Override
    public void onBundledInputChanged() {
        this.updateSignal(null);
    }

    @Override
    public int getInsulatedWireColour() {
        if (this.getType() == null) {
            return 0;
        }
        return this.getType().ordinal() - EnumWire.INSULATED_0.ordinal();
    }

    @Override
    public Icon getSpecialIconForRender() {
        if (this.getRedstoneSignalStrength() > 0) {
            return this.getType().wireSprites[1];
        }
        return this.getType().wireSprites[0];
    }
}

