/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.wires;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mrtjp.projectred.crafting.ProjectRedTabs;
import mrtjp.projectred.multipart.BlockMultipartBase;
import mrtjp.projectred.multipart.wiring.CommandDebug;
import mrtjp.projectred.multipart.wiring.InvalidTile;
import mrtjp.projectred.multipart.wiring.wires.EnumWire;
import mrtjp.projectred.multipart.wiring.wires.TileRedAlloy;
import mrtjp.projectred.multipart.wiring.wires.TileWire;
import mrtjp.projectred.renderstuffs.RenderIDs;
import mrtjp.projectred.utils.BasicWireMaterial;
import mrtjp.projectred.utils.codechicken.core.render.EntityDigIconFX;
import mrtjp.projectred.utils.codechicken.core.vec.Cuboid6;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWire
extends BlockMultipartBase {
    public BlockWire(int id) {
        super(id, (Material)new BasicWireMaterial());
        this.func_71849_a(ProjectRedTabs.tabWires);
        this.func_71864_b("projred.redwire");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister reg) {
        for (EnumWire wireType : EnumWire.VALUES) {
            wireType.loadTextures(reg);
        }
    }

    @Override
    public int wrappedGetRenderType() {
        return RenderIDs.renderIdRedwire;
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (EnumWire type : EnumWire.VALUES) {
            par3List.add(new ItemStack((Block)this, 1, type.ordinal()));
        }
        for (EnumWire type : EnumWire.VALUES) {
            if (!type.hasJacketedForm()) continue;
            par3List.add(new ItemStack((Block)this, 1, type.ordinal() | 0x4000));
        }
    }

    public TileEntity createTileEntity(World world, int meta) {
        Class clazz = (Class)EnumWire.META_TO_CLASS.get((Object)meta);
        if (clazz == null) {
            return new InvalidTile();
        }
        try {
            return (TileEntity)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public void func_71863_a(World par1World, int par2, int par3, int par4, int par5) {
        ((TileWire)par1World.func_72796_p(par2, par3, par4)).onNeighbourBlockChange();
    }

    public int func_71855_c(IBlockAccess w, int x, int y, int z, int opposite_dir) {
        int meta = w.func_72805_g(x, y, z);
        if (meta == 0) {
            TileRedAlloy tile = (TileRedAlloy)w.func_72796_p(x, y, z);
            return tile.canProvideStrongPowerInDirection(opposite_dir ^ 1) ? tile.getVanillaRedstoneStrength() : (byte)0;
        }
        return 0;
    }

    public int func_71865_a(IBlockAccess w, int x, int y, int z, int opposite_dir) {
        int meta = w.func_72805_g(x, y, z);
        if (meta == 0 || meta == 1) {
            TileRedAlloy tile = (TileRedAlloy)w.func_72796_p(x, y, z);
            return tile.canProvideWeakPowerInDirection(opposite_dir ^ 1) ? tile.getVanillaRedstoneStrength() : (byte)0;
        }
        return 0;
    }

    public boolean func_71853_i() {
        return true;
    }

    public boolean func_71903_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (CommandDebug.WIRE_READING) {
            return ((TileWire)par1World.func_72796_p(par2, par3, par4)).debug(par5EntityPlayer);
        }
        return super.func_71903_a(par1World, par2, par3, par4, par5EntityPlayer, par6, par7, par8, par9);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof TileWire)) {
            return true;
        }
        EnumWire wireType = ((TileWire)te).getType();
        EntityDigIconFX.addBlockDestroyEffects(world, new Cuboid6(x, y, z, x + 1, y + 1, z + 1), new Icon[]{wireType.wireSprites[0]}, effectRenderer);
        return true;
    }
}

