/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.gates;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.projectred.multipart.wiring.RotatedRenderer;
import mrtjp.projectred.multipart.wiring.gates.EnumGate;
import mrtjp.projectred.multipart.wiring.gates.GateRenderBridge;
import mrtjp.projectred.multipart.wiring.gates.TileGate;
import mrtjp.projectred.renderstuffs.gates.RotatedPartModel;
import mrtjp.projectred.utils.codechicken.core.render.CCRenderState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;

@SideOnly(value=Side.CLIENT)
public class GateDynamicRenderer
extends TileEntitySpecialRenderer {
    public static final GateDynamicRenderer instance = new GateDynamicRenderer();
    RotatedRenderer rotatedTess = new RotatedRenderer();
    private GateRenderBridge defaultRendering = new GateRenderBridge.Default();

    public void func_76894_a(TileEntity var1, double x, double y, double z, float partialTick) {
        TileGate te = (TileGate)var1;
        if (te.getType() == null) {
            return;
        }
        EnumGate type = te.getType();
        this.rotatedTess.x = x;
        this.rotatedTess.y = y;
        this.rotatedTess.z = z;
        this.rotatedTess.side = te.getSide();
        this.rotatedTess.front = te.getFront();
        GateRenderBridge rendering = type == null ? this.defaultRendering : type.getRenderBridge();
        rendering.set(te.getRenderState());
        CCRenderState.reset();
        CCRenderState.changeTexture("/terrain.png");
        CCRenderState.useNormals(true);
        CCRenderState.pullLightmap();
        CCRenderState.startDrawing(7);
        for (int i = 0; i < rendering.pointerX.length; ++i) {
            float xOffset = rendering.pointerX[i];
            float zOffset = rendering.pointerZ[i];
            GateDynamicRenderer.renderPointerOnGateWithRotation(this.rotatedTess, xOffset, 0.0f, zOffset, GateRenderBridge._pointer, te.pointerPos);
        }
        CCRenderState.draw();
        rendering.renderSpecials(this.rotatedTess, true);
    }

    public static void renderTorchOnGate(RotatedRenderer rt, float xOffset, float yOffset, float zOffset, boolean on, RotatedPartModel torchon, RotatedPartModel torchoff) {
        xOffset = (16.0f - xOffset) / 16.0f + 0.03f;
        yOffset /= 16.0f;
        zOffset = (16.0f - zOffset) / 16.0f + 0.03f;
        if (!on) {
            rt.renderPartModel(torchoff, "torch", xOffset, yOffset, zOffset, -1.0f, -1, false);
            return;
        }
        rt.renderPartModel(torchon, "torch", xOffset, yOffset, zOffset, -1.0f, -1, false);
    }

    public static void renderGlowOnTorch(RotatedRenderer rt, float xOffset, float yOffset, float zOffset, RotatedPartModel torch) {
        rt.renderPartModel(torch, "glow1", (16.0f - xOffset) / 16.0f + 0.03f, yOffset / 16.0f, (16.0f - zOffset) / 16.0f + 0.03f, -1.0f, -1, false);
        rt.renderPartModel(torch, "glow2", (16.0f - xOffset) / 16.0f + 0.03f, yOffset / 16.0f, (16.0f - zOffset) / 16.0f + 0.03f, -1.0f, -1, false);
    }

    public static void renderWireOnGate(RotatedRenderer rt, float[] xOffsets, float[] zOffsets, RotatedPartModel wire, int color) {
        for (int i = 0; i < xOffsets.length; ++i) {
            float xOffset = (16.0f - xOffsets[i]) / 16.0f + 0.03f;
            float zOffset = (16.0f - zOffsets[i]) / 16.0f + 0.03f;
            rt.renderPartModel(wire, "border", xOffset, 0.0f, zOffset, -1.0f, -1, true);
            rt.renderPartModel(wire, "wire", xOffset, 0.0f, zOffset, -1.0f, color, true);
        }
    }

    public static void renderPointerOnGateWithRotation(RotatedRenderer rt, float xOffset, float yOffset, float zOffset, RotatedPartModel pointer, float degreesRotation) {
        if (degreesRotation < 0.0f) {
            degreesRotation = 360.0f + degreesRotation;
        }
        xOffset = (16.0f - xOffset) / 16.0f + 0.03f;
        zOffset = (16.0f - zOffset) / 16.0f + 0.03f;
        rt.renderPartModel(pointer, "pointer", xOffset, yOffset /= 16.0f, zOffset, degreesRotation, -1, true);
    }
}

