/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.gates;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mrtjp.projectred.crafting.ProjectRedTabs;
import mrtjp.projectred.multipart.BlockMultipartBase;
import mrtjp.projectred.multipart.wiring.gates.EnumGate;
import mrtjp.projectred.multipart.wiring.gates.GateRenderBridge;
import mrtjp.projectred.multipart.wiring.gates.TileGate;
import mrtjp.projectred.network.ClientProxy;
import mrtjp.projectred.renderstuffs.RenderIDs;
import mrtjp.projectred.utils.BasicUtils;
import mrtjp.projectred.utils.BasicWireMaterial;
import mrtjp.projectred.utils.Coords;
import mrtjp.projectred.utils.codechicken.core.vec.Rotation;
import mrtjp.projectred.utils.codechicken.core.vec.Translation;
import mrtjp.projectred.utils.codechicken.core.vec.Vector3;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGate
extends BlockMultipartBase {
    public static final float THICKNESS = 0.125f;
    static Icon textureOverride = null;
    static int colourOverride = -1;
    static int renderSide;
    static int renderTypeOverride;

    public BlockGate(int id) {
        super(id, (Material)new BasicWireMaterial());
        this.func_71849_a(ProjectRedTabs.tabWires);
        this.func_71864_b("projred.gate");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (textureOverride != null) {
            return textureOverride;
        }
        return super.func_71858_a(side, meta);
    }

    public int func_71889_f_(int par1) {
        if (colourOverride < 0) {
            return super.func_71889_f_(par1);
        }
        return colourOverride;
    }

    @Override
    public boolean func_71877_c(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        if (renderSide < 0) {
            return par5 != -(renderSide + 1);
        }
        return par5 == renderSide;
    }

    public int func_71920_b(IBlockAccess par1iBlockAccess, int par2, int par3, int par4) {
        if (colourOverride >= 0) {
            return colourOverride;
        }
        return super.func_71920_b(par1iBlockAccess, par2, par3, par4);
    }

    @Override
    public int wrappedGetRenderType() {
        return renderTypeOverride >= 0 ? renderTypeOverride : RenderIDs.renderIdGate;
    }

    public int func_71856_s_() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ClientProxy.renderPass = pass;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random ran) {
        if (BasicUtils.isServer(world)) {
            return;
        }
        TileGate gate = (TileGate)BasicUtils.getTileEntity((IBlockAccess)world, new Coords(x, y, z), TileGate.class);
        if (gate != null) {
            double d2;
            double d1;
            double d0;
            Vector3 vec;
            float zOffset;
            float yOffset;
            float xOffset;
            int i;
            GateRenderBridge bridge = gate.getType().getRenderBridge();
            bridge.set(gate.getRenderState());
            for (i = 0; i < bridge.torchState.length; ++i) {
                if (!bridge.torchState[i]) continue;
                xOffset = (16.0f - bridge.torchX[i]) / 16.0f;
                yOffset = (bridge.torchY[i] + 6.0f) / 16.0f;
                zOffset = (16.0f - bridge.torchZ[i]) / 16.0f;
                vec = new Vector3();
                vec.apply(new Translation(xOffset, yOffset, zOffset));
                vec.apply(Rotation.getForSideFacing(gate.getSide(), gate.getFront()));
                vec.apply(new Translation(x, y, z));
                d0 = (double)((float)vec.x) + (double)(ran.nextFloat() - 0.5f) * 0.02;
                d1 = (double)((float)vec.y) + (double)(ran.nextFloat() - 0.3f) * 0.3;
                d2 = (double)((float)vec.z) + (double)(ran.nextFloat() - 0.5f) * 0.02;
                world.func_72869_a("reddust", d0, d1, d2, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < bridge.pointerX.length; ++i) {
                xOffset = (16.0f - bridge.pointerX[i]) / 16.0f;
                yOffset = (bridge.pointerY[i] + 6.0f) / 16.0f;
                zOffset = (16.0f - bridge.pointerZ[i]) / 16.0f;
                vec = new Vector3();
                vec.apply(new Translation(xOffset, yOffset, zOffset));
                vec.apply(Rotation.getForSideFacing(gate.getSide(), gate.getFront()));
                vec.apply(new Translation(x, y, z));
                d0 = (double)((float)vec.x) + (double)(ran.nextFloat() - 0.5f) * 0.02;
                d1 = (double)((float)vec.y) + (double)(ran.nextFloat() - 0.3f) * 0.3;
                d2 = (double)((float)vec.z) + (double)(ran.nextFloat() - 0.5f) * 0.02;
                world.func_72869_a("reddust", d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumGate type : EnumGate.VALUES) {
            list.add(new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public TileEntity func_72274_a(World world) {
        return new TileGate();
    }

    public boolean func_71853_i() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public void func_71863_a(World w, int x, int y, int z, int id) {
        TileGate tile;
        super.func_71863_a(w, x, y, z, id);
        if (BasicUtils.isServer(w) && (tile = (TileGate)BasicUtils.getTileEntity((IBlockAccess)w, new Coords(x, y, z), TileGate.class)) != null) {
            tile.onNeighborChanged();
            if (id == 0 || Block.field_71973_m[id].func_71853_i()) {
                tile.updateLogic(false, false);
            }
        }
    }

    public int func_71855_c(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        return ((TileGate)par1iBlockAccess.func_72796_p(par2, par3, par4)).getVanillaOutputStrength(par5 ^ 1);
    }

    public int func_71865_a(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        return ((TileGate)par1iBlockAccess.func_72796_p(par2, par3, par4)).getVanillaOutputStrength(par5 ^ 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister reg) {
        GateRenderBridge.registerAllIcons(reg);
        this.field_94336_cN = reg.func_94245_a("projectred:/gates/base");
    }

    private int getSide(IBlockAccess w, int x, int y, int z) {
        TileEntity te = w.func_72796_p(x, y, z);
        if (!(te instanceof TileGate)) {
            return 0;
        }
        return ((TileGate)te).getSide();
    }

    public void func_71902_a(IBlockAccess w, int x, int y, int z) {
        switch (this.getSide(w, x, y, z)) {
            case 4: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 1.0f);
                break;
            }
            case 0: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
                break;
            }
            case 2: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
                break;
            }
            case 5: {
                this.func_71905_a(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.func_71905_a(0.0f, 0.875f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.func_71905_a(0.0f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public AxisAlignedBB func_71872_e(World w, int x, int y, int z) {
        switch (this.getSide((IBlockAccess)w, x, y, z)) {
            case 4: {
                return AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.0, 0.0, 0.125, 1.0, 1.0).func_72317_d((double)x, (double)y, (double)z);
            }
            case 0: {
                return AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.0, 0.0, 1.0, 0.125, 1.0).func_72317_d((double)x, (double)y, (double)z);
            }
            case 2: {
                return AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.0, 0.0, 1.0, 1.0, 0.125).func_72317_d((double)x, (double)y, (double)z);
            }
            case 5: {
                return AxisAlignedBB.func_72332_a().func_72299_a(0.875, 0.0, 0.0, 1.0, 1.0, 1.0).func_72317_d((double)x, (double)y, (double)z);
            }
            case 1: {
                return AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.875, 0.0, 1.0, 1.0, 1.0).func_72317_d((double)x, (double)y, (double)z);
            }
            case 3: {
                return AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.0, 0.875, 1.0, 1.0, 1.0).func_72317_d((double)x, (double)y, (double)z);
            }
        }
        return null;
    }

    public void func_71847_b(World w, int x, int y, int z, Random par5Random) {
        ((TileGate)w.func_72796_p(x, y, z)).scheduledTick();
    }

    public boolean func_71903_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        return ((TileGate)par1World.func_72796_p(par2, par3, par4)).onBlockActivated(par5EntityPlayer);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        EnumGate type;
        TileGate te = (TileGate)BasicUtils.getTileEntity(world, new Coords(x, y, z), TileGate.class);
        if (te != null && (type = te.getType()) != null) {
            GateRenderBridge render = type.getRenderBridge();
            int on = 0;
            if (render != null) {
                on += render.torchState.length;
                on += render.pointerX.length;
            }
            return on > 0 ? on + 4 : 0;
        }
        return 0;
    }

    static {
        renderTypeOverride = -1;
    }
}

