/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.microblocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.projectred.multipart.microblocks.ItemBlockMicroblock;
import mrtjp.projectred.multipart.microblocks.MicroblockLibrary;
import mrtjp.projectred.multipart.microblocks.PartType;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class MicroblockItemRenderer
implements IItemRenderer {
    public static final MicroblockItemRenderer instance = new MicroblockItemRenderer();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
            case FIRST_PERSON_MAP: {
                return false;
            }
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case ENTITY_BOBBING: {
                return true;
            }
            case ENTITY_ROTATION: {
                return true;
            }
            case BLOCK_3D: {
                return true;
            }
            case EQUIPPED_BLOCK: {
                return true;
            }
            case INVENTORY_BLOCK: {
                return true;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int typen = ItemBlockMicroblock.getPartTypeID(item);
        PartType pt = (PartType)MicroblockLibrary.parts.get(typen);
        if (pt == null) {
            return;
        }
        switch (type) {
            case EQUIPPED: 
            case INVENTORY: 
            case EQUIPPED_FIRST_PERSON: {
                pt.renderPartInv((RenderBlocks)data[0], item);
                break;
            }
            case ENTITY: {
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                pt.renderPartInv((RenderBlocks)data[0], item);
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                break;
            }
            case FIRST_PERSON_MAP: {
                break;
            }
        }
    }
}

