/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.microblocks;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.multipart.BlockMultipartBase;
import mrtjp.projectred.multipart.microblocks.EnumPartClass;
import mrtjp.projectred.multipart.microblocks.EnumPosition;
import mrtjp.projectred.multipart.microblocks.IMicroblockCoverSystem;
import mrtjp.projectred.multipart.microblocks.IMicroblockSupporterTile;
import mrtjp.projectred.multipart.microblocks.IMicroblockSupporterTile2;
import mrtjp.projectred.multipart.microblocks.MicroblockLibrary;
import mrtjp.projectred.multipart.microblocks.Part;
import mrtjp.projectred.multipart.microblocks.PartType;
import mrtjp.projectred.multipart.microblocks.TileMicroblockContainer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;

public class MicroblockCoverSystem
implements IMicroblockCoverSystem {
    ArrayList parts = new ArrayList();
    public BlockMultipartBase wrappedBlock;
    public double hollow_edge_size;
    private TileEntity te;
    private IMicroblockSupporterTile te2;

    public MicroblockCoverSystem(IMicroblockSupporterTile te, double hes) {
        this.te = (TileEntity)te;
        this.te2 = te;
        this.hollow_edge_size = hes;
    }

    public MicroblockCoverSystem(IMicroblockSupporterTile te) {
        this(te, 0.25);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList l = new NBTTagList();
        for (Part p : this.parts) {
            l.func_74742_a(p.writeToNBT());
        }
        tag.func_74782_a("ICMP", (NBTBase)l);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.parts.clear();
        NBTTagList l = tag.func_74761_m("ICMP");
        if (l == null) {
            return;
        }
        for (int k = 0; k < l.func_74745_c(); ++k) {
            Part p = Part.readFromNBT(l.func_74743_b(k));
            if (p == null) continue;
            this.parts.add(p);
        }
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 src, Vec3 dst) {
        int k = 0;
        int x = this.te.field_70329_l;
        int y = this.te.field_70330_m;
        int z = this.te.field_70327_n;
        src = src.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        dst = dst.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        double best = dst.func_72436_e(src) + 1.0;
        Part hit = null;
        MovingObjectPosition hitInfo = null;
        int subHit = -1;
        for (Part p : this.parts) {
            double rtdist;
            AxisAlignedBB aabb = p.getBoundingBoxFromPool();
            MovingObjectPosition rt = aabb.func_72327_a(src, dst);
            if (rt != null && (rtdist = rt.field_72307_f.func_72436_e(src)) < best) {
                hitInfo = rt;
                best = rtdist;
                hit = p;
                subHit = -1 - k;
            }
            ++k;
        }
        if (hit == null) {
            return null;
        }
        MovingObjectPosition pos = new MovingObjectPosition(x, y, z, hitInfo.field_72310_e, hitInfo.field_72307_f.func_72441_c((double)x, (double)y, (double)z));
        pos.subHit = subHit;
        return pos;
    }

    @Override
    public boolean addPart(Part part) {
        if (!this.canPlace(part.type, part.pos)) {
            return false;
        }
        this.parts.add(part);
        return true;
    }

    public boolean canPlaceCentre(double size) {
        AxisAlignedBB aabb = Part.getBoundingBoxFromPool(EnumPosition.Centre, size);
        for (Part p : this.parts) {
            if (!p.getBoundingBoxFromPool().func_72326_a(aabb)) continue;
            return false;
        }
        return true;
    }

    public boolean canPlace(PartType type, EnumPosition pos) {
        for (Part p : this.parts) {
            if (p.pos == pos) {
                return false;
            }
            if (p.pos.clazz == pos.clazz || !p.getBoundingBoxFromPool().func_72326_a(Part.getBoundingBoxFromPool(pos, type.getSize()))) continue;
            return false;
        }
        return this.te == null || !this.te2.isPlacementBlockedByTile(type, pos);
    }

    @Override
    public void getCollidingBoundingBoxes(AxisAlignedBB mask, List list) {
        for (Part p : this.parts) {
            AxisAlignedBB bb = p.getBoundingBoxFromPool().func_72325_c((double)this.te.field_70329_l, (double)this.te.field_70330_m, (double)this.te.field_70327_n);
            if (!mask.func_72326_a(bb)) continue;
            list.add(bb);
        }
    }

    @Override
    public boolean isSideOpen(int side) {
        return !this.isPositionOccupied(EnumPosition.getFacePosition(side), true, false);
    }

    @Override
    public byte[] writeDescriptionBytes() {
        ByteArrayDataOutput o = ByteStreams.newDataOutput((int)(6 + this.parts.size() * 3));
        try {
            this.writeDescriptionPacket((DataOutput)o);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return o.toByteArray();
    }

    @Override
    public void readDescriptionBytes(byte[] data, int start) {
        try {
            this.readDescriptionPacket((DataInput)ByteStreams.newDataInput((byte[])data, (int)start));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeDescriptionPacket(DataOutput data) throws IOException {
        data.writeShort(this.wrappedBlock == null ? 0 : this.wrappedBlock.field_71990_ca);
        data.writeShort(this.parts.size());
        for (Part pt : this.parts) {
            data.writeByte(pt.pos.ordinal());
            data.writeInt(pt.type.getID());
            pt.writeExtraData(data);
        }
    }

    @Override
    public void readDescriptionPacket(DataInput data) throws IOException {
        short wrappedID = data.readShort();
        this.wrappedBlock = wrappedID == 0 ? null : (BlockMultipartBase)Block.field_71973_m[wrappedID];
        int ncovers = data.readShort();
        this.parts.clear();
        for (int k = 0; k < ncovers; ++k) {
            EnumPosition pos = EnumPosition.values()[data.readByte()];
            int type = data.readInt();
            this.parts.add(((PartType)MicroblockLibrary.parts.get(type)).createPart(pos, data));
        }
        this.te.field_70331_k.func_72845_h(this.te.field_70329_l, this.te.field_70330_m, this.te.field_70327_n);
    }

    public void copyPartsTo(MicroblockCoverSystem other) {
        for (Part p : this.parts) {
            other.addPart(p);
        }
    }

    @Override
    public List removePartByPlayer(EntityPlayer ply, int part) {
        if (ProjectRed.blockMicrocontainer == null) {
            return null;
        }
        if (part >= this.parts.size()) {
            return null;
        }
        Part p = (Part)this.parts.remove(part);
        if (p == null) {
            return null;
        }
        ItemStack drop = p.type.getDroppedStack(p, ply);
        if (this.parts.size() == 0 && this.te.getClass() == TileMicroblockContainer.class) {
            this.te.field_70331_k.func_72832_d(this.te.field_70329_l, this.te.field_70330_m, this.te.field_70327_n, 0, 0, 3);
        } else if (this.te instanceof IMicroblockSupporterTile2) {
            ((IMicroblockSupporterTile2)this.te).onMicroblocksChanged();
        } else {
            this.te.field_70331_k.func_72845_h(this.te.field_70329_l, this.te.field_70330_m, this.te.field_70327_n);
            this.te.field_70331_k.func_72898_h(this.te.field_70329_l, this.te.field_70330_m, this.te.field_70327_n, this.te.func_70311_o().field_71990_ca);
        }
        return Collections.singletonList(drop);
    }

    @Override
    public boolean isPositionOccupied(EnumPosition pos) {
        for (Part p : this.parts) {
            if (p.pos != pos) continue;
            return true;
        }
        return false;
    }

    public boolean isPositionOccupied(EnumPosition pos, boolean ignoreHollowPanels, boolean includeTile) {
        if (includeTile && this.te != null && this.te2.isPositionOccupiedByTile(pos)) {
            return true;
        }
        for (Part p : this.parts) {
            if (p.pos != pos || ignoreHollowPanels && p.type.getPartClass() == EnumPartClass.HollowPanel) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEdgeOpen(int face1, int face2) {
        return !this.isPositionOccupied(EnumPosition.getEdgePosition(face1, face2)) && !this.isPositionOccupied(EnumPosition.getFacePosition(face1), false, false) && !this.isPositionOccupied(EnumPosition.getFacePosition(face2), false, false);
    }

    @Override
    public EnumPosition getPartPosition(int part) {
        if (part >= this.parts.size()) {
            return null;
        }
        return ((Part)this.parts.get((int)part)).pos;
    }

    @Override
    public AxisAlignedBB getPartAABBFromPool(int part) {
        if (part >= this.parts.size()) {
            return null;
        }
        return ((Part)this.parts.get(part)).getBoundingBoxFromPool();
    }

    @Override
    public float getPlayerRelativePartHardness(EntityPlayer ply, int part) {
        if (part >= this.parts.size()) {
            return 0.0f;
        }
        return ((Part)this.parts.get((int)part)).type.getPlayerRelativeHardness((Part)this.parts.get(part), ply);
    }

    @Override
    public ItemStack pickPart(MovingObjectPosition rayTrace, int part) {
        if (part >= this.parts.size()) {
            return null;
        }
        return ((Part)this.parts.get((int)part)).type.getPickItem((Part)this.parts.get(part));
    }

    @Override
    public boolean isSolidOnSide(ForgeDirection side) {
        switch (side.ordinal()) {
            case 4: {
                return this.isPositionOccupied(EnumPosition.FaceNX, true, true);
            }
            case 5: {
                return this.isPositionOccupied(EnumPosition.FacePX, true, true);
            }
            case 0: {
                return this.isPositionOccupied(EnumPosition.FaceNY, true, true);
            }
            case 1: {
                return this.isPositionOccupied(EnumPosition.FacePY, true, true);
            }
            case 2: {
                return this.isPositionOccupied(EnumPosition.FaceNZ, true, true);
            }
            case 3: {
                return this.isPositionOccupied(EnumPosition.FacePZ, true, true);
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderPartWorld(Part p, RenderBlocks render, int x, int y, int z) {
        boolean[] dontRenderSides = new boolean[6];
        for (Part p2 : this.parts) {
            if (!p2.type.isOpaque()) continue;
            switch (p2.pos) {
                case FaceNX: {
                    dontRenderSides[4] = true;
                    break;
                }
                case FaceNY: {
                    dontRenderSides[0] = true;
                    break;
                }
                case FaceNZ: {
                    dontRenderSides[2] = true;
                    break;
                }
                case FacePX: {
                    dontRenderSides[5] = true;
                    break;
                }
                case FacePY: {
                    dontRenderSides[1] = true;
                    break;
                }
                case FacePZ: {
                    dontRenderSides[3] = true;
                    break;
                }
            }
        }
        switch (p.pos) {
            case FaceNX: {
                dontRenderSides[4] = false;
                break;
            }
            case FaceNY: {
                dontRenderSides[0] = false;
                break;
            }
            case FaceNZ: {
                dontRenderSides[2] = false;
                break;
            }
            case FacePX: {
                dontRenderSides[5] = false;
                break;
            }
            case FacePY: {
                dontRenderSides[1] = false;
                break;
            }
            case FacePZ: {
                dontRenderSides[3] = false;
                break;
            }
        }
        p.type.renderPartWorld(render, p, x, y, z, dontRenderSides);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(RenderBlocks render) {
        for (Part p : this.parts) {
            this.renderPartWorld(p, render, this.te.field_70329_l, this.te.field_70330_m, this.te.field_70327_n);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(RenderBlocks render, int part) {
        if (part >= this.parts.size()) {
            return;
        }
        Part p = (Part)this.parts.get(part);
        this.renderPartWorld(p, render, this.te.field_70329_l, this.te.field_70330_m, this.te.field_70327_n);
    }

    @Override
    public void convertToContainerBlock() {
        if (this.parts.size() == 0 || ProjectRed.blockMicrocontainer == null) {
            this.te.field_70331_k.func_72832_d(this.te.field_70329_l, this.te.field_70330_m, this.te.field_70327_n, 0, 0, 3);
        } else {
            this.te.field_70331_k.func_72832_d(this.te.field_70329_l, this.te.field_70330_m, this.te.field_70327_n, ProjectRed.blockMicrocontainer.field_71990_ca, 0, 2);
            IMicroblockCoverSystem c2 = ((TileMicroblockContainer)this.te.field_70331_k.func_72796_p(this.te.field_70329_l, this.te.field_70330_m, this.te.field_70327_n)).getCoverSystem();
            for (Part p : this.parts) {
                c2.addPart(p);
            }
        }
    }

    @Override
    public Collection getAllParts() {
        return Collections.unmodifiableList(this.parts);
    }
}

