/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.microblocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.multipart.BlockMultipartBase;
import mrtjp.projectred.multipart.microblocks.EnumPartClass;
import mrtjp.projectred.multipart.microblocks.EnumPosition;
import mrtjp.projectred.multipart.microblocks.IMicroblockCoverSystem;
import mrtjp.projectred.multipart.microblocks.IMicroblockSupporterTile;
import mrtjp.projectred.multipart.microblocks.IMicroblockSupporterTile2;
import mrtjp.projectred.multipart.microblocks.MicroblockLibrary;
import mrtjp.projectred.multipart.microblocks.MicroblockPlacementHighlightHandler;
import mrtjp.projectred.multipart.microblocks.PartType;
import mrtjp.projectred.multipart.microblocks.TileMicroblockContainer;
import mrtjp.projectred.network.PacketHandler;
import mrtjp.projectred.network.packets.MicroblockPlacementPacket;
import mrtjp.projectred.utils.BasicUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemBlockMicroblock
extends ItemBlock {
    private BlockMultipartBase block;
    private static final boolean DEBUG = Configurator.debugMode.getBoolean(false);

    public ItemBlockMicroblock(int id) {
        super(id);
        this.block = (BlockMultipartBase)Block.field_71973_m[this.field_77779_bT];
    }

    @SideOnly(value=Side.CLIENT)
    public static Placement getPlacement(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int dir) {
        EnumPosition pos;
        int oldblock;
        MovingObjectPosition ray = player.func_70614_a(BasicUtils.getPlayerReach(player), 0.0f);
        if (ray == null) {
            if (DEBUG) {
                System.out.println("null raytrace");
            }
            return null;
        }
        x = ray.field_72311_b;
        y = ray.field_72312_c;
        z = ray.field_72309_d;
        dir = ray.field_72310_e;
        TileEntity rayTE = world.func_72796_p(ray.field_72311_b, ray.field_72312_c, ray.field_72309_d);
        EnumPosition rayPos = null;
        if (rayTE instanceof IMicroblockSupporterTile) {
            rayPos = ray.subHit < 0 ? ((IMicroblockSupporterTile)rayTE).getCoverSystem().getPartPosition(-1 - ray.subHit) : ((IMicroblockSupporterTile)rayTE).getPartPosition(ray.subHit);
        }
        if ((oldblock = world.func_72798_a(x, y, z)) == Block.field_72037_aS.field_71990_ca) {
            dir = 0;
        } else if (oldblock != Block.field_71998_bu.field_71990_ca) {
            int dx = 0;
            int dy = 0;
            int dz = 0;
            switch (dir) {
                case 4: {
                    if (rayPos != null && !rayPos.x.touchesNegative()) break;
                    dx = -1;
                    break;
                }
                case 5: {
                    if (rayPos != null && !rayPos.x.touchesPositive()) break;
                    dx = 1;
                    break;
                }
                case 0: {
                    if (rayPos != null && !rayPos.y.touchesNegative()) break;
                    dy = -1;
                    break;
                }
                case 1: {
                    if (rayPos != null && !rayPos.y.touchesPositive()) break;
                    dy = 1;
                    break;
                }
                case 2: {
                    if (rayPos != null && !rayPos.z.touchesNegative()) break;
                    dz = -1;
                    break;
                }
                case 3: {
                    if (rayPos != null && !rayPos.z.touchesPositive()) break;
                    dz = 1;
                }
            }
            if (dx != 0 || dy != 0 || dz != 0) {
                x += dx;
                y += dy;
                z += dz;
                rayPos = null;
            }
        }
        if (itemstack.field_77994_a == 0) {
            if (DEBUG) {
                System.out.println("empty stack");
            }
            return null;
        }
        PartType type = (PartType)MicroblockLibrary.parts.get(ItemBlockMicroblock.getPartTypeID(itemstack));
        if (type == null) {
            itemstack.field_77994_a = 0;
            if (DEBUG) {
                System.out.println("invalid type");
            }
            return null;
        }
        EnumPartClass clazz = type.getPartClass();
        if (clazz == EnumPartClass.Panel || clazz == EnumPartClass.HollowPanel) {
            pos = MicroblockPlacementHighlightHandler.getPanelPlacement(player, ray, rayPos);
        } else if (clazz == EnumPartClass.Corner) {
            pos = MicroblockPlacementHighlightHandler.getCornerPlacement(player, ray, rayPos);
        } else if (clazz == EnumPartClass.Strip) {
            pos = MicroblockPlacementHighlightHandler.getStripPlacement(player, ray, rayPos);
        } else {
            if (DEBUG) {
                System.out.println("invalid class");
            }
            return null;
        }
        return new Placement(x, y, z, pos);
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int dir, float x2, float y2, float z2) {
        if (world.field_72995_K) {
            Placement pl = ItemBlockMicroblock.getPlacement(itemstack, entityplayer, world, x, y, z, dir);
            if (pl == null) {
                return false;
            }
            if (!this.placeInBlock(world, pl.x, pl.y, pl.z, pl.pos, itemstack, true, dir)) {
                if (DEBUG) {
                    System.out.println("placeInBlock failed");
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean placeInBlock(World world, int x, int y, int z, EnumPosition pos, ItemStack itemstack, boolean doBlockUpdate, int sideClicked) {
        if (DEBUG) {
            System.out.println((world.field_72995_K ? "client" : "server") + " placeInBlock " + x + "," + y + "," + z + " " + (Object)((Object)pos));
            System.out.println("ID of microblock is " + ItemBlockMicroblock.getPartTypeID(itemstack));
        }
        if (world.field_72995_K) {
            MicroblockPlacementPacket packet = (MicroblockPlacementPacket)PacketHandler.getPacket(MicroblockPlacementPacket.class);
            packet.position = pos.ordinal();
            packet.side = sideClicked;
            packet.posX = x;
            packet.posY = y;
            packet.posZ = z;
            BasicUtils.sendPacketToServer(packet.getPacket());
            return true;
        }
        int d = ItemBlockMicroblock.getPartTypeID(itemstack);
        if (!MicroblockLibrary.parts.containsKey(d)) {
            if (DEBUG) {
                System.out.println("wrong part ID, got " + d);
            }
            return false;
        }
        TileEntity newTE = world.func_72796_p(x, y, z);
        boolean addedTE = false;
        if (newTE == null || !(newTE instanceof IMicroblockSupporterTile)) {
            Block replacing = Block.field_71973_m[world.func_72798_a(x, y, z)];
            if (replacing != null && !replacing.isBlockReplaceable(world, x, y, z)) {
                if (DEBUG) {
                    System.out.println("not replaceable");
                }
                return false;
            }
            if (!this.block.func_71850_a_(world, x, y, z, 0)) {
                if (DEBUG) {
                    System.out.println("can't place on side");
                }
                return false;
            }
            world.func_72832_d(x, y, z, this.block.field_71990_ca, 0, 0);
            newTE = new TileMicroblockContainer();
            world.func_72837_a(x, y, z, newTE);
            addedTE = true;
        }
        PartType type = (PartType)MicroblockLibrary.parts.get(d);
        assert (type != null) : "No part type with ID " + d;
        IMicroblockCoverSystem cover = ((IMicroblockSupporterTile)newTE).getCoverSystem();
        assert (cover != null) : "New tile entity has no cover system";
        if (!cover.addPart(type.createPart(pos))) {
            if (addedTE) {
                world.func_72832_d(x, y, z, 0, 0, 0);
            }
            if (DEBUG) {
                System.out.println("addPart failed");
            }
            return false;
        }
        if (DEBUG) {
            System.out.println("addPart ok");
        }
        if (doBlockUpdate) {
            if (newTE instanceof IMicroblockSupporterTile2) {
                ((IMicroblockSupporterTile2)newTE).onMicroblocksChanged();
            } else {
                world.func_72898_h(x, y, z, this.block.field_71990_ca);
                world.func_72845_h(x, y, z);
            }
        }
        return true;
    }

    public String func_77667_c(ItemStack is) {
        PartType pt = MicroblockLibrary.instance.getPartTypeByID(ItemBlockMicroblock.getPartTypeID(is));
        return pt == null ? null : pt.getUnlocalizedName(is);
    }

    public boolean func_77614_k() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77884_a(World w, int x, int y, int z, int side, EntityPlayer ply, ItemStack stack) {
        return true;
    }

    public boolean func_77651_p() {
        return true;
    }

    public static int getPartTypeID(ItemStack stack) {
        NBTTagCompound tag = stack.field_77990_d;
        if (tag != null && tag.func_74764_b("MicroType")) {
            return tag.func_74762_e("MicroType");
        }
        return stack.func_77960_j();
    }

    public static ItemStack getStackWithPartID(int id) {
        ItemStack rv = new ItemStack((Block)ProjectRed.blockMicrocontainer, 1, 0);
        rv.field_77990_d = new NBTTagCompound("tag");
        rv.field_77990_d.func_74768_a("MicroType", id);
        return rv;
    }

    public static ItemStack getStackWithPartID(int partID, int stackSize) {
        ItemStack rv = ItemBlockMicroblock.getStackWithPartID(partID);
        rv.field_77994_a = stackSize;
        return rv;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        if (par4) {
            par3List.add("Part ID: " + ItemBlockMicroblock.getPartTypeID(par1ItemStack));
            par3List.add("Hex: " + Integer.toHexString(ItemBlockMicroblock.getPartTypeID(par1ItemStack)));
        }
    }

    public static class Placement {
        public final int x;
        public final int y;
        public final int z;
        public final EnumPosition pos;

        public Placement(int x, int y, int z, EnumPosition pos) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.pos = pos;
        }
    }
}

