/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;

public class SynchronizedWeakIdentityListMap {
    private ReferenceQueue refQueue = new ReferenceQueue();
    private ListNode head = null;

    public synchronized void remove(Object key) {
        this.removeCollectedKeys();
        if (this.head == null) {
            return;
        }
        if (this.head.key.get() == key) {
            this.head = this.head.next;
            return;
        }
        ListNode cur = this.head;
        while (cur.next != null) {
            if (cur.next.key.get() == key) {
                cur.next = cur.next.next;
                return;
            }
            cur = cur.next;
        }
    }

    public synchronized Object get(Object key) {
        this.removeCollectedKeys();
        ListNode cur = this.head;
        while (cur != null) {
            if (cur.key.get() == key) {
                return cur.value;
            }
            cur = cur.next;
        }
        return null;
    }

    public synchronized void put(Object key, Object val) {
        this.removeCollectedKeys();
        ListNode cur = this.head;
        while (cur != null) {
            Object curKey = cur.key.get();
            if (curKey != null && key == curKey) {
                cur.value = val;
                return;
            }
            cur = cur.next;
        }
        ListNode n = new ListNode();
        n.key = new WeakReference<Object>(key, this.refQueue);
        n.value = val;
        n.next = this.head;
        this.head = n;
    }

    private void removeCollectedKeys() {
        Reference ref;
        block0: while ((ref = this.refQueue.poll()) != null) {
            if (this.head == null) continue;
            if (this.head != null && this.head.key == ref) {
                this.head = this.head.next;
                continue;
            }
            ListNode cur = this.head;
            while (cur.next != null) {
                if (cur.next.key == ref) {
                    cur.next = cur.next.next;
                    continue block0;
                }
                cur = cur.next;
            }
        }
    }

    public synchronized Iterable entries() {
        ArrayList rv = new ArrayList();
        ListNode cur = this.head;
        while (cur != null) {
            Object curKey = cur.key.get();
            if (curKey != null) {
                rv.add(new AbstractMap.SimpleEntry(curKey, cur.value));
            }
            cur = cur.next;
        }
        return rv;
    }

    private static class ListNode {
        public WeakReference key;
        public Object value;
        public ListNode next = null;

        private ListNode() {
        }
    }
}

