/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.crafting;

import cpw.mods.fml.common.registry.GameRegistry;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.blocks.BlockLamp;
import mrtjp.projectred.blocks.BlockLantern;
import mrtjp.projectred.blocks.BlockMachines;
import mrtjp.projectred.crafting.AlloySmelterRecipe;
import mrtjp.projectred.crafting.microblocks.RecipeCombineSeveral;
import mrtjp.projectred.crafting.microblocks.RecipeCombineTwo;
import mrtjp.projectred.crafting.microblocks.RecipeHollowCover;
import mrtjp.projectred.crafting.microblocks.RecipeHorizontalCut;
import mrtjp.projectred.crafting.microblocks.RecipeUnHollowCover;
import mrtjp.projectred.crafting.microblocks.RecipeVerticalCut;
import mrtjp.projectred.crafting.tools.RecipeBackpackRecoloring;
import mrtjp.projectred.crafting.tools.RecipeDrawPlate;
import mrtjp.projectred.items.ItemBackpack;
import mrtjp.projectred.items.ItemPart;
import mrtjp.projectred.multipart.wiring.gates.EnumGate;
import mrtjp.projectred.multipart.wiring.wires.EnumWire;
import mrtjp.projectred.utils.Color;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CraftingRecipeManager {
    public static void initRecipes() {
        CraftingRecipeManager.initGateRecipes();
        CraftingRecipeManager.initMicroblockRecipes();
        CraftingRecipeManager.initWireRecipes();
        CraftingRecipeManager.initPartsRecipes();
        CraftingRecipeManager.initMachineRecipes();
        CraftingRecipeManager.initToolRecipes();
        CraftingRecipeManager.initOtherRecipes();
        CraftingRecipeManager.initOtherAlloySmelterRecipes();
    }

    private static void initMicroblockRecipes() {
        GameRegistry.addRecipe((IRecipe)new RecipeHollowCover());
        GameRegistry.addRecipe((IRecipe)new RecipeUnHollowCover());
        GameRegistry.addRecipe((IRecipe)new RecipeVerticalCut());
        GameRegistry.addRecipe((IRecipe)new RecipeHorizontalCut());
        GameRegistry.addRecipe((IRecipe)new RecipeCombineTwo());
        GameRegistry.addRecipe((IRecipe)new RecipeCombineSeveral());
    }

    private static void initWireRecipes() {
        GameRegistry.addRecipe((ItemStack)EnumWire.RED_ALLOY.getItemStack(12), (Object[])new Object[]{" r ", " r ", " r ", Character.valueOf('r'), ItemPart.EnumPart.REDINGOT.getItemStack()});
        for (int i = 0; i < EnumWire.INSULATED_WIRE.length; ++i) {
            EnumWire w = EnumWire.INSULATED_WIRE[i];
            GameRegistry.addRecipe((ItemStack)w.getItemStack(12), (Object[])new Object[]{"WrW", "WrW", "WrW", Character.valueOf('W'), new ItemStack(Block.field_72101_ab, 1, Color.get(i).woolId()), Character.valueOf('r'), ItemPart.EnumPart.REDINGOT.getItemStack()});
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(EnumWire.BUNDLED_N.getItemStack(), new Object[]{"SWS", "WWW", "SWS", Character.valueOf('S'), Item.field_77683_K, Character.valueOf('W'), "projredInsulatedWire"}));
        int bundledColor = 0;
        for (EnumWire w : EnumWire.BUNDLED_WIRE) {
            if (w == EnumWire.BUNDLED_N) continue;
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(w.getItemStack(3), new Object[]{Color.get(bundledColor).getOreDict(), "projredBundledCable", "projredBundledCable", "projredBundledCable", Color.get(bundledColor).getOreDict()}));
            ++bundledColor;
        }
        for (EnumWire w : EnumWire.VALID_WIRE) {
            if (!w.hasJacketedForm()) continue;
            GameRegistry.addRecipe((ItemStack)w.getJacketedItemStack(3), (Object[])new Object[]{"sis", "sis", "sis", Character.valueOf('i'), w.getItemStack(), Character.valueOf('s'), Item.field_77669_D});
            GameRegistry.addRecipe((ItemStack)w.getItemStack(3), (Object[])new Object[]{"i", "i", "i", Character.valueOf('i'), w.getJacketedItemStack()});
        }
    }

    private static void initGateRecipes() {
        GameRegistry.addRecipe((ItemStack)EnumGate.AND.getItemStack(), (Object[])new Object[]{"ACA", "CCC", "PWP", Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.OR.getItemStack(), (Object[])new Object[]{"PCP", "WCW", "PWP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.NOT.getItemStack(), (Object[])new Object[]{"PCP", "CAC", "PWP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.RSLATCH.getItemStack(), (Object[])new Object[]{"WWA", "CPC", "AWW", Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack(), Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.TOGGLE.getItemStack(), (Object[])new Object[]{"CPP", "WLW", "CPP", Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack(), Character.valueOf('L'), Block.field_72043_aJ});
        GameRegistry.addRecipe((ItemStack)EnumGate.NOR.getItemStack(), (Object[])new Object[]{"PAP", "WCW", "PWP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.NAND.getItemStack(), (Object[])new Object[]{"AAA", "CCC", "PWP", Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.XOR.getItemStack(), (Object[])new Object[]{"AWA", "CAC", "WCW", Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.XNOR.getItemStack(), (Object[])new Object[]{"ACA", "CAC", "WCW", Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.Buffer.getItemStack(), (Object[])new Object[]{"ACA", "WCW", "PWP", Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack(), Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.Multiplexer.getItemStack(), (Object[])new Object[]{"ACA", "CPC", "ACW", Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.Repeater.getItemStack(), (Object[])new Object[]{"PCA", "ACP", "PWP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.Timer.getItemStack(), (Object[])new Object[]{"ACA", "WTW", "PWP", Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack(), Character.valueOf('T'), ItemPart.EnumPart.POINTER.getItemStack(), Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.Counter.getItemStack(), (Object[])new Object[]{"PWP", "CTC", "PWP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('T'), ItemPart.EnumPart.POINTER.getItemStack(), Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.Sequencer.getItemStack(), (Object[])new Object[]{"PCP", "CTC", "PCP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('T'), ItemPart.EnumPart.POINTER.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.PulseFormer.getItemStack(), (Object[])new Object[]{"ACA", "CAC", "WWP", Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack(), Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.Randomizer.getItemStack(), (Object[])new Object[]{"PEP", "WWW", "EWE", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('E'), ItemPart.EnumPart.ENERGIZEDSILICONCHIP.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.StateCell.getItemStack(), (Object[])new Object[]{"PAC", "WST", "PWP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack(), Character.valueOf('S'), ItemPart.EnumPart.SILICONCHIP.getItemStack(), Character.valueOf('T'), ItemPart.EnumPart.POINTER.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.Synchronizer.getItemStack(), (Object[])new Object[]{"WCW", "SAS", "WWW", Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack(), Character.valueOf('C'), ItemPart.EnumPart.CATHODE.getItemStack(), Character.valueOf('S'), ItemPart.EnumPart.SILICONCHIP.getItemStack(), Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.DLatch.getItemStack(), (Object[])new Object[]{"PAP", "ASW", "PWP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('S'), ItemPart.EnumPart.SILICONCHIP.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.DFlop.getItemStack(), (Object[])new Object[]{"PAP", "ASA", "PWP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('A'), ItemPart.EnumPart.ANODE.getItemStack(), Character.valueOf('S'), ItemPart.EnumPart.SILICONCHIP.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.BundledLatch.getItemStack(), (Object[])new Object[]{"PBP", "GSW", "PBP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('B'), ItemPart.EnumPart.BUNDLEDPLATE.getItemStack(), Character.valueOf('G'), EnumGate.DLatch.getItemStack(), Character.valueOf('S'), ItemPart.EnumPart.SILICONCHIP.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.BundledRelay.getItemStack(), (Object[])new Object[]{"PBP", "GSW", "PBP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('B'), ItemPart.EnumPart.BUNDLEDPLATE.getItemStack(), Character.valueOf('G'), EnumGate.Repeater.getItemStack(), Character.valueOf('S'), ItemPart.EnumPart.SILICONCHIP.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.BundledMultiplexer.getItemStack(), (Object[])new Object[]{"PBP", "BSB", "PWP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('B'), ItemPart.EnumPart.BUNDLEDPLATE.getItemStack(), Character.valueOf('S'), ItemPart.EnumPart.SILICONCHIP.getItemStack(), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.LightSensor.getItemStack(), (Object[])new Object[]{"PPP", "LLL", "PWP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('L'), new ItemStack(Item.field_77756_aW, 1, Color.BLUE.dyeId()), Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)EnumGate.RainSensor.getItemStack(), (Object[])new Object[]{"PPP", "SSS", "PWP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('S'), Item.field_77761_aM, Character.valueOf('W'), ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack()});
    }

    private static void initPartsRecipes() {
        GameRegistry.addSmelting((int)Block.field_71981_t.field_71990_ca, (ItemStack)ItemPart.EnumPart.PLATE.getItemStack(2), (float)0.0f);
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.CONDUCTIVEPLATE.getItemStack(), (Object[])new Object[]{"r", "p", Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('p'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.WIREDPLATE.getItemStack(), (Object[])new Object[]{"r", "p", Character.valueOf('r'), EnumWire.RED_ALLOY.getItemStack(), Character.valueOf('p'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.BUNDLEDPLATE.getItemStack(), (Object[])new Object[]{"r", "p", Character.valueOf('r'), EnumWire.BUNDLED_N.getItemStack(), Character.valueOf('p'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.ANODE.getItemStack(3), (Object[])new Object[]{" r ", "rrr", "ppp", Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('p'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.CATHODE.getItemStack(), (Object[])new Object[]{"t", "p", Character.valueOf('t'), Block.field_72035_aQ, Character.valueOf('p'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.POINTER.getItemStack(), (Object[])new Object[]{"b", "m", "c", Character.valueOf('b'), Block.field_71981_t, Character.valueOf('m'), ItemPart.EnumPart.MOTOR.getItemStack(), Character.valueOf('c'), ItemPart.EnumPart.CATHODE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.SILICONCHIP.getItemStack(), (Object[])new Object[]{" s ", "ppp", Character.valueOf('s'), ItemPart.EnumPart.INFUSEDSILICON.getItemStack(), Character.valueOf('p'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.ENERGIZEDSILICONCHIP.getItemStack(), (Object[])new Object[]{" e ", "ppp", Character.valueOf('e'), ItemPart.EnumPart.ENERGIZEDSILICON.getItemStack(), Character.valueOf('p'), ItemPart.EnumPart.PLATE.getItemStack()});
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.PLATFORMEDPLATE.getItemStack(), (Object[])new Object[]{" r ", "sps", "prp", Character.valueOf('r'), ItemPart.EnumPart.WIREDPLATE.getItemStack(), Character.valueOf('s'), Item.field_77669_D, Character.valueOf('p'), ItemPart.EnumPart.PLATE.getItemStack()});
        AlloySmelterRecipe.add(new AlloySmelterRecipe(new ItemStack[]{new ItemStack(Block.field_71939_E, 8), new ItemStack(Item.field_77705_m, 8)}, ItemPart.EnumPart.SILICONBOULE.getItemStack(), 500));
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.SILICON.getItemStack(8), (Object[])new Object[]{"s", "b", Character.valueOf('s'), new ItemStack((Item)ProjectRed.itemSaw, 1, Short.MAX_VALUE), Character.valueOf('b'), ItemPart.EnumPart.SILICONBOULE.getItemStack()});
        AlloySmelterRecipe.add(new AlloySmelterRecipe(new ItemStack[]{ItemPart.EnumPart.SILICON.getItemStack(), new ItemStack(Item.field_77767_aC, 4)}, ItemPart.EnumPart.INFUSEDSILICON.getItemStack(), 150));
        AlloySmelterRecipe.add(new AlloySmelterRecipe(new ItemStack[]{ItemPart.EnumPart.SILICON.getItemStack(), new ItemStack(Item.field_77751_aT, 4)}, ItemPart.EnumPart.ENERGIZEDSILICON.getItemStack(), 160));
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.MOTOR.getItemStack(), (Object[])new Object[]{" i ", "scs", "rcr", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('s'), Block.field_71981_t, Character.valueOf('c'), ItemPart.EnumPart.COPPERCOIL.getItemStack(), Character.valueOf('r'), Item.field_77767_aC});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ItemPart.EnumPart.COPPERCOIL.getItemStack(), new Object[]{"cd", Character.valueOf('c'), "ingotCopper", Character.valueOf('d'), new ItemStack((Item)ProjectRed.itemDrawPlate, 1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.IRONCOIL.getItemStack(), (Object[])new Object[]{"cd", Character.valueOf('c'), new ItemStack(Item.field_77703_o), Character.valueOf('d'), new ItemStack((Item)ProjectRed.itemDrawPlate, 1, Short.MAX_VALUE)});
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.GOLDCOIL.getItemStack(), (Object[])new Object[]{"cd", Character.valueOf('c'), new ItemStack(Item.field_77717_p), Character.valueOf('d'), new ItemStack((Item)ProjectRed.itemDrawPlate, 1, Short.MAX_VALUE)});
        AlloySmelterRecipe.add(new AlloySmelterRecipe(new ItemStack[]{new ItemStack(Item.field_77703_o), new ItemStack(Item.field_77767_aC, 4)}, ItemPart.EnumPart.REDINGOT.getItemStack(), 125));
        for (int i = 0; i < ItemPart.EnumPart.ILLUMAR_PARTS.length; ++i) {
            ItemPart.EnumPart p = ItemPart.EnumPart.ILLUMAR_PARTS[i];
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(p.getItemStack(), new Object[]{new ItemStack(Item.field_77751_aT), new ItemStack(Item.field_77751_aT), Color.get(i).getOreDict(), Color.get(i).getOreDict()}));
        }
        GameRegistry.addRecipe((ItemStack)ItemPart.EnumPart.WOVENCLOTH.getItemStack(), (Object[])new Object[]{"sss", "sws", "sss", Character.valueOf('s'), Item.field_77683_K, Character.valueOf('w'), Item.field_77669_D});
    }

    private static void initMachineRecipes() {
        for (BlockLamp.EnumLamp enumLamp : BlockLamp.EnumLamp.VALID_TYPES) {
            GameRegistry.addRecipe((ItemStack)enumLamp.getItemStack(), (Object[])new Object[]{"gIg", "gIg", "gtg", Character.valueOf('g'), Block.field_72003_bq, Character.valueOf('I'), ItemPart.EnumPart.ILLUMAR_PARTS[enumLamp.meta].getItemStack(), Character.valueOf('t'), Item.field_77767_aC});
            GameRegistry.addRecipe((ItemStack)enumLamp.getInvertedItemStack(), (Object[])new Object[]{"gIg", "gIg", "gtg", Character.valueOf('g'), Block.field_72003_bq, Character.valueOf('I'), ItemPart.EnumPart.ILLUMAR_PARTS[enumLamp.meta].getItemStack(), Character.valueOf('t'), Block.field_72035_aQ});
        }
        GameRegistry.addRecipe((ItemStack)BlockMachines.EnumMachine.ALLOYSMELTER.getItemStack(), (Object[])new Object[]{"CBC", "BBB", "CBC", Character.valueOf('C'), Block.field_72041_aW, Character.valueOf('B'), Block.field_72081_al});
        for (Enum enum_ : BlockLantern.EnumLantern.VALID_TYPES) {
            GameRegistry.addRecipe((ItemStack)((BlockLantern.EnumLantern)enum_).getItemStack(), (Object[])new Object[]{"PNP", "GIG", "PRP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('N'), Item.field_77733_bq, Character.valueOf('G'), Block.field_72003_bq, Character.valueOf('I'), ItemPart.EnumPart.ILLUMAR_PARTS[((BlockLantern.EnumLantern)enum_).meta].getItemStack(), Character.valueOf('R'), Item.field_77767_aC});
            GameRegistry.addRecipe((ItemStack)((BlockLantern.EnumLantern)enum_).getInvertedItemStack(), (Object[])new Object[]{"PNP", "GIG", "PRP", Character.valueOf('P'), ItemPart.EnumPart.PLATE.getItemStack(), Character.valueOf('N'), Item.field_77733_bq, Character.valueOf('G'), Block.field_72003_bq, Character.valueOf('I'), ItemPart.EnumPart.ILLUMAR_PARTS[((BlockLantern.EnumLantern)enum_).meta].getItemStack(), Character.valueOf('R'), Block.field_72035_aQ});
        }
    }

    private static void initToolRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ProjectRed.itemSaw), (Object[])new Object[]{"sss", "ii ", "dd ", Character.valueOf('s'), Item.field_77669_D, Character.valueOf('i'), Item.field_77703_o, Character.valueOf('d'), Item.field_77702_n});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ProjectRed.itemScrewdriver), (Object[])new Object[]{"i  ", " ib", " bi", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('b'), new ItemStack(Item.field_77756_aW, 1, Color.BLUE.dyeId())});
        GameRegistry.addRecipe((IRecipe)new RecipeDrawPlate());
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ProjectRed.itemWoolGin), (Object[])new Object[]{"sis", "sss", " s ", Character.valueOf('s'), Item.field_77669_D, Character.valueOf('i'), ItemPart.EnumPart.IRONCOIL.getItemStack()});
        for (int i = 0; i < ItemBackpack.EnumBackpack.VALID_BP.length; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ItemBackpack.EnumBackpack.get(i).getItemStack(), new Object[]{"ccc", "cdc", "ccc", Character.valueOf('c'), ItemPart.EnumPart.WOVENCLOTH.getItemStack(), Character.valueOf('d'), Color.get(i).getOreDict()}));
        }
        GameRegistry.addRecipe((IRecipe)new RecipeBackpackRecoloring());
    }

    private static void initOtherRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(Item.field_77683_K, 4), (Object[])new Object[]{"gw", Character.valueOf('g'), new ItemStack((Item)ProjectRed.itemWoolGin, 1, Short.MAX_VALUE), Character.valueOf('w'), Block.field_72101_ab});
    }

    private static void initOtherAlloySmelterRecipes() {
        AlloySmelterRecipe.add(new AlloySmelterRecipe(new ItemStack[]{EnumWire.RED_ALLOY.getItemStack(4)}, ItemPart.EnumPart.REDINGOT.getItemStack(), 50));
        AlloySmelterRecipe.add(new AlloySmelterRecipe(new ItemStack[]{EnumWire.BUNDLED_N.getItemStack(8)}, ItemPart.EnumPart.REDINGOT.getItemStack(5), 90));
        for (EnumWire w : EnumWire.INSULATED_WIRE) {
            AlloySmelterRecipe.add(new AlloySmelterRecipe(new ItemStack[]{w.getItemStack(4)}, ItemPart.EnumPart.REDINGOT.getItemStack(), 80));
        }
    }
}

