/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.crafting.ProjectRedTabs;
import mrtjp.projectred.tiles.TileLantern;
import mrtjp.projectred.utils.BasicUtils;
import mrtjp.projectred.utils.Coords;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockLantern
extends Block {
    public static Icon[] iconsForBreakEffect = new Icon[16];

    public BlockLantern(int id) {
        super(id, new Material(Material.field_76265_p.field_76234_F));
        this.func_71848_c(0.4f);
        this.func_71849_a(ProjectRedTabs.tabLighting);
        this.func_71905_a(0.34f, 0.25f, 0.34f, 0.66f, 0.75f, 0.66f);
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        TileLantern tile = (TileLantern)BasicUtils.getTileEntity((IBlockAccess)world, new Coords(x, y, z), TileLantern.class);
        if (tile != null) {
            tile.onNeighborBlockChange();
        }
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return -1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int i = 0; i < 32; ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileLantern tile = (TileLantern)BasicUtils.getTileEntity(world, new Coords(x, y, z), TileLantern.class);
        if (tile != null) {
            return tile.getLightValue();
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_71853_i() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister reg) {
        for (int i = 0; i < 16; ++i) {
            BlockLantern.iconsForBreakEffect[i] = reg.func_94245_a("projectred:lanternoff/" + EnumLantern.get((int)i).unlocalName + "off");
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileLantern tile = (TileLantern)BasicUtils.getTileEntity((IBlockAccess)world, new Coords(x, y, z), TileLantern.class);
        if (tile != null) {
            return tile.getDroppedBlock();
        }
        return null;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileLantern tile = (TileLantern)BasicUtils.getTileEntity((IBlockAccess)world, new Coords(x, y, z), TileLantern.class);
        if (tile != null && !player.field_71075_bZ.field_75098_d) {
            BasicUtils.dropItem(world, x, y, z, tile.getDroppedBlock());
        }
        return super.removeBlockByPlayer(world, player, x, y, z);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList();
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta < iconsForBreakEffect.length) {
            return iconsForBreakEffect[meta];
        }
        return null;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileLantern();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public static enum EnumLantern {
        WHITE("White Lantern", "lanternwhite"),
        ORANGE("Orange Lantern", "lanternorange"),
        MAGENTA("Magenta Lantern", "lanternmagenta"),
        LIGHTBLUE("Light Blue Lantern", "lanternlightblue"),
        YELLOW("Yellow Lantern", "lanternyellow"),
        LIME("Lime Lantern", "lanternlime"),
        PINK("Pink Lantern", "lanternpink"),
        GREY("Grey Lantern", "lanterngrey"),
        LIGHTGREY("Light Grey Lantern", "lanternlightgrey"),
        CYAN("Cyan Lantern", "lanterncyan"),
        PURPLE("Purple Lantern", "lanternpurple"),
        BLUE("Blue Lantern", "lanternblue"),
        BROWN("Brown Lantern", "lanternbrown"),
        GREEN("Green Lantern", "lanterngreen"),
        RED("Red Lantern", "lanternred"),
        BLACK("Black Lantern", "lanternblack"),
        INVALID("ERROR INVALID LANTERN", "INVALID");

        public final String fullName;
        public final String unlocalName;
        public static final EnumLantern[] VALID_TYPES;
        public int meta = this.ordinal();
        public static final String oreDictDefinition = "projredLantern";

        /*
         * WARNING - void declaration
         */
        private EnumLantern() {
            void unlocal;
            void name;
            this.fullName = name;
            this.unlocalName = unlocal;
        }

        public static EnumLantern get(int i) {
            if (i > VALID_TYPES.length - 1) {
                return INVALID;
            }
            return VALID_TYPES[i];
        }

        public ItemStack getItemStack() {
            return new ItemStack(ProjectRed.blockLantern.field_71990_ca, 1, this.meta);
        }

        public ItemStack getInvertedItemStack() {
            return new ItemStack(ProjectRed.blockLantern.field_71990_ca, 1, this.meta + 16);
        }

        public static void initOreDictDefinitions() {
            for (EnumLantern l : VALID_TYPES) {
                OreDictionary.registerOre((String)oreDictDefinition, (ItemStack)l.getItemStack());
                OreDictionary.registerOre((String)oreDictDefinition, (ItemStack)l.getInvertedItemStack());
            }
        }

        static {
            VALID_TYPES = new EnumLantern[]{WHITE, ORANGE, MAGENTA, LIGHTBLUE, YELLOW, LIME, PINK, GREY, LIGHTGREY, CYAN, PURPLE, BLUE, BROWN, GREEN, RED, BLACK};
        }
    }
}

