/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.crafting.ProjectRedTabs;
import mrtjp.projectred.tiles.TileLamp;
import mrtjp.projectred.utils.BasicUtils;
import mrtjp.projectred.utils.Coords;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockLamp
extends Block {
    public static Icon[] onIcons = new Icon[16];
    public static Icon[] offIcons = new Icon[16];

    public BlockLamp(int id) {
        super(id, new Material(Material.field_76265_p.field_76234_F));
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_71848_c(0.5f);
        this.func_71849_a(ProjectRedTabs.tabLighting);
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        TileLamp tile = (TileLamp)BasicUtils.getTileEntity((IBlockAccess)world, new Coords(x, y, z), TileLamp.class);
        if (tile != null) {
            tile.onNeighborBlockChange();
        }
    }

    public boolean func_71886_c() {
        return true;
    }

    public int func_71857_b() {
        return 0;
    }

    public boolean func_71926_d() {
        return true;
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return true;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int i = 0; i < 32; ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileLamp tile = (TileLamp)BasicUtils.getTileEntity(world, new Coords(x, y, z), TileLamp.class);
        if (tile != null) {
            return tile.getLightValue();
        }
        return 0;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_71853_i() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister reg) {
        for (int i = 0; i < 16; ++i) {
            BlockLamp.onIcons[i] = reg.func_94245_a("projectred:lampon/" + EnumLamp.get((int)i).unlocalName + "on");
            BlockLamp.offIcons[i] = reg.func_94245_a("projectred:lampoff/" + EnumLamp.get((int)i).unlocalName + "off");
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileLamp tile = (TileLamp)BasicUtils.getTileEntity((IBlockAccess)world, new Coords(x, y, z), TileLamp.class);
        if (tile != null) {
            return tile.getDroppedBlock();
        }
        return null;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileLamp tile = (TileLamp)BasicUtils.getTileEntity((IBlockAccess)world, new Coords(x, y, z), TileLamp.class);
        if (tile != null && !player.field_71075_bZ.field_75098_d) {
            BasicUtils.dropItem(world, x, y, z, tile.getDroppedBlock());
        }
        return super.removeBlockByPlayer(world, player, x, y, z);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList();
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileLamp tile = (TileLamp)BasicUtils.getTileEntity(world, new Coords(x, y, z), TileLamp.class);
        if (tile != null) {
            if (tile.getLightValue() == 15) {
                return onIcons[tile.getColor()];
            }
            return offIcons[tile.getColor()];
        }
        return super.func_71895_b(world, x, y, z, side);
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta > 15) {
            return onIcons[meta - 16];
        }
        return offIcons[meta];
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileLamp();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public static enum EnumLamp {
        WHITE("White Lamp", "lampwhite"),
        ORANGE("Orange Lamp", "lamporange"),
        MAGENTA("Magenta Lamp", "lampmagenta"),
        LIGHTBLUE("Light Blue Lamp", "lamplightblue"),
        YELLOW("Yellow Lamp", "lampyellow"),
        LIME("Lime Lamp", "lamplime"),
        PINK("Pink Lamp", "lamppink"),
        GREY("Grey Lamp", "lampgrey"),
        LIGHTGREY("Light Grey Lamp", "lamplightgrey"),
        CYAN("Cyan Lamp", "lampcyan"),
        PURPLE("Purple Lamp", "lamppurple"),
        BLUE("Blue Lamp", "lampblue"),
        BROWN("Brown Lamp", "lampbrown"),
        GREEN("Green Lamp", "lampgreen"),
        RED("Red Lamp", "lampred"),
        BLACK("Black Lamp", "lampblack"),
        INVALID("ERROR INVALID LAMP", "INVALID");

        public final String fullName;
        public final String unlocalName;
        public static final EnumLamp[] VALID_TYPES;
        public int meta = this.ordinal();
        public static final String oreDictDefinition = "projredLamp";

        /*
         * WARNING - void declaration
         */
        private EnumLamp() {
            void unlocal;
            void name;
            this.fullName = name;
            this.unlocalName = unlocal;
        }

        public static EnumLamp get(int i) {
            if (i > VALID_TYPES.length - 1) {
                return INVALID;
            }
            return VALID_TYPES[i];
        }

        public ItemStack getItemStack() {
            return new ItemStack(ProjectRed.blockLamp.field_71990_ca, 1, this.meta);
        }

        public ItemStack getInvertedItemStack() {
            return new ItemStack(ProjectRed.blockLamp.field_71990_ca, 1, this.meta + 16);
        }

        public static void initOreDictDefinitions() {
            for (EnumLamp l : VALID_TYPES) {
                OreDictionary.registerOre((String)oreDictDefinition, (ItemStack)l.getItemStack());
            }
        }

        static {
            VALID_TYPES = new EnumLamp[]{WHITE, ORANGE, MAGENTA, LIGHTBLUE, YELLOW, LIME, PINK, GREY, LIGHTGREY, CYAN, PURPLE, BLUE, BROWN, GREEN, RED, BLACK};
        }
    }
}

