/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.utils.codechicken.core.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import mrtjp.projectred.utils.codechicken.core.render.TextureFX;
import mrtjp.projectred.utils.codechicken.core.render.TextureSpecial;
import mrtjp.projectred.utils.codechicken.core.render.TextureUtils;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureStitched;
import net.minecraft.util.Icon;
import org.lwjgl.util.Dimension;

public class SpriteSheetManager {
    private static HashMap spriteSheets = new HashMap();

    public static SpriteSheet getSheet(String textureFile) {
        return SpriteSheetManager.getSheet(16, 16, textureFile);
    }

    public static SpriteSheet getSheet(int tilesX, int tilesY, String textureFile) {
        SpriteSheet sheet = (SpriteSheet)spriteSheets.get(textureFile);
        if (sheet == null) {
            sheet = new SpriteSheet(tilesX, tilesY, textureFile);
            spriteSheets.put(textureFile, sheet);
        }
        return sheet;
    }

    @SideOnly(value=Side.CLIENT)
    public static class SpriteSheet
    implements TextureUtils.IIconRegister {
        private int tilesX;
        private int tilesY;
        private ArrayList newSprites = new ArrayList();
        private TextureSpecial[] sprites;
        private String textureFile;
        private Texture texture;
        private int spriteWidth;
        private int spriteHeight;
        public int atlasIndex;

        private SpriteSheet(int tilesX, int tilesY, String textureFile) {
            this.tilesX = tilesX;
            this.tilesY = tilesY;
            this.textureFile = textureFile;
            this.sprites = new TextureSpecial[tilesX * tilesY];
        }

        public void requestIndicies(int ... indicies) {
            for (int i : indicies) {
                this.setupSprite(i);
            }
        }

        @Override
        public void registerIcons(IconRegister register) {
            TextureMap textureMap = (TextureMap)register;
            if (TextureUtils.refreshTexture(textureMap, this.textureFile)) {
                this.reloadTexture();
                for (int i = 0; i < this.sprites.length; ++i) {
                    if (this.sprites[i] == null) continue;
                    textureMap.setTextureEntry(this.sprites[i].func_94215_i(), (TextureStitched)this.sprites[i]);
                }
            } else {
                Iterator i$ = this.newSprites.iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    textureMap.setTextureEntry(this.sprites[i].func_94215_i(), (TextureStitched)this.sprites[i]);
                }
            }
            this.newSprites.clear();
        }

        public TextureSpecial setupSprite(int i) {
            if (this.sprites[i] == null) {
                String name = this.textureFile + "_" + i;
                this.sprites[i] = new TextureSpecial(name).baseFromSheet(this, i);
                this.newSprites.add(i);
            }
            return this.sprites[i];
        }

        private void reloadTexture() {
            this.texture = TextureUtils.createTextureObject(this.textureFile);
            Dimension dim = TextureUtils.getTextureDimension(this.textureFile);
            this.spriteWidth = dim.getWidth() / this.tilesX;
            this.spriteHeight = dim.getHeight() / this.tilesY;
        }

        public Icon getSprite(int index) {
            TextureSpecial i = this.sprites[index];
            if (i == null) {
                throw new IllegalArgumentException("Sprite at index: " + index + " from texture file " + this.textureFile + " was not preloaded.");
            }
            return i;
        }

        public Texture createSprite(int spriteIndex) {
            int sx = spriteIndex % this.tilesX;
            int sy = spriteIndex / this.tilesX;
            Texture sprite = TextureUtils.createTextureObject(this.textureFile + "_" + spriteIndex, this.spriteWidth, this.spriteHeight);
            TextureUtils.copySubImg(this.texture, sx * this.spriteWidth, sy * this.spriteHeight, this.spriteWidth, this.spriteHeight, sprite, 0, 0);
            return sprite;
        }

        public int spriteWidth() {
            return this.spriteWidth;
        }

        public int spriteHeight() {
            return this.spriteHeight;
        }

        public TextureSpecial bindTextureFX(int i, TextureFX textureFX) {
            return this.setupSprite(i).addTextureFX(textureFX);
        }

        public SpriteSheet selfRegister(int atlas) {
            TextureUtils.addIconRegistrar(this);
            return this;
        }

        @Override
        public int atlasIndex() {
            return this.atlasIndex;
        }
    }
}

