/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.utils.codechicken.core.colour;

import java.awt.image.BufferedImage;
import mrtjp.projectred.utils.codechicken.core.alg.MathHelper;
import mrtjp.projectred.utils.codechicken.core.colour.ColourRGBA;
import mrtjp.projectred.utils.codechicken.core.render.TextureUtils;

public class CustomGradient {
    public int[] gradient;

    public CustomGradient(String textureFile) {
        BufferedImage img = TextureUtils.loadBufferedImage(textureFile);
        int[] data = new int[img.getWidth()];
        img.getRGB(0, 0, img.getWidth(), 1, data, 0, img.getWidth());
        this.gradient = new int[img.getWidth()];
        for (int i = 0; i < data.length; ++i) {
            this.gradient[i] = data[i] << 8 | data[i] >> 24 & 0xFF;
        }
    }

    public ColourRGBA getColour(double position) {
        return new ColourRGBA(this.getColourI(position));
    }

    public int getColourI(double position) {
        int off = (int)MathHelper.clip((double)this.gradient.length * position, 0.0, this.gradient.length - 1);
        return this.gradient[off];
    }
}

