/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.utils;

import java.util.LinkedList;
import mrtjp.projectred.interfaces.ISimpleInventoryListener;
import mrtjp.projectred.utils.BasicUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class SimpleInventory
implements IInventory {
    private final String _name;
    private ItemStack[] _contents;
    private final int _stackLimit;
    private final LinkedList _listener = new LinkedList();

    public SimpleInventory(int size, String name, int stackLimit) {
        this(size, name, stackLimit, null);
    }

    public SimpleInventory(int size, String name, int stackLimit, ISimpleInventoryListener listener) {
        this._contents = new ItemStack[size];
        this._name = name;
        this._stackLimit = stackLimit;
        if (listener != null) {
            this.addListener(listener);
        }
    }

    public int func_70302_i_() {
        return this._contents.length;
    }

    public ItemStack func_70301_a(int i) {
        return this._contents[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this._contents[i] == null) {
            return null;
        }
        if (this._contents[i].field_77994_a > j) {
            ItemStack ret = this._contents[i].func_77979_a(j);
            return ret;
        }
        ItemStack ret = this._contents[i];
        this._contents[i] = null;
        return ret;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this._contents[i] = itemstack;
    }

    public String func_70303_b() {
        return this._name;
    }

    public int func_70297_j_() {
        return this._stackLimit;
    }

    public void func_70296_d() {
        for (ISimpleInventoryListener handler : this._listener) {
            handler.InventoryChanged(this);
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound, "");
    }

    public void readFromNBT(NBTTagCompound nbt, String prefix) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagList nbttaglist = nbt.func_74761_m(prefix + "items");
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist.func_74743_b(j);
            int index = nbttagcompound2.func_74762_e("index");
            if (index >= this._contents.length) continue;
            this._contents[index] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2);
        }
        this.func_70296_d();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this.writeToNBT(nbttagcompound, "");
    }

    public void writeToNBT(NBTTagCompound nbt, String prefix) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int j = 0; j < this._contents.length; ++j) {
            if (this._contents[j] == null || this._contents[j].field_77994_a <= 0) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            nbttagcompound2.func_74768_a("index", j);
            this._contents[j].func_77955_b(nbttagcompound2);
        }
        nbt.func_74782_a(prefix + "items", (NBTBase)nbttaglist);
        nbt.func_74768_a(prefix + "itemsCount", this._contents.length);
    }

    public void dropContents(World worldObj, int posX, int posY, int posZ) {
        if (BasicUtils.isServer(worldObj)) {
            for (int i = 0; i < this._contents.length; ++i) {
                while (this._contents[i] != null) {
                    ItemStack todrop = this.func_70298_a(i, this._contents[i].func_77976_d());
                    BasicUtils.dropItem(worldObj, posX, posY, posZ, todrop);
                }
            }
            this.func_70296_d();
        }
    }

    public void addListener(ISimpleInventoryListener listner) {
        if (!this._listener.contains(listner)) {
            this._listener.add(listner);
        }
    }

    public void removeListener(ISimpleInventoryListener listner) {
        if (this._listener.contains(listner)) {
            this._listener.remove(listner);
        }
    }

    public ItemStack func_70304_b(int i) {
        if (this._contents[i] == null) {
            return null;
        }
        ItemStack stackToTake = this._contents[i];
        this._contents[i] = null;
        this.func_70296_d();
        return stackToTake;
    }

    private int tryAddToSlot(int i, ItemStack stack) {
        ItemStack slot = this._contents[i];
        if (slot == null) {
            this._contents[i] = stack.func_77946_l();
            return stack.field_77994_a;
        }
        if (BasicUtils.areStacksTheSame(slot, stack)) {
            slot.field_77994_a += stack.field_77994_a;
            if (slot.field_77994_a > 127) {
                int ans = stack.field_77994_a - (slot.field_77994_a - 127);
                slot.field_77994_a = 127;
                return ans;
            }
            return stack.field_77994_a;
        }
        return 0;
    }

    public int addCompressed(ItemStack stack) {
        int added;
        int i;
        if (stack == null) {
            return 0;
        }
        stack = stack.func_77946_l();
        for (i = 0; i < this._contents.length && stack.field_77994_a > 0; ++i) {
            if (this._contents[i] == null) continue;
            added = this.tryAddToSlot(i, stack);
            stack.field_77994_a -= added;
        }
        for (i = 0; i < this._contents.length && stack.field_77994_a > 0; ++i) {
            added = this.tryAddToSlot(i, stack);
            stack.field_77994_a -= added;
        }
        this.func_70296_d();
        return stack.field_77994_a;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public ItemStack[] getContents() {
        return this._contents;
    }
}

