/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.utils;

import java.lang.reflect.Field;
import mrtjp.projectred.interfaces.wiring.IRedstoneEmitter;
import mrtjp.projectred.multipart.microblocks.IMicroblockCoverSystem;
import mrtjp.projectred.multipart.microblocks.IMicroblockSupporterTile;
import mrtjp.projectred.multipart.wiring.wires.EnumWire;
import mrtjp.projectred.multipart.wiring.wires.TilePlainRedAlloy;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BasicWireUtils {
    private static final int plainRedAlloyMeta = (Integer)EnumWire.CLASS_TO_META.get(TilePlainRedAlloy.class);
    private static int[][] rotationMap = new int[][]{{9, 9, 4, 5, 3, 2}, {9, 9, 5, 4, 2, 3}, {5, 4, 9, 9, 0, 1}, {4, 5, 9, 9, 1, 0}, {2, 3, 1, 0, 9, 9}, {3, 2, 0, 1, 9, 9}};
    public static final int FRONT = 0;
    public static final int BACK = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int[][][] dirMap = new int[6][6][4];
    public static final int[][][] invDirMap = new int[6][6][6];
    private static Field wiresProvidePower;

    public static boolean canConnectThroughEdge(World w, int x, int y, int z, int side, int dir) {
        TileEntity te = w.func_72796_p(x, y, z);
        if (te instanceof IMicroblockSupporterTile) {
            IMicroblockCoverSystem ci = ((IMicroblockSupporterTile)te).getCoverSystem();
            return ci.isEdgeOpen(side, dir);
        }
        return !w.isBlockSolidOnSide(x, y, z, ForgeDirection.VALID_DIRECTIONS[side]) && !w.isBlockSolidOnSide(x, y, z, ForgeDirection.VALID_DIRECTIONS[dir]);
    }

    public static short getPowerStrength(World w, int x, int y, int z, int toDirection, int onSide) {
        return BasicWireUtils.getPowerStrength(w, x, y, z, toDirection, onSide, true);
    }

    public static short getPowerStrength(World w, int x, int y, int z, int toDirection, int onSide, boolean countRedAlloyWire) {
        block10: {
            TileEntity te;
            Block b = Block.field_71973_m[w.func_72798_a(x, y, z)];
            int meta = w.func_72805_g(x, y, z);
            if (b == Block.field_72075_av) {
                return (short)((meta - 1) * 17);
            }
            if (b == null) {
                return 0;
            }
            if (b.hasTileEntity(meta) && (te = w.func_72796_p(x, y, z)) instanceof IRedstoneEmitter) {
                if (!countRedAlloyWire && te instanceof TilePlainRedAlloy) {
                    return 0;
                }
                return ((IRedstoneEmitter)te).getEmittedSignalStrength(onSide, toDirection);
            }
            int pl = b.func_71855_c((IBlockAccess)w, x, y, z, toDirection ^ 1);
            if (pl > 0) {
                return (short)(pl * 17);
            }
            if (w.func_72809_s(x, y, z)) {
                try {
                    wiresProvidePower.set(Block.field_72075_av, false);
                    pl = w.func_94577_B(x, y, z);
                    wiresProvidePower.set(Block.field_72075_av, true);
                    if (pl > 0) {
                        return (short)(pl * 17);
                    }
                    break block10;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            pl = b.func_71865_a((IBlockAccess)w, x, y, z, toDirection ^ 1);
            if (pl > 0) {
                return (short)(pl * 17);
            }
        }
        return 0;
    }

    public static boolean canPlaceWireOnSide(World w, int x, int y, int z, ForgeDirection side, boolean _default) {
        if (!w.func_72899_e(x, y, z)) {
            return _default;
        }
        Block b = Block.field_71973_m[w.func_72798_a(x, y, z)];
        if (b == null) {
            return false;
        }
        if (b == Block.field_72014_bd || b == Block.field_71963_Z || b == Block.field_71956_V || b == Block.field_72095_ac || b == Block.field_71946_M) {
            return true;
        }
        return b.isBlockSolidOnSide(w, x, y, z, side);
    }

    static {
        for (int side = 0; side < 6; ++side) {
            for (int front = 0; front < 6; ++front) {
                if ((front & 6) == (side & 6)) continue;
                BasicWireUtils.dirMap[side][front][0] = front;
                BasicWireUtils.dirMap[side][front][1] = front ^ 1;
                BasicWireUtils.dirMap[side][front][2] = rotationMap[side][front];
                BasicWireUtils.dirMap[side][front][3] = rotationMap[side][front ^ 1];
                for (int dir = 0; dir < 4; ++dir) {
                    BasicWireUtils.invDirMap[side][front][BasicWireUtils.dirMap[side][front][dir]] = dir;
                }
            }
        }
        wiresProvidePower = BlockRedstoneWire.class.getDeclaredFields()[0];
        try {
            wiresProvidePower.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

