/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.wires;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.interfaces.wiring.IConnectable;
import mrtjp.projectred.interfaces.wiring.IWire;
import mrtjp.projectred.multipart.TileCoverableBase;
import mrtjp.projectred.multipart.microblocks.EnumPosition;
import mrtjp.projectred.multipart.microblocks.EnumPositionClass;
import mrtjp.projectred.multipart.microblocks.IMicroblockCoverSystem;
import mrtjp.projectred.multipart.microblocks.Part;
import mrtjp.projectred.multipart.microblocks.PartType;
import mrtjp.projectred.multipart.wiring.InvalidTile;
import mrtjp.projectred.multipart.wiring.wires.EnumWire;
import mrtjp.projectred.multipart.wiring.wires.WireRenderer;
import mrtjp.projectred.utils.BasicUtils;
import mrtjp.projectred.utils.BasicWireUtils;
import mrtjp.projectred.utils.Coords;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileWire
extends TileCoverableBase
implements IConnectable,
IWire {
    private EnumWire wireType;
    private boolean containsJacketed;
    private byte jacketConnectMaskCache;
    private byte wireMask;
    private int connectMaskCache = -1;
    private int connectCornerCache = -1;
    private boolean notifyNeighboursNextTick = false;

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        if (this.wireType == null) {
            new InvalidTile().func_70310_b(tag);
            return;
        }
        super.func_70310_b(tag);
        tag.func_74774_a("type", (byte)this.wireType.ordinal());
        tag.func_74774_a("mask", this.wireMask);
        tag.func_74768_a("cmc", this.connectMaskCache);
        tag.func_74768_a("ccc", this.connectCornerCache);
        if (this.canUpdate()) {
            tag.func_74757_a("notifyQueued", this.notifyNeighboursNextTick);
        }
        if (this.containsJacketed) {
            tag.func_74774_a("jcmc", this.jacketConnectMaskCache);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        byte type = tag.func_74771_c("type");
        this.wireType = type < 0 || type >= EnumWire.VALUES.length ? null : EnumWire.VALUES[type];
        this.wireMask = tag.func_74771_c("mask");
        this.containsJacketed = tag.func_74764_b("jcmc");
        if (this.containsJacketed) {
            this.jacketConnectMaskCache = tag.func_74771_c("jcmc");
        }
        if (tag.func_74764_b("cmc")) {
            this.connectMaskCache = tag.func_74762_e("cmc");
            this.connectCornerCache = tag.func_74762_e("ccc");
        } else {
            this.connectMaskCache = -1;
            this.connectCornerCache = -1;
        }
        if (this.canUpdate()) {
            this.notifyNeighboursNextTick = tag.func_74767_n("notifyQueued");
        }
    }

    public abstract boolean canUpdate();

    public void func_70316_g() {
        if (this.notifyNeighboursNextTick) {
            this.notifyNeighboursNextTick = false;
            this.notifyNeighbours();
        }
        super.func_70316_g();
    }

    @Override
    public boolean isPlacementBlockedByTile(PartType type, EnumPosition pos) {
        int MASK_NX = 16;
        int MASK_PX = 32;
        boolean MASK_NY = true;
        int MASK_PY = 2;
        int MASK_NZ = 4;
        int MASK_PZ = 8;
        double MAX_OPPOSITE_THICKNESS = 1.0 - this.getType().thickness;
        double MAX_SIDE_THICKNESS = 0.25;
        if (pos.clazz == EnumPositionClass.Centre || pos.clazz == EnumPositionClass.Post) {
            return true;
        }
        switch (pos) {
            case FaceNX: {
                return (this.wireMask & 0x10) != 0 || (this.wireMask & 0xFFFFFFDF) != 0 && type.getSize() > 0.25 || (this.wireMask & 0x20) != 0 && type.getSize() > MAX_OPPOSITE_THICKNESS;
            }
            case FacePX: {
                return (this.wireMask & 0x20) != 0 || (this.wireMask & 0xFFFFFFEF) != 0 && type.getSize() > 0.25 || (this.wireMask & 0x10) != 0 && type.getSize() > MAX_OPPOSITE_THICKNESS;
            }
            case FaceNY: {
                return (this.wireMask & 1) != 0 || (this.wireMask & 0xFFFFFFFD) != 0 && type.getSize() > 0.25 || (this.wireMask & 2) != 0 && type.getSize() > MAX_OPPOSITE_THICKNESS;
            }
            case FacePY: {
                return (this.wireMask & 2) != 0 || (this.wireMask & 0xFFFFFFFE) != 0 && type.getSize() > 0.25 || (this.wireMask & 1) != 0 && type.getSize() > MAX_OPPOSITE_THICKNESS;
            }
            case FaceNZ: {
                return (this.wireMask & 4) != 0 || (this.wireMask & 0xFFFFFFF7) != 0 && type.getSize() > 0.25 || (this.wireMask & 8) != 0 && type.getSize() > MAX_OPPOSITE_THICKNESS;
            }
            case FacePZ: {
                return (this.wireMask & 8) != 0 || (this.wireMask & 0xFFFFFFFB) != 0 && type.getSize() > 0.25 || (this.wireMask & 4) != 0 && type.getSize() > MAX_OPPOSITE_THICKNESS;
            }
        }
        double FAKE_WIRE_MIN = 0.25;
        double FAKE_WIRE_MAX = 0.75;
        double FAKE_WIRE_THICK = 1.0 - MAX_OPPOSITE_THICKNESS;
        block16: for (int k = 0; k < 6; ++k) {
            AxisAlignedBB bb;
            if (!this.isWirePresent(k)) continue;
            switch (k) {
                case 4: {
                    bb = AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.25, 0.25, FAKE_WIRE_THICK, 0.75, 0.75);
                    break;
                }
                case 0: {
                    bb = AxisAlignedBB.func_72332_a().func_72299_a(0.25, 0.0, 0.25, 0.75, FAKE_WIRE_THICK, 0.75);
                    break;
                }
                case 2: {
                    bb = AxisAlignedBB.func_72332_a().func_72299_a(0.25, 0.25, 0.0, 0.75, 0.75, FAKE_WIRE_THICK);
                    break;
                }
                case 5: {
                    bb = AxisAlignedBB.func_72332_a().func_72299_a(1.0 - FAKE_WIRE_THICK, 0.25, 0.25, 1.0, 0.75, 0.75);
                    break;
                }
                case 1: {
                    bb = AxisAlignedBB.func_72332_a().func_72299_a(0.25, 1.0 - FAKE_WIRE_THICK, 0.25, 0.75, 1.0, 0.75);
                    break;
                }
                case 3: {
                    bb = AxisAlignedBB.func_72332_a().func_72299_a(0.25, 0.25, 1.0 - FAKE_WIRE_THICK, 0.75, 0.75, 1.0);
                    break;
                }
                default: {
                    continue block16;
                }
            }
            if (!bb.func_72326_a(Part.getBoundingBoxFromPool(pos, type.getSize()))) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceWireOnSide(EnumWire type, int side) {
        int newMask = this.wireMask | 1 << side;
        return type == this.wireType && (this.wireMask & 1 << side) == 0 && (this.containsJacketed || newMask != 3 && newMask != 12 && newMask != 48);
    }

    public boolean canAddJacketedWire(EnumWire type) {
        return type == this.getType() && !this.containsJacketed;
    }

    void rawAddWire(EnumWire type, int side) {
        if (type != this.wireType && this.wireType != null) {
            throw new IllegalArgumentException("wrong type (passed " + (Object)((Object)type) + ", expected " + (Object)((Object)this.wireType) + ")");
        }
        this.wireType = type;
        this.wireMask = (byte)(this.wireMask | (byte)(1 << side));
    }

    public boolean addWire(EnumWire type, int side) {
        if (!this.canPlaceWireOnSide(type, side)) {
            return false;
        }
        this.wireMask = (byte)(this.wireMask | (byte)(1 << side));
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.computeConnections();
        this.notifyExtendedNeighbours();
        return true;
    }

    void rawAddJacketedWire(EnumWire type) {
        if (this.getType() != null && type != this.getType()) {
            throw new IllegalArgumentException("wrong type (passed " + (Object)((Object)type) + ", expected " + (Object)((Object)this.getType()) + ")");
        }
        this.wireType = type;
        this.containsJacketed = true;
    }

    public boolean addJacketedWire(EnumWire type) {
        if (!this.canAddJacketedWire(type)) {
            return false;
        }
        this.rawAddJacketedWire(type);
        this.computeConnections();
        this.notifyExtendedNeighbours();
        return true;
    }

    public Packet132TileEntityData getDescriptionPacket() {
        if (this.wireType == null) {
            return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, new NBTTagCompound());
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (this.wireType == null) {
            tag.func_74757_a("invalid", true);
        } else {
            if (this.connectMaskCache == -1 || this.connectCornerCache == -1) {
                this.computeConnections();
            }
            tag.func_74774_a("t", (byte)this.wireType.ordinal());
            tag.func_74774_a("m", this.wireMask);
            tag.func_74773_a("c", this.getCoverSystem().writeDescriptionBytes());
            tag.func_74768_a("C", this.connectMaskCache);
            tag.func_74768_a("C2", this.connectCornerCache);
            if (this.containsJacketed) {
                tag.func_74774_a("j", this.jacketConnectMaskCache);
            }
        }
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, tag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        if (pkt.field_73331_e.func_74767_n("invalid")) {
            return;
        }
        this.wireType = EnumWire.VALUES[pkt.field_73331_e.func_74771_c("t")];
        this.wireMask = pkt.field_73331_e.func_74771_c("m");
        this.getCoverSystem().readDescriptionBytes(pkt.field_73331_e.func_74770_j("c"), 0);
        this.connectMaskCache = pkt.field_73331_e.func_74762_e("C");
        this.connectCornerCache = pkt.field_73331_e.func_74762_e("C2");
        this.containsJacketed = pkt.field_73331_e.func_74764_b("j");
        if (this.containsJacketed) {
            this.jacketConnectMaskCache = pkt.field_73331_e.func_74771_c("j");
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public final EnumWire getType() {
        return this.wireType;
    }

    public final byte getSideMask() {
        return this.wireMask;
    }

    void onNeighbourBlockChange() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        for (int k = 0; k < 6; ++k) {
            int z;
            int y;
            int x;
            if ((this.wireMask & 1 << k) == 0 || BasicWireUtils.canPlaceWireOnSide(this.field_70331_k, x = this.field_70329_l + ForgeDirection.VALID_DIRECTIONS[k].offsetX, y = this.field_70330_m + ForgeDirection.VALID_DIRECTIONS[k].offsetY, z = this.field_70327_n + ForgeDirection.VALID_DIRECTIONS[k].offsetZ, ForgeDirection.VALID_DIRECTIONS[k ^ 1], true)) continue;
            this.removeAndDropWireOnSide(k);
            if (this.wireMask != 0) continue;
            return;
        }
        this.computeConnections();
    }

    protected boolean connects(int x, int y, int z, int wireSide, int direction) {
        return false;
    }

    protected boolean connectsAroundCorner(int x, int y, int z, int wireSide, int direction) {
        return false;
    }

    private boolean connectsInDirectionUncached(int wireSide, int direction) {
        if ((wireSide & 6) == (direction & 6)) {
            return false;
        }
        if (!this.getCoverSystem().isEdgeOpen(wireSide, direction)) {
            return false;
        }
        if ((this.wireMask & 1 << direction) != 0) {
            return true;
        }
        int x = this.field_70329_l;
        int y = this.field_70330_m;
        int z = this.field_70327_n;
        switch (direction) {
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
                break;
            }
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid direction " + direction);
            }
        }
        if (!this.field_70331_k.func_72799_c(x, y, z)) {
            TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
            if (te instanceof IConnectable) {
                return ((IConnectable)te).connects(this, wireSide, direction ^ 1);
            }
            return this.connects(x, y, z, wireSide, direction ^ 1);
        }
        return false;
    }

    private boolean jacketConnectsInDirectionUncached(int direction) {
        if (!this.containsJacketed) {
            return false;
        }
        if (!this.getCoverSystem().isSideOpen(direction)) {
            return false;
        }
        if ((this.wireMask & 1 << direction) != 0) {
            return true;
        }
        int x = this.field_70329_l;
        int y = this.field_70330_m;
        int z = this.field_70327_n;
        switch (direction) {
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
                break;
            }
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid direction " + direction);
            }
        }
        if (!this.field_70331_k.func_72799_c(x, y, z)) {
            TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
            if (te instanceof IConnectable) {
                return ((IConnectable)te).connects(this, -1, direction ^ 1);
            }
            return this.connects(x, y, z, -1, direction ^ 1);
        }
        return false;
    }

    private boolean connectsAroundCornerUncached(int wireSide, int direction) {
        if ((wireSide & 6) == (direction & 6)) {
            return false;
        }
        if ((this.wireMask & 1 << direction) != 0) {
            return false;
        }
        if (!this.getCoverSystem().isEdgeOpen(wireSide, direction)) {
            return false;
        }
        int x = this.field_70329_l;
        int y = this.field_70330_m;
        int z = this.field_70327_n;
        switch (direction) {
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
                break;
            }
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid direction " + direction);
            }
        }
        if (!BasicWireUtils.canConnectThroughEdge(this.field_70331_k, x, y, z, wireSide, direction ^ 1)) {
            return false;
        }
        switch (wireSide) {
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
                break;
            }
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid direction " + direction);
            }
        }
        TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
        if (te instanceof IConnectable) {
            return ((IConnectable)te).connectsAroundCorner(this, direction ^ 1, wireSide ^ 1);
        }
        return this.connectsAroundCorner(x, y, z, direction ^ 1, wireSide ^ 1);
    }

    private void computeConnections() {
        int prev = this.connectMaskCache;
        int prevC = this.connectCornerCache;
        byte prevJ = this.jacketConnectMaskCache;
        this.connectMaskCache = 0;
        this.connectCornerCache = 0;
        this.jacketConnectMaskCache = 0;
        for (int side = 0; side < 6; ++side) {
            if (this.containsJacketed && this.jacketConnectsInDirectionUncached(side)) {
                this.jacketConnectMaskCache = (byte)(this.jacketConnectMaskCache | 1 << side);
            }
            if ((this.wireMask & 1 << side) == 0) continue;
            for (int dir = 0; dir < 6; ++dir) {
                if (this.connectsInDirectionUncached(side, dir)) {
                    this.connectMaskCache |= 1 << side * 6 + dir - 2;
                    continue;
                }
                if (!this.connectsAroundCornerUncached(side, dir)) continue;
                this.connectMaskCache |= 1 << side * 6 + dir - 2;
                this.connectCornerCache |= 1 << side * 6 + dir - 2;
            }
        }
        if (prev != this.connectMaskCache || prevC != this.connectCornerCache || prevJ != this.jacketConnectMaskCache) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (this.canUpdate()) {
                this.notifyNeighboursNextTick = true;
            } else {
                this.notifyNeighbours();
            }
        }
    }

    public boolean connectsInDirection(int wireSide, int direction) {
        if (this.connectMaskCache == -1) {
            this.computeConnections();
        }
        if (wireSide == -1) {
            return this.connectsInDirectionByJacketedWire(direction);
        }
        return (this.connectMaskCache & 1 << wireSide * 6 + direction - 2) != 0;
    }

    public boolean connectsInDirectionAroundCorner(int wireSide, int direction) {
        if (this.connectMaskCache == -1) {
            this.computeConnections();
        }
        return (this.connectCornerCache & 1 << wireSide * 6 + direction - 2) != 0;
    }

    public boolean connectsInDirectionByJacketedWire(int direction) {
        return this.containsJacketed && (this.jacketConnectMaskCache & 1 << direction) != 0;
    }

    public boolean connectsInDirection(int direction) {
        if (this.connectMaskCache == -1) {
            this.computeConnections();
        }
        if (this.connectsInDirectionByJacketedWire(direction)) {
            return true;
        }
        return (this.connectMaskCache & 0x41041041 << direction - 2) != 0;
    }

    public void removeAndDropWireOnSide(int side) {
        if (!this.removeWireOnSide(side)) {
            return;
        }
        ItemStack dropped = new ItemStack((Block)ProjectRed.blockWire, 1, this.wireType.ordinal());
        BasicUtils.dropItemFromLocation(this.field_70331_k, dropped, false, null, side, 10, new Coords(this));
    }

    public boolean removeWireOnSide(int side) {
        if ((this.wireMask & 1 << side) == 0) {
            return false;
        }
        this.wireMask = (byte)(this.wireMask & ~(1 << side));
        if (this.wireMask == 0 && !this.containsJacketed) {
            if (this.cover != null) {
                this.cover.convertToContainerBlock();
            } else {
                this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 3);
            }
            this.notifyExtendedNeighbours();
        } else if (this.wireMask == 3 && !this.containsJacketed) {
            this.removeAndDropWireOnSide(1);
        } else if (this.wireMask == 12 && !this.containsJacketed) {
            this.removeAndDropWireOnSide(3);
        } else if (this.wireMask == 48 && !this.containsJacketed) {
            this.removeAndDropWireOnSide(5);
        } else {
            this.computeConnections();
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.notifyExtendedNeighbours();
        }
        return true;
    }

    public boolean removeJacketedWire() {
        if (!this.containsJacketed) {
            return false;
        }
        this.containsJacketed = false;
        if (this.wireMask == 0) {
            if (this.cover != null) {
                this.cover.convertToContainerBlock();
            } else {
                this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 3);
            }
            this.notifyExtendedNeighbours();
        } else if (this.wireMask == 3) {
            this.removeAndDropWireOnSide(1);
        } else if (this.wireMask == 12) {
            this.removeAndDropWireOnSide(3);
        } else if (this.wireMask == 48) {
            this.removeAndDropWireOnSide(5);
        } else {
            this.computeConnections();
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.notifyExtendedNeighbours();
        }
        return true;
    }

    void notifyExtendedNeighbours() {
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, ProjectRed.blockWire.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, ProjectRed.blockWire.field_71990_ca);
    }

    private void notifyNeighbourOnClient(int dx, int dy, int dz) {
        if (!this.field_70331_k.field_72995_K) {
            throw new IllegalStateException("Not the client.");
        }
        int blockID = this.field_70331_k.func_72798_a(this.field_70329_l + dx, this.field_70330_m + dy, this.field_70327_n + dz);
        if (blockID == ProjectRed.blockWire.field_71990_ca) {
            Block.field_71973_m[blockID].func_71863_a(this.field_70331_k, this.field_70329_l + dx, this.field_70330_m + dy, this.field_70327_n + dz, ProjectRed.blockWire.field_71990_ca);
        }
    }

    void notifyExtendedNeighbourWiresOnClient() {
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dx = -1; dx <= 1; ++dx) {
                    this.notifyNeighbourOnClient(dx, dy, dz);
                }
            }
        }
        this.notifyNeighbourOnClient(2, 0, 0);
        this.notifyNeighbourOnClient(-2, 0, 0);
        this.notifyNeighbourOnClient(0, 2, 0);
        this.notifyNeighbourOnClient(0, -2, 0);
        this.notifyNeighbourOnClient(0, 0, 2);
        this.notifyNeighbourOnClient(0, 0, -2);
    }

    void notifyNeighbours() {
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, ProjectRed.blockWire.field_71990_ca);
    }

    void notifyConnectedWireNeighbours() {
        int notifiedSides = 0;
        for (int side = 0; side < 6; ++side) {
            for (int dir = 0; dir < 6; ++dir) {
                if (!this.connectsInDirection(side, dir)) continue;
                ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[dir];
                int x = this.field_70329_l + fd.offsetX;
                int y = this.field_70330_m + fd.offsetY;
                int z = this.field_70327_n + fd.offsetZ;
                if (this.connectsInDirectionAroundCorner(side, dir)) {
                    fd = ForgeDirection.VALID_DIRECTIONS[side];
                    x += fd.offsetX;
                    y += fd.offsetY;
                    z += fd.offsetZ;
                } else {
                    if ((notifiedSides & 1 << side) != 0) continue;
                    notifiedSides |= 1 << side;
                }
                if (this.field_70331_k.func_72798_a(x, y, z) != ProjectRed.blockWire.field_71990_ca) continue;
                ProjectRed.blockWire.func_71863_a(this.field_70331_k, x, y, z, ProjectRed.blockWire.field_71990_ca);
            }
        }
    }

    protected boolean canConnectToWire(TileWire wire) {
        return wire.getType() == this.wireType;
    }

    @Override
    public boolean wireConnectsInDirection(int blockFace, int direction) {
        return this.connectsInDirection(blockFace, direction);
    }

    @Override
    public final boolean connects(IWire wire, int blockFace, int fromDirection) {
        if (!this.canConnectToWire((TileWire)wire) || !((TileWire)wire).canConnectToWire(this)) {
            return false;
        }
        IMicroblockCoverSystem imcs = this.getCoverSystem();
        if (blockFace == -1) {
            return this.containsJacketed && (imcs == null || imcs.isSideOpen(fromDirection));
        }
        if (blockFace >= 0 && blockFace <= 5) {
            return (this.wireMask & 1 << blockFace) != 0 && (imcs == null || imcs.isEdgeOpen(blockFace, fromDirection));
        }
        return false;
    }

    @Override
    public boolean connectsAroundCorner(IWire wire, int blockFace, int fromDirection) {
        return this.connects(wire, blockFace, fromDirection);
    }

    @Override
    public boolean isPositionOccupiedByTile(EnumPosition pos) {
        switch (pos) {
            case FaceNX: {
                return (this.wireMask & 0x10) != 0;
            }
            case FacePX: {
                return (this.wireMask & 0x20) != 0;
            }
            case FaceNY: {
                return (this.wireMask & 1) != 0;
            }
            case FacePY: {
                return (this.wireMask & 2) != 0;
            }
            case FaceNZ: {
                return (this.wireMask & 4) != 0;
            }
            case FacePZ: {
                return (this.wireMask & 8) != 0;
            }
        }
        return false;
    }

    public boolean isWirePresent(int side) {
        return (this.wireMask & 1 << side) != 0;
    }

    public int getVisualWireColour() {
        return 0xFFFFFF;
    }

    @Override
    public EnumPosition getPartPosition(int part) {
        if (part == 6) {
            return EnumPosition.Centre;
        }
        return EnumPosition.getFacePosition(part);
    }

    @Override
    public AxisAlignedBB getPartAABBFromPool(int part) {
        if (part == 6) {
            return this.containsJacketed ? Part.getBoundingBoxFromPool(EnumPosition.Centre, 0.5) : null;
        }
        if ((this.wireMask & 1 << part) == 0) {
            return null;
        }
        return Part.getBoundingBoxFromPool(EnumPosition.getFacePosition(part), this.wireType.thickness);
    }

    @Override
    protected int getNumTileOwnedParts() {
        return 7;
    }

    @Override
    public float getPlayerRelativePartHardness(EntityPlayer ply, int part) {
        return ply.getCurrentPlayerStrVsBlock((Block)ProjectRed.blockWire, false, this.getType().ordinal()) / 0.25f / 30.0f;
    }

    @Override
    public ItemStack pickPart(MovingObjectPosition rayTrace, int part) {
        if (part == 6 && this.containsJacketed) {
            return new ItemStack((Block)ProjectRed.blockWire, 1, this.getType().ordinal() | 0x4000);
        }
        return new ItemStack((Block)ProjectRed.blockWire, 1, this.getType().ordinal());
    }

    @Override
    public boolean isSolidOnSide(ForgeDirection side) {
        return false;
    }

    public Icon getSpecialIconForRender() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(RenderBlocks render) {
        if (this.getType() == null) {
            return;
        }
        WireRenderer.instance.renderWorld(render, this.getType(), this, this.getSideMask(), this.containsJacketed);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(RenderBlocks render, int part) {
        if (part == 6) {
            WireRenderer.instance.renderWorld(render, this.getType(), this, 0, true);
            return;
        }
        if ((this.getSideMask() & 1 << part) == 0 || this.getType() == null) {
            return;
        }
        WireRenderer.instance.renderWorld(render, this.getType(), this, 1 << part, false);
    }

    @Override
    public List removePartByPlayer(EntityPlayer ply, int part) {
        EnumWire type = this.getType();
        if (part == 6) {
            if (!this.containsJacketed) {
                return null;
            }
            if (!this.removeJacketedWire()) {
                return null;
            }
            return Collections.singletonList(new ItemStack((Block)ProjectRed.blockWire, 1, type.ordinal() | 0x4000));
        }
        if (type == null || (this.getSideMask() & 1 << part) == 0) {
            return null;
        }
        if (!this.removeWireOnSide(part)) {
            return null;
        }
        return Collections.singletonList(new ItemStack((Block)ProjectRed.blockWire, 1, type.ordinal()));
    }

    @Override
    public void onMicroblocksChanged() {
        this.notifyExtendedNeighbours();
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    protected boolean debug(EntityPlayer ply) {
        return false;
    }

    protected void debugEffect_bonemeal() {
        this.field_70331_k.func_72926_e(2005, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
    }

    protected void debugEffect_fireburst() {
        this.field_70331_k.func_72926_e(2004, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
    }

    protected void debugEffect_potion() {
        this.field_70331_k.func_72926_e(2002, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
    }

    protected void debugEffect_smoke() {
        this.field_70331_k.func_72926_e(2000, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0);
    }

    public boolean hasJacketedWire() {
        return this.containsJacketed;
    }

    public int getJacketedWireConnectionMask() {
        return this.containsJacketed ? this.jacketConnectMaskCache : (byte)0;
    }

    @Override
    public void getCollidingBoundingBoxes(AxisAlignedBB mask, List list) {
        AxisAlignedBB bb;
        if (this.containsJacketed && (bb = this.getPartAABBFromPool(6)) != null && (bb = bb.func_72317_d((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n)).func_72326_a(mask)) {
            list.add(bb);
        }
    }
}

