/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.wires;

import java.util.Arrays;
import mrtjp.projectred.interfaces.wiring.IBundledEmitter;
import mrtjp.projectred.interfaces.wiring.IBundledUpdatable;
import mrtjp.projectred.interfaces.wiring.IBundledWire;
import mrtjp.projectred.interfaces.wiring.IRedstoneUpdatable;
import mrtjp.projectred.multipart.wiring.CommandDebug;
import mrtjp.projectred.multipart.wiring.wires.EnumWire;
import mrtjp.projectred.multipart.wiring.wires.TileInsulatedRedAlloy;
import mrtjp.projectred.multipart.wiring.wires.TileWire;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TileBundled
extends TileWire
implements IRedstoneUpdatable,
IBundledEmitter,
IBundledUpdatable,
IBundledWire {
    private byte[] strength = new byte[16];
    private byte[] oldStrength = new byte[16];
    private boolean isUpdating;
    private boolean recursiveUpdatePending = true;

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74773_a("strength", this.strength);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.strength = tag.func_74770_j("strength");
    }

    @Override
    protected boolean canConnectToWire(TileWire wire) {
        return super.canConnectToWire(wire) || wire instanceof TileInsulatedRedAlloy || this.getType() == wire.getType() || wire.getType() == EnumWire.BUNDLED_N || this.getType() == EnumWire.BUNDLED_N && wire instanceof TileBundled;
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    private void updateStrengthFromBlock(int x, int y, int z, int side, int dir) {
        byte[] o_strength;
        TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
        if (te instanceof TileInsulatedRedAlloy) {
            TileInsulatedRedAlloy o = (TileInsulatedRedAlloy)te;
            int o_strength2 = o.getRedstoneSignalStrength() - 1;
            int colour = o.getInsulatedWireColour();
            if ((this.strength[colour] & 0xFF) < o_strength2) {
                this.strength[colour] = (byte)o_strength2;
            }
        } else if (te instanceof IBundledEmitter && (o_strength = ((IBundledEmitter)te).getBundledCableStrength(side, dir)) != null) {
            for (int k = 0; k < 16; ++k) {
                int o_c_strength = (o_strength[k] & 0xFF) - 1;
                if ((this.strength[k] & 0xFF) >= o_c_strength) continue;
                this.strength[k] = (byte)o_c_strength;
            }
        }
    }

    private void updateStrengthFromSurroundingBlocks() {
        byte[] temp = this.oldStrength;
        this.oldStrength = this.strength;
        this.strength = temp;
        Arrays.fill(this.strength, (byte)0);
        for (int side = 0; side < 6; ++side) {
            for (int dir = 0; dir < 6; ++dir) {
                if (!this.connectsInDirection(side, dir)) continue;
                ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[dir];
                int x = this.field_70329_l + fd.offsetX;
                int y = this.field_70330_m + fd.offsetY;
                int z = this.field_70327_n + fd.offsetZ;
                int oside = side;
                int odir = dir ^ 1;
                if (this.connectsInDirectionAroundCorner(side, dir)) {
                    fd = ForgeDirection.VALID_DIRECTIONS[side];
                    x += fd.offsetX;
                    y += fd.offsetY;
                    z += fd.offsetZ;
                    oside = dir ^ 1;
                    odir = side ^ 1;
                }
                this.updateStrengthFromBlock(x, y, z, oside, odir);
            }
            if (!this.connectsInDirectionByJacketedWire(side)) continue;
            ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[side];
            int x = this.field_70329_l + fd.offsetX;
            int y = this.field_70330_m + fd.offsetY;
            int z = this.field_70327_n + fd.offsetZ;
            this.updateStrengthFromBlock(x, y, z, -1, side ^ 1);
        }
    }

    private void updateStrength() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.isUpdating) {
            this.recursiveUpdatePending = true;
            return;
        }
        if (CommandDebug.WIRE_DEBUG_PARTICLES) {
            this.debugEffect_bonemeal();
        }
        this.isUpdating = true;
        do {
            this.recursiveUpdatePending = false;
            this.updateStrengthFromSurroundingBlocks();
            if (Arrays.equals(this.oldStrength, this.strength)) continue;
            boolean any_decreased = false;
            for (int k = 0; k < 16; ++k) {
                if ((this.strength[k] & 0xFF) >= (this.oldStrength[k] & 0xFF)) continue;
                this.strength[k] = 0;
                any_decreased = true;
            }
            if (any_decreased) {
                this.updateConnectedThings();
                this.updateStrengthFromSurroundingBlocks();
            }
            this.updateConnectedThings();
        } while (this.recursiveUpdatePending);
        this.isUpdating = false;
    }

    private void updateConnectedThings() {
        int notifiedSides = 0;
        if (CommandDebug.WIRE_DEBUG_PARTICLES) {
            this.debugEffect_bonemeal();
        }
        for (int side = 0; side < 6; ++side) {
            for (int dir = 0; dir < 6; ++dir) {
                if (!this.connectsInDirection(side, dir)) continue;
                ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[dir];
                int x = this.field_70329_l + fd.offsetX;
                int y = this.field_70330_m + fd.offsetY;
                int z = this.field_70327_n + fd.offsetZ;
                if (this.connectsInDirectionAroundCorner(side, dir)) {
                    fd = ForgeDirection.VALID_DIRECTIONS[side];
                    x += fd.offsetX;
                    y += fd.offsetY;
                    z += fd.offsetZ;
                } else {
                    if ((notifiedSides & 1 << dir) != 0) continue;
                    notifiedSides |= 1 << dir;
                }
                TileEntity t = this.field_70331_k.func_72796_p(x, y, z);
                if (!(t instanceof IBundledUpdatable)) continue;
                ((IBundledUpdatable)t).onBundledInputChanged();
            }
            if (!this.connectsInDirectionByJacketedWire(side) || (notifiedSides & 1 << side) != 0) continue;
            notifiedSides |= 1 << side;
            ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[side];
            int x = this.field_70329_l + fd.offsetX;
            int y = this.field_70330_m + fd.offsetY;
            int z = this.field_70327_n + fd.offsetZ;
            TileEntity t = this.field_70331_k.func_72796_p(x, y, z);
            if (!(t instanceof IBundledUpdatable)) continue;
            ((IBundledUpdatable)t).onBundledInputChanged();
        }
    }

    @Override
    public void onRedstoneInputChanged() {
        this.updateStrength();
    }

    @Override
    public void onBundledInputChanged() {
        this.updateStrength();
    }

    @Override
    void onNeighbourBlockChange() {
        super.onNeighbourBlockChange();
        this.updateStrength();
    }

    @Override
    public byte[] getBundledCableStrength(int blockFace, int direction) {
        return this.connectsInDirection(blockFace, direction) ? this.strength : null;
    }

    @Override
    protected boolean debug(EntityPlayer ply) {
        if (!this.field_70331_k.field_72995_K) {
            int[] i = new int[16];
            for (int k = 0; k < 16; ++k) {
                i[k] = this.strength[k] & 0xFF;
            }
            ply.func_70006_a("Bundled cable strength: " + Arrays.toString(i));
        }
        return true;
    }
}

