/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.wires;

import com.google.common.collect.ImmutableBiMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.multipart.wiring.wires.TileBundled;
import mrtjp.projectred.multipart.wiring.wires.TileInsulatedRedAlloy;
import mrtjp.projectred.multipart.wiring.wires.TilePlainRedAlloy;
import mrtjp.projectred.utils.codechicken.core.render.CCModel;
import mrtjp.projectred.utils.codechicken.core.vec.CoordinateSystem;
import mrtjp.projectred.utils.codechicken.core.vec.InvertX;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.oredict.OreDictionary;

public enum EnumWire {
    RED_ALLOY("Red alloy wire", TilePlainRedAlloy.class, 2, 2, 0xCA0000, "alloywire.obj", "jacketedalloy.obj", new String[]{"redalloy"}),
    INSULATED_0("White insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/whiteoff", "insulated/whiteon"}),
    INSULATED_1("Orange insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/orangeoff", "insulated/orangeon"}),
    INSULATED_2("Magenta insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/magentaoff", "insulated/magentaon"}),
    INSULATED_3("Light blue insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/lightblueoff", "insulated/lightblueon"}),
    INSULATED_4("Yellow insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/yellowoff", "insulated/yellowon"}),
    INSULATED_5("Lime insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/limeoff", "insulated/limeon"}),
    INSULATED_6("Pink insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/pinkoff", "insulated/pinkon"}),
    INSULATED_7("Grey insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/greyoff", "insulated/greyon"}),
    INSULATED_8("Light grey insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/lightgreyoff", "insulated/lightgreyon"}),
    INSULATED_9("Cyan insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/cyanoff", "insulated/cyanon"}),
    INSULATED_10("Purple insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/purpleoff", "insulated/purpleon"}),
    INSULATED_11("Blue insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/blueoff", "insulated/blueon"}),
    INSULATED_12("Brown insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/brownoff", "insulated/brownon"}),
    INSULATED_13("Green insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/greenoff", "insulated/greenon"}),
    INSULATED_14("Red insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/redoff", "insulated/redon"}),
    INSULATED_15("Black insulated wire", TileInsulatedRedAlloy.class, 3, 4, "insulatedwire.obj", "jacketedinsulated.obj", new String[]{"insulated/blackoff", "insulated/blackon"}),
    BUNDLED_N("Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/neutral"}),
    BUNDLED_0("White Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/white"}),
    BUNDLED_1("Orange Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/orange"}),
    BUNDLED_2("Magenta Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/magenta"}),
    BUNDLED_3("Light Blue Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/lightblue"}),
    BUNDLED_4("Yellow Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/yellow"}),
    BUNDLED_5("Lime Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/lime"}),
    BUNDLED_6("Pink Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/pink"}),
    BUNDLED_7("Grey Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/grey"}),
    BUNDLED_8("Light Grey Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/lightgrey"}),
    BUNDLED_9("Cyan Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/cyan"}),
    BUNDLED_10("Purple Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/purple"}),
    BUNDLED_11("Blue Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/blue"}),
    BUNDLED_12("Brown Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/brown"}),
    BUNDLED_13("Green Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/green"}),
    BUNDLED_14("Red Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/red"}),
    BUNDLED_15("Black Bundled cable", TileBundled.class, 4, 6, "bundledcable.obj", "jacketedbundled.obj", new String[]{"bundled/black"});

    public static final int PLAIN_RED_ALLOY_META = 0;
    public static final int INSULATED_RED_ALLOY_META = 1;
    public static final int BUNDLED_META = 2;
    public static ImmutableBiMap CLASS_TO_META;
    public static ImmutableBiMap META_TO_CLASS;
    public static EnumWire[] VALID_WIRE;
    public static EnumWire[] INSULATED_WIRE;
    public static EnumWire[] BUNDLED_WIRE;
    public final String name;
    public final Class teclass;
    public final int itemColour;
    public final double thickness;
    public final double width;
    public Icon[] wireSprites;
    public final String[] wireSpritePaths;
    public final String wireModelPath;
    public final String jacketModelPath;
    public Map wireMap;
    public Map jacketMap;
    public static final String oreDictDefinition = "projredWire";
    public static final String oreDictDefinitionInsulated = "projredInsulatedWire";
    public static final String oreDictDefinitionJacketed = "projredJacketedWire";
    public static final String oreDictDefinitionBundled = "projredBundledCable";
    public int meta = this.ordinal();
    public static final EnumWire[] VALUES;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumWire(int name, int tileClazz, int thicknessPixels, String widthPixels, String itemColour, String ... objPathWire) {
        void textures;
        void objPathJacket;
        this.name = (String)name;
        this.teclass = (Class)tileClazz;
        this.thickness = (double)thicknessPixels / 16.0;
        this.width = (double)widthPixels / 16.0;
        this.itemColour = (int)itemColour;
        this.wireModelPath = objPathWire;
        this.jacketModelPath = objPathJacket;
        this.wireSpritePaths = textures;
        this.wireSprites = new Icon[((void)textures).length];
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumWire(int name, int tileClazz, String thicknessPixels, String widthPixels, String ... objPath) {
        this((String)var1_-1, (int)var2_-1, (String)name, (Class)tileClazz, (int)thicknessPixels, (int)widthPixels, 0xFFFFFF, (String)objPath, (String)objPathJacket, (String[])textures);
        void textures;
        void objPathJacket;
        void var2_-1;
        void var1_-1;
    }

    public boolean hasJacketedForm() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void loadTextures(IconRegister reg) {
        if (this.wireSpritePaths.length > 0) {
            this.wireSprites = new Icon[this.wireSpritePaths.length];
            for (int i = 0; i < this.wireSpritePaths.length; ++i) {
                this.wireSprites[i] = reg.func_94245_a("projectred:wires/" + this.wireSpritePaths[i]);
            }
        }
        this.wireMap = CCModel.parseObjModels("/mods/projectred/textures/obj/wiring/" + this.wireModelPath, 7, (CoordinateSystem)new InvertX());
        this.jacketMap = CCModel.parseObjModels("/mods/projectred/textures/obj/wiring/" + this.jacketModelPath, 7, (CoordinateSystem)new InvertX());
        for (CCModel m : this.wireMap.values()) {
            m.shrinkUVs(5.0E-4);
        }
        for (CCModel m : this.jacketMap.values()) {
            m.shrinkUVs(5.0E-4);
        }
    }

    public ItemStack getItemStack() {
        return new ItemStack((Block)ProjectRed.blockWire, 1, this.meta);
    }

    public ItemStack getItemStack(int i) {
        return new ItemStack((Block)ProjectRed.blockWire, i, this.meta);
    }

    public ItemStack getJacketedItemStack() {
        return new ItemStack((Block)ProjectRed.blockWire, 1, this.meta | 0x4000);
    }

    public ItemStack getJacketedItemStack(int i) {
        if (!this.hasJacketedForm()) {
            return null;
        }
        return new ItemStack((Block)ProjectRed.blockWire, i, this.meta | 0x4000);
    }

    public static boolean isBundledCable(ItemStack stack) {
        for (EnumWire w : BUNDLED_WIRE) {
            if (stack.field_77993_c != ProjectRed.blockWire.field_71990_ca || stack.func_77960_j() != w.meta) continue;
            return true;
        }
        return false;
    }

    public static boolean isInsulatedWire(ItemStack stack) {
        for (EnumWire w : INSULATED_WIRE) {
            if (stack.field_77993_c != ProjectRed.blockWire.field_71990_ca || stack.func_77960_j() != w.meta) continue;
            return true;
        }
        return false;
    }

    public static void initOreDictDefinitions() {
        for (EnumWire w : VALID_WIRE) {
            OreDictionary.registerOre((String)oreDictDefinition, (ItemStack)w.getItemStack());
            if (!w.hasJacketedForm()) continue;
            OreDictionary.registerOre((String)oreDictDefinitionJacketed, (ItemStack)w.getJacketedItemStack());
        }
        for (EnumWire w : INSULATED_WIRE) {
            OreDictionary.registerOre((String)oreDictDefinitionInsulated, (ItemStack)w.getItemStack());
        }
        for (EnumWire w : BUNDLED_WIRE) {
            OreDictionary.registerOre((String)oreDictDefinitionBundled, (ItemStack)w.getItemStack());
        }
    }

    static {
        CLASS_TO_META = ImmutableBiMap.builder().put(TilePlainRedAlloy.class, (Object)0).put(TileInsulatedRedAlloy.class, (Object)1).put(TileBundled.class, (Object)2).build();
        META_TO_CLASS = CLASS_TO_META.inverse();
        VALID_WIRE = EnumWire.values();
        INSULATED_WIRE = new EnumWire[]{INSULATED_0, INSULATED_1, INSULATED_2, INSULATED_3, INSULATED_4, INSULATED_5, INSULATED_6, INSULATED_7, INSULATED_8, INSULATED_9, INSULATED_10, INSULATED_11, INSULATED_12, INSULATED_13, INSULATED_14, INSULATED_15};
        BUNDLED_WIRE = new EnumWire[]{BUNDLED_N, BUNDLED_0, BUNDLED_1, BUNDLED_2, BUNDLED_3, BUNDLED_4, BUNDLED_5, BUNDLED_6, BUNDLED_7, BUNDLED_8, BUNDLED_9, BUNDLED_10, BUNDLED_11, BUNDLED_12, BUNDLED_13, BUNDLED_14, BUNDLED_15};
        VALUES = EnumWire.values();
    }

    public static class WireDamageValues {
        public static final int DMG_FLAG_JACKETED = 16384;
        public static final int DMG_MASK_ORDINAL = 255;

        public static boolean isJacketed(int damageValue) {
            return (damageValue & 0x4000) != 0;
        }

        public static EnumWire getType(int damageValue) {
            int ordinal = damageValue & 0xFF;
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return null;
            }
            return VALUES[ordinal];
        }
    }
}

