/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.gates;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.interfaces.wiring.IBundledEmitter;
import mrtjp.projectred.interfaces.wiring.IBundledUpdatable;
import mrtjp.projectred.interfaces.wiring.IBundledWire;
import mrtjp.projectred.interfaces.wiring.IConnectable;
import mrtjp.projectred.interfaces.wiring.IRedstoneUpdatable;
import mrtjp.projectred.interfaces.wiring.IRedstoneWire;
import mrtjp.projectred.interfaces.wiring.IWire;
import mrtjp.projectred.multipart.TileCoverableBase;
import mrtjp.projectred.multipart.microblocks.EnumPosition;
import mrtjp.projectred.multipart.microblocks.Part;
import mrtjp.projectred.multipart.microblocks.PartType;
import mrtjp.projectred.multipart.wiring.gates.EnumGate;
import mrtjp.projectred.multipart.wiring.gates.GateLogic;
import mrtjp.projectred.multipart.wiring.gates.GateStaticRenderer;
import mrtjp.projectred.utils.BasicUtils;
import mrtjp.projectred.utils.BasicWireUtils;
import mrtjp.projectred.utils.Coords;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileGate
extends TileCoverableBase
implements IRedstoneUpdatable,
IConnectable,
IBundledUpdatable,
IBundledEmitter {
    private EnumGate type;
    private GateLogic logic;
    private byte side;
    private byte front;
    private boolean isNotStateless;
    private int gateSettings;
    private GateLogic.WithPointer pointer;
    private boolean flipped;
    private boolean hasBundledConnections;
    float pointerPos;
    float pointerSpeed;
    private boolean isFirstTick = true;
    private short[] inputs = new short[4];
    private short[] outputs = new short[4];
    private short[] absOutputs = new short[6];
    private short[] prevAbsOutputs = new short[6];
    private short[] prevOutputs = new short[4];
    private int renderState;
    private int prevRenderState;
    private boolean updatePending;
    private static int[] FLIPMAP_FLIPPED = new int[]{0, 1, 3, 2};
    private static int[] FLIPMAP_UNFLIPPED = new int[]{0, 1, 2, 3};
    public byte[][] rotationMap = new byte[][]{{-1, -1, 5, 4, 2, 3}, {-1, -1, 4, 5, 3, 2}, {4, 5, -1, -1, 1, 0}, {5, 4, -1, -1, 0, 1}, {3, 2, 0, 1, -1, -1}, {2, 3, 1, 0, -1, -1}};
    private byte[] returnedBundledCableStrength;

    @Override
    public Packet func_70319_e() {
        if (this.type == null) {
            return null;
        }
        Packet132TileEntityData p = new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, new NBTTagCompound());
        p.field_73331_e.func_74773_a("c", this.getCoverSystem().writeDescriptionBytes());
        p.field_73331_e.func_74774_a("t", (byte)(this.type.ordinal() | (this.flipped ? 128 : 0)));
        p.field_73331_e.func_74774_a("s", this.side);
        p.field_73331_e.func_74774_a("f", this.front);
        p.field_73331_e.func_74777_a("r", (short)this.prevRenderState);
        if (this.pointer != null) {
            p.field_73331_e.func_74777_a("p", (short)this.pointer.getPointerPosition());
            p.field_73331_e.func_74776_a("P", this.pointer.getPointerSpeed());
        }
        return p;
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        this.getCoverSystem().readDescriptionBytes(pkt.field_73331_e.func_74770_j("c"), 0);
        this.type = EnumGate.VALUES[pkt.field_73331_e.func_74771_c("t") & 0x7F];
        this.side = pkt.field_73331_e.func_74771_c("s");
        this.front = pkt.field_73331_e.func_74771_c("f");
        this.flipped = (pkt.field_73331_e.func_74771_c("t") & 0x80) != 0;
        this.prevRenderState = pkt.field_73331_e.func_74765_d("r") & 0xFFFFF;
        if (pkt.field_73331_e.func_74764_b("p")) {
            this.pointerPos = pkt.field_73331_e.func_74765_d("p");
            this.pointerSpeed = pkt.field_73331_e.func_74760_g("P");
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int getSide() {
        return this.side;
    }

    public TileGate(EnumGate type, int side, int front) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.type = type;
        this.side = (byte)side;
        this.front = (byte)front;
        this.createLogic();
    }

    public TileGate() {
    }

    private long toBitfield8(short[] a) {
        if (a.length > 8) {
            throw new IllegalArgumentException("array too long");
        }
        long rv = 0L;
        for (int k = 0; k < a.length; ++k) {
            if (a[k] < 0 || a[k] > 255) {
                throw new IllegalArgumentException("element out of range (index " + k + ", value " + a[k] + ")");
            }
            rv = rv << 8 | (long)a[k];
        }
        return rv;
    }

    private long toBitfield16(short[] a) {
        if (a.length > 4) {
            throw new IllegalArgumentException("array too long");
        }
        long rv = 0L;
        for (int k = 0; k < a.length; ++k) {
            rv = rv << 16 | (long)a[k];
        }
        return rv;
    }

    private void fromBitfield8(long bf, short[] a) {
        if (a.length > 8) {
            throw new IllegalArgumentException("array too long");
        }
        for (int k = a.length - 1; k >= 0; --k) {
            a[k] = (short)(bf & 0xFFL);
            bf >>= 8;
        }
    }

    private void fromBitfield16(long bf, short[] a) {
        if (a.length > 4) {
            throw new IllegalArgumentException("array too long");
        }
        for (int k = a.length - 1; k >= 0; --k) {
            a[k] = (short)bf;
            bf >>= 16;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74774_a("type", this.type == null ? (byte)-1 : (byte)this.type.ordinal());
        tag.func_74774_a("side", this.side);
        tag.func_74774_a("front", this.front);
        tag.func_74757_a("version2", true);
        tag.func_74772_a("outputs", this.toBitfield16(this.outputs));
        tag.func_74772_a("inputs", this.toBitfield16(this.inputs));
        tag.func_74772_a("prevOutputs", this.toBitfield16(this.prevOutputs));
        tag.func_74777_a("renderState", (short)this.renderState);
        tag.func_74777_a("prevRenderState", (short)this.prevRenderState);
        tag.func_74757_a("updatePending", this.updatePending);
        tag.func_74777_a("gateSettings", (short)this.gateSettings);
        tag.func_74757_a("flipped", this.flipped);
        if (this.logic != null && this.isNotStateless) {
            NBTTagCompound tag2 = new NBTTagCompound();
            this.logic.write(tag2);
            tag.func_74782_a("logic", (NBTBase)tag2);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        try {
            this.type = EnumGate.VALUES[tag.func_74771_c("type")];
        }
        catch (Exception e) {
            this.type = EnumGate.AND;
        }
        this.side = tag.func_74771_c("side");
        this.front = tag.func_74771_c("front");
        this.flipped = tag.func_74767_n("flipped");
        this.renderState = tag.func_74765_d("renderState") & 0xFFFF;
        this.prevRenderState = tag.func_74765_d("prevRenderState") & 0xFFFF;
        this.updatePending = tag.func_74767_n("updatePending");
        this.gateSettings = tag.func_74765_d("gateSettings") & 0xFFFF;
        if (tag.func_74781_a("inputs") instanceof NBTTagLong) {
            if (tag.func_74767_n("version2")) {
                this.fromBitfield16(tag.func_74763_f("inputs"), this.inputs);
                this.fromBitfield16(tag.func_74763_f("outputs"), this.outputs);
                this.fromBitfield16(tag.func_74763_f("prevOutputs"), this.prevOutputs);
                for (int k = 0; k < 4; ++k) {
                    this.absOutputs[this.relToAbsDirection((int)k)] = this.outputs[k];
                    this.prevAbsOutputs[this.relToAbsDirection((int)k)] = this.prevOutputs[k];
                }
            } else {
                this.fromBitfield8(tag.func_74763_f("inputs"), this.inputs);
                this.fromBitfield8(tag.func_74763_f("outputs"), this.outputs);
                this.fromBitfield8(tag.func_74763_f("absOutputs"), this.absOutputs);
                this.fromBitfield8(tag.func_74763_f("prevAbsOutputs"), this.prevAbsOutputs);
                this.fromBitfield8(tag.func_74763_f("prevOutputs"), this.prevOutputs);
            }
        }
        this.createLogic();
        if (this.logic != null && tag.func_74764_b("logic")) {
            this.logic.read(tag.func_74775_l("logic"));
        }
    }

    private void createLogic() {
        this.logic = this.type.createLogic();
        this.isNotStateless = !(this.logic instanceof GateLogic.Stateless);
        this.pointer = this.logic instanceof GateLogic.WithPointer ? (GateLogic.WithPointer)((Object)this.logic) : null;
        this.hasBundledConnections = this.logic instanceof GateLogic.WithBundledConnections;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (BasicUtils.isServer(this.field_70331_k)) {
            if (this.isNotStateless) {
                this.updateLogic(true, false);
                if (this.logic instanceof GateLogic.WorldStateBound && ((GateLogic.WorldStateBound)((Object)this.logic)).needsWorldInfo()) {
                    ((GateLogic.WorldStateBound)((Object)this.logic)).setWorldInfo(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            } else if (this.isFirstTick) {
                this.updateLogic(false, false);
                this.isFirstTick = false;
            }
        } else {
            this.pointerPos += this.pointerSpeed;
        }
    }

    public int getFront() {
        return this.front;
    }

    public EnumGate getType() {
        return this.type;
    }

    private void updateRenderState() {
        this.renderState = this.logic.getRenderState(this.inputs, this.prevOutputs, this.gateSettings);
        if (this.prevRenderState != this.renderState) {
            this.prevRenderState = this.renderState;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    private int relToAbsDirection(int rel) {
        if (this.flipped) {
            rel = FLIPMAP_FLIPPED[rel];
        }
        return BasicWireUtils.dirMap[this.side][this.front][rel];
    }

    private int absToRelDirection(int abs) {
        if ((abs & 6) == (this.side & 6)) {
            return -1;
        }
        int rel = BasicWireUtils.invDirMap[this.side][this.front][abs];
        if (this.flipped) {
            rel = FLIPMAP_FLIPPED[rel];
        }
        return rel;
    }

    public void updateLogic(boolean fromTick, boolean forceUpdate) {
        int k;
        if (this.type == null) {
            return;
        }
        int[] flipMap = this.flipped ? FLIPMAP_FLIPPED : FLIPMAP_UNFLIPPED;
        for (k = 0; k < 4; ++k) {
            this.inputs[flipMap[k]] = this.getInputValue(k);
        }
        this.updateRenderState();
        if (forceUpdate || fromTick == this.isNotStateless) {
            this.logic.update(this.inputs, this.outputs, this.gateSettings);
            for (k = 0; k < 4; ++k) {
                this.absOutputs[BasicWireUtils.dirMap[this.side][this.front][k]] = this.outputs[flipMap[k]];
            }
            this.absOutputs[this.side ^ 1] = 0;
            this.absOutputs[this.side] = 0;
            if (!(!forceUpdate && Arrays.equals(this.outputs, this.prevOutputs) || this.updatePending)) {
                this.field_70331_k.func_72836_a(this.field_70329_l, this.field_70330_m, this.field_70327_n, ProjectRed.blockGate.field_71990_ca, 2);
                this.updatePending = true;
            }
        }
    }

    private short getInputValue(int rel) {
        int abs = this.relToAbsDirection(rel);
        if (this.hasBundledConnections && ((GateLogic.WithBundledConnections)((Object)this.logic)).isBundledConnection(rel)) {
            return this.getBundledInputBitmask(abs);
        }
        return this.getInputStrength(abs);
    }

    private short getBundledInputBitmask(int abs) {
        ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[abs];
        int x = this.field_70329_l + fd.offsetX;
        int y = this.field_70330_m + fd.offsetY;
        int z = this.field_70327_n + fd.offsetZ;
        TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
        if (te instanceof IBundledEmitter) {
            byte[] values = ((IBundledEmitter)te).getBundledCableStrength(this.side, abs ^ 1);
            if (values == null) {
                return 0;
            }
            short rv = 0;
            for (int k = 15; k >= 0; --k) {
                rv = (short)(rv << 1);
                if (values[k] == 0) continue;
                rv = (short)(rv | 1);
            }
            return rv;
        }
        return 0;
    }

    private short getInputStrength(int abs) {
        switch (abs) {
            case 4: {
                return BasicWireUtils.getPowerStrength(this.field_70331_k, this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, abs ^ 1, this.side);
            }
            case 5: {
                return BasicWireUtils.getPowerStrength(this.field_70331_k, this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, abs ^ 1, this.side);
            }
            case 0: {
                return BasicWireUtils.getPowerStrength(this.field_70331_k, this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, abs ^ 1, this.side);
            }
            case 1: {
                return BasicWireUtils.getPowerStrength(this.field_70331_k, this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, abs ^ 1, this.side);
            }
            case 2: {
                return BasicWireUtils.getPowerStrength(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, abs ^ 1, this.side);
            }
            case 3: {
                return BasicWireUtils.getPowerStrength(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, abs ^ 1, this.side);
            }
        }
        throw new IllegalArgumentException("Invalid direction " + abs);
    }

    public int getVanillaOutputStrength(int dir) {
        int rel = this.absToRelDirection(dir);
        if (rel < 0) {
            return 0;
        }
        if (this.hasBundledConnections && ((GateLogic.WithBundledConnections)((Object)this.logic)).isBundledConnection(rel)) {
            return 0;
        }
        return this.prevAbsOutputs[dir] / 17;
    }

    public int getRenderState() {
        return this.prevRenderState;
    }

    public void scheduledTick() {
        this.updatePending = false;
        System.arraycopy(this.absOutputs, 0, this.prevAbsOutputs, 0, 6);
        System.arraycopy(this.outputs, 0, this.prevOutputs, 0, 4);
        this.updateRenderState();
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, ProjectRed.blockGate.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, ProjectRed.blockGate.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, ProjectRed.blockGate.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, ProjectRed.blockGate.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, ProjectRed.blockGate.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, ProjectRed.blockGate.field_71990_ca);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, ProjectRed.blockGate.field_71990_ca);
        if (this.hasBundledConnections) {
            for (int rel = 0; rel < 4; ++rel) {
                if (!((GateLogic.WithBundledConnections)((Object)this.logic)).isBundledConnection(rel)) continue;
                int abs = this.relToAbsDirection(rel);
                ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[abs];
                int x = this.field_70329_l + fd.offsetX;
                int y = this.field_70330_m + fd.offsetY;
                int z = this.field_70327_n + fd.offsetZ;
                TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
                if (te == null || !(te instanceof IBundledUpdatable)) continue;
                ((IBundledUpdatable)te).onBundledInputChanged();
            }
        }
    }

    public void configure() {
        if (this.logic instanceof GateLogic.Flippable) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        } else {
            this.gateSettings = this.logic.configure(this.gateSettings);
        }
        this.updateLogic(false, true);
    }

    public void rotate() {
        if (this.rotationMap[this.side][this.front] == -1) {
            return;
        }
        this.front = this.rotationMap[this.side][this.front];
        this.updateLogic(false, true);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean onBlockActivated(EntityPlayer ply) {
        if (ply.func_70694_bm() != null && ply.func_70694_bm().func_77973_b() == ProjectRed.itemScrewdriver) {
            return false;
        }
        if (this.field_70331_k.field_72995_K) {
            return this.type != null && GateLogic.WithRightClickAction.class.isAssignableFrom(this.type.getLogicClass());
        }
        if (this.logic instanceof GateLogic.WithRightClickAction) {
            ((GateLogic.WithRightClickAction)((Object)this.logic)).onRightClick(ply, this);
            return true;
        }
        return false;
    }

    public GateLogic getLogic() {
        return this.logic;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    @Override
    public boolean isPlacementBlockedByTile(PartType type, EnumPosition pos) {
        return !this.getPartAABBFromPool(0).func_72326_a(Part.getBoundingBoxFromPool(pos, type.getSize()));
    }

    @Override
    public boolean isPositionOccupiedByTile(EnumPosition pos) {
        return pos == EnumPosition.getFacePosition(this.side);
    }

    @Override
    public EnumPosition getPartPosition(int subHit) {
        if (subHit == 0) {
            return EnumPosition.getFacePosition(this.side);
        }
        return null;
    }

    @Override
    public AxisAlignedBB getPartAABBFromPool(int subHit) {
        if (subHit == 0) {
            return Part.getBoundingBoxFromPool(EnumPosition.getFacePosition(this.side), 0.125);
        }
        return null;
    }

    @Override
    protected int getNumTileOwnedParts() {
        return 1;
    }

    @Override
    public float getPlayerRelativePartHardness(EntityPlayer ply, int part) {
        return ply.getCurrentPlayerStrVsBlock((Block)ProjectRed.blockGate, false, this.func_70322_n()) / 0.25f / 30.0f;
    }

    @Override
    public ItemStack pickPart(MovingObjectPosition rayTrace, int part) {
        return new ItemStack((Block)ProjectRed.blockGate, 1, this.getType().ordinal());
    }

    @Override
    public boolean isSolidOnSide(ForgeDirection side) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(RenderBlocks render) {
        GateStaticRenderer.instance.renderWorldBlock((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o(), 0, render);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(RenderBlocks render, int part) {
        this.render(render);
    }

    @Override
    public List removePartByPlayer(EntityPlayer ply, int part) {
        if (this.cover != null) {
            this.cover.convertToContainerBlock();
        } else {
            this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 3);
        }
        return Collections.singletonList(new ItemStack((Block)ProjectRed.blockGate, 1, this.getType().ordinal()));
    }

    @Override
    public void onRedstoneInputChanged() {
        this.updateLogic(false, false);
    }

    @Override
    public boolean connects(IWire wire, int blockFace, int fromDirection) {
        boolean bundled;
        if (blockFace != this.side) {
            return false;
        }
        if (this.logic == null) {
            return false;
        }
        int rel = this.absToRelDirection(fromDirection);
        if (rel < 0) {
            return false;
        }
        boolean bl = bundled = this.hasBundledConnections && ((GateLogic.WithBundledConnections)((Object)this.logic)).isBundledConnection(rel);
        if (!(!bundled ? wire instanceof IRedstoneWire : wire instanceof IBundledWire)) {
            return false;
        }
        return this.logic.connectsToDirection(rel);
    }

    @Override
    public boolean connectsAroundCorner(IWire wire, int blockFace, int fromDirection) {
        return false;
    }

    @Override
    public byte[] getBundledCableStrength(int blockFace, int toDirection) {
        if (!this.hasBundledConnections) {
            return null;
        }
        if (blockFace != this.side) {
            return null;
        }
        int rel = this.absToRelDirection(toDirection);
        if (rel < 0) {
            return null;
        }
        if (!((GateLogic.WithBundledConnections)((Object)this.logic)).isBundledConnection(rel)) {
            return null;
        }
        if (this.returnedBundledCableStrength == null) {
            this.returnedBundledCableStrength = new byte[16];
        }
        short bitmask = this.prevOutputs[rel];
        for (int k = 0; k < 16; ++k) {
            this.returnedBundledCableStrength[k] = (bitmask & 1) != 0 ? -1 : 0;
            bitmask = (short)(bitmask >> 1);
        }
        return this.returnedBundledCableStrength;
    }

    @Override
    public void onBundledInputChanged() {
        if (this.hasBundledConnections) {
            this.onRedstoneInputChanged();
        }
    }

    public void onNeighborChanged() {
        this.checkSupport();
    }

    public void checkSupport() {
        int id;
        Block gate;
        if (BasicUtils.isClient(this.field_70331_k)) {
            return;
        }
        Coords localCoord = new Coords(this);
        localCoord.orientation = ForgeDirection.getOrientation((int)this.getSide());
        localCoord.moveForwards(1);
        Block supporter = Block.field_71973_m[this.field_70331_k.func_72798_a(localCoord.x, localCoord.y, localCoord.z)];
        if (!BasicWireUtils.canPlaceWireOnSide(this.field_70331_k, localCoord.x, localCoord.y, localCoord.z, localCoord.orientation.getOpposite(), false) && (gate = Block.field_71973_m[id = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n)]) != null) {
            ItemStack dropped = new ItemStack((Block)ProjectRed.blockGate, 1, this.type.ordinal());
            BasicUtils.dropItemFromLocation(this.field_70331_k, dropped, false, null, this.getSide(), 10, new Coords(this));
            this.removeGate();
        }
    }

    public void removeGate() {
        if (this.cover != null) {
            this.cover.convertToContainerBlock();
        } else {
            this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 3);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
    }
}

