/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.gates;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.projectred.multipart.wiring.RotatedRenderer;
import mrtjp.projectred.multipart.wiring.gates.BlockGate;
import mrtjp.projectred.multipart.wiring.gates.EnumGate;
import mrtjp.projectred.multipart.wiring.gates.GateDynamicRenderer;
import mrtjp.projectred.multipart.wiring.gates.GateRenderBridge;
import mrtjp.projectred.multipart.wiring.gates.TileGate;
import mrtjp.projectred.renderstuffs.RenderIDs;
import mrtjp.projectred.utils.codechicken.core.render.CCRenderState;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;

@SideOnly(value=Side.CLIENT)
public class GateStaticRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    private GateRenderBridge defaultRendering = new GateRenderBridge.Default();
    private RotatedRenderer rotatedRenderer = new RotatedRenderer();
    public static final GateStaticRenderer instance = new GateStaticRenderer();

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int model, RenderBlocks render) {
        int i;
        TileGate te = (TileGate)world.func_72796_p(x, y, z);
        int side = te.getSide();
        int front = te.getFront();
        EnumGate type = te.getType();
        if (type == null) {
            return true;
        }
        BlockGate.renderSide = -(side ^ 1) - 1;
        BlockGate.textureOverride = null;
        BlockGate.colourOverride = -1;
        GateRenderBridge rendering = type.getRenderBridge();
        rendering.set(te.getRenderState());
        this.rotatedRenderer.x = x;
        this.rotatedRenderer.y = y;
        this.rotatedRenderer.z = z;
        this.rotatedRenderer.side = side;
        this.rotatedRenderer.front = front;
        this.rotatedRenderer.renderBlocks = render;
        CCRenderState.reset();
        CCRenderState.changeTexture("/terrain.png");
        CCRenderState.setColour(0);
        Tessellator.field_78398_a.func_78370_a(255, 255, 255, 255);
        CCRenderState.setBrightness((IBlockAccess)te.field_70331_k, te.field_70329_l, te.field_70330_m, te.field_70327_n);
        this.rotatedRenderer.renderPartModel(GateRenderBridge._modelBase, "base", 0.5f, 0.0f, 0.5f, -1.0f, -1, false);
        for (i = 0; i < rendering.wireColor.length; ++i) {
            float[] xPositions = rendering.wirePosX[i];
            float[] zPositions = rendering.wirePosZ[i];
            int color = rendering.wireColor[i];
            GateDynamicRenderer.renderWireOnGate(this.rotatedRenderer, xPositions, zPositions, GateRenderBridge._wire, color);
        }
        for (i = 0; i < rendering.torchState.length; ++i) {
            GateDynamicRenderer.renderTorchOnGate(this.rotatedRenderer, rendering.torchX[i], rendering.torchY[i], rendering.torchZ[i], rendering.torchState[i], GateRenderBridge._torchOn, GateRenderBridge._torchOff);
        }
        for (i = 0; i < rendering.pointerX.length; ++i) {
            float xOffset = rendering.pointerX[i];
            float zOffset = rendering.pointerZ[i];
            GateDynamicRenderer.renderTorchOnGate(this.rotatedRenderer, rendering.pointerX[i], 0.0f, rendering.pointerZ[i], true, GateRenderBridge._torchOn, GateRenderBridge._torchOff);
        }
        for (i = 0; i < rendering.torchState.length; ++i) {
            if (!rendering.torchState[i]) continue;
            GateDynamicRenderer.renderGlowOnTorch(this.rotatedRenderer, rendering.torchX[i], rendering.torchY[i], rendering.torchZ[i], GateRenderBridge._torchOn);
        }
        for (i = 0; i < rendering.pointerX.length; ++i) {
            GateDynamicRenderer.renderGlowOnTorch(this.rotatedRenderer, rendering.pointerX[i], 0.0f, rendering.pointerZ[i], GateRenderBridge._torchOn);
        }
        rendering.renderSpecials(this.rotatedRenderer, false);
        return true;
    }

    public void renderInventoryBlock(Block block, int meta, int model, RenderBlocks render) {
        int i;
        EnumGate type = EnumGate.VALUES[meta];
        GateRenderBridge rendering = type == null ? this.defaultRendering : type.getRenderBridge();
        rendering.setItemRender();
        this.rotatedRenderer.x = 0.0;
        this.rotatedRenderer.y = 0.0;
        this.rotatedRenderer.z = 0.0;
        this.rotatedRenderer.front = 2;
        this.rotatedRenderer.side = 0;
        this.rotatedRenderer.renderBlocks = render;
        CCRenderState.reset();
        CCRenderState.useNormals(true);
        CCRenderState.startDrawing(7);
        this.rotatedRenderer.renderPartModel(GateRenderBridge._modelBase, "base", 0.5f, 0.0f, 0.5f, -1.0f, -1, false);
        for (i = 0; i < rendering.wireColor.length; ++i) {
            float[] xPositions = rendering.wirePosX[i];
            float[] zPositions = rendering.wirePosZ[i];
            int color = rendering.wireColor[i];
            GateDynamicRenderer.renderWireOnGate(this.rotatedRenderer, xPositions, zPositions, GateRenderBridge._wire, color);
        }
        for (i = 0; i < rendering.torchState.length; ++i) {
            GateDynamicRenderer.renderTorchOnGate(this.rotatedRenderer, rendering.torchX[i], rendering.torchY[i], rendering.torchZ[i], rendering.torchState[i], GateRenderBridge._torchOn, GateRenderBridge._torchOff);
        }
        for (i = 0; i < rendering.pointerX.length; ++i) {
            GateDynamicRenderer.renderPointerOnGateWithRotation(this.rotatedRenderer, rendering.pointerX[i], 0.0f, rendering.pointerZ[i], GateRenderBridge._pointer, 0.0f);
            GateDynamicRenderer.renderTorchOnGate(this.rotatedRenderer, rendering.pointerX[i], 0.0f, rendering.pointerZ[i], true, GateRenderBridge._torchOn, GateRenderBridge._torchOff);
        }
        for (i = 0; i < rendering.torchState.length; ++i) {
            if (!rendering.torchState[i]) continue;
            GateDynamicRenderer.renderGlowOnTorch(this.rotatedRenderer, rendering.torchX[i], rendering.torchY[i], rendering.torchZ[i], GateRenderBridge._torchOn);
        }
        for (i = 0; i < rendering.pointerX.length; ++i) {
            GateDynamicRenderer.renderGlowOnTorch(this.rotatedRenderer, rendering.pointerX[i], 0.0f, rendering.pointerZ[i], GateRenderBridge._torchOn);
        }
        rendering.renderSpecials(this.rotatedRenderer, false);
        BlockGate.renderTypeOverride = -1;
        CCRenderState.draw();
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return RenderIDs.renderIdGate;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderInventoryBlock(null, item.func_77960_j(), 0, null);
    }
}

