/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.gates;

import mrtjp.projectred.multipart.wiring.RotatedRenderer;
import mrtjp.projectred.renderstuffs.gates.RotatedPartModel;
import net.minecraft.client.renderer.texture.IconRegister;

public abstract class GateRenderBridge {
    public static final int OFF = 0x400000;
    public static final int ON = 0xFF0000;
    public static final int DISABLED = 0xC0C0C0;
    public float[][] wirePosX = new float[][]{new float[0]};
    public float[][] wirePosZ = new float[][]{new float[0]};
    public int[] wireColor = new int[0];
    public float[] torchX = new float[0];
    public float[] torchY = new float[0];
    public float[] torchZ = new float[0];
    public boolean[] torchState = new boolean[0];
    public float[] pointerX = new float[0];
    public float[] pointerY = new float[0];
    public float[] pointerZ = new float[0];
    public static RotatedPartModel _modelBase;
    public static RotatedPartModel _torchOff;
    public static RotatedPartModel _torchOn;
    public static RotatedPartModel _greenTorchOff;
    public static RotatedPartModel _greenTorchOn;
    public static RotatedPartModel _wire;
    public static RotatedPartModel _lever;
    public static RotatedPartModel _pointer;
    public static RotatedPartModel _chipYellow;
    public static RotatedPartModel _chipRed;
    public static RotatedPartModel _diode;
    public static RotatedPartModel _latchCableCover;
    public static RotatedPartModel _relayCableCover;
    public static RotatedPartModel _multCableCover;
    public static RotatedPartModel _solar;
    public static RotatedPartModel _rainSensor;

    public static void registerAllIcons(IconRegister reg) {
        String baseTex = "projectred:gates/";
        _modelBase = new RotatedPartModel("gateparts/base.obj", reg.func_94245_a(baseTex + "base"));
        _torchOff = new RotatedPartModel("gateparts/torch.obj", reg.func_94245_a(baseTex + "redtorchoff"));
        _torchOn = new RotatedPartModel(_torchOff.getCCModels(), "gateparts/torch.obj", reg.func_94245_a(baseTex + "redtorchon"));
        _greenTorchOff = new RotatedPartModel(_torchOff.getCCModels(), "gateparts/torch.obj", reg.func_94245_a(baseTex + "greentorchoff"));
        _greenTorchOn = new RotatedPartModel(_torchOff.getCCModels(), "gateparts/torch.obj", reg.func_94245_a(baseTex + "greentorchon"));
        _wire = new RotatedPartModel("gateparts/wire.obj", reg.func_94245_a(baseTex + "wire"));
        _pointer = new RotatedPartModel("gateparts/pointer.obj", reg.func_94245_a(baseTex + "pointer"));
        _lever = new RotatedPartModel("gateparts/lever.obj", reg.func_94245_a(baseTex + "lever"));
        _chipYellow = new RotatedPartModel("gateparts/chip.obj", reg.func_94245_a(baseTex + "yellowchip"));
        _chipRed = new RotatedPartModel(_chipYellow.getCCModels(), "gateparts/chip.obj", reg.func_94245_a(baseTex + "redchip"));
        _diode = new RotatedPartModel("gateparts/diode.obj", reg.func_94245_a(baseTex + "diode"));
        _latchCableCover = new RotatedPartModel("gateparts/cablecover.obj", reg.func_94245_a(baseTex + "cablelatch"));
        _relayCableCover = new RotatedPartModel(_latchCableCover.getCCModels(), "gateparts/cablecover.obj", reg.func_94245_a(baseTex + "cablerelay"));
        _multCableCover = new RotatedPartModel(_latchCableCover.getCCModels(), "gateparts/cablecover.obj", reg.func_94245_a(baseTex + "cablemulti"));
        _solar = new RotatedPartModel("gateparts/solar.obj", reg.func_94245_a(baseTex + "solar"));
        _rainSensor = new RotatedPartModel("gateparts/rainsensor.obj", reg.func_94245_a(baseTex + "rainsensor"));
    }

    public void set(int renderState) {
    }

    public void setItemRender() {
    }

    public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
    }

    public static class RainSensor
    extends GateRenderBridge {
        public RainSensor() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}};
            this.wirePosZ = new float[][]{{15.0f, 14.0f, 13.0f, 12.0f, 11.0f, 10.0f}};
            this.wireColor = new int[]{0};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0xFF0000;
        }

        @Override
        public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
            if (isTESR) {
                return;
            }
            rt.renderPartModel(_rainSensor, "base", 0.49875f, 0.0f, 0.49875f, -1.0f, -1, false);
            rt.renderPartModel(_rainSensor, "sensor", 0.49875f, 0.0f, 0.49875f, -1.0f, -1, false);
        }
    }

    public static class LightSensor
    extends GateRenderBridge {
        public short solarThreshold;

        public LightSensor() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}};
            this.wirePosZ = new float[][]{{15.0f, 14.0f, 13.0f, 12.0f, 11.0f, 10.0f}};
            this.wireColor = new int[]{0};
            this.solarThreshold = 0;
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            this.solarThreshold = (renderState & 2) != 0 ? (short)0 : this.solarThreshold;
            this.solarThreshold = (renderState & 4) != 0 ? (short)1 : this.solarThreshold;
            this.solarThreshold = (short)((renderState & 8) != 0 ? 2 : (int)this.solarThreshold);
            this.solarThreshold = (short)((renderState & 0x10) != 0 ? 3 : (int)this.solarThreshold);
            this.solarThreshold = (short)((renderState & 0x20) != 0 ? 4 : (int)this.solarThreshold);
            this.solarThreshold = (short)((renderState & 0x40) != 0 ? 5 : (int)this.solarThreshold);
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0xFF0000;
            this.solarThreshold = 1;
        }

        @Override
        public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
            if (isTESR) {
                return;
            }
            rt.renderPartModel(_solar, "cover" + this.solarThreshold, 0.49875f, 0.0f, 0.62375f, -1.0f, -1, false);
        }
    }

    public static class BundledMultiplexer
    extends GateRenderBridge
    implements Stateless {
        public BundledMultiplexer() {
            this.wirePosX = new float[][]{{8.0f, 8.0f, 8.0f, 8.0f, 9.0f, 9.0f, 9.0f, 9.0f}};
            this.wirePosZ = new float[][]{{15.0f, 14.0f, 13.0f, 12.0f, 15.0f, 14.0f, 13.0f, 12.0f}};
            this.wireColor = new int[]{0};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
        }

        @Override
        public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
            if (isTESR) {
                return;
            }
            rt.renderPartModel(_multCableCover, this.wireColor[0] == 0xFF0000 ? "on" : "off", 0.49875f, 0.0f, 0.49875f, -1.0f, -1, false);
        }
    }

    public static class BundledRelay
    extends GateRenderBridge
    implements Stateless {
        public BundledRelay() {
            this.wirePosX = new float[][]{{15.0f, 14.0f, 13.0f, 12.0f, 15.0f, 14.0f, 13.0f, 12.0f}};
            this.wirePosZ = new float[][]{{8.0f, 8.0f, 8.0f, 8.0f, 9.0f, 9.0f, 9.0f, 9.0f}};
            this.wireColor = new int[]{0};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
        }

        @Override
        public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
            if (isTESR) {
                return;
            }
            rt.renderPartModel(_relayCableCover, this.wireColor[0] == 0xFF0000 ? "on" : "off", 0.49875f, 0.0f, 0.49875f, -1.0f, -1, false);
        }
    }

    public static class BundledLatch
    extends GateRenderBridge
    implements Stateless {
        public BundledLatch() {
            this.wirePosX = new float[][]{{15.0f, 14.0f, 13.0f, 12.0f, 15.0f, 14.0f, 13.0f, 12.0f}};
            this.wirePosZ = new float[][]{{8.0f, 8.0f, 8.0f, 8.0f, 9.0f, 9.0f, 9.0f, 9.0f}};
            this.wireColor = new int[]{0};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
        }

        @Override
        public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
            if (isTESR) {
                return;
            }
            rt.renderPartModel(_latchCableCover, this.wireColor[0] == 0xFF0000 ? "on" : "off", 0.49875f, 0.0f, 0.49875f, -1.0f, -1, false);
        }
    }

    public static class DFlop
    extends GateRenderBridge
    implements Stateless {
        public DFlop() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {15.0f, 14.0f, 14.0f, 14.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.0f, 8.5f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {2.0f, 3.0f, 4.0f, 5.0f, 5.0f, 5.0f, 6.0f, 7.0f, 8.0f, 8.5f}};
            this.wirePosZ = new float[][]{{15.0f, 14.0f, 13.0f, 12.0f, 11.0f}, {8.5f, 8.5f, 9.5f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f}, {2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f}, {8.5f, 8.5f, 8.5f, 8.5f, 9.5f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f}};
            this.wireColor = new int[]{0, 0, 0, 0};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[1] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[2] = (renderState & 4) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[3] = (renderState & 8) != 0 ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0x400000;
            this.wireColor[3] = 0x400000;
        }

        @Override
        public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
            if (isTESR) {
                return;
            }
            rt.renderPartModel(_chipRed, "base", 0.49875f, 0.0f, 0.405f, -1.0f, -1, false);
            rt.renderPartModel(_chipRed, this.wireColor[3] == 0xFF0000 ? "diodeon" : "diodeoff", 0.49875f, 0.0f, 0.405f, -1.0f, -1, false);
            rt.renderPartModel(_diode, "base", 0.31125f, 0.0f, 0.405f, 270.0f, -1, false);
        }
    }

    public static class DLatch
    extends GateRenderBridge
    implements Stateless {
        public DLatch() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {15.0f, 14.0f, 14.0f, 14.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.0f, 8.5f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {2.0f, 3.0f, 4.0f, 5.0f, 5.0f, 5.0f, 6.0f, 7.0f, 8.0f, 8.5f}};
            this.wirePosZ = new float[][]{{15.0f, 14.0f, 13.0f, 12.0f, 11.0f}, {8.5f, 8.5f, 9.5f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f}, {2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f}, {8.5f, 8.5f, 8.5f, 8.5f, 9.5f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f}};
            this.wireColor = new int[]{0, 0, 0, 0};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[1] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[2] = (renderState & 4) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[3] = (renderState & 8) != 0 ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0x400000;
            this.wireColor[3] = 0x400000;
        }

        @Override
        public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
            if (isTESR) {
                return;
            }
            rt.renderPartModel(_chipRed, "base", 0.49875f, 0.0f, 0.405f, -1.0f, -1, false);
            rt.renderPartModel(_chipRed, this.wireColor[2] == 0xFF0000 ? "diodeon" : "diodeoff", 0.49875f, 0.0f, 0.405f, -1.0f, -1, false);
        }
    }

    public static class Synchronizer
    extends GateRenderBridge
    implements Stateless {
        public Synchronizer() {
            this.wirePosX = new float[][]{{2.0f, 3.0f, 4.0f}, {15.0f, 14.0f, 13.0f}, {8.5f, 8.5f, 8.5f, 8.5f, 7.5f, 6.5f, 6.0f, 6.0f, 6.0f, 9.5f, 10.5f, 11.0f, 11.0f, 11.0f}, {8.5f, 8.5f, 8.5f}, {6.0f, 6.0f, 6.0f, 6.0f, 7.0f, 8.0f, 8.5f}, {11.0f, 11.0f, 11.0f, 11.0f, 10.0f, 9.0f, 8.5f}};
            this.wirePosZ = new float[][]{{8.5f, 8.5f, 8.5f}, {8.5f, 8.5f, 8.5f}, {15.0f, 14.0f, 13.0f, 12.0f, 12.0f, 12.0f, 12.0f, 11.0f, 10.0f, 12.0f, 12.0f, 12.0f, 11.0f, 10.0f}, {2.0f, 3.0f, 4.0f}, {7.0f, 6.0f, 5.0f, 4.0f, 4.0f, 4.0f, 4.0f}, {7.0f, 6.0f, 5.0f, 4.0f, 4.0f, 4.0f, 4.0f}};
            this.wireColor = new int[]{0, 0, 0, 0, 0, 0};
            this.torchX = new float[]{8.5f};
            this.torchY = new float[]{0.0f};
            this.torchZ = new float[]{4.0f};
            this.torchState = new boolean[]{false};
        }

        @Override
        public void set(int renderState) {
            this.torchState[0] = (renderState & 8) != 0;
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[1] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[2] = (renderState & 4) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[3] = (renderState & 0x40) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[4] = (renderState & 0x10) != 0 ? 0x400000 : 0xFF0000;
            this.wireColor[5] = (renderState & 0x20) != 0 ? 0x400000 : 0xFF0000;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0x400000;
            this.wireColor[3] = 0x400000;
            this.wireColor[4] = 0xFF0000;
            this.wireColor[5] = 0xFF0000;
            this.torchState[0] = false;
        }

        @Override
        public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
            if (isTESR) {
                return;
            }
            rt.renderPartModel(_chipRed, "base", 0.655f, 0.0f, 0.49875f, -1.0f, -1, false);
            rt.renderPartModel(_chipRed, this.wireColor[4] == 0xFF0000 ? "diodeon" : "diodeoff", 0.655f, 0.0f, 0.49875f, -1.0f, -1, false);
            rt.renderPartModel(_chipRed, "base", 0.3425f, 0.0f, 0.49875f, -1.0f, -1, false);
            rt.renderPartModel(_chipRed, this.wireColor[5] == 0xFF0000 ? "diodeon" : "diodeoff", 0.3425f, 0.0f, 0.49875f, -1.0f, -1, false);
        }
    }

    public static class StateCell
    extends GateRenderBridge
    implements Stateless {
        public StateCell() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 8.5f}, {8.5f, 8.5f, 8.5f}, {2.0f, 3.0f, 4.0f, 5.0f, 5.0f, 5.0f, 6.0f, 7.0f, 8.0f, 8.5f}, {8.5f, 8.5f, 8.5f}, {9.5f, 10.5f, 11.5f, 12.5f, 13.0f, 13.0f, 13.0f}, {15.0f, 14.0f, 13.0f}};
            this.wirePosZ = new float[][]{{2.0f, 3.0f, 4.0f, 5.0f}, {15.0f, 14.0f, 13.0f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.0f, 7.0f, 7.0f, 7.0f, 7.0f, 7.0f}, {11.0f, 10.0f, 9.0f}, {7.0f, 7.0f, 7.0f, 7.0f, 7.0f, 8.0f, 8.5f}, {8.5f, 8.5f, 8.5f}};
            this.wireColor = new int[]{0, 0, 0, 0, 0, 0};
            this.torchX = new float[]{13.0f};
            this.torchY = new float[]{0.0f};
            this.torchZ = new float[]{8.5f};
            this.torchState = new boolean[]{false};
            this.pointerX = new float[]{8.5f};
            this.pointerY = new float[]{0.0f};
            this.pointerZ = new float[]{12.0f};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[1] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[2] = (renderState & 4) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[3] = (renderState & 0x10) == 0 ? 0xFF0000 : 0x400000;
            this.wireColor[4] = (renderState & 8) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[5] = (renderState & 0x40) != 0 ? 0xFF0000 : 0x400000;
            this.torchState[0] = (renderState & 8) != 0;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0x400000;
            this.wireColor[3] = 0xFF0000;
            this.wireColor[4] = 0x400000;
            this.wireColor[5] = 0x400000;
            this.torchState[0] = false;
        }

        @Override
        public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
            if (isTESR) {
                return;
            }
            rt.renderPartModel(_chipRed, "base", 0.49875f, 0.0f, 0.5925f, -1.0f, -1, false);
            rt.renderPartModel(_chipRed, this.wireColor[0] == 0xFF0000 && this.wireColor[3] == 0x400000 ? "diodeon" : "diodeoff", 0.49875f, 0.0f, 0.5925f, -1.0f, -1, false);
        }
    }

    public static class Randomizer
    extends GateRenderBridge {
        boolean[] chipState;

        public Randomizer() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 9.5f, 7.5f}, {2.0f, 3.0f, 4.0f}, {15.0f, 14.0f, 13.0f}, {8.5f, 8.5f, 8.5f, 8.5f}};
            this.wirePosZ = new float[][]{{15.0f, 14.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.0f, 8.0f, 7.0f, 8.5f, 8.5f}, {8.5f, 8.5f, 8.5f}, {8.5f, 8.5f, 8.5f}, {2.0f, 3.0f, 4.0f, 5.0f}};
            this.wireColor = new int[]{0, 0, 0, 0};
            this.torchX = new float[]{5.5f, 11.5f, 8.5f};
            this.torchY = new float[]{0.0f, 0.0f, 0.0f};
            this.torchZ = new float[]{8.5f, 8.5f, 5.5f};
            this.chipState = new boolean[]{false, false, false};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[1] = (renderState & 0x20) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[2] = (renderState & 0x40) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[3] = (renderState & 0x10) != 0 ? 0xFF0000 : 0x400000;
            this.chipState[0] = (renderState & 2) != 0;
            this.chipState[1] = (renderState & 4) != 0;
            this.chipState[2] = (renderState & 8) != 0;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0x400000;
            this.wireColor[3] = 0x400000;
            this.chipState[0] = false;
            this.chipState[1] = false;
            this.chipState[2] = false;
        }

        @Override
        public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
            if (isTESR) {
                return;
            }
            rt.renderPartModel(_chipYellow, this.chipState[0] ? "diodeon" : "diodeoff", (16.0f - this.torchX[0]) / 16.0f + 0.03f, this.torchY[0] / 16.0f, (16.0f - this.torchZ[0]) / 16.0f + 0.03f, -1.0f, -1, false);
            rt.renderPartModel(_chipYellow, "base", (16.0f - this.torchX[0]) / 16.0f + 0.03f, this.torchY[0] / 16.0f, (16.0f - this.torchZ[0]) / 16.0f + 0.03f, -1.0f, -1, false);
            rt.renderPartModel(_chipYellow, this.chipState[1] ? "diodeon" : "diodeoff", (16.0f - this.torchX[1]) / 16.0f + 0.03f, this.torchY[1] / 16.0f, (16.0f - this.torchZ[1]) / 16.0f + 0.03f, -1.0f, -1, false);
            rt.renderPartModel(_chipYellow, "base", (16.0f - this.torchX[1]) / 16.0f + 0.03f, this.torchY[1] / 16.0f, (16.0f - this.torchZ[1]) / 16.0f + 0.03f, -1.0f, -1, false);
            rt.renderPartModel(_chipYellow, this.chipState[2] ? "diodeon" : "diodeoff", (16.0f - this.torchX[2]) / 16.0f + 0.03f, this.torchY[2] / 16.0f, (16.0f - this.torchZ[2]) / 16.0f + 0.03f, -1.0f, -1, false);
            rt.renderPartModel(_chipYellow, "base", (16.0f - this.torchX[2]) / 16.0f + 0.03f, this.torchY[2] / 16.0f, (16.0f - this.torchZ[2]) / 16.0f + 0.03f, -1.0f, -1, false);
        }
    }

    public static class PulseFormer
    extends GateRenderBridge
    implements Stateless {
        public PulseFormer() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 7.5f, 6.5f, 5.5f, 4.5f, 4.5f, 4.5f, 4.5f, 4.5f}, {5.5f, 3.5f, 4.5f, 4.5f, 4.5f, 4.5f, 5.5f, 6.5f, 7.5f, 8.5f}, {6.5f, 6.5f, 6.5f, 7.5f, 8.5f, 9.5f, 10.5f, 11.5f, 12.5f}, {12.5f, 12.5f, 12.5f, 12.25f, 12.75f}, {12.0f, 13.0f, 12.0f, 13.0f, 12.0f, 13.0f, 11.0f, 10.0f, 9.0f, 8.5f}, {8.5f, 8.5f}};
            this.wirePosZ = new float[][]{{15.0f, 14.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.0f, 8.5f}, {6.0f, 6.0f, 6.0f, 5.0f, 4.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f}, {7.5f, 8.5f, 9.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {7.5f, 6.5f, 5.5f, 5.5f, 5.5f}, {4.5f, 4.5f, 3.5f, 3.5f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f}, {2.0f, 3.0f}};
            this.wireColor = new int[]{0, 0, 0, 0, 0, 0};
            this.torchX = new float[]{8.5f, 4.5f, 12.5f};
            this.torchY = new float[]{0.0f, 0.0f, 0.0f};
            this.torchZ = new float[]{3.0f, 8.5f, 8.5f};
            this.torchState = new boolean[]{false, false, false};
        }

        @Override
        public void set(int renderState) {
            boolean inBack = (renderState & 1) != 0;
            boolean out = (renderState & 2) != 0;
            boolean changing = (renderState & 4) != 0;
            this.torchState[0] = out;
            this.torchState[1] = !inBack;
            this.torchState[2] = inBack && (!out || changing);
            this.wireColor[0] = inBack ? 0xFF0000 : 0x400000;
            this.wireColor[1] = inBack ? 0x400000 : 0xFF0000;
            this.wireColor[2] = inBack ? 0x400000 : 0xFF0000;
            this.wireColor[3] = this.torchState[2] ? 0xFF0000 : 0x400000;
            this.wireColor[4] = !this.torchState[0] && this.torchState[2] && !changing ? 0xFF0000 : 0x400000;
            this.wireColor[5] = (renderState & 8) != 0 ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.torchState[0] = false;
            this.torchState[1] = true;
            this.torchState[2] = false;
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0xFF0000;
            this.wireColor[2] = 0xFF0000;
            this.wireColor[3] = 0x400000;
            this.wireColor[4] = 0x400000;
            this.wireColor[5] = 0x400000;
        }
    }

    public static class Sequencer
    extends GateRenderBridge
    implements Stateless {
        public Sequencer() {
            this.wireColor = new int[0];
            this.torchX = new float[]{8.0f, 2.0f, 14.0f, 8.0f};
            this.torchY = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            this.torchZ = new float[]{2.0f, 8.0f, 8.0f, 14.0f};
            this.torchState = new boolean[]{false, false, false, false};
            this.pointerX = new float[]{8.0f};
            this.pointerY = new float[]{0.0f};
            this.pointerZ = new float[]{8.0f};
        }

        @Override
        public void set(int renderState) {
            this.torchState[0] = renderState == 0;
            this.torchState[1] = renderState == 3;
            this.torchState[2] = renderState == 1;
            this.torchState[3] = renderState == 2;
        }

        @Override
        public void setItemRender() {
            this.torchState[0] = true;
            this.torchState[1] = false;
            this.torchState[2] = false;
            this.torchState[3] = false;
        }
    }

    public static class Counter
    extends GateRenderBridge
    implements Stateless {
        public Counter() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 3.0f, 4.0f, 5.0f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 12.0f, 13.0f, 13.0f, 13.0f, 14.0f}, {2.0f, 3.0f, 4.0f}, {15.0f, 14.0f, 13.0f}};
            this.wirePosZ = new float[][]{{2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 4.0f, 4.0f, 4.0f}, {15.0f, 14.0f, 13.0f, 12.0f, 11.0f, 13.0f, 12.0f, 13.0f, 14.0f, 13.0f}, {8.5f, 8.5f, 8.5f}, {8.5f, 8.5f, 8.5f}};
            this.wireColor = new int[]{0, 0, 0, 0};
            this.torchX = new float[]{4.0f, 13.0f};
            this.torchY = new float[]{0.0f, 0.0f};
            this.torchZ = new float[]{8.5f, 8.5f};
            this.torchState = new boolean[]{false, false};
            this.pointerX = new float[]{8.5f};
            this.pointerY = new float[]{0.0f};
            this.pointerZ = new float[]{11.0f};
        }

        @Override
        public void set(int renderState) {
            this.torchState[0] = (renderState & 4) != 0;
            this.torchState[1] = (renderState & 8) != 0;
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[1] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[2] = (renderState & 0x10) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[3] = (renderState & 0x20) != 0 ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.torchState[0] = true;
            this.torchState[1] = false;
        }
    }

    public static class Timer
    extends GateRenderBridge
    implements Stateless {
        public Timer() {
            this.wirePosX = new float[][]{{2.0f, 3.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 5.0f, 6.0f, 6.0f, 6.0f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {15.0f, 14.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 12.0f, 11.0f, 11.0f, 11.0f}, {8.5f, 8.5f, 8.5f}};
            this.wirePosZ = new float[][]{{8.5f, 8.5f, 8.5f, 7.5f, 6.5f, 5.5f, 4.5f, 4.0f, 4.0f, 4.0f, 5.0f, 3.0f}, {15.0f, 14.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.0f, 8.5f}, {8.5f, 8.5f, 8.5f, 7.5f, 6.5f, 5.5f, 4.5f, 4.0f, 4.0f, 4.0f, 5.0f, 3.0f}, {2.0f, 3.0f, 4.0f}};
            this.wireColor = new int[]{0, 0, 0, 0};
            this.torchX = new float[]{8.5f};
            this.torchY = new float[]{0.0f};
            this.torchZ = new float[]{4.0f};
            this.torchState = new boolean[]{false};
            this.pointerX = new float[]{8.5f};
            this.pointerY = new float[]{0.0f};
            this.pointerZ = new float[]{8.5f};
        }

        @Override
        public void set(int renderState) {
            this.torchState[0] = (renderState & 1) != 0;
            this.wireColor[0] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[1] = (renderState & 4) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[2] = (renderState & 8) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[3] = (renderState & 0x20) != 0 ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.torchState[0] = false;
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0x400000;
            this.wireColor[3] = 0x400000;
        }
    }

    public static class Repeater
    extends GateRenderBridge
    implements Stateless {
        public Repeater() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.75f, 8.25f}, {8.0f, 8.0f, 8.0f, 8.0f, 8.0f, 8.0f, 8.0f, 8.0f, 8.0f, 8.0f, 8.0f, 9.0f, 9.0f, 9.0f, 9.0f, 9.0f, 9.0f, 9.0f, 9.0f, 9.0f, 9.0f, 9.0f}};
            this.wirePosZ = new float[][]{{14.0f, 15.0f, 13.0f, 13.0f}, {2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f}};
            this.wireColor = new int[]{0, 0};
            this.torchX = new float[]{8.5f, 8.5f};
            this.torchY = new float[]{0.0f, 0.0f};
            this.torchZ = new float[]{3.0f, 6.0f};
            this.torchState = new boolean[]{false, false};
        }

        @Override
        public void set(int renderState) {
            boolean out = (renderState & 0x8000) != 0;
            boolean in = (renderState & 0x40) != 0;
            this.torchZ[1] = (renderState & 7) + 6;
            this.torchState[0] = this.torchState[1] = out;
            this.wireColor[0] = in ? 0xFF0000 : 0x400000;
            this.wireColor[1] = out ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.torchZ[1] = 6.0f;
            this.torchState[1] = false;
            this.torchState[0] = false;
            this.wireColor[1] = 0x400000;
        }
    }

    public static class Multiplexer
    extends GateRenderBridge
    implements Stateless {
        public Multiplexer() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 7.5f, 6.5f, 5.5f, 4.5f, 8.5f, 9.5f, 10.5f, 11.5f, 12.5f, 12.5f, 12.5f, 12.5f, 12.5f}, {2.0f, 3.0f, 4.0f}, {15.0f, 14.0f, 13.0f}, {3.5f, 4.5f, 5.5f, 4.5f, 4.5f, 4.5f}, {7.5f, 6.5f, 5.5f, 4.5f, 4.5f, 4.5f, 4.5f, 3.5f, 5.5f}, {9.5f, 10.5f, 11.5f, 12.5f, 12.5f, 12.5f, 12.5f, 11.5f, 13.5f}, {8.5f}};
            this.wirePosZ = new float[][]{{15.0f, 14.0f, 14.0f, 14.0f, 14.0f, 14.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.0f}, {8.5f, 8.5f, 8.5f}, {8.5f, 8.5f, 8.5f}, {12.0f, 12.0f, 12.0f, 11.0f, 10.0f, 9.0f}, {3.0f, 3.0f, 3.0f, 3.0f, 4.0f, 5.0f, 6.0f, 6.0f, 6.0f}, {3.0f, 3.0f, 3.0f, 3.0f, 4.0f, 5.0f, 6.0f, 6.0f, 6.0f}, {2.0f}};
            this.wireColor = new int[]{0, 0, 0, 0, 0, 0, 0};
            this.torchX = new float[]{8.5f, 4.5f, 12.5f, 4.5f};
            this.torchY = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            this.torchZ = new float[]{3.0f, 8.5f, 8.5f, 14.0f};
            this.torchState = new boolean[]{false, false, false, false};
        }

        @Override
        public void set(int renderState) {
            boolean back = (renderState & 1) != 0;
            boolean left = (renderState & 2) != 0;
            boolean right = (renderState & 4) != 0;
            boolean out = (renderState & 8) != 0;
            this.wireColor[0] = back ? 0xFF0000 : 0x400000;
            this.wireColor[1] = left ? 0xFF0000 : 0x400000;
            this.wireColor[2] = right ? 0xFF0000 : 0x400000;
            this.wireColor[3] = !back ? 0xFF0000 : 0x400000;
            this.wireColor[4] = !left && back ? 0xFF0000 : 0x400000;
            this.wireColor[5] = !right && !back ? 0xFF0000 : 0x400000;
            this.wireColor[6] = (renderState & 0x10) != 0 ? 0xFF0000 : 0x400000;
            this.torchState[0] = out;
            this.torchState[1] = !left && back;
            this.torchState[2] = !right && !back;
            this.torchState[3] = !back;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0x400000;
            this.wireColor[3] = 0xFF0000;
            this.wireColor[4] = 0x400000;
            this.wireColor[5] = 0xFF0000;
            this.wireColor[6] = 0xFF0000;
            this.torchState[0] = false;
            this.torchState[1] = false;
            this.torchState[2] = true;
            this.torchState[3] = true;
        }
    }

    public static class Buffer
    extends GateRenderBridge
    implements Stateless {
        public Buffer() {
            this.wirePosX = new float[][]{{2.0f, 3.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 5.0f, 6.0f, 6.0f, 6.0f}, {15.0f, 14.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 12.0f, 11.0f, 11.0f, 11.0f}, {8.5f, 8.5f, 8.5f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 7.5f, 9.5f}, {8.5f, 8.5f}};
            this.wirePosZ = new float[][]{{8.5f, 8.5f, 8.5f, 7.5f, 6.5f, 5.5f, 4.5f, 4.0f, 4.0f, 4.0f, 5.0f, 3.0f}, {8.5f, 8.5f, 8.5f, 7.5f, 6.5f, 5.5f, 4.5f, 4.0f, 4.0f, 4.0f, 5.0f, 3.0f}, {15.0f, 14.0f, 13.0f}, {5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 10.0f, 10.0f}, {2.0f, 3.0f}};
            this.wireColor = new int[]{0, 0, 0, 0, 0};
            this.torchX = new float[]{8.5f, 8.5f};
            this.torchY = new float[]{0.0f, 0.0f};
            this.torchZ = new float[]{4.0f, 12.0f};
            this.torchState = new boolean[]{false, false};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 4) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[1] = (renderState & 8) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[2] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[3] = (renderState & 2) == 0 ? 0xFF0000 : 0x400000;
            this.wireColor[4] = (renderState & 0x10) != 0 ? 0xFF0000 : 0x400000;
            this.torchState[0] = (renderState & 1) != 0;
            this.torchState[1] = (renderState & 2) == 0;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0x400000;
            this.wireColor[3] = 0xFF0000;
            this.wireColor[4] = 0xFF0000;
            this.torchState[0] = false;
            this.torchState[1] = true;
        }
    }

    public static class XNOR
    extends GateRenderBridge
    implements Stateless {
        public XNOR() {
            this.wirePosX = new float[][]{{2.0f, 3.0f, 4.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f}, {15.0f, 14.0f, 13.0f, 14.0f, 14.0f, 14.0f, 14.0f, 14.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.0f}, {5.5f, 6.5f, 7.5f, 9.5f, 10.5f, 11.5f, 8.5f, 8.5f, 8.5f, 8.5f, 7.5f, 9.5f}, {7.5f, 6.5f, 5.5f, 4.5f, 4.5f, 4.5f, 4.5f, 4.5f, 4.5f}, {9.5f, 10.5f, 11.5f, 12.5f, 12.5f, 12.5f, 12.5f, 12.5f, 12.5f}, {8.5f}};
            this.wirePosZ = new float[][]{{8.5f, 8.5f, 8.5f, 9.5f, 10.5f, 11.5f, 12.5f, 13.5f, 13.5f, 13.5f, 13.5f, 13.5f, 13.5f}, {8.5f, 8.5f, 8.5f, 9.5f, 10.5f, 11.5f, 12.5f, 13.5f, 13.5f, 13.5f, 13.5f, 13.5f, 13.5f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 9.5f, 10.5f, 11.0f, 11.0f, 11.0f}, {3.0f, 3.0f, 3.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f}, {3.0f, 3.0f, 3.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f}, {2.0f}};
            this.wireColor = new int[]{0, 0, 0, 0, 0, 0};
            this.torchX = new float[]{8.5f, 4.5f, 12.5f, 8.5f};
            this.torchY = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            this.torchZ = new float[]{3.0f, 8.5f, 8.5f, 13.5f};
            this.torchState = new boolean[]{false, false, false, false};
        }

        @Override
        public void set(int renderState) {
            boolean left = (renderState & 1) != 0;
            boolean right = (renderState & 2) != 0;
            boolean out = (renderState & 4) != 0;
            this.wireColor[0] = left ? 0xFF0000 : 0x400000;
            this.wireColor[1] = right ? 0xFF0000 : 0x400000;
            this.wireColor[2] = !left && !right ? 0xFF0000 : 0x400000;
            this.wireColor[3] = !left && right ? 0xFF0000 : 0x400000;
            this.wireColor[4] = left && !right ? 0xFF0000 : 0x400000;
            this.wireColor[5] = (renderState & 8) != 0 ? 0xFF0000 : 0x400000;
            this.torchState[0] = out;
            this.torchState[1] = !left && right;
            this.torchState[2] = left && !right;
            this.torchState[3] = !left && !right;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0xFF0000;
            this.wireColor[3] = 0x400000;
            this.wireColor[4] = 0x400000;
            this.wireColor[5] = 0xFF0000;
            this.torchState[0] = true;
            this.torchState[1] = false;
            this.torchState[2] = false;
            this.torchState[3] = true;
        }
    }

    public static class XOR
    extends GateRenderBridge
    implements Stateless {
        public XOR() {
            this.wirePosX = new float[][]{{2.0f, 3.0f, 4.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f}, {15.0f, 14.0f, 13.0f, 14.0f, 14.0f, 14.0f, 14.0f, 14.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.0f}, {5.5f, 6.5f, 7.5f, 9.5f, 10.5f, 11.5f, 8.5f, 8.5f, 8.5f, 8.5f, 7.5f, 9.5f}, {8.5f, 8.5f, 8.5f, 7.5f, 6.5f, 5.5f, 4.5f, 9.5f, 10.5f, 11.5f, 12.5f, 4.5f, 4.5f, 4.5f, 4.5f, 12.5f, 12.5f, 12.5f, 12.5f}};
            this.wirePosZ = new float[][]{{8.5f, 8.5f, 8.5f, 9.5f, 10.5f, 11.5f, 12.5f, 13.5f, 13.5f, 13.5f, 13.5f, 13.5f, 13.5f}, {8.5f, 8.5f, 8.5f, 9.5f, 10.5f, 11.5f, 12.5f, 13.5f, 13.5f, 13.5f, 13.5f, 13.5f, 13.5f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 9.5f, 10.5f, 11.0f, 11.0f, 11.0f}, {2.0f, 3.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 5.0f, 6.0f, 7.0f, 8.0f}};
            this.wireColor = new int[]{0, 0, 0, 0};
            this.torchX = new float[]{4.5f, 12.5f, 8.5f};
            this.torchY = new float[]{0.0f, 0.0f, 0.0f};
            this.torchZ = new float[]{8.5f, 8.5f, 13.5f};
            this.torchState = new boolean[]{false, false, false};
        }

        @Override
        public void set(int renderState) {
            boolean left = (renderState & 1) != 0;
            boolean right = (renderState & 2) != 0;
            boolean out = (renderState & 4) != 0;
            this.wireColor[0] = left ? 0xFF0000 : 0x400000;
            this.wireColor[1] = right ? 0xFF0000 : 0x400000;
            this.wireColor[2] = !left && !right ? 0xFF0000 : 0x400000;
            this.wireColor[3] = out ? 0xFF0000 : 0x400000;
            this.torchState[0] = !left && right;
            this.torchState[1] = left && !right;
            this.torchState[2] = !left && !right;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0xFF0000;
            this.wireColor[3] = 0x400000;
            this.torchState[0] = false;
            this.torchState[1] = false;
            this.torchState[2] = true;
        }
    }

    public static class NAND
    extends GateRenderBridge
    implements Stateless {
        public NAND() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 4.5f, 4.5f, 5.0f, 6.0f, 7.0f, 8.0f, 8.5f, 9.0f, 10.0f, 11.0f, 12.0f, 12.5f, 12.5f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {12.5f, 12.5f, 12.5f, 13.0f, 14.0f, 15.0f}, {4.5f, 4.5f, 4.5f, 4.0f, 3.0f, 2.0f}};
            this.wirePosZ = new float[][]{{2.0f, 3.0f, 4.0f, 6.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 6.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 6.0f}, {7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f}, {7.0f, 8.0f, 8.5f, 8.5f, 8.5f, 8.5f}, {7.0f, 8.0f, 8.5f, 8.5f, 8.5f, 8.5f}};
            this.wireColor = new int[]{0, 0, 0, 0};
            this.torchX = new float[]{4.5f, 8.5f, 12.5f};
            this.torchY = new float[]{0.0f, 0.0f, 0.0f};
            this.torchZ = new float[]{6.5f, 6.5f, 6.5f};
            this.torchState = new boolean[]{true, true, true};
        }

        @Override
        public void set(int renderState) {
            boolean left_disabled = (renderState & 0x10) != 0;
            boolean back_disabled = (renderState & 0x20) != 0;
            boolean right_disabled = (renderState & 0x40) != 0;
            int n = this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            int n2 = back_disabled ? 0xC0C0C0 : (this.wireColor[1] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000);
            int n3 = right_disabled ? 0xC0C0C0 : (this.wireColor[2] = (renderState & 8) != 0 ? 0xFF0000 : 0x400000);
            this.wireColor[3] = left_disabled ? 0xC0C0C0 : ((renderState & 4) != 0 ? 0xFF0000 : 0x400000);
            this.torchState[0] = (renderState & 4) == 0 && !left_disabled;
            this.torchState[1] = (renderState & 2) == 0 && !back_disabled;
            this.torchState[2] = (renderState & 8) == 0 && !right_disabled;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0xFF0000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0x400000;
            this.wireColor[3] = 0x400000;
            this.torchState[0] = true;
            this.torchState[1] = true;
            this.torchState[2] = true;
        }
    }

    public static class NOR
    extends GateRenderBridge
    implements Stateless {
        public NOR() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {15.0f, 14.0f, 13.0f, 13.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.5f}, {2.0f, 3.0f, 4.0f, 4.0f, 4.0f, 5.0f, 6.0f, 7.0f, 7.5f}};
            this.wirePosZ = new float[][]{{2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f}, {8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f}, {8.5f, 8.5f, 8.5f, 8.0f, 7.5f, 7.5f, 7.5f, 7.5f, 7.5f}, {8.5f, 8.5f, 8.5f, 8.0f, 7.5f, 7.5f, 7.5f, 7.5f, 7.5f}};
            this.wireColor = new int[]{0, 0, 0, 0};
            this.torchX = new float[]{8.5f};
            this.torchY = new float[]{0.0f};
            this.torchZ = new float[]{7.5f};
            this.torchState = new boolean[]{false};
        }

        @Override
        public void set(int renderState) {
            int n = this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            int n2 = (renderState & 0x40) != 0 ? 0xC0C0C0 : (this.wireColor[1] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000);
            int n3 = (renderState & 0x80) != 0 ? 0xC0C0C0 : (this.wireColor[2] = (renderState & 8) != 0 ? 0xFF0000 : 0x400000);
            this.wireColor[3] = (renderState & 0x20) != 0 ? 0xC0C0C0 : ((renderState & 4) != 0 ? 0xFF0000 : 0x400000);
            this.torchState[0] = (renderState & 0x10) != 0;
        }

        @Override
        public void setItemRender() {
            this.wireColor[3] = 0xFF0000;
            this.wireColor[2] = 0xFF0000;
            this.wireColor[0] = 0xFF0000;
            this.wireColor[1] = 0x400000;
            this.torchState[0] = true;
        }
    }

    public static class ToggleLatch
    extends GateRenderBridge
    implements Stateless {
        public ToggleLatch() {
            this.wirePosX = new float[][]{{2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f}, {15.0f, 14.0f, 13.0f}, {4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 10.0f, 8.5f, 8.5f}, {4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 10.0f, 8.5f, 8.5f}};
            this.wirePosZ = new float[][]{{8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {8.5f, 8.5f, 8.5f}, {3.5f, 3.5f, 3.5f, 3.5f, 3.5f, 3.5f, 3.5f, 4.5f, 2.0f, 3.0f}, {13.5f, 13.5f, 13.5f, 13.5f, 13.5f, 13.5f, 13.5f, 13.0f, 15.0f, 14.0f}};
            this.wireColor = new int[]{0, 0, 0, 0};
            this.torchX = new float[]{4.0f, 4.0f};
            this.torchY = new float[]{0.0f, 0.0f};
            this.torchZ = new float[]{3.5f, 13.5f};
            this.torchState = new boolean[]{true, false};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[1] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000;
            this.torchState[0] = (renderState & 4) != 0;
            this.torchState[1] = (renderState & 8) != 0;
            this.wireColor[2] = this.torchState[0] ? 0xFF0000 : 0x400000;
            this.wireColor[3] = this.torchState[1] ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0xFF0000;
            this.wireColor[3] = 0x400000;
            this.torchState[0] = true;
            this.torchState[1] = false;
        }

        @Override
        public void renderSpecials(RotatedRenderer rt, boolean isTESR) {
            if (isTESR) {
                return;
            }
            float xPos = 0.405f;
            float zPos = 0.49875f;
            rt.renderPartModel(_lever, "base", xPos, 0.125f, zPos, -1.0f, -1, false);
            rt.renderPartModel(_lever, this.torchState[0] ? "leveron" : "leveroff", xPos, 0.125f, zPos, -1.0f, -1, false);
        }
    }

    public static class RSLatch
    extends GateRenderBridge
    implements Stateless {
        public RSLatch() {
            this.wirePosX = new float[][]{{5.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 8.5f, 8.5f, 8.5f, 8.5f, 2.0f, 3.0f}, {8.5f, 8.5f, 8.5f, 8.5f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 12.0f, 14.0f, 15.0f}};
            this.wirePosZ = new float[][]{{13.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.0f, 8.0f, 7.0f, 6.0f, 5.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 4.0f, 5.0f, 3.0f, 2.0f, 8.5f, 8.5f}, {15.0f, 14.0f, 12.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.0f, 8.0f, 7.0f, 6.0f, 5.0f, 4.0f, 4.0f, 8.5f, 8.5f}};
            this.wireColor = new int[]{0, 0};
            this.torchX = new float[]{11.0f, 6.0f};
            this.torchY = new float[]{0.0f, 0.0f};
            this.torchZ = new float[]{4.0f, 13.0f};
            this.torchState = new boolean[]{false, false};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            this.wireColor[1] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000;
            this.torchState[0] = (renderState & 4) != 0;
            this.torchState[1] = (renderState & 8) != 0;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0xFF0000;
            this.wireColor[1] = 0x400000;
            this.torchState[0] = true;
            this.torchState[1] = false;
        }
    }

    public static class NOT
    extends GateRenderBridge
    implements Stateless {
        public NOT() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 7.5f, 9.5f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {15.0f, 14.0f, 13.0f, 13.0f, 13.0f, 12.5f, 12.5f, 12.5f}, {2.0f, 3.0f, 4.0f, 4.0f, 4.0f, 4.5f, 4.5f, 4.5f}};
            this.wirePosZ = new float[][]{{2.0f, 3.0f, 4.0f, 4.0f, 4.0f}, {8.5f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 7.5f, 9.5f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 7.5f, 9.5f}};
            this.wireColor = new int[]{0, 0, 0, 0};
            this.torchX = new float[]{8.5f};
            this.torchY = new float[]{0.0f};
            this.torchZ = new float[]{8.5f};
            this.torchState = new boolean[]{false};
        }

        @Override
        public void set(int renderState) {
            this.wireColor[0] = (renderState & 0x40) != 0 ? 0xC0C0C0 : ((renderState & 1) != 0 ? 0xFF0000 : 0x400000);
            int n = this.wireColor[1] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000;
            int n2 = (renderState & 0x80) != 0 ? 0xC0C0C0 : (this.wireColor[2] = (renderState & 8) != 0 ? 0xFF0000 : 0x400000);
            this.wireColor[3] = (renderState & 0x20) != 0 ? 0xC0C0C0 : ((renderState & 4) != 0 ? 0xFF0000 : 0x400000);
            this.torchState[0] = (renderState & 0x10) != 0;
        }

        @Override
        public void setItemRender() {
            this.wireColor[3] = 0xFF0000;
            this.wireColor[2] = 0xFF0000;
            this.wireColor[0] = 0xFF0000;
            this.wireColor[1] = 0x400000;
            this.torchState[0] = true;
        }
    }

    public static class OR
    extends GateRenderBridge
    implements Stateless {
        public OR() {
            this.wirePosX = new float[][]{{8.5f, 8.5f, 8.5f, 7.5f, 9.5f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {15.0f, 14.0f, 13.0f, 13.0f, 13.0f, 12.0f, 11.0f, 10.0f, 9.5f}, {2.0f, 3.0f, 4.0f, 4.0f, 4.0f, 5.0f, 6.0f, 7.0f, 7.5f}, {8.5f, 8.5f, 8.5f, 7.5f, 9.5f}};
            this.wirePosZ = new float[][]{{2.0f, 3.0f, 4.0f, 4.0f, 4.0f}, {10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f}, {8.5f, 8.5f, 8.5f, 9.0f, 9.5f, 9.5f, 9.5f, 9.5f, 9.5f}, {8.5f, 8.5f, 8.5f, 9.0f, 9.5f, 9.5f, 9.5f, 9.5f, 9.5f}, {7.0f, 8.0f, 9.0f, 7.0f, 7.0f}};
            this.wireColor = new int[]{0, 0, 0, 0, 0};
            this.torchX = new float[]{8.5f, 8.5f};
            this.torchY = new float[]{0.0f, 0.0f};
            this.torchZ = new float[]{5.5f, 9.5f};
            this.torchState = new boolean[]{false, true};
        }

        @Override
        public void set(int renderState) {
            int n = this.wireColor[0] = (renderState & 1) != 0 ? 0xFF0000 : 0x400000;
            int n2 = (renderState & 0x40) != 0 ? 0xC0C0C0 : (this.wireColor[1] = (renderState & 2) != 0 ? 0xFF0000 : 0x400000);
            int n3 = (renderState & 0x80) != 0 ? 0xC0C0C0 : (this.wireColor[2] = (renderState & 8) != 0 ? 0xFF0000 : 0x400000);
            this.wireColor[3] = (renderState & 0x20) != 0 ? 0xC0C0C0 : ((renderState & 4) != 0 ? 0xFF0000 : 0x400000);
            this.torchState[0] = (renderState & 0x10) != 0;
            this.torchState[1] = !this.torchState[0];
            this.wireColor[4] = this.torchState[1] ? 0xFF0000 : 0x400000;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0x400000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0x400000;
            this.wireColor[3] = 0x400000;
            this.wireColor[4] = 0xFF0000;
            this.torchState[0] = false;
            this.torchState[1] = true;
        }
    }

    public static class AND
    extends GateRenderBridge
    implements Stateless {
        public AND() {
            this.wirePosX = new float[][]{{4.5f, 4.5f, 5.0f, 6.0f, 7.0f, 8.0f, 8.5f, 9.0f, 10.0f, 11.0f, 12.0f, 12.5f, 12.5f}, {8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f, 8.5f}, {12.5f, 12.5f, 12.5f, 13.0f, 14.0f, 15.0f}, {4.5f, 4.5f, 4.5f, 4.0f, 3.0f, 2.0f}, {8.5f, 8.5f}};
            this.wirePosZ = new float[][]{{6.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 6.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 6.0f}, {7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f}, {7.0f, 8.0f, 8.5f, 8.5f, 8.5f, 8.5f}, {7.0f, 8.0f, 8.5f, 8.5f, 8.5f, 8.5f}, {2.0f, 2.5f}};
            this.wireColor = new int[]{0, 0, 0, 0, 0};
            this.torchX = new float[]{8.5f, 4.5f, 8.5f, 12.5f};
            this.torchY = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            this.torchZ = new float[]{2.5f, 7.0f, 7.0f, 7.0f};
            this.torchState = new boolean[]{false, true, true, true};
        }

        @Override
        public void set(int renderState) {
            boolean out_on = (renderState & 1) != 0;
            boolean back_on = (renderState & 2) != 0;
            boolean left_on = (renderState & 4) != 0;
            boolean right_on = (renderState & 8) != 0;
            boolean left_disabled = (renderState & 0x10) != 0;
            boolean back_disabled = (renderState & 0x20) != 0;
            boolean right_disabled = (renderState & 0x40) != 0;
            boolean out_in = (renderState & 0x80) != 0;
            int n = this.wireColor[0] = out_on ? 0x400000 : 0xFF0000;
            int n2 = back_disabled ? 0xC0C0C0 : (this.wireColor[1] = back_on ? 0xFF0000 : 0x400000);
            int n3 = right_disabled ? 0xC0C0C0 : (this.wireColor[2] = right_on ? 0xFF0000 : 0x400000);
            this.wireColor[3] = left_disabled ? 0xC0C0C0 : (left_on ? 0xFF0000 : 0x400000);
            this.wireColor[4] = out_in ? 0xFF0000 : 0x400000;
            this.torchState[0] = out_on;
            this.torchState[1] = !left_on && !left_disabled;
            this.torchState[2] = !back_on && !back_disabled;
            this.torchState[3] = !right_on && !right_disabled;
        }

        @Override
        public void setItemRender() {
            this.wireColor[0] = 0xFF0000;
            this.wireColor[1] = 0x400000;
            this.wireColor[2] = 0x400000;
            this.wireColor[3] = 0x400000;
            this.torchState[0] = false;
            this.torchState[1] = true;
            this.torchState[2] = true;
            this.torchState[3] = true;
        }
    }

    public static interface Stateless {
    }

    public static class Default
    extends GateRenderBridge
    implements Stateless {
    }
}

