/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.gates;

import java.util.Random;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.multipart.wiring.gates.GateLogicTimed;
import mrtjp.projectred.multipart.wiring.gates.TileGate;
import mrtjp.projectred.network.GuiIDs;
import mrtjp.projectred.utils.BasicUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class GateLogic {
    public World world;

    public abstract void update(short[] var1, short[] var2, int var3);

    public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
        return 0;
    }

    public int configure(int gateSettings) {
        return gateSettings;
    }

    public void write(NBTTagCompound tag) {
    }

    public void read(NBTTagCompound tag) {
    }

    public boolean connectsToDirection(int side) {
        return true;
    }

    public static class RainSensor
    extends GateLogic
    implements WorldStateBound {
        World w;
        int x;
        int y;
        int z;

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (this.w != null && this.w.func_82737_E() % 8L == 0L) {
                outputs[1] = (short)(this.w.func_72896_J() && BasicUtils.canBlockSeeSky(this.w, this.x, this.y, this.z) ? 255 : 0);
            }
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return inputs[1] != 0 || outputs[1] != 0 ? 1 : 0;
        }

        @Override
        public void setWorldInfo(World world, int x, int y, int z) {
            this.w = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public boolean needsWorldInfo() {
            return this.w == null;
        }
    }

    public static class LightSensor
    extends GateLogic
    implements WorldStateBound {
        World w;
        int x;
        int y;
        int z;
        int threshold;

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            this.threshold = gateSettings;
            if (this.w != null && this.w.func_82737_E() % 8L == 0L) {
                int brightness = BasicUtils.getAbsoluteBrightness(this.w, this.x, this.y, this.z);
                outputs[1] = this.threshold < 5 ? (short)(brightness >= this.threshold * 3 + 3 ? 255 : 0) : (short)(brightness * 17 > 255 ? 255 : brightness * 17);
            }
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[1] != 0 || outputs[1] != 0 ? 1 : 0) | (gateSettings == 0 ? 2 : 0) | (gateSettings == 1 ? 4 : 0) | (gateSettings == 2 ? 8 : 0) | (gateSettings == 3 ? 16 : 0) | (gateSettings == 4 ? 32 : 0) | (gateSettings == 5 ? 64 : 0);
        }

        @Override
        public void setWorldInfo(World world, int x, int y, int z) {
            this.w = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public boolean needsWorldInfo() {
            return this.w == null;
        }

        @Override
        public int configure(int gateSettings) {
            return ++gateSettings > 5 ? 0 : gateSettings;
        }
    }

    public static class BundledMultiplexer
    extends GateLogic
    implements Stateless,
    Flippable,
    WithBundledConnections {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            outputs[0] = inputs[1] != 0 ? inputs[3] : inputs[2];
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return inputs[1] != 0 ? 1 : 0;
        }

        @Override
        public boolean isBundledConnection(int side) {
            return side == 0 || side == 2 || side == 3;
        }
    }

    public static class BundledRelay
    extends GateLogic
    implements Stateless,
    Flippable,
    WithBundledConnections {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            outputs[0] = inputs[3] != 0 ? inputs[1] : (short)0;
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return inputs[3] != 0 ? 1 : 0;
        }

        @Override
        public boolean connectsToDirection(int side) {
            return side == 3 || side == 0 || side == 1;
        }

        @Override
        public boolean isBundledConnection(int side) {
            return side == 0 || side == 1;
        }
    }

    public static class BundledLatch
    extends GateLogic
    implements Stateless,
    Flippable,
    WithBundledConnections {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (inputs[3] != 0) {
                outputs[0] = inputs[1];
            }
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return inputs[3] != 0 ? 1 : 0;
        }

        @Override
        public boolean connectsToDirection(int side) {
            return side == 3 || side == 0 || side == 1;
        }

        @Override
        public boolean isBundledConnection(int side) {
            return side == 0 || side == 1;
        }
    }

    public static class DFlop
    extends GateLogic
    implements Flippable {
        private boolean clockWasOn;

        @Override
        public void write(NBTTagCompound tag) {
            tag.func_74757_a("clock", this.clockWasOn);
        }

        @Override
        public void read(NBTTagCompound tag) {
            this.clockWasOn = tag.func_74767_n("clock");
        }

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (inputs[3] != 0 && !this.clockWasOn) {
                outputs[0] = outputs[2] = (short)(inputs[1] != 0 ? 255 : 0);
            }
            this.clockWasOn = inputs[3] != 0;
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[1] != 0 ? 1 : 0) | (inputs[3] != 0 ? 2 : 0) | (outputs[0] != 0 || inputs[0] != 0 ? 4 : 0) | (outputs[2] != 0 || inputs[2] != 0 ? 8 : 0);
        }
    }

    public static class DLatch
    extends GateLogic
    implements Stateless,
    Flippable {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (inputs[3] != 0) {
                outputs[0] = outputs[2] = (short)(inputs[1] != 0 ? 255 : 0);
            }
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[1] != 0 ? 1 : 0) | (inputs[3] != 0 ? 2 : 0) | (outputs[0] != 0 || inputs[0] != 0 ? 4 : 0) | (outputs[2] != 0 || inputs[2] != 0 ? 8 : 0);
        }
    }

    public static class Synchronizer
    extends GateLogic {
        private boolean leftLatch;
        private boolean rightLatch;
        private boolean wasLeft;
        private boolean wasRight;
        private int pulseTicks;

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (inputs[2] == 0 && this.wasLeft) {
                this.leftLatch = true;
            }
            if (inputs[3] == 0 && this.wasRight) {
                this.rightLatch = true;
            }
            if (inputs[1] != 0) {
                this.rightLatch = false;
                this.leftLatch = false;
            }
            if (this.leftLatch && this.rightLatch) {
                this.pulseTicks = 2;
                this.rightLatch = false;
                this.leftLatch = false;
            }
            this.wasLeft = inputs[2] != 0;
            boolean bl = this.wasRight = inputs[3] != 0;
            if (this.pulseTicks > 0) {
                outputs[0] = 255;
                --this.pulseTicks;
            } else {
                outputs[0] = 0;
            }
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[2] != 0 ? 1 : 0) | (inputs[3] != 0 ? 2 : 0) | (inputs[1] != 0 ? 4 : 0) | (outputs[0] != 0 ? 8 : 0) | (this.leftLatch ? 16 : 0) | (this.rightLatch ? 32 : 0) | (outputs[0] != 0 || inputs[0] != 0 ? 64 : 0);
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74774_a("f", (byte)(this.pulseTicks | (this.leftLatch ? 4 : 0) | (this.rightLatch ? 8 : 0) | (this.wasLeft ? 16 : 0) | (this.wasRight ? 32 : 0)));
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            byte f = tag.func_74771_c("f");
            this.pulseTicks = f & 3;
            this.leftLatch = (f & 4) != 0;
            this.rightLatch = (f & 8) != 0;
            this.wasLeft = (f & 0x10) != 0;
            this.wasRight = (f & 0x20) != 0;
        }
    }

    public static class StateCell
    extends GateLogic
    implements WithRightClickAction,
    WithPointer,
    GateLogicTimed,
    Flippable {
        private int intervalTicks = 20;
        private int ticksLeft;
        private int pulseTicks;
        private boolean timing;
        private boolean paused;

        @Override
        public int getPointerPosition() {
            if (!this.timing) {
                return 0;
            }
            return 44 - (int)((float)this.ticksLeft * 45.0f / (float)this.intervalTicks);
        }

        @Override
        public float getPointerSpeed() {
            if (!this.timing || this.paused) {
                return 0.0f;
            }
            return 45.0f / (float)this.intervalTicks;
        }

        @Override
        public void onRightClick(EntityPlayer ply, TileGate tile) {
            ply.openGui((Object)ProjectRed.instance, GuiIDs.ID_Timer, tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
        }

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (inputs[2] != 0 && !this.timing) {
                this.timing = true;
                this.ticksLeft = this.intervalTicks;
            }
            boolean bl = this.paused = inputs[2] != 0 || inputs[1] != 0;
            if (this.timing && !this.paused) {
                --this.ticksLeft;
                if (this.ticksLeft <= 0) {
                    this.pulseTicks = 2;
                    this.timing = false;
                }
            }
            outputs[0] = this.timing ? 255 : 0;
            int n = outputs[3] = this.pulseTicks > 0 ? 255 : 0;
            if (this.pulseTicks > 0) {
                --this.pulseTicks;
            }
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (outputs[0] != 0 || inputs[0] != 0 ? 1 : 0) | (inputs[1] != 0 ? 2 : 0) | (inputs[2] != 0 ? 4 : 0) | (outputs[3] != 0 ? 8 : 0) | (this.timing ? 16 : 0) | (this.paused ? 32 : 0) | (inputs[3] != 0 || outputs[3] != 0 ? 64 : 0);
        }

        @Override
        public int getInterval() {
            return this.intervalTicks;
        }

        @Override
        public void setInterval(int i) {
            this.intervalTicks = i;
            if (this.ticksLeft > i) {
                this.ticksLeft = i;
            }
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.intervalTicks = tag.func_74762_e("intv");
            this.ticksLeft = tag.func_74762_e("left");
            this.pulseTicks = tag.func_74771_c("pulse");
            this.timing = tag.func_74767_n("timing");
            this.paused = tag.func_74767_n("paused");
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74768_a("intv", this.intervalTicks);
            tag.func_74768_a("left", this.ticksLeft);
            tag.func_74774_a("pulse", (byte)this.pulseTicks);
            tag.func_74757_a("timing", this.timing);
            tag.func_74757_a("paused", this.paused);
        }
    }

    public static class Randomizer
    extends GateLogic {
        private int ticksLeft;
        private Random random = new Random();

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (inputs[1] != 0 && this.ticksLeft == 0) {
                this.ticksLeft = 20;
                outputs[0] = this.random.nextBoolean() ? 255 : 0;
                outputs[2] = this.random.nextBoolean() ? 255 : 0;
                int n = outputs[3] = this.random.nextBoolean() ? 255 : 0;
            }
            if (inputs[1] == 0) {
                this.ticksLeft = 0;
            }
            if (this.ticksLeft > 0) {
                --this.ticksLeft;
            }
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[1] != 0 ? 1 : 0) | (outputs[2] != 0 ? 2 : 0) | (outputs[3] != 0 ? 4 : 0) | (outputs[0] != 0 ? 8 : 0) | (outputs[0] != 0 || inputs[0] != 0 ? 16 : 0) | (outputs[2] != 0 || inputs[2] != 0 ? 32 : 0) | (outputs[3] != 0 || inputs[3] != 0 ? 64 : 0);
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74774_a("ticksLeft", (byte)this.ticksLeft);
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.ticksLeft = tag.func_74771_c("ticksLeft");
        }
    }

    public static class PulseFormer
    extends GateLogic {
        private boolean prevInput;
        private int ticksLeft;

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (inputs[1] != 0 && !this.prevInput) {
                outputs[0] = 255;
                this.ticksLeft = 3;
            }
            if (this.ticksLeft > 0) {
                --this.ticksLeft;
                if (this.ticksLeft == 0) {
                    outputs[0] = 0;
                }
            }
            this.prevInput = inputs[1] != 0;
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[1] != 0 ? 1 : 0) | (outputs[0] != 0 ? 2 : 0) | (this.ticksLeft > 0 ? 4 : 0) | (outputs[0] != 0 || inputs[0] != 0 ? 8 : 0);
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74774_a("ticksLeft", (byte)this.ticksLeft);
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.ticksLeft = tag.func_74771_c("ticksLeft");
        }
    }

    public static class Sequencer
    extends GateLogic
    implements WithRightClickAction,
    WithPointer,
    GateLogicTimed,
    Flippable {
        public int intervalTicks = 20;
        public int ticksLeft;
        public int state;

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                this.ticksLeft = this.intervalTicks;
                this.state = this.state + 1 & 3;
            }
            outputs[0] = this.state == 0 ? 255 : 0;
            outputs[3] = this.state == 1 ? 255 : 0;
            outputs[1] = this.state == 2 ? 255 : 0;
            outputs[2] = this.state == 3 ? 255 : 0;
        }

        @Override
        public void onRightClick(EntityPlayer ply, TileGate tile) {
            ply.openGui((Object)ProjectRed.instance, GuiIDs.ID_Timer, tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return this.state;
        }

        @Override
        public int getPointerPosition() {
            return 89 - (int)((float)this.ticksLeft * 90.0f / (float)this.intervalTicks) + this.state * 90;
        }

        @Override
        public float getPointerSpeed() {
            return 90.0f / (float)this.intervalTicks;
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.intervalTicks = tag.func_74762_e("intv");
            this.ticksLeft = tag.func_74762_e("left");
            this.state = tag.func_74771_c("state");
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74768_a("intv", this.intervalTicks);
            tag.func_74768_a("left", this.ticksLeft);
            tag.func_74774_a("state", (byte)this.state);
        }

        @Override
        public int getInterval() {
            return this.intervalTicks;
        }

        @Override
        public void setInterval(int i) {
            this.intervalTicks = i;
            this.ticksLeft = i > 0 ? (this.ticksLeft %= this.intervalTicks) : 0;
        }

        @Override
        public boolean connectsToDirection(int side) {
            return side == 0 || side == 1;
        }
    }

    public static class Counter
    extends GateLogic
    implements WithRightClickAction,
    WithPointer,
    Flippable {
        int value = 0;
        int max = 10;
        int incr = 1;
        int decr = 1;
        private boolean wasFront;
        private boolean wasBack;

        @Override
        public int getPointerPosition() {
            if (this.max == 0) {
                return 0;
            }
            return this.value * 120 / this.max - 60;
        }

        @Override
        public float getPointerSpeed() {
            return 0.0f;
        }

        @Override
        public void onRightClick(EntityPlayer ply, TileGate tile) {
            ply.openGui((Object)ProjectRed.instance, GuiIDs.ID_Counter, tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[0] != 0 ? 1 : 0) | (inputs[1] != 0 ? 2 : 0) | (outputs[2] != 0 ? 4 : 0) | (outputs[3] != 0 ? 8 : 0) | (inputs[2] != 0 || outputs[2] != 0 ? 16 : 0) | (inputs[3] != 0 || outputs[3] != 0 ? 32 : 0) | this.getPointerPosition() << 20;
        }

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (inputs[0] != 0 && !this.wasFront) {
                this.value = Math.max(0, this.value - this.decr);
            }
            if (inputs[1] != 0 && !this.wasBack) {
                this.value = Math.min(this.max, this.value + this.incr);
            }
            outputs[2] = this.value == 0 ? 255 : 0;
            outputs[3] = this.value == this.max ? 255 : 0;
            this.wasFront = inputs[0] != 0;
            this.wasBack = inputs[1] != 0;
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.value = tag.func_74762_e("cur");
            this.max = tag.func_74762_e("max");
            this.incr = tag.func_74762_e("+");
            this.decr = tag.func_74762_e("-");
            this.wasFront = tag.func_74767_n("front");
            this.wasBack = tag.func_74767_n("back");
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74768_a("cur", this.value);
            tag.func_74768_a("max", this.max);
            tag.func_74768_a("+", this.incr);
            tag.func_74768_a("-", this.decr);
            tag.func_74757_a("front", this.wasFront);
            tag.func_74757_a("back", this.wasBack);
        }
    }

    public static class Timer
    extends GateLogic
    implements WithRightClickAction,
    WithPointer,
    GateLogicTimed {
        public int intervalTicks = 20;
        public int ticksLeft;
        public boolean state;
        public boolean stopped;

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            boolean bl = this.stopped = inputs[1] != 0;
            if (inputs[1] != 0) {
                this.state = true;
                outputs[3] = 0;
                outputs[2] = 0;
                outputs[0] = 0;
                this.ticksLeft = 0;
                return;
            }
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                this.state = !this.state;
                outputs[3] = this.state ? 255 : 0;
                outputs[2] = outputs[3];
                outputs[0] = outputs[3];
                this.ticksLeft = this.state ? 2 : this.intervalTicks - 2;
            }
        }

        @Override
        public void onRightClick(EntityPlayer ply, TileGate tile) {
            ply.openGui((Object)ProjectRed.instance, GuiIDs.ID_Timer, tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (outputs[0] != 0 ? 1 : 0) | (outputs[0] != 0 || inputs[0] != 0 ? 32 : 0) | (outputs[2] != 0 || inputs[2] != 0 ? 2 : 0) | (outputs[3] != 0 || inputs[3] != 0 ? 8 : 0) | (inputs[1] != 0 ? 4 : 0) | (this.stopped ? 16 : 0);
        }

        @Override
        public int getPointerPosition() {
            return this.state || this.stopped ? 0 : 359 - (int)((float)this.ticksLeft * 360.0f / (float)(this.intervalTicks - 2));
        }

        @Override
        public float getPointerSpeed() {
            return this.state || this.stopped ? 0.0f : 360.0f / (float)(this.intervalTicks - 2);
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.intervalTicks = tag.func_74762_e("intv");
            this.ticksLeft = tag.func_74762_e("left");
            this.state = tag.func_74767_n("state");
            this.stopped = tag.func_74767_n("stopped");
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74768_a("intv", this.intervalTicks);
            tag.func_74768_a("left", this.ticksLeft);
            tag.func_74757_a("state", this.state);
            tag.func_74757_a("stopped", this.stopped);
        }

        @Override
        public int getInterval() {
            return this.intervalTicks;
        }

        @Override
        public void setInterval(int i) {
            this.intervalTicks = i;
            this.ticksLeft = i > 0 ? (this.ticksLeft %= this.intervalTicks) : 0;
        }
    }

    public static class Repeater
    extends GateLogic {
        private static int[] DELAYS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        private boolean state;
        private int timer;

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (inputs[1] != 0 && this.state) {
                this.timer = 0;
                return;
            }
            if (inputs[1] != 0 != this.state && this.timer == 0) {
                this.timer = DELAYS[gateSettings] * 2 - 2;
                if (this.timer == 0) {
                    this.state = !this.state;
                    int n = outputs[0] = this.state ? 255 : 0;
                }
            }
            if (this.timer > 0) {
                --this.timer;
                if (this.timer == 0) {
                    this.state = !this.state;
                    outputs[0] = this.state ? 255 : 0;
                }
            }
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.timer = tag.func_74762_e("timer");
            this.state = tag.func_74767_n("state");
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74768_a("timer", this.timer);
            tag.func_74757_a("state", this.state);
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return gateSettings | (outputs[0] != 0 ? 32768 : 0) | (inputs[1] != 0 ? 64 : 0);
        }

        @Override
        public int configure(int gateSettings) {
            return (gateSettings + 1) % DELAYS.length;
        }

        @Override
        public boolean connectsToDirection(int side) {
            return side == 0 || side == 1;
        }
    }

    public static class Multiplexer
    extends GateLogic
    implements Stateless,
    Flippable {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            outputs[0] = inputs[1] != 0 ? inputs[2] : inputs[3];
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[1] != 0 ? 1 : 0) | (inputs[2] != 0 ? 2 : 0) | (inputs[3] != 0 ? 4 : 0) | (outputs[0] != 0 ? 8 : 0) | (inputs[0] != 0 || outputs[0] != 0 ? 16 : 0);
        }
    }

    public static class Buffer
    extends GateLogic
    implements Stateless {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            outputs[2] = outputs[3] = inputs[1];
            outputs[0] = outputs[3];
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (outputs[0] != 0 ? 1 : 0) | (inputs[1] != 0 ? 2 : 0) | (inputs[2] != 0 || outputs[2] != 0 ? 4 : 0) | (inputs[3] != 0 || outputs[3] != 0 ? 8 : 0) | (outputs[0] != 0 || inputs[0] != 0 ? 16 : 0);
        }
    }

    public static class XNOR
    extends GateLogic
    implements Stateless {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            outputs[0] = !(inputs[2] != 0 ^ inputs[3] != 0) ? 255 : 0;
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[2] != 0 ? 1 : 0) | (inputs[3] != 0 ? 2 : 0) | (outputs[0] != 0 ? 4 : 0) | (outputs[0] != 0 || inputs[0] != 0 ? 8 : 0);
        }

        @Override
        public boolean connectsToDirection(int side) {
            return super.connectsToDirection(side) && side != 1;
        }
    }

    public static class XOR
    extends GateLogic
    implements Stateless {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            outputs[0] = inputs[2] != 0 ^ inputs[3] != 0 ? 255 : 0;
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[2] != 0 ? 1 : 0) | (inputs[3] != 0 ? 2 : 0) | (outputs[0] != 0 ? 4 : 0);
        }

        @Override
        public boolean connectsToDirection(int side) {
            return super.connectsToDirection(side) && side != 1;
        }
    }

    public static class NAND
    extends GateLogic
    implements Stateless {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            boolean left = inputs[2] != 0 || (gateSettings & 1) != 0;
            boolean back = inputs[1] != 0 || (gateSettings & 2) != 0;
            boolean right = inputs[3] != 0 || (gateSettings & 4) != 0;
            outputs[0] = !back || !left || !right ? 255 : 0;
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[0] != 0 || outputs[0] != 0 ? 1 : 0) | (inputs[1] != 0 ? 2 : 0) | (inputs[2] != 0 ? 4 : 0) | (inputs[3] != 0 ? 8 : 0) | gateSettings << 4;
        }

        @Override
        public int configure(int gateSettings) {
            return gateSettings + 1 & 7;
        }
    }

    public static class NOR
    extends GateLogic
    implements Stateless {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            boolean left = inputs[2] != 0 && (gateSettings & 1) == 0;
            boolean back = inputs[1] != 0 && (gateSettings & 2) == 0;
            boolean right = inputs[3] != 0 && (gateSettings & 4) == 0;
            outputs[0] = !left && !back && !right ? 255 : 0;
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[0] != 0 || outputs[0] != 0 ? 1 : 0) | (inputs[1] != 0 ? 2 : 0) | (inputs[2] != 0 ? 4 : 0) | (inputs[3] != 0 ? 8 : 0) | (outputs[0] != 0 ? 16 : 0) | gateSettings << 5;
        }

        @Override
        public int configure(int gateSettings) {
            return gateSettings + 1 & 7;
        }
    }

    public static class ToggleLatch
    extends GateLogic
    implements Flippable,
    WithRightClickAction {
        private boolean wasLeft;
        private boolean wasRight;
        private boolean state;

        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (inputs[2] != 0 && !this.wasLeft) {
                boolean bl = this.state = !this.state;
            }
            if (inputs[3] != 0 && !this.wasRight) {
                this.state = !this.state;
            }
            this.wasLeft = inputs[2] != 0;
            this.wasRight = inputs[3] != 0;
            outputs[0] = !this.state ? 255 : 0;
            outputs[1] = this.state ? 255 : 0;
        }

        @Override
        public void write(NBTTagCompound tag) {
            tag.func_74757_a("wasLeft", this.wasLeft);
            tag.func_74757_a("wasRight", this.wasRight);
            tag.func_74757_a("state", this.state);
        }

        @Override
        public void read(NBTTagCompound tag) {
            this.wasLeft = tag.func_74767_n("wasLeft");
            this.wasRight = tag.func_74767_n("wasRight");
            this.state = tag.func_74767_n("state");
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[2] != 0 ? 1 : 0) | (inputs[3] != 0 ? 2 : 0) | (outputs[0] != 0 ? 4 : 0) | (outputs[1] != 0 ? 8 : 0);
        }

        @Override
        public void onRightClick(EntityPlayer ply, TileGate tile) {
            this.state = !this.state;
        }
    }

    public static class RSLatch
    extends GateLogic
    implements Stateless,
    Flippable {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            if (inputs[2] != 0 && inputs[3] != 0) {
                outputs[3] = 0;
                outputs[2] = 0;
            } else if (inputs[2] != 0) {
                outputs[2] = 255;
                outputs[3] = 0;
            } else if (inputs[3] != 0) {
                outputs[3] = 255;
                outputs[2] = 0;
            }
            outputs[0] = inputs[3] == 0 && outputs[3] == 0 ? 255 : 0;
            outputs[1] = inputs[2] == 0 && outputs[2] == 0 ? 255 : 0;
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[2] != 0 || outputs[2] != 0 ? 1 : 0) | (inputs[3] != 0 || outputs[3] != 0 ? 2 : 0) | (outputs[0] != 0 ? 4 : 0) | (outputs[1] != 0 ? 8 : 0);
        }
    }

    public static class NOT
    extends GateLogic
    implements Stateless {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            outputs[2] = outputs[3] = (short)(inputs[1] != 0 ? 0 : 255);
            outputs[0] = outputs[3];
            if ((gateSettings & 1) != 0) {
                outputs[2] = 0;
            }
            if ((gateSettings & 2) != 0) {
                outputs[0] = 0;
            }
            if ((gateSettings & 4) != 0) {
                outputs[3] = 0;
            }
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[0] != 0 || outputs[0] != 0 ? 1 : 0) | (inputs[1] != 0 ? 2 : 0) | (inputs[2] != 0 || outputs[2] != 0 ? 4 : 0) | (inputs[3] != 0 || outputs[3] != 0 ? 8 : 0) | (outputs[0] != 0 || outputs[2] != 0 || outputs[3] != 0 ? 16 : 0) | gateSettings << 5;
        }

        @Override
        public int configure(int gateSettings) {
            return gateSettings + 1 & 7;
        }
    }

    public static class OR
    extends GateLogic
    implements Stateless {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            boolean left = inputs[2] != 0 && (gateSettings & 1) == 0;
            boolean back = inputs[1] != 0 && (gateSettings & 2) == 0;
            boolean right = inputs[3] != 0 && (gateSettings & 4) == 0;
            outputs[0] = (short)(left || back || right ? 255 : 0);
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (inputs[0] != 0 || outputs[0] != 0 ? 1 : 0) | (inputs[1] != 0 ? 2 : 0) | (inputs[2] != 0 || outputs[2] != 0 ? 4 : 0) | (inputs[3] != 0 || outputs[3] != 0 ? 8 : 0) | (outputs[0] != 0 ? 16 : 0) | gateSettings << 5;
        }

        @Override
        public int configure(int gateSettings) {
            return gateSettings + 1 & 7;
        }
    }

    public static class AND
    extends GateLogic
    implements Stateless {
        @Override
        public void update(short[] inputs, short[] outputs, int gateSettings) {
            boolean left = inputs[2] != 0 || (gateSettings & 1) != 0;
            boolean back = inputs[1] != 0 || (gateSettings & 2) != 0;
            boolean right = inputs[3] != 0 || (gateSettings & 4) != 0;
            outputs[0] = (short)(left && back && right ? 255 : 0);
        }

        @Override
        public int getRenderState(short[] inputs, short[] outputs, int gateSettings) {
            return (outputs[0] != 0 ? 1 : 0) | (inputs[1] != 0 ? 2 : 0) | (inputs[2] != 0 || outputs[2] != 0 ? 4 : 0) | (inputs[3] != 0 || outputs[3] != 0 ? 8 : 0) | (inputs[0] != 0 || outputs[0] != 0 ? 128 : 0) | gateSettings << 4;
        }

        @Override
        public int configure(int gateSettings) {
            return gateSettings + 1 & 7;
        }
    }

    public static interface WorldStateBound {
        public void setWorldInfo(World var1, int var2, int var3, int var4);

        public boolean needsWorldInfo();
    }

    public static interface WithPointer {
        public int getPointerPosition();

        public float getPointerSpeed();
    }

    public static interface WithRightClickAction {
        public void onRightClick(EntityPlayer var1, TileGate var2);
    }

    public static interface Flippable {
    }

    public static interface Stateless {
    }

    public static interface WithBundledConnections {
        public boolean isBundledConnection(int var1);
    }
}

