/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.wiring.gates;

import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.multipart.wiring.gates.GateLogic;
import mrtjp.projectred.multipart.wiring.gates.GateRenderBridge;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum EnumGate {
    AND("AND gate", GateLogic.AND.class, GateRenderBridge.AND.class),
    OR("OR gate", GateLogic.OR.class, GateRenderBridge.OR.class),
    NOT("NOT gate", GateLogic.NOT.class, GateRenderBridge.NOT.class),
    RSLATCH("RS-Latch", GateLogic.RSLatch.class, GateRenderBridge.RSLatch.class),
    TOGGLE("T-FlipFlop", GateLogic.ToggleLatch.class, GateRenderBridge.ToggleLatch.class),
    NOR("NOR gate", GateLogic.NOR.class, GateRenderBridge.NOR.class),
    NAND("NAND gate", GateLogic.NAND.class, GateRenderBridge.NAND.class),
    XOR("XOR gate", GateLogic.XOR.class, GateRenderBridge.XOR.class),
    XNOR("XNOR gate", GateLogic.XNOR.class, GateRenderBridge.XNOR.class),
    Buffer("Buffer gate", GateLogic.Buffer.class, GateRenderBridge.Buffer.class),
    Multiplexer("Multiplexer", GateLogic.Multiplexer.class, GateRenderBridge.Multiplexer.class),
    Repeater("Repeater", GateLogic.Repeater.class, GateRenderBridge.Repeater.class),
    Timer("Timer", GateLogic.Timer.class, GateRenderBridge.Timer.class),
    Counter("Counter", GateLogic.Counter.class, GateRenderBridge.Counter.class),
    Sequencer("Sequencer", GateLogic.Sequencer.class, GateRenderBridge.Sequencer.class),
    PulseFormer("Pulse Former", GateLogic.PulseFormer.class, GateRenderBridge.PulseFormer.class),
    Randomizer("Randomizer", GateLogic.Randomizer.class, GateRenderBridge.Randomizer.class),
    StateCell("State Cell", GateLogic.StateCell.class, GateRenderBridge.StateCell.class),
    Synchronizer("Synchronizer", GateLogic.Synchronizer.class, GateRenderBridge.Synchronizer.class),
    DLatch("D-Latch", GateLogic.DLatch.class, GateRenderBridge.DLatch.class),
    DFlop("D-FlipFlop", GateLogic.DFlop.class, GateRenderBridge.DFlop.class),
    BundledLatch("Bundled Latch", GateLogic.BundledLatch.class, GateRenderBridge.BundledLatch.class),
    BundledRelay("Bundled Relay", GateLogic.BundledRelay.class, GateRenderBridge.BundledRelay.class),
    BundledMultiplexer("Bundled Multiplexer", GateLogic.BundledMultiplexer.class, GateRenderBridge.BundledMultiplexer.class),
    LightSensor("Light Sensor", GateLogic.LightSensor.class, GateRenderBridge.LightSensor.class),
    RainSensor("Rain Sensor", GateLogic.RainSensor.class, GateRenderBridge.RainSensor.class);

    private Class logicClass;
    private Class renderClass;
    private GateLogic logicInst;
    private GateRenderBridge renderInst;
    public final String name;
    public int meta = this.ordinal();
    public static final String oreDictDefinition = "projredGate";
    public static final EnumGate[] VALUES;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumGate(Class name) {
        void renderClass;
        void logicClass;
        this.name = name;
        this.logicClass = logicClass;
        this.renderClass = renderClass;
        if (GateLogic.Stateless.class.isAssignableFrom((Class<?>)logicClass)) {
            this.logicInst = this.createLogic();
        }
    }

    public GateLogic createLogic() {
        if (this.logicInst != null) {
            return this.logicInst;
        }
        try {
            return (GateLogic)this.logicClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GateRenderBridge getRenderBridge() {
        if (this.renderInst != null) {
            return this.renderInst;
        }
        try {
            this.renderInst = (GateRenderBridge)this.renderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.renderInst;
    }

    public Class getLogicClass() {
        return this.logicClass;
    }

    public static EnumGate get(int ordinal) {
        if (ordinal > VALUES.length - 1) {
            return null;
        }
        return VALUES[ordinal];
    }

    public ItemStack getItemStack() {
        return new ItemStack((Block)ProjectRed.blockGate, 1, this.meta);
    }

    public static void initOreDictDefinitions() {
        for (EnumGate g : EnumGate.values()) {
            OreDictionary.registerOre((String)oreDictDefinition, (ItemStack)g.getItemStack());
        }
    }

    static {
        VALUES = EnumGate.values();
    }
}

