/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.microblocks;

import java.io.DataOutput;
import mrtjp.projectred.multipart.microblocks.EnumAxisPosition;
import mrtjp.projectred.multipart.microblocks.EnumPosition;
import mrtjp.projectred.multipart.microblocks.MicroblockLibrary;
import mrtjp.projectred.multipart.microblocks.PartType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class Part {
    public final PartType type;
    public final EnumPosition pos;

    public Part(PartType type, EnumPosition pos) {
        this.type = type;
        this.pos = pos;
    }

    private static double getMinFromAxisPosition(EnumAxisPosition ap, double size) {
        switch (ap) {
            case Span: 
            case Negative: {
                return 0.0;
            }
            case Positive: {
                return 1.0 - size;
            }
            case Centre: {
                return (1.0 - size) / 2.0;
            }
        }
        throw new IllegalArgumentException("ap");
    }

    private static double getMaxFromAxisPosition(EnumAxisPosition ap, double size) {
        switch (ap) {
            case Span: 
            case Positive: {
                return 1.0;
            }
            case Negative: {
                return size;
            }
            case Centre: {
                return (1.0 + size) / 2.0;
            }
        }
        throw new IllegalArgumentException("ap");
    }

    public AxisAlignedBB getBoundingBoxFromPool() {
        return Part.getBoundingBoxFromPool(this.pos, this.type.getSize());
    }

    public static AxisAlignedBB getBoundingBoxFromPool(EnumPosition pos, double size) {
        double minx = Part.getMinFromAxisPosition(pos.x, size);
        double miny = Part.getMinFromAxisPosition(pos.y, size);
        double minz = Part.getMinFromAxisPosition(pos.z, size);
        double maxx = Part.getMaxFromAxisPosition(pos.x, size);
        double maxy = Part.getMaxFromAxisPosition(pos.y, size);
        double maxz = Part.getMaxFromAxisPosition(pos.z, size);
        return AxisAlignedBB.func_72332_a().func_72299_a(minx, miny, minz, maxx, maxy, maxz);
    }

    public NBTBase writeToNBT() {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74768_a("type", this.type.getID());
        c.func_74774_a("pos", (byte)this.pos.ordinal());
        return c;
    }

    public static Part readFromNBT(NBTBase tag) {
        NBTTagCompound c = (NBTTagCompound)tag;
        PartType type = MicroblockLibrary.getMicroblockSystem().getPartTypeByID(c.func_74762_e("type"));
        if (type == null) {
            return null;
        }
        EnumPosition pos = EnumPosition.values()[c.func_74771_c("pos")];
        Part p = type.createPart(pos, c);
        return p;
    }

    public void writeExtraData(DataOutput data) {
    }
}

