/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.microblocks;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.Map;
import mrtjp.projectred.multipart.BlockMultipartBase;
import mrtjp.projectred.multipart.ICoverSystem;
import mrtjp.projectred.multipart.IMultipartTile;
import mrtjp.projectred.multipart.PartCoordinates;
import mrtjp.projectred.renderstuffs.RenderIDs;
import mrtjp.projectred.utils.BasicUtils;
import mrtjp.projectred.utils.Coords;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;

public class MultiblockRenderer
implements ISimpleBlockRenderingHandler {
    public static final MultiblockRenderer instance = new MultiblockRenderer();

    public void renderInventoryBlock(Block block, int meta, int model, RenderBlocks render) {
        if (block instanceof BlockMultipartBase) {
            ((BlockMultipartBase)block).renderInvBlock(render, meta);
        } else {
            BlockMultipartBase.renderInvBlockStatic(render, block, meta);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks render) {
        boolean damageLayer;
        IMultipartTile te = (IMultipartTile)BasicUtils.getTileEntity(world, new Coords(x, y, z), IMultipartTile.class);
        if (te == null) {
            BlockMultipartBase.renderBlockStatic(render, block, x, y, z);
            return true;
        }
        ICoverSystem ci = te.getCoverSystem();
        boolean bl = damageLayer = render.field_78664_d != null;
        if (!damageLayer) {
            te.render(render);
            if (ci != null) {
                ci.render(render);
            }
        } else {
            for (Map.Entry breaking : BlockMultipartBase.getBreakingParts()) {
                if (!((EntityPlayer)breaking.getKey()).field_70170_p.field_72995_K) continue;
                PartCoordinates pc = (PartCoordinates)breaking.getValue();
                if (pc.x != x || pc.y != y || pc.z != z) continue;
                if (!pc.isCoverSystemPart) {
                    te.renderPart(render, pc.part);
                    continue;
                }
                if (ci == null) continue;
                ci.renderPart(render, pc.part);
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return RenderIDs.renderIdMicroblock;
    }
}

