/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.microblocks;

import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.multipart.microblocks.EnumAxisPosition;
import mrtjp.projectred.multipart.microblocks.EnumPartClass;
import mrtjp.projectred.multipart.microblocks.EnumPosition;
import mrtjp.projectred.multipart.microblocks.IMicroblockCoverSystem;
import mrtjp.projectred.multipart.microblocks.IMicroblockSupporterTile;
import mrtjp.projectred.multipart.microblocks.ItemBlockMicroblock;
import mrtjp.projectred.multipart.microblocks.MicroblockCoverSystem;
import mrtjp.projectred.multipart.microblocks.MicroblockLibrary;
import mrtjp.projectred.multipart.microblocks.PartType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

public class MicroblockPlacementHighlightHandler {
    static final double SELECTOR_OUTER_SIZE = 0.25;
    static final double SELECTOR_STRIP_OUTER_SIZE = 0.4;

    @ForgeSubscribe(receiveCanceled=true)
    public void onHighlight(DrawBlockHighlightEvent evt) {
        PartType type;
        MovingObjectPosition pos = evt.target;
        int pass = evt.subID;
        ItemStack holding = evt.currentItem;
        EntityPlayer ply = evt.player;
        float partialTick = evt.partialTicks;
        if (pos.field_72313_a != EnumMovingObjectType.TILE) {
            return;
        }
        if (pass != 0) {
            return;
        }
        EnumPosition hitPos = null;
        AxisAlignedBB hitBB = null;
        TileEntity te = ply.field_70170_p.func_72796_p(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        IMicroblockCoverSystem ci = null;
        if (te instanceof IMicroblockSupporterTile) {
            IMicroblockSupporterTile ict = (IMicroblockSupporterTile)te;
            ci = ict.getCoverSystem();
            if (pos.subHit >= 0) {
                hitPos = ict.getPartPosition(pos.subHit);
                hitBB = ict.getPartAABBFromPool(pos.subHit);
            } else if (ci != null) {
                hitPos = ci.getPartPosition(-1 - pos.subHit);
                hitBB = ci.getPartAABBFromPool(-1 - pos.subHit);
            }
        }
        if (holding != null && holding.field_77993_c == ProjectRed.blockMicrocontainer.field_71990_ca && (type = (PartType)MicroblockLibrary.parts.get(ItemBlockMicroblock.getPartTypeID(holding))) != null) {
            World world = ply.field_70170_p;
            boolean ok = false;
            int x = pos.field_72311_b;
            int y = pos.field_72312_c;
            int z = pos.field_72309_d;
            int dx = 0;
            int dy = 0;
            int dz = 0;
            switch (pos.field_72310_e) {
                case 4: {
                    if (hitPos != null && !hitPos.x.touchesNegative()) break;
                    dx = -1;
                    break;
                }
                case 5: {
                    if (hitPos != null && !hitPos.x.touchesPositive()) break;
                    dx = 1;
                    break;
                }
                case 0: {
                    if (hitPos != null && !hitPos.y.touchesNegative()) break;
                    dy = -1;
                    break;
                }
                case 1: {
                    if (hitPos != null && !hitPos.y.touchesPositive()) break;
                    dy = 1;
                    break;
                }
                case 2: {
                    if (hitPos != null && !hitPos.z.touchesNegative()) break;
                    dz = -1;
                    break;
                }
                case 3: {
                    if (hitPos != null && !hitPos.z.touchesPositive()) break;
                    dz = 1;
                }
            }
            ok = MicroblockPlacementHighlightHandler.canPlaceInBlock(world, x + dx, y + dy, z + dz);
            TileEntity tePlacingIn = world.func_72796_p(x + dx, y + dy, z + dz);
            if (ok) {
                EnumPartClass clazz;
                GL11.glDisable((int)3553);
                GL11.glDepthMask((boolean)false);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                GL11.glPushMatrix();
                GL11.glTranslated((double)((double)pos.field_72311_b - ply.field_70142_S - (ply.field_70165_t - ply.field_70142_S) * (double)partialTick - 0.5), (double)((double)pos.field_72312_c - ply.field_70137_T - (ply.field_70163_u - ply.field_70137_T) * (double)partialTick - 0.5), (double)((double)pos.field_72309_d - ply.field_70136_U - (ply.field_70161_v - ply.field_70136_U) * (double)partialTick - 0.5));
                GL11.glScalef((float)1.002f, (float)1.002f, (float)1.002f);
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                EnumPosition placement = null;
                double inset = 0.0;
                if (hitPos != null) {
                    switch (pos.field_72310_e) {
                        case 4: {
                            inset = hitBB.field_72340_a;
                            break;
                        }
                        case 5: {
                            inset = 1.0 - hitBB.field_72336_d;
                            break;
                        }
                        case 0: {
                            inset = hitBB.field_72338_b;
                            break;
                        }
                        case 1: {
                            inset = 1.0 - hitBB.field_72337_e;
                            break;
                        }
                        case 2: {
                            inset = hitBB.field_72339_c;
                            break;
                        }
                        case 3: {
                            inset = 1.0 - hitBB.field_72334_f;
                        }
                    }
                    inset -= 0.01;
                }
                if ((clazz = type.getPartClass()) == EnumPartClass.Panel || clazz == EnumPartClass.HollowPanel) {
                    MicroblockPlacementHighlightHandler.renderEdgeSelector(pos, ply, 0.25, inset);
                    placement = MicroblockPlacementHighlightHandler.getPanelPlacement(ply, pos, dx != 0 || dy != 0 || dz != 0 ? null : hitPos);
                } else if (clazz == EnumPartClass.Strip) {
                    MicroblockPlacementHighlightHandler.renderEdgeSelector(pos, ply, 0.4, inset);
                    placement = MicroblockPlacementHighlightHandler.getStripPlacement(ply, pos, dx != 0 || dy != 0 || dz != 0 ? null : hitPos);
                } else if (clazz == EnumPartClass.Corner) {
                    MicroblockPlacementHighlightHandler.renderCornerSelector(pos, ply, inset);
                    placement = MicroblockPlacementHighlightHandler.getCornerPlacement(ply, pos, dx != 0 || dy != 0 || dz != 0 ? null : hitPos);
                }
                GL11.glTranslatef((float)dx, (float)dy, (float)dz);
                GL11.glEnable((int)3553);
                if (placement != null && (tePlacingIn == null || tePlacingIn instanceof IMicroblockSupporterTile && ((MicroblockCoverSystem)((IMicroblockSupporterTile)tePlacingIn).getCoverSystem()).canPlace(type, placement))) {
                    type.renderPreview(evt.context, placement, holding);
                }
                GL11.glPopMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDepthMask((boolean)true);
            }
        }
    }

    static EnumPosition getPanelPlacement(EntityPlayer ply, MovingObjectPosition pos, EnumPosition placingOn) {
        Vec3 hv = pos.field_72307_f.func_72441_c((double)(-pos.field_72311_b), (double)(-pos.field_72312_c), (double)(-pos.field_72309_d));
        double x = hv.field_72450_a - 0.5;
        double y = hv.field_72448_b - 0.5;
        double z = hv.field_72449_c - 0.5;
        double BORDER = 0.25;
        Enum result = null;
        switch (pos.field_72310_e) {
            case 4: 
            case 5: {
                if (y >= -0.25 && y <= 0.25 && z >= -0.25 && z <= 0.25) {
                    result = pos.field_72310_e == 4 ? EnumPosition.FacePX : EnumPosition.FaceNX;
                    break;
                }
                if (Math.abs(y) < Math.abs(z)) {
                    result = z < 0.0 ? EnumPosition.FaceNZ : EnumPosition.FacePZ;
                    break;
                }
                result = y < 0.0 ? EnumPosition.FaceNY : EnumPosition.FacePY;
                break;
            }
            case 0: 
            case 1: {
                if (x >= -0.25 && x <= 0.25 && z >= -0.25 && z <= 0.25) {
                    result = pos.field_72310_e == 0 ? EnumPosition.FacePY : EnumPosition.FaceNY;
                    break;
                }
                if (Math.abs(z) < Math.abs(x)) {
                    result = x < 0.0 ? EnumPosition.FaceNX : EnumPosition.FacePX;
                    break;
                }
                result = z < 0.0 ? EnumPosition.FaceNZ : EnumPosition.FacePZ;
                break;
            }
            case 2: 
            case 3: {
                if (x >= -0.25 && x <= 0.25 && y >= -0.25 && y <= 0.25) {
                    result = pos.field_72310_e == 2 ? EnumPosition.FacePZ : EnumPosition.FaceNZ;
                    break;
                }
                if (Math.abs(x) < Math.abs(y)) {
                    result = y < 0.0 ? EnumPosition.FaceNY : EnumPosition.FacePY;
                    break;
                }
                Enum enum_ = result = x < 0.0 ? EnumPosition.FaceNX : EnumPosition.FacePX;
            }
        }
        if (placingOn != null) {
            switch (1.$SwitchMap$mrtjp$projectred$multipart$microblocks$EnumPosition[result.ordinal()]) {
                case 1: {
                    if (pos.field_72310_e != 5 || placingOn.x != EnumAxisPosition.Negative && placingOn.x != EnumAxisPosition.Centre) break;
                    result = EnumPosition.FacePX;
                    break;
                }
                case 2: {
                    if (pos.field_72310_e != 1 || placingOn.y != EnumAxisPosition.Negative && placingOn.y != EnumAxisPosition.Centre) break;
                    result = EnumPosition.FacePY;
                    break;
                }
                case 3: {
                    if (pos.field_72310_e != 3 || placingOn.z != EnumAxisPosition.Negative && placingOn.z != EnumAxisPosition.Centre) break;
                    result = EnumPosition.FacePZ;
                    break;
                }
                case 4: {
                    if (pos.field_72310_e != 4 || placingOn.x != EnumAxisPosition.Positive && placingOn.x != EnumAxisPosition.Centre) break;
                    result = EnumPosition.FaceNX;
                    break;
                }
                case 5: {
                    if (pos.field_72310_e != 0 || placingOn.y != EnumAxisPosition.Positive && placingOn.y != EnumAxisPosition.Centre) break;
                    result = EnumPosition.FaceNY;
                    break;
                }
                case 6: {
                    if (pos.field_72310_e != 2 || placingOn.z != EnumAxisPosition.Positive && placingOn.z != EnumAxisPosition.Centre) break;
                    result = EnumPosition.FaceNZ;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"can't get here");
                }
            }
        }
        return result;
    }

    static EnumPosition getStripPlacement(EntityPlayer player, MovingObjectPosition pos, EnumPosition placingOn) {
        Vec3 hv = pos.field_72307_f.func_72441_c((double)(-pos.field_72311_b), (double)(-pos.field_72312_c), (double)(-pos.field_72309_d));
        double x = hv.field_72450_a - 0.5;
        double y = hv.field_72448_b - 0.5;
        double z = hv.field_72449_c - 0.5;
        double BORDER = 0.09999999999999998;
        EnumPosition result = EnumPosition.EdgePXPY;
        int sideHit = pos.field_72310_e;
        if (placingOn != null) {
            sideHit ^= 1;
        }
        if (player.func_70093_af()) {
            sideHit = ForgeDirection.getOrientation((int)sideHit).getOpposite().ordinal();
        }
        switch (sideHit) {
            case 5: {
                if (y >= -0.09999999999999998 && y <= 0.09999999999999998 && z >= -0.09999999999999998 && z <= 0.09999999999999998) {
                    result = EnumPosition.PostX;
                    break;
                }
                if (Math.abs(y) < Math.abs(z)) {
                    result = z < 0.0 ? EnumPosition.EdgeNXNZ : EnumPosition.EdgeNXPZ;
                    break;
                }
                result = y < 0.0 ? EnumPosition.EdgeNXNY : EnumPosition.EdgeNXPY;
                break;
            }
            case 4: {
                if (y >= -0.09999999999999998 && y <= 0.09999999999999998 && z >= -0.09999999999999998 && z <= 0.09999999999999998) {
                    result = EnumPosition.PostX;
                    break;
                }
                if (Math.abs(y) < Math.abs(z)) {
                    result = z < 0.0 ? EnumPosition.EdgePXNZ : EnumPosition.EdgePXPZ;
                    break;
                }
                result = y < 0.0 ? EnumPosition.EdgePXNY : EnumPosition.EdgePXPY;
                break;
            }
            case 1: {
                if (x >= -0.09999999999999998 && x <= 0.09999999999999998 && z >= -0.09999999999999998 && z <= 0.09999999999999998) {
                    result = EnumPosition.PostY;
                    break;
                }
                if (Math.abs(x) < Math.abs(z)) {
                    result = z < 0.0 ? EnumPosition.EdgeNYNZ : EnumPosition.EdgeNYPZ;
                    break;
                }
                result = x < 0.0 ? EnumPosition.EdgeNXNY : EnumPosition.EdgePXNY;
                break;
            }
            case 0: {
                if (x >= -0.09999999999999998 && x <= 0.09999999999999998 && z >= -0.09999999999999998 && z <= 0.09999999999999998) {
                    result = EnumPosition.PostY;
                    break;
                }
                if (Math.abs(x) < Math.abs(z)) {
                    result = z < 0.0 ? EnumPosition.EdgePYNZ : EnumPosition.EdgePYPZ;
                    break;
                }
                result = x < 0.0 ? EnumPosition.EdgeNXPY : EnumPosition.EdgePXPY;
                break;
            }
            case 3: {
                if (x >= -0.09999999999999998 && x <= 0.09999999999999998 && y >= -0.09999999999999998 && y <= 0.09999999999999998) {
                    result = EnumPosition.PostZ;
                    break;
                }
                if (Math.abs(x) < Math.abs(y)) {
                    result = y < 0.0 ? EnumPosition.EdgeNYNZ : EnumPosition.EdgePYNZ;
                    break;
                }
                result = x < 0.0 ? EnumPosition.EdgeNXNZ : EnumPosition.EdgePXNZ;
                break;
            }
            case 2: {
                result = x >= -0.09999999999999998 && x <= 0.09999999999999998 && y >= -0.09999999999999998 && y <= 0.09999999999999998 ? EnumPosition.PostZ : (Math.abs(x) < Math.abs(y) ? (y < 0.0 ? EnumPosition.EdgeNYPZ : EnumPosition.EdgePYPZ) : (x < 0.0 ? EnumPosition.EdgeNXPZ : EnumPosition.EdgePXPZ));
            }
        }
        return result;
    }

    static EnumPosition getCornerPlacement(EntityPlayer ply, MovingObjectPosition pos, EnumPosition placingOn) {
        Vec3 hv = pos.field_72307_f.func_72441_c((double)(-pos.field_72311_b), (double)(-pos.field_72312_c), (double)(-pos.field_72309_d));
        double x = hv.field_72450_a - 0.5;
        double y = hv.field_72448_b - 0.5;
        double z = hv.field_72449_c - 0.5;
        EnumPosition result = EnumPosition.CornerPXPYPZ;
        switch (pos.field_72310_e) {
            case 4: {
                result = EnumPosition.getCornerPosition(placingOn == null || placingOn.x != EnumAxisPosition.Positive ? 1 : -1, y < 0.0 ? -1 : 1, z < 0.0 ? -1 : 1);
                break;
            }
            case 5: {
                result = EnumPosition.getCornerPosition(placingOn == null || placingOn.x != EnumAxisPosition.Negative ? -1 : 1, y < 0.0 ? -1 : 1, z < 0.0 ? -1 : 1);
                break;
            }
            case 0: {
                result = EnumPosition.getCornerPosition(x < 0.0 ? -1 : 1, placingOn == null || placingOn.y != EnumAxisPosition.Positive ? 1 : -1, z < 0.0 ? -1 : 1);
                break;
            }
            case 1: {
                result = EnumPosition.getCornerPosition(x < 0.0 ? -1 : 1, placingOn == null || placingOn.y != EnumAxisPosition.Negative ? -1 : 1, z < 0.0 ? -1 : 1);
                break;
            }
            case 2: {
                result = EnumPosition.getCornerPosition(x < 0.0 ? -1 : 1, y < 0.0 ? -1 : 1, placingOn == null || placingOn.z != EnumAxisPosition.Positive ? 1 : -1);
                break;
            }
            case 3: {
                result = EnumPosition.getCornerPosition(x < 0.0 ? -1 : 1, y < 0.0 ? -1 : 1, placingOn == null || placingOn.z != EnumAxisPosition.Negative ? -1 : 1);
            }
        }
        return result;
    }

    private static void renderEdgeSelector(MovingObjectPosition pos, EntityPlayer ply, double outer_size, double inset) {
        Tessellator t = Tessellator.field_78398_a;
        GL11.glLineWidth((float)4.0f);
        t.func_78371_b(1);
        switch (pos.field_72310_e) {
            case 4: 
            case 5: {
                double x = pos.field_72310_e == 4 ? inset : 1.0 - inset;
                t.func_78377_a(x, 0.0, 0.0);
                t.func_78377_a(x, 0.0, 1.0);
                t.func_78377_a(x, 0.0, 1.0);
                t.func_78377_a(x, 1.0, 1.0);
                t.func_78377_a(x, 1.0, 1.0);
                t.func_78377_a(x, 1.0, 0.0);
                t.func_78377_a(x, 1.0, 0.0);
                t.func_78377_a(x, 0.0, 0.0);
                t.func_78377_a(x, outer_size, outer_size);
                t.func_78377_a(x, outer_size, 1.0 - outer_size);
                t.func_78377_a(x, outer_size, 1.0 - outer_size);
                t.func_78377_a(x, 1.0 - outer_size, 1.0 - outer_size);
                t.func_78377_a(x, 1.0 - outer_size, 1.0 - outer_size);
                t.func_78377_a(x, 1.0 - outer_size, outer_size);
                t.func_78377_a(x, 1.0 - outer_size, outer_size);
                t.func_78377_a(x, outer_size, outer_size);
                t.func_78377_a(x, 0.0, 0.0);
                t.func_78377_a(x, outer_size, outer_size);
                t.func_78377_a(x, 1.0, 0.0);
                t.func_78377_a(x, 1.0 - outer_size, outer_size);
                t.func_78377_a(x, 1.0, 1.0);
                t.func_78377_a(x, 1.0 - outer_size, 1.0 - outer_size);
                t.func_78377_a(x, 0.0, 1.0);
                t.func_78377_a(x, outer_size, 1.0 - outer_size);
                break;
            }
            case 0: 
            case 1: {
                double y = pos.field_72310_e == 0 ? inset : 1.0 - inset;
                t.func_78377_a(0.0, y, 0.0);
                t.func_78377_a(0.0, y, 1.0);
                t.func_78377_a(0.0, y, 1.0);
                t.func_78377_a(1.0, y, 1.0);
                t.func_78377_a(1.0, y, 1.0);
                t.func_78377_a(1.0, y, 0.0);
                t.func_78377_a(1.0, y, 0.0);
                t.func_78377_a(0.0, y, 0.0);
                t.func_78377_a(outer_size, y, outer_size);
                t.func_78377_a(outer_size, y, 1.0 - outer_size);
                t.func_78377_a(outer_size, y, 1.0 - outer_size);
                t.func_78377_a(1.0 - outer_size, y, 1.0 - outer_size);
                t.func_78377_a(1.0 - outer_size, y, 1.0 - outer_size);
                t.func_78377_a(1.0 - outer_size, y, outer_size);
                t.func_78377_a(1.0 - outer_size, y, outer_size);
                t.func_78377_a(outer_size, y, outer_size);
                t.func_78377_a(0.0, y, 0.0);
                t.func_78377_a(outer_size, y, outer_size);
                t.func_78377_a(1.0, y, 0.0);
                t.func_78377_a(1.0 - outer_size, y, outer_size);
                t.func_78377_a(1.0, y, 1.0);
                t.func_78377_a(1.0 - outer_size, y, 1.0 - outer_size);
                t.func_78377_a(0.0, y, 1.0);
                t.func_78377_a(outer_size, y, 1.0 - outer_size);
                break;
            }
            case 2: 
            case 3: {
                double z = pos.field_72310_e == 2 ? inset : 1.0 - inset;
                t.func_78377_a(0.0, 0.0, z);
                t.func_78377_a(0.0, 1.0, z);
                t.func_78377_a(0.0, 1.0, z);
                t.func_78377_a(1.0, 1.0, z);
                t.func_78377_a(1.0, 1.0, z);
                t.func_78377_a(1.0, 0.0, z);
                t.func_78377_a(1.0, 0.0, z);
                t.func_78377_a(0.0, 0.0, z);
                t.func_78377_a(outer_size, outer_size, z);
                t.func_78377_a(outer_size, 1.0 - outer_size, z);
                t.func_78377_a(outer_size, 1.0 - outer_size, z);
                t.func_78377_a(1.0 - outer_size, 1.0 - outer_size, z);
                t.func_78377_a(1.0 - outer_size, 1.0 - outer_size, z);
                t.func_78377_a(1.0 - outer_size, outer_size, z);
                t.func_78377_a(1.0 - outer_size, outer_size, z);
                t.func_78377_a(outer_size, outer_size, z);
                t.func_78377_a(0.0, 0.0, z);
                t.func_78377_a(outer_size, outer_size, z);
                t.func_78377_a(1.0, 0.0, z);
                t.func_78377_a(1.0 - outer_size, outer_size, z);
                t.func_78377_a(1.0, 1.0, z);
                t.func_78377_a(1.0 - outer_size, 1.0 - outer_size, z);
                t.func_78377_a(0.0, 1.0, z);
                t.func_78377_a(outer_size, 1.0 - outer_size, z);
            }
        }
        t.func_78381_a();
    }

    private static void renderCornerSelector(MovingObjectPosition pos, EntityPlayer ply, double inset) {
        Tessellator t = Tessellator.field_78398_a;
        GL11.glLineWidth((float)4.0f);
        t.func_78371_b(1);
        switch (pos.field_72310_e) {
            case 4: 
            case 5: {
                double x = pos.field_72310_e == 4 ? inset : 1.0 - inset;
                t.func_78377_a(x, 0.0, 0.0);
                t.func_78377_a(x, 0.0, 1.0);
                t.func_78377_a(x, 0.0, 1.0);
                t.func_78377_a(x, 1.0, 1.0);
                t.func_78377_a(x, 1.0, 1.0);
                t.func_78377_a(x, 1.0, 0.0);
                t.func_78377_a(x, 1.0, 0.0);
                t.func_78377_a(x, 0.0, 0.0);
                t.func_78377_a(x, 0.5, 0.0);
                t.func_78377_a(x, 0.5, 1.0);
                t.func_78377_a(x, 0.0, 0.5);
                t.func_78377_a(x, 1.0, 0.5);
                break;
            }
            case 0: 
            case 1: {
                double y = pos.field_72310_e == 0 ? inset : 1.0 - inset;
                t.func_78377_a(0.0, y, 0.0);
                t.func_78377_a(0.0, y, 1.0);
                t.func_78377_a(0.0, y, 1.0);
                t.func_78377_a(1.0, y, 1.0);
                t.func_78377_a(1.0, y, 1.0);
                t.func_78377_a(1.0, y, 0.0);
                t.func_78377_a(1.0, y, 0.0);
                t.func_78377_a(0.0, y, 0.0);
                t.func_78377_a(0.5, y, 0.0);
                t.func_78377_a(0.5, y, 1.0);
                t.func_78377_a(0.0, y, 0.5);
                t.func_78377_a(1.0, y, 0.5);
                break;
            }
            case 2: 
            case 3: {
                double z = pos.field_72310_e == 2 ? inset : 1.0 - inset;
                t.func_78377_a(0.0, 0.0, z);
                t.func_78377_a(0.0, 1.0, z);
                t.func_78377_a(0.0, 1.0, z);
                t.func_78377_a(1.0, 1.0, z);
                t.func_78377_a(1.0, 1.0, z);
                t.func_78377_a(1.0, 0.0, z);
                t.func_78377_a(1.0, 0.0, z);
                t.func_78377_a(0.0, 0.0, z);
                t.func_78377_a(0.5, 0.0, z);
                t.func_78377_a(0.5, 1.0, z);
                t.func_78377_a(0.0, 0.5, z);
                t.func_78377_a(1.0, 0.5, z);
            }
        }
        t.func_78381_a();
    }

    private static boolean canPlaceInBlock(World world, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        if (blockid == 0) {
            return true;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        return te instanceof IMicroblockSupporterTile;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$mrtjp$projectred$multipart$microblocks$EnumPosition;

        static {
            $SwitchMap$mrtjp$projectred$multipart$microblocks$EnumPosition = new int[EnumPosition.values().length];
            try {
                1.$SwitchMap$mrtjp$projectred$multipart$microblocks$EnumPosition[EnumPosition.FaceNX.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mrtjp$projectred$multipart$microblocks$EnumPosition[EnumPosition.FaceNY.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mrtjp$projectred$multipart$microblocks$EnumPosition[EnumPosition.FaceNZ.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mrtjp$projectred$multipart$microblocks$EnumPosition[EnumPosition.FacePX.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mrtjp$projectred$multipart$microblocks$EnumPosition[EnumPosition.FacePY.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$mrtjp$projectred$multipart$microblocks$EnumPosition[EnumPosition.FacePZ.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

