/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.microblocks;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.crafting.microblocks.RecipeCombineSeveral;
import mrtjp.projectred.crafting.microblocks.RecipeCombineTwo;
import mrtjp.projectred.crafting.microblocks.RecipeHollowCover;
import mrtjp.projectred.crafting.microblocks.RecipeHorizontalCut;
import mrtjp.projectred.crafting.microblocks.RecipeUnHollowCover;
import mrtjp.projectred.crafting.microblocks.RecipeVerticalCut;
import mrtjp.projectred.multipart.microblocks.DefaultPartType;
import mrtjp.projectred.multipart.microblocks.EnumPartClass;
import mrtjp.projectred.multipart.microblocks.IMicroblockCoverSystem;
import mrtjp.projectred.multipart.microblocks.IMicroblockLibrary;
import mrtjp.projectred.multipart.microblocks.IMicroblockSupporterTile;
import mrtjp.projectred.multipart.microblocks.ItemBlockMicroblock;
import mrtjp.projectred.multipart.microblocks.MicroblockCoverSystem;
import mrtjp.projectred.multipart.microblocks.Part;
import mrtjp.projectred.multipart.microblocks.PartType;
import mrtjp.projectred.utils.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringTranslate;
import net.minecraft.world.World;

public class MicroblockLibrary
implements IMicroblockLibrary {
    public static final HashMap parts = new HashMap();
    public static MicroblockLibrary instance;
    public static ArrayList neiPartIDs;
    public static int neiMaxDamage;
    private static PartRegistrationType[] blockparts;

    public void initializeParts() {
        this.registerManualParts(1, Block.field_71981_t);
        this.registerManualParts(2, (Block)Block.field_71980_u);
        this.registerManualParts(3, Block.field_71979_v);
        this.registerManualParts(4, Block.field_71978_w);
        this.registerManualParts(5, Block.field_71988_x, 0);
        this.registerManualParts(6, Block.field_71988_x, 1);
        this.registerManualParts(7, Block.field_71988_x, 2);
        this.registerManualParts(8, Block.field_71988_x, 3);
        this.registerManualParts(9, Block.field_71986_z);
        this.registerManualParts(10, Block.field_71939_E);
        this.registerManualParts(11, Block.field_71940_F);
        this.registerManualParts(12, Block.field_71941_G);
        this.registerManualParts(13, Block.field_71949_H);
        this.registerManualParts(14, Block.field_71950_I);
        this.registerManualParts(15, Block.field_71951_J, 0);
        this.registerManualParts(16, Block.field_71951_J, 1);
        this.registerManualParts(17, Block.field_71951_J, 2);
        this.registerManualParts(18, Block.field_71951_J, 3);
        this.registerManualParts(23, Block.field_71945_L);
        this.registerManualParts(24, Block.field_71946_M);
        this.registerManualParts(25, Block.field_71947_N);
        this.registerManualParts(26, Block.field_71948_O);
        this.registerManualParts(27, Block.field_71958_P);
        this.registerManualParts(28, Block.field_71957_Q);
        this.registerManualParts(29, Block.field_71960_R);
        this.registerManualParts(30, (Block)Block.field_71956_V);
        this.registerManualParts(31, (Block)Block.field_71963_Z);
        this.registerManualParts(32, Block.field_72101_ab, 0);
        this.registerManualParts(33, Block.field_72101_ab, 1);
        this.registerManualParts(34, Block.field_72101_ab, 2);
        this.registerManualParts(35, Block.field_72101_ab, 3);
        this.registerManualParts(36, Block.field_72101_ab, 4);
        this.registerManualParts(37, Block.field_72101_ab, 5);
        this.registerManualParts(38, Block.field_72101_ab, 6);
        this.registerManualParts(39, Block.field_72101_ab, 7);
        this.registerManualParts(40, Block.field_72101_ab, 8);
        this.registerManualParts(41, Block.field_72101_ab, 9);
        this.registerManualParts(42, Block.field_72101_ab, 10);
        this.registerManualParts(43, Block.field_72101_ab, 11);
        this.registerManualParts(44, Block.field_72101_ab, 12);
        this.registerManualParts(45, Block.field_72101_ab, 13);
        this.registerManualParts(46, Block.field_72101_ab, 14);
        this.registerManualParts(47, Block.field_72101_ab, 15);
        this.registerManualParts(48, Block.field_72105_ah);
        this.registerManualParts(49, Block.field_72083_ai);
        this.registerManualParts(50, Block.field_72081_al);
        this.registerManualParts(51, Block.field_72091_am);
        this.registerManualParts(52, Block.field_72093_an);
        this.registerManualParts(53, Block.field_72087_ao);
        this.registerManualParts(54, Block.field_72089_ap);
        this.registerManualParts(55, Block.field_72065_as);
        this.registerManualParts(56, Block.field_72073_aw);
        this.registerManualParts(57, Block.field_72071_ax);
        this.registerManualParts(58, Block.field_72060_ay);
        this.registerManualParts(59, Block.field_72051_aB);
        this.registerManualParts(60, Block.field_72047_aN);
        this.registerManualParts(61, Block.field_72039_aU);
        this.registerManualParts(62, Block.field_72041_aW);
        this.registerManualParts(63, Block.field_72032_aY);
        this.registerManualParts(64, Block.field_72061_ba);
        this.registerManualParts(65, Block.field_72012_bb);
        this.registerManualParts(66, Block.field_72013_bc);
        this.registerManualParts(67, Block.field_72014_bd);
        this.registerManualParts(68, Block.field_72008_bf);
        this.registerManualParts(69, Block.field_72007_bm);
        this.registerManualParts(70, Block.field_71997_br);
        this.registerManualParts(71, (Block)Block.field_71994_by);
        this.registerManualParts(72, Block.field_72033_bA);
        this.registerManualParts(73, Block.field_72082_bJ, 0);
        this.registerManualParts(74, Block.field_72082_bJ, 1);
        this.registerManualParts(75, Block.field_72068_bR);
        this.registerManualParts(76, Block.field_72076_bV);
        this.registerManualParts(77, Block.field_82517_cc);
        this.registerManualParts(78, Block.field_71957_Q, 1);
        this.registerManualParts(79, Block.field_71957_Q, 2);
        this.registerManualParts(80, Block.field_72078_bL);
        this.registerManualParts(81, Block.field_72007_bm, 1);
        this.registerManualParts(82, Block.field_72007_bm, 2);
        this.registerManualParts(83, Block.field_72007_bm, 3);
        this.registerManualParts(84, Block.field_94341_cq);
        this.registerManualParts(85, Block.field_94342_cr);
        this.registerManualParts(86, Block.field_94339_ct, 0);
        this.registerManualParts(87, Block.field_94339_ct, 1);
        this.registerManualParts(88, Block.field_94339_ct, 2);
        this.registerManualParts(89, Block.field_96469_cy);
        this.registerManualParts(90, (Block)Block.field_72085_aj, 0, (Block)Block.field_72079_ak, 0);
    }

    public void initializeBlockScan() {
        ArrayList<Integer> IDBlacklist = new ArrayList<Integer>();
        ArrayList<Integer> IDWhitelist = new ArrayList<Integer>();
        IDBlacklist.add(Block.field_71986_z.field_71990_ca);
        IDBlacklist.add(Block.field_71980_u.field_71990_ca);
        IDBlacklist.add(Block.field_71952_K.field_71990_ca);
        IDBlacklist.add(Block.field_71945_L.field_71990_ca);
        IDBlacklist.add(Block.field_72004_bj.field_71990_ca);
        IDWhitelist.add(Block.field_71946_M.field_71990_ca);
        for (Field f : Block.class.getDeclaredFields()) {
            Block b;
            if (!Modifier.isStatic(f.getModifiers()) || !Block.class.isAssignableFrom(f.getType())) continue;
            try {
                b = (Block)f.get(null);
            }
            catch (Exception e) {
                continue;
            }
            if (IDBlacklist.contains(b.field_71990_ca) || (!b.func_71926_d() || b.hasTileEntity(0) || !b.func_71886_c()) && !IDWhitelist.contains(b.field_71990_ca)) continue;
            ItemStack candidate = new ItemStack(b, 1);
            if (candidate.func_77981_g()) {
                HashSet names = Sets.newHashSet();
                for (int meta = 0; meta < 16; ++meta) {
                    ItemStack is = new ItemStack(b, 1, meta);
                    if (Strings.isNullOrEmpty((String)is.func_77977_a()) || !names.add(is.func_77977_a())) continue;
                    this.addCuttableBlock(b, meta);
                }
                continue;
            }
            this.addCuttableBlock(b, 0);
        }
    }

    private void registerManualParts(int n, Block block, int blockMeta) {
        this.registerManualParts(n, block, blockMeta, block, blockMeta);
    }

    private void registerManualParts(int n, Block block) {
        this.registerManualParts(n, block, 0);
    }

    private void registerManualParts(int n, Block block, int meta, Block craftingBlock, int craftingMeta) {
        this.registerParts(n * 64, block, meta, craftingBlock, craftingMeta, false);
    }

    private static String getItemDisplayName(int itemID, int meta) {
        String nameKey = Item.field_77698_e[itemID].func_77667_c(new ItemStack(itemID, 1, meta)) + ".name";
        String name = StringTranslate.func_74808_a().func_74805_b(nameKey);
        if ((name.equals(nameKey) || name.equals("")) && ((name = LanguageRegistry.instance().getStringLocalization(nameKey)) == null || name.equals(nameKey) || name.equals("")) && ((name = LanguageRegistry.instance().getStringLocalization(nameKey, "en_US")) == null || name.equals(nameKey) || name.equals(""))) {
            try {
                name = Item.field_77698_e[itemID].func_77628_j(new ItemStack(itemID, 1, meta));
            }
            catch (Throwable t) {
                name = null;
            }
            if (name == null || name.equals(nameKey) || name.equals("")) {
                return null;
            }
        }
        return name;
    }

    private void registerParts(int partIDBase, Block block, int meta, Block craftingBlock, int craftingMeta, boolean ignoreNameCheck) {
        assert (blockparts.length == 32);
        String name = MicroblockLibrary.getItemDisplayName(craftingBlock.field_71990_ca, craftingMeta);
        if (name == null) {
            if (ignoreNameCheck) {
                name = "Unknown";
            } else {
                return;
            }
        }
        for (int k = 0; k < 7; ++k) {
            RecipeHollowCover.addMap(partIDBase + k, partIDBase + k + 24);
            RecipeUnHollowCover.addMap(partIDBase + k + 24, partIDBase + k);
            RecipeHorizontalCut.addMap(new BlockMetaPair(ProjectRed.blockMicrocontainer.field_71990_ca, partIDBase + k), ItemBlockMicroblock.getStackWithPartID(partIDBase + k + 8, 2));
            RecipeHorizontalCut.addMap(new BlockMetaPair(ProjectRed.blockMicrocontainer.field_71990_ca, partIDBase + k + 8), ItemBlockMicroblock.getStackWithPartID(partIDBase + k + 16, 2));
            RecipeCombineTwo.addMap(partIDBase + k + 16, partIDBase + k + 8);
            RecipeCombineTwo.addMap(partIDBase + k + 8, partIDBase + k);
        }
        RecipeCombineSeveral.addMap(partIDBase, new ItemStack(craftingBlock, 1, craftingMeta));
        RecipeCombineSeveral.addMap(partIDBase + 24, new ItemStack(craftingBlock, 1, craftingMeta));
        RecipeVerticalCut.addMap(new BlockMetaPair(craftingBlock.field_71990_ca, craftingMeta), ItemBlockMicroblock.getStackWithPartID(partIDBase + 3, 2));
        RecipeVerticalCut.addMap(new BlockMetaPair(ProjectRed.blockMicrocontainer.field_71990_ca, partIDBase + 3), ItemBlockMicroblock.getStackWithPartID(partIDBase + 1, 2));
        RecipeVerticalCut.addMap(new BlockMetaPair(ProjectRed.blockMicrocontainer.field_71990_ca, partIDBase + 1), ItemBlockMicroblock.getStackWithPartID(partIDBase + 0, 2));
        RecipeVerticalCut.addMap(new BlockMetaPair(ProjectRed.blockMicrocontainer.field_71990_ca, partIDBase + 27), ItemBlockMicroblock.getStackWithPartID(partIDBase + 25, 2));
        RecipeVerticalCut.addMap(new BlockMetaPair(ProjectRed.blockMicrocontainer.field_71990_ca, partIDBase + 25), ItemBlockMicroblock.getStackWithPartID(partIDBase + 24, 2));
        ArrayList subblocks = new ArrayList();
        for (int k = 0; k < blockparts.length; ++k) {
            if (blockparts[k] == null) continue;
            String unlocalizedName = "projectred.microblocks." + (partIDBase + k);
            String localizedName = MicroblockLibrary.blockparts[k].prefix + name + MicroblockLibrary.blockparts[k].suffix;
            LanguageRegistry.instance().addStringLocalization(unlocalizedName + ".name", localizedName);
            DefaultPartType type = new DefaultPartType(partIDBase + k, MicroblockLibrary.blockparts[k].clazz, MicroblockLibrary.blockparts[k].size, unlocalizedName, block, meta);
            this.registerPartType(type);
        }
    }

    @Override
    public void registerPartType(PartType type) {
        int id = type.getID();
        if (parts.containsKey(id)) {
            throw new RuntimeException("part id: " + id + " already in use when adding " + id + " with type " + parts.get(id));
        }
        parts.put(id, type);
        neiPartIDs.add(id);
    }

    @Override
    public IMicroblockCoverSystem createMicroblockCoverSystem(IMicroblockSupporterTile tile) {
        return new MicroblockCoverSystem(tile);
    }

    @Override
    public void addCuttableBlock(Block block, int meta) {
        if (block.field_71990_ca < 1 || block.field_71990_ca > 4095) {
            throw new IllegalArgumentException("BlockID must be between 1 and 4095 inclusive");
        }
        if (meta < 0 || meta > 1023) {
            throw new IllegalArgumentException("meta must be between 0 and 1023 inclusive");
        }
        this.registerParts((block.field_71990_ca & 0xFFF) << 20 | (meta & 0x3FF) << 10, block, meta, block, meta, true);
    }

    @Override
    public PartType getPartTypeByID(int id) {
        return (PartType)parts.get(id);
    }

    @Override
    public ItemStack partTypeIDToItemStack(int id, int stackSize) throws IllegalArgumentException {
        if (!parts.containsKey(id)) {
            throw new IllegalArgumentException("No part with ID " + id + " (hex: " + Integer.toHexString(id) + ")");
        }
        return ItemBlockMicroblock.getStackWithPartID(id, stackSize);
    }

    @Override
    public int itemStackToPartID(ItemStack stack) throws NullPointerException, IllegalArgumentException {
        if (stack.field_77993_c != ProjectRed.blockMicrocontainer.field_71990_ca) {
            throw new IllegalArgumentException("Not a stack of microblocks");
        }
        return ItemBlockMicroblock.getPartTypeID(stack);
    }

    public static synchronized IMicroblockLibrary getMicroblockSystem() {
        return instance;
    }

    public boolean mergeIntoMicroblockContainer(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int l, int newBlockID, int newMetadata) {
        if (ProjectRed.blockMicrocontainer == null || world.func_72798_a(x, y, z) != ProjectRed.blockMicrocontainer.field_71990_ca) {
            return false;
        }
        IMicroblockSupporterTile tm = (IMicroblockSupporterTile)world.func_72796_p(x, y, z);
        IMicroblockCoverSystem oldCI = tm.getCoverSystem();
        if (!world.func_72832_d(x, y, z, newBlockID, newMetadata, 2)) {
            return false;
        }
        IMicroblockSupporterTile tcb = (IMicroblockSupporterTile)world.func_72796_p(x, y, z);
        IMicroblockCoverSystem newCI = tcb.getCoverSystem();
        for (Part p : oldCI.getAllParts()) {
            newCI.addPart(p);
        }
        Block b = Block.field_71973_m[newBlockID];
        b.func_71860_a(world, x, y, z, (EntityLiving)entityplayer, itemstack);
        return true;
    }

    @Override
    public Block getMicroblockContainerBlock() {
        return ProjectRed.blockMicrocontainer;
    }

    static {
        neiPartIDs = new ArrayList();
        neiMaxDamage = 0;
        blockparts = new PartRegistrationType[]{new PartRegistrationType(EnumPartClass.Panel, 0.125, "", " Cover"), new PartRegistrationType(EnumPartClass.Panel, 0.25, "", " Panel"), new PartRegistrationType(EnumPartClass.Panel, 0.375, "", " Triple Cover"), new PartRegistrationType(EnumPartClass.Panel, 0.5, "", " Slab"), new PartRegistrationType(EnumPartClass.Panel, 0.625, "", " Cover Slab"), new PartRegistrationType(EnumPartClass.Panel, 0.75, "", " Triple Panel"), new PartRegistrationType(EnumPartClass.Panel, 0.875, "", " Anticover"), null, new PartRegistrationType(EnumPartClass.Strip, 0.125, "", " Cover Strip"), new PartRegistrationType(EnumPartClass.Strip, 0.25, "", " Panel Strip"), new PartRegistrationType(EnumPartClass.Strip, 0.375, "", " Triple Cover Strip"), new PartRegistrationType(EnumPartClass.Strip, 0.5, "", " Slab Strip"), new PartRegistrationType(EnumPartClass.Strip, 0.625, "", " Cover Slab Strip"), new PartRegistrationType(EnumPartClass.Strip, 0.75, "", " Triple Panel Strip"), new PartRegistrationType(EnumPartClass.Strip, 0.875, "", " Anticover Strip"), null, new PartRegistrationType(EnumPartClass.Corner, 0.125, "", " Cover Corner"), new PartRegistrationType(EnumPartClass.Corner, 0.25, "", " Panel Corner"), new PartRegistrationType(EnumPartClass.Corner, 0.375, "", " Triple Cover Corner"), new PartRegistrationType(EnumPartClass.Corner, 0.5, "", " Slab Corner"), new PartRegistrationType(EnumPartClass.Corner, 0.625, "", " Cover Slab Corner"), new PartRegistrationType(EnumPartClass.Corner, 0.75, "", " Triple Panel Corner"), new PartRegistrationType(EnumPartClass.Corner, 0.875, "", " Anticover Corner"), null, new PartRegistrationType(EnumPartClass.HollowPanel, 0.125, "Hollow ", " Cover"), new PartRegistrationType(EnumPartClass.HollowPanel, 0.25, "Hollow ", " Panel"), new PartRegistrationType(EnumPartClass.HollowPanel, 0.375, "Hollow ", " Triple Cover"), new PartRegistrationType(EnumPartClass.HollowPanel, 0.5, "Hollow ", " Slab"), new PartRegistrationType(EnumPartClass.HollowPanel, 0.625, "Hollow ", " Cover Slab"), new PartRegistrationType(EnumPartClass.HollowPanel, 0.75, "Hollow ", " Triple Panel"), new PartRegistrationType(EnumPartClass.HollowPanel, 0.875, "Hollow ", " Anticover"), null};
    }

    private static class PartRegistrationType {
        public EnumPartClass clazz;
        public double size;
        public String prefix;
        public String suffix;

        public PartRegistrationType(EnumPartClass c, double s, String pr, String su) {
            this.clazz = c;
            this.size = s;
            this.prefix = pr;
            this.suffix = su;
        }
    }
}

