/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart.microblocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import mrtjp.projectred.multipart.microblocks.EnumAxisPosition;
import mrtjp.projectred.multipart.microblocks.EnumPartClass;
import mrtjp.projectred.multipart.microblocks.EnumPosition;
import mrtjp.projectred.multipart.microblocks.MicroblockLibrary;
import mrtjp.projectred.multipart.microblocks.Part;
import mrtjp.projectred.multipart.microblocks.PartType;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import org.lwjgl.opengl.GL11;

public class DefaultPartType
implements PartType {
    private final EnumPartClass clazz;
    private final double size;
    private final String unlocalizedName;
    private final int id;
    public Block modelBlock;
    public int modelMeta;
    @SideOnly(value=Side.CLIENT)
    private float uMin;
    @SideOnly(value=Side.CLIENT)
    private float uMax;
    @SideOnly(value=Side.CLIENT)
    private float vMin;
    @SideOnly(value=Side.CLIENT)
    private float vMax;
    @SideOnly(value=Side.CLIENT)
    private Icon icon;
    @SideOnly(value=Side.CLIENT)
    private Icon overrideIcon;
    private static final double HOLLOW_EDGE_SIZE = 0.25;
    @SideOnly(value=Side.CLIENT)
    private int colNN;
    @SideOnly(value=Side.CLIENT)
    private int colPN;
    @SideOnly(value=Side.CLIENT)
    private int colNP;
    @SideOnly(value=Side.CLIENT)
    private int colPP;
    @SideOnly(value=Side.CLIENT)
    private int briNN;
    @SideOnly(value=Side.CLIENT)
    private int briPN;
    @SideOnly(value=Side.CLIENT)
    private int briNP;
    @SideOnly(value=Side.CLIENT)
    private int briPP;

    @Override
    public boolean canHarvest(EntityPlayer ply, Part part) {
        return this.modelBlock.canHarvestBlock(ply, this.modelMeta);
    }

    @Override
    public EnumPartClass getPartClass() {
        return this.clazz;
    }

    @Override
    public double getSize() {
        return this.size;
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return this.unlocalizedName;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public ItemStack getDroppedStack(Part part, EntityPlayer ply) {
        return MicroblockLibrary.instance.getMicroblockSystem().partTypeIDToItemStack(this.id, 1);
    }

    @Override
    public float getPlayerRelativeHardness(Part part, EntityPlayer ply) {
        float hardness;
        try {
            hardness = this.modelBlock.func_71934_m(null, 0, 0, 0);
        }
        catch (Throwable t) {
            return 0.1f;
        }
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!this.canHarvest(ply, part)) {
            return 0.01f / hardness;
        }
        return ply.getCurrentPlayerStrVsBlock(this.modelBlock, false, this.modelMeta) / hardness / 30.0f;
    }

    @Override
    public ItemStack getPickItem(Part part) {
        return this.getDroppedStack(part, null);
    }

    @Override
    public Part createPart(EnumPosition pos) {
        return new Part(this, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Part createPart(EnumPosition pos, DataInput data) {
        return this.createPart(pos);
    }

    @Override
    public Part createPart(EnumPosition pos, NBTTagCompound c) {
        return this.createPart(pos);
    }

    public DefaultPartType(int id, EnumPartClass clazz, double size, String unlocalizedName, Block modelBlock, int modelMeta) {
        this.clazz = clazz;
        this.size = size;
        this.id = id;
        this.unlocalizedName = unlocalizedName;
        this.modelBlock = modelBlock;
        this.modelMeta = modelMeta;
    }

    @SideOnly(value=Side.CLIENT)
    private void setTex(Icon i) {
        if (this.overrideIcon != null) {
            i = this.overrideIcon;
        }
        this.icon = i;
        this.uMin = i.func_94209_e();
        this.uMax = i.func_94212_f();
        this.vMin = i.func_94206_g();
        this.vMax = i.func_94210_h();
    }

    @SideOnly(value=Side.CLIENT)
    private void setTex(int side) {
        this.setTex(this.modelBlock.func_71858_a(side, this.modelMeta));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPreview(RenderGlobal context, EnumPosition pos, ItemStack stack) {
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        this.overrideIcon = null;
        Minecraft.func_71410_x().field_71446_o.func_98187_b("/terrain.png");
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        this.renderQuads(t, pos);
        t.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    @SideOnly(value=Side.CLIENT)
    private void vertXY(Tessellator t, double x, double y, double z) {
        t.func_78374_a(x, y, z, (double)this.uMin + (double)(this.uMax - this.uMin) * x, (double)this.vMax + (double)(this.vMin - this.vMax) * y);
    }

    @SideOnly(value=Side.CLIENT)
    private void vertXZ(Tessellator t, double x, double y, double z) {
        t.func_78374_a(x, y, z, (double)this.uMin + (double)(this.uMax - this.uMin) * x, (double)this.vMin + (double)(this.vMax - this.vMin) * z);
    }

    @SideOnly(value=Side.CLIENT)
    private void vertYZ(Tessellator t, double x, double y, double z) {
        t.func_78374_a(x, y, z, (double)this.uMin + (double)(this.uMax - this.uMin) * z, (double)this.vMax + (double)(this.vMin - this.vMax) * y);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderHollowPanelYZ(Tessellator t, AxisAlignedBB aabb) {
        this.setTex(this.modelBlock.func_71858_a(4, this.modelMeta));
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.vertYZ(t, aabb.field_72340_a, 0.25, 0.25);
        this.vertYZ(t, aabb.field_72340_a, 0.75, 0.25);
        this.vertYZ(t, aabb.field_72340_a, 1.0, 0.0);
        this.vertYZ(t, aabb.field_72340_a, 0.0, 0.0);
        this.vertYZ(t, aabb.field_72340_a, 0.0, 1.0);
        this.vertYZ(t, aabb.field_72340_a, 1.0, 1.0);
        this.vertYZ(t, aabb.field_72340_a, 0.75, 0.75);
        this.vertYZ(t, aabb.field_72340_a, 0.25, 0.75);
        this.vertYZ(t, aabb.field_72340_a, 0.0, 1.0);
        this.vertYZ(t, aabb.field_72340_a, 0.25, 0.75);
        this.vertYZ(t, aabb.field_72340_a, 0.25, 0.25);
        this.vertYZ(t, aabb.field_72340_a, 0.0, 0.0);
        this.vertYZ(t, aabb.field_72340_a, 1.0, 0.0);
        this.vertYZ(t, aabb.field_72340_a, 0.75, 0.25);
        this.vertYZ(t, aabb.field_72340_a, 0.75, 0.75);
        this.vertYZ(t, aabb.field_72340_a, 1.0, 1.0);
        this.setTex(this.modelBlock.func_71858_a(5, this.modelMeta));
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        this.vertYZ(t, aabb.field_72336_d, 0.0, 0.0);
        this.vertYZ(t, aabb.field_72336_d, 1.0, 0.0);
        this.vertYZ(t, aabb.field_72336_d, 0.75, 0.25);
        this.vertYZ(t, aabb.field_72336_d, 0.25, 0.25);
        this.vertYZ(t, aabb.field_72336_d, 0.25, 0.75);
        this.vertYZ(t, aabb.field_72336_d, 0.75, 0.75);
        this.vertYZ(t, aabb.field_72336_d, 1.0, 1.0);
        this.vertYZ(t, aabb.field_72336_d, 0.0, 1.0);
        this.vertYZ(t, aabb.field_72336_d, 0.0, 0.0);
        this.vertYZ(t, aabb.field_72336_d, 0.25, 0.25);
        this.vertYZ(t, aabb.field_72336_d, 0.25, 0.75);
        this.vertYZ(t, aabb.field_72336_d, 0.0, 1.0);
        this.vertYZ(t, aabb.field_72336_d, 1.0, 1.0);
        this.vertYZ(t, aabb.field_72336_d, 0.75, 0.75);
        this.vertYZ(t, aabb.field_72336_d, 0.75, 0.25);
        this.vertYZ(t, aabb.field_72336_d, 1.0, 0.0);
        this.setTex(this.modelBlock.func_71858_a(0, this.modelMeta));
        t.func_78375_b(0.0f, -1.0f, 0.0f);
        this.vertXZ(t, aabb.field_72340_a, 0.0, 0.0);
        this.vertXZ(t, aabb.field_72336_d, 0.0, 0.0);
        this.vertXZ(t, aabb.field_72336_d, 0.0, 1.0);
        this.vertXZ(t, aabb.field_72340_a, 0.0, 1.0);
        this.vertXZ(t, aabb.field_72340_a, 0.25, 0.75);
        this.vertXZ(t, aabb.field_72336_d, 0.25, 0.75);
        this.vertXZ(t, aabb.field_72336_d, 0.25, 0.25);
        this.vertXZ(t, aabb.field_72340_a, 0.25, 0.25);
        this.setTex(this.modelBlock.func_71858_a(1, this.modelMeta));
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        this.vertXZ(t, aabb.field_72340_a, 1.0, 1.0);
        this.vertXZ(t, aabb.field_72336_d, 1.0, 1.0);
        this.vertXZ(t, aabb.field_72336_d, 1.0, 0.0);
        this.vertXZ(t, aabb.field_72340_a, 1.0, 0.0);
        this.vertXZ(t, aabb.field_72340_a, 0.75, 0.25);
        this.vertXZ(t, aabb.field_72336_d, 0.75, 0.25);
        this.vertXZ(t, aabb.field_72336_d, 0.75, 0.75);
        this.vertXZ(t, aabb.field_72340_a, 0.75, 0.75);
        this.setTex(this.modelBlock.func_71858_a(2, this.modelMeta));
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        this.vertXY(t, aabb.field_72340_a, 0.0, 0.0);
        this.vertXY(t, aabb.field_72340_a, 1.0, 0.0);
        this.vertXY(t, aabb.field_72336_d, 1.0, 0.0);
        this.vertXY(t, aabb.field_72336_d, 0.0, 0.0);
        this.vertXY(t, aabb.field_72340_a, 0.75, 0.25);
        this.vertXY(t, aabb.field_72340_a, 0.25, 0.25);
        this.vertXY(t, aabb.field_72336_d, 0.25, 0.25);
        this.vertXY(t, aabb.field_72336_d, 0.75, 0.25);
        this.setTex(this.modelBlock.func_71858_a(3, this.modelMeta));
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        this.vertXY(t, aabb.field_72340_a, 1.0, 1.0);
        this.vertXY(t, aabb.field_72340_a, 0.0, 1.0);
        this.vertXY(t, aabb.field_72336_d, 0.0, 1.0);
        this.vertXY(t, aabb.field_72336_d, 1.0, 1.0);
        this.vertXY(t, aabb.field_72340_a, 0.25, 0.75);
        this.vertXY(t, aabb.field_72340_a, 0.75, 0.75);
        this.vertXY(t, aabb.field_72336_d, 0.75, 0.75);
        this.vertXY(t, aabb.field_72336_d, 0.25, 0.75);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderHollowPanelXZ(Tessellator t, AxisAlignedBB aabb) {
        this.setTex(0);
        t.func_78375_b(0.0f, -1.0f, 0.0f);
        this.vertXZ(t, 0.25, aabb.field_72338_b, 0.25);
        this.vertXZ(t, 0.25, aabb.field_72338_b, 0.75);
        this.vertXZ(t, 0.0, aabb.field_72338_b, 1.0);
        this.vertXZ(t, 0.0, aabb.field_72338_b, 0.0);
        this.vertXZ(t, 0.75, aabb.field_72338_b, 0.75);
        this.vertXZ(t, 0.75, aabb.field_72338_b, 0.25);
        this.vertXZ(t, 1.0, aabb.field_72338_b, 0.0);
        this.vertXZ(t, 1.0, aabb.field_72338_b, 1.0);
        this.vertXZ(t, 0.0, aabb.field_72338_b, 0.0);
        this.vertXZ(t, 1.0, aabb.field_72338_b, 0.0);
        this.vertXZ(t, 0.75, aabb.field_72338_b, 0.25);
        this.vertXZ(t, 0.25, aabb.field_72338_b, 0.25);
        this.vertXZ(t, 0.25, aabb.field_72338_b, 0.75);
        this.vertXZ(t, 0.75, aabb.field_72338_b, 0.75);
        this.vertXZ(t, 1.0, aabb.field_72338_b, 1.0);
        this.vertXZ(t, 0.0, aabb.field_72338_b, 1.0);
        this.setTex(1);
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        this.vertXZ(t, 0.0, aabb.field_72337_e, 0.0);
        this.vertXZ(t, 0.0, aabb.field_72337_e, 1.0);
        this.vertXZ(t, 0.25, aabb.field_72337_e, 0.75);
        this.vertXZ(t, 0.25, aabb.field_72337_e, 0.25);
        this.vertXZ(t, 1.0, aabb.field_72337_e, 1.0);
        this.vertXZ(t, 1.0, aabb.field_72337_e, 0.0);
        this.vertXZ(t, 0.75, aabb.field_72337_e, 0.25);
        this.vertXZ(t, 0.75, aabb.field_72337_e, 0.75);
        this.vertXZ(t, 0.25, aabb.field_72337_e, 0.25);
        this.vertXZ(t, 0.75, aabb.field_72337_e, 0.25);
        this.vertXZ(t, 1.0, aabb.field_72337_e, 0.0);
        this.vertXZ(t, 0.0, aabb.field_72337_e, 0.0);
        this.vertXZ(t, 0.0, aabb.field_72337_e, 1.0);
        this.vertXZ(t, 1.0, aabb.field_72337_e, 1.0);
        this.vertXZ(t, 0.75, aabb.field_72337_e, 0.75);
        this.vertXZ(t, 0.25, aabb.field_72337_e, 0.75);
        this.setTex(4);
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.vertYZ(t, 0.0, aabb.field_72338_b, 0.0);
        this.vertYZ(t, 0.0, aabb.field_72338_b, 1.0);
        this.vertYZ(t, 0.0, aabb.field_72337_e, 1.0);
        this.vertYZ(t, 0.0, aabb.field_72337_e, 0.0);
        this.vertYZ(t, 0.25, aabb.field_72338_b, 0.75);
        this.vertYZ(t, 0.25, aabb.field_72338_b, 0.25);
        this.vertYZ(t, 0.25, aabb.field_72337_e, 0.25);
        this.vertYZ(t, 0.25, aabb.field_72337_e, 0.75);
        this.setTex(5);
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        this.vertYZ(t, 1.0, aabb.field_72338_b, 1.0);
        this.vertYZ(t, 1.0, aabb.field_72338_b, 0.0);
        this.vertYZ(t, 1.0, aabb.field_72337_e, 0.0);
        this.vertYZ(t, 1.0, aabb.field_72337_e, 1.0);
        this.vertYZ(t, 0.75, aabb.field_72337_e, 0.75);
        this.vertYZ(t, 0.75, aabb.field_72337_e, 0.25);
        this.vertYZ(t, 0.75, aabb.field_72338_b, 0.25);
        this.vertYZ(t, 0.75, aabb.field_72338_b, 0.75);
        this.setTex(2);
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        this.vertXY(t, 0.0, aabb.field_72338_b, 0.0);
        this.vertXY(t, 0.0, aabb.field_72337_e, 0.0);
        this.vertXY(t, 1.0, aabb.field_72337_e, 0.0);
        this.vertXY(t, 1.0, aabb.field_72338_b, 0.0);
        this.vertXY(t, 0.75, aabb.field_72338_b, 0.25);
        this.vertXY(t, 0.75, aabb.field_72337_e, 0.25);
        this.vertXY(t, 0.25, aabb.field_72337_e, 0.25);
        this.vertXY(t, 0.25, aabb.field_72338_b, 0.25);
        this.setTex(3);
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        this.vertXY(t, 1.0, aabb.field_72338_b, 1.0);
        this.vertXY(t, 1.0, aabb.field_72337_e, 1.0);
        this.vertXY(t, 0.0, aabb.field_72337_e, 1.0);
        this.vertXY(t, 0.0, aabb.field_72338_b, 1.0);
        this.vertXY(t, 0.25, aabb.field_72338_b, 0.75);
        this.vertXY(t, 0.25, aabb.field_72337_e, 0.75);
        this.vertXY(t, 0.75, aabb.field_72337_e, 0.75);
        this.vertXY(t, 0.75, aabb.field_72338_b, 0.75);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderHollowPanelXY(Tessellator t, AxisAlignedBB aabb) {
        this.setTex(2);
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        this.vertXY(t, 0.0, 0.0, aabb.field_72339_c);
        this.vertXY(t, 0.0, 1.0, aabb.field_72339_c);
        this.vertXY(t, 0.25, 0.75, aabb.field_72339_c);
        this.vertXY(t, 0.25, 0.25, aabb.field_72339_c);
        this.vertXY(t, 1.0, 1.0, aabb.field_72339_c);
        this.vertXY(t, 1.0, 0.0, aabb.field_72339_c);
        this.vertXY(t, 0.75, 0.25, aabb.field_72339_c);
        this.vertXY(t, 0.75, 0.75, aabb.field_72339_c);
        this.vertXY(t, 0.25, 0.25, aabb.field_72339_c);
        this.vertXY(t, 0.75, 0.25, aabb.field_72339_c);
        this.vertXY(t, 1.0, 0.0, aabb.field_72339_c);
        this.vertXY(t, 0.0, 0.0, aabb.field_72339_c);
        this.vertXY(t, 0.0, 1.0, aabb.field_72339_c);
        this.vertXY(t, 1.0, 1.0, aabb.field_72339_c);
        this.vertXY(t, 0.75, 0.75, aabb.field_72339_c);
        this.vertXY(t, 0.25, 0.75, aabb.field_72339_c);
        this.setTex(3);
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        this.vertXY(t, 0.25, 0.25, aabb.field_72334_f);
        this.vertXY(t, 0.25, 0.75, aabb.field_72334_f);
        this.vertXY(t, 0.0, 1.0, aabb.field_72334_f);
        this.vertXY(t, 0.0, 0.0, aabb.field_72334_f);
        this.vertXY(t, 0.75, 0.75, aabb.field_72334_f);
        this.vertXY(t, 0.75, 0.25, aabb.field_72334_f);
        this.vertXY(t, 1.0, 0.0, aabb.field_72334_f);
        this.vertXY(t, 1.0, 1.0, aabb.field_72334_f);
        this.vertXY(t, 0.0, 0.0, aabb.field_72334_f);
        this.vertXY(t, 1.0, 0.0, aabb.field_72334_f);
        this.vertXY(t, 0.75, 0.25, aabb.field_72334_f);
        this.vertXY(t, 0.25, 0.25, aabb.field_72334_f);
        this.vertXY(t, 0.25, 0.75, aabb.field_72334_f);
        this.vertXY(t, 0.75, 0.75, aabb.field_72334_f);
        this.vertXY(t, 1.0, 1.0, aabb.field_72334_f);
        this.vertXY(t, 0.0, 1.0, aabb.field_72334_f);
        this.setTex(4);
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.vertYZ(t, 0.0, 1.0, aabb.field_72339_c);
        this.vertYZ(t, 0.0, 0.0, aabb.field_72339_c);
        this.vertYZ(t, 0.0, 0.0, aabb.field_72334_f);
        this.vertYZ(t, 0.0, 1.0, aabb.field_72334_f);
        this.vertYZ(t, 0.25, 0.25, aabb.field_72339_c);
        this.vertYZ(t, 0.25, 0.75, aabb.field_72339_c);
        this.vertYZ(t, 0.25, 0.75, aabb.field_72334_f);
        this.vertYZ(t, 0.25, 0.25, aabb.field_72334_f);
        this.setTex(5);
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        this.vertYZ(t, 1.0, 0.0, aabb.field_72339_c);
        this.vertYZ(t, 1.0, 1.0, aabb.field_72339_c);
        this.vertYZ(t, 1.0, 1.0, aabb.field_72334_f);
        this.vertYZ(t, 1.0, 0.0, aabb.field_72334_f);
        this.vertYZ(t, 0.75, 0.25, aabb.field_72334_f);
        this.vertYZ(t, 0.75, 0.75, aabb.field_72334_f);
        this.vertYZ(t, 0.75, 0.75, aabb.field_72339_c);
        this.vertYZ(t, 0.75, 0.25, aabb.field_72339_c);
        this.setTex(0);
        t.func_78375_b(0.0f, -1.0f, 0.0f);
        this.vertXZ(t, 1.0, 0.0, aabb.field_72339_c);
        this.vertXZ(t, 1.0, 0.0, aabb.field_72334_f);
        this.vertXZ(t, 0.0, 0.0, aabb.field_72334_f);
        this.vertXZ(t, 0.0, 0.0, aabb.field_72339_c);
        this.vertXZ(t, 0.25, 0.25, aabb.field_72339_c);
        this.vertXZ(t, 0.25, 0.25, aabb.field_72334_f);
        this.vertXZ(t, 0.75, 0.25, aabb.field_72334_f);
        this.vertXZ(t, 0.75, 0.25, aabb.field_72339_c);
        this.setTex(1);
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        this.vertXZ(t, 0.0, 1.0, aabb.field_72339_c);
        this.vertXZ(t, 0.0, 1.0, aabb.field_72334_f);
        this.vertXZ(t, 1.0, 1.0, aabb.field_72334_f);
        this.vertXZ(t, 1.0, 1.0, aabb.field_72339_c);
        this.vertXZ(t, 0.75, 0.75, aabb.field_72339_c);
        this.vertXZ(t, 0.75, 0.75, aabb.field_72334_f);
        this.vertXZ(t, 0.25, 0.75, aabb.field_72334_f);
        this.vertXZ(t, 0.25, 0.75, aabb.field_72339_c);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderQuads(Tessellator t, EnumPosition pos) {
        AxisAlignedBB aabb = Part.getBoundingBoxFromPool(pos, this.size);
        if (this.getPartClass() == EnumPartClass.HollowPanel) {
            if (pos.x != EnumAxisPosition.Span) {
                this.renderHollowPanelYZ(t, aabb);
            } else if (pos.y != EnumAxisPosition.Span) {
                this.renderHollowPanelXZ(t, aabb);
            } else if (pos.z != EnumAxisPosition.Span) {
                this.renderHollowPanelXY(t, aabb);
            }
            return;
        }
        this.renderAABB(t, aabb, null, 0, 0, 0, null, new boolean[6]);
    }

    @SideOnly(value=Side.CLIENT)
    private static double interp(double a, double b, double i) {
        return a + (b - a) * i;
    }

    @SideOnly(value=Side.CLIENT)
    private static int rgb_component(double a) {
        if (a < 0.0) {
            return 0;
        }
        if (a > 1.0) {
            return 255;
        }
        return (int)(255.0 * a);
    }

    @SideOnly(value=Side.CLIENT)
    private static int rgb(double r, double g, double b) {
        return DefaultPartType.rgb_component(r) << 16 | DefaultPartType.rgb_component(g) << 8 | DefaultPartType.rgb_component(b);
    }

    @SideOnly(value=Side.CLIENT)
    private static int rgb_r(int a) {
        return a >> 16 & 0xFF;
    }

    @SideOnly(value=Side.CLIENT)
    private static int rgb_g(int a) {
        return a >> 8 & 0xFF;
    }

    @SideOnly(value=Side.CLIENT)
    private static int rgb_b(int a) {
        return a & 0xFF;
    }

    @SideOnly(value=Side.CLIENT)
    private static int interpRGB(int a, int b, double i) {
        return DefaultPartType.rgb(DefaultPartType.interp(DefaultPartType.rgb_r(a), DefaultPartType.rgb_r(b), i) / 255.0, DefaultPartType.interp(DefaultPartType.rgb_g(a), DefaultPartType.rgb_g(b), i) / 255.0, DefaultPartType.interp(DefaultPartType.rgb_b(a), DefaultPartType.rgb_b(b), i) / 255.0);
    }

    @SideOnly(value=Side.CLIENT)
    private static int scaleRGB(int a, double sc) {
        return DefaultPartType.rgb((double)DefaultPartType.rgb_r(a) * (sc /= 255.0), (double)DefaultPartType.rgb_g(a) * sc, (double)DefaultPartType.rgb_b(a) * sc);
    }

    @SideOnly(value=Side.CLIENT)
    private static int interpBrightness(int a, int b, double i) {
        int AH = a >> 16;
        int AL = a & 0xFFFF;
        int BH = b >> 16;
        int BL = b & 0xFFFF;
        int H = (int)((double)AH + (double)(BH - AH) * i);
        int L = (int)((double)AL + (double)(BL - AL) * i);
        return H << 16 | L;
    }

    @SideOnly(value=Side.CLIENT)
    private void setColourAndBrightness(Tessellator t, double x, double y) {
        int col = DefaultPartType.interpRGB(DefaultPartType.interpRGB(this.colNN, this.colPN, x), DefaultPartType.interpRGB(this.colNP, this.colPP, x), y);
        int bri = DefaultPartType.interpBrightness(DefaultPartType.interpBrightness(this.briNN, this.briPN, x), DefaultPartType.interpBrightness(this.briNP, this.briPP, x), y);
        t.func_78378_d(col);
        t.func_78380_c(bri);
    }

    @SideOnly(value=Side.CLIENT)
    private void getBrightnessXFace(RenderBlocks rb, int bx, int by, int bz, double f_dx) {
        int dx;
        int n = f_dx >= 1.0 ? 1 : (dx = f_dx <= 0.0 ? -1 : 0);
        if (rb == null) {
            this.briPP = 0xF000F0;
            this.briPN = 0xF000F0;
            this.briNP = 0xF000F0;
            this.briNN = 0xF000F0;
        } else {
            this.briPN = this.briPP = rb.field_78669_a.func_72802_i(bx += dx, by, bz, 0);
            this.briNP = this.briPP;
            this.briNN = this.briPP;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void getBrightnessYFace(RenderBlocks rb, int bx, int by, int bz, double f_dy) {
        int dy;
        int n = f_dy >= 1.0 ? 1 : (dy = f_dy <= 0.0 ? -1 : 0);
        if (rb == null) {
            this.briPP = 0xF000F0;
            this.briPN = 0xF000F0;
            this.briNP = 0xF000F0;
            this.briNN = 0xF000F0;
        } else {
            this.briPN = this.briPP = rb.field_78669_a.func_72802_i(bx, by += dy, bz, 0);
            this.briNP = this.briPP;
            this.briNN = this.briPP;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void getBrightnessZFace(RenderBlocks rb, int bx, int by, int bz, double f_dz) {
        int dz;
        int n = f_dz >= 1.0 ? 1 : (dz = f_dz <= 0.0 ? -1 : 0);
        if (rb == null) {
            this.briPP = 0xF000F0;
            this.briPN = 0xF000F0;
            this.briNP = 0xF000F0;
            this.briNN = 0xF000F0;
        } else {
            this.briPN = this.briPP = rb.field_78669_a.func_72802_i(bx, by, bz += dz, 0);
            this.briNP = this.briPP;
            this.briNN = this.briPP;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderAABB(Tessellator t, AxisAlignedBB aabb, RenderBlocks rb, int bx, int by, int bz, Block par1Block, boolean[] dontRenderFaces) {
        AxisAlignedBB rbb = aabb.func_72325_c((double)(-bx), (double)(-by), (double)(-bz));
        double txmin = (aabb.field_72340_a % 1.0 + 1.0) % 1.0;
        double txmax = (aabb.field_72336_d % 1.0 + 1.0) % 1.0;
        double tymin = (aabb.field_72338_b % 1.0 + 1.0) % 1.0;
        double tymax = (aabb.field_72337_e % 1.0 + 1.0) % 1.0;
        double tzmin = (aabb.field_72339_c % 1.0 + 1.0) % 1.0;
        double tzmax = (aabb.field_72334_f % 1.0 + 1.0) % 1.0;
        if (txmax == 0.0) {
            txmax = 1.0;
        }
        if (tymax == 0.0) {
            tymax = 1.0;
        }
        if (tzmax == 0.0) {
            tzmax = 1.0;
        }
        float colourR = 1.0f;
        float colourG = 1.0f;
        float colourB = 1.0f;
        double DRFMIN = 0.005;
        double DRFMAX = 0.995;
        if (tzmin > 0.005 || !dontRenderFaces[2]) {
            this.setTex(2);
            t.func_78375_b(0.0f, 0.0f, -1.0f);
            this.colNP = this.colPP = DefaultPartType.rgb((double)colourR * 0.8, (double)colourG * 0.8, (double)colourB * 0.8);
            this.colPN = this.colPP;
            this.colNN = this.colPP;
            this.getBrightnessZFace(rb, bx, by, bz, rbb.field_72339_c);
            this.setColourAndBrightness(t, rbb.field_72340_a, rbb.field_72338_b);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, (double)this.uMax + txmin * (double)(this.uMin - this.uMax), (double)this.vMax + tymin * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72340_a, rbb.field_72337_e);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c, (double)this.uMax + txmin * (double)(this.uMin - this.uMax), (double)this.vMax + tymax * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72336_d, rbb.field_72337_e);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c, (double)this.uMax + txmax * (double)(this.uMin - this.uMax), (double)this.vMax + tymax * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72336_d, rbb.field_72338_b);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c, (double)this.uMax + txmax * (double)(this.uMin - this.uMax), (double)this.vMax + tymin * (double)(this.vMin - this.vMax));
        }
        if (tymin > 0.005 || !dontRenderFaces[0]) {
            this.setTex(0);
            this.colNP = this.colPP = DefaultPartType.rgb((double)colourR * 0.5, (double)colourG * 0.5, (double)colourB * 0.5);
            this.colPN = this.colPP;
            this.colNN = this.colPP;
            t.func_78375_b(0.0f, -1.0f, 0.0f);
            this.getBrightnessYFace(rb, bx, by, bz, rbb.field_72338_b);
            this.setColourAndBrightness(t, rbb.field_72336_d, rbb.field_72339_c);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c, (double)this.uMin + txmax * (double)(this.uMax - this.uMin), (double)this.vMin + tzmin * (double)(this.vMax - this.vMin));
            this.setColourAndBrightness(t, rbb.field_72336_d, rbb.field_72334_f);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f, (double)this.uMin + txmax * (double)(this.uMax - this.uMin), (double)this.vMin + tzmax * (double)(this.vMax - this.vMin));
            this.setColourAndBrightness(t, rbb.field_72340_a, rbb.field_72334_f);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f, (double)this.uMin + txmin * (double)(this.uMax - this.uMin), (double)this.vMin + tzmax * (double)(this.vMax - this.vMin));
            this.setColourAndBrightness(t, rbb.field_72340_a, rbb.field_72339_c);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, (double)this.uMin + txmin * (double)(this.uMax - this.uMin), (double)this.vMin + tzmin * (double)(this.vMax - this.vMin));
        }
        if (txmin > 0.005 || !dontRenderFaces[4]) {
            this.setTex(4);
            t.func_78375_b(-1.0f, 0.0f, 0.0f);
            this.colNP = this.colPP = DefaultPartType.rgb((double)colourR * 0.6, (double)colourG * 0.6, (double)colourB * 0.6);
            this.colPN = this.colPP;
            this.colNN = this.colPP;
            this.getBrightnessXFace(rb, bx, by, bz, rbb.field_72340_a);
            this.setColourAndBrightness(t, rbb.field_72338_b, rbb.field_72339_c);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, (double)this.uMin + tzmin * (double)(this.uMax - this.uMin), (double)this.vMax + tymin * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72338_b, rbb.field_72334_f);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f, (double)this.uMin + tzmax * (double)(this.uMax - this.uMin), (double)this.vMax + tymin * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72337_e, rbb.field_72334_f);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f, (double)this.uMin + tzmax * (double)(this.uMax - this.uMin), (double)this.vMax + tymax * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72337_e, rbb.field_72339_c);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c, (double)this.uMin + tzmin * (double)(this.uMax - this.uMin), (double)this.vMax + tymax * (double)(this.vMin - this.vMax));
        }
        if (tzmax < 0.995 || !dontRenderFaces[3]) {
            this.setTex(3);
            t.func_78375_b(0.0f, 0.0f, 1.0f);
            this.colNP = this.colPP = DefaultPartType.rgb((double)colourR * 0.8, (double)colourG * 0.8, (double)colourB * 0.8);
            this.colPN = this.colPP;
            this.colNN = this.colPP;
            this.getBrightnessZFace(rb, bx, by, bz, rbb.field_72334_f);
            this.setColourAndBrightness(t, rbb.field_72336_d, rbb.field_72338_b);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f, (double)this.uMin + txmax * (double)(this.uMax - this.uMin), (double)this.vMax + tymin * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72336_d, rbb.field_72337_e);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f, (double)this.uMin + txmax * (double)(this.uMax - this.uMin), (double)this.vMax + tymax * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72340_a, rbb.field_72337_e);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f, (double)this.uMin + txmin * (double)(this.uMax - this.uMin), (double)this.vMax + tymax * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72340_a, rbb.field_72338_b);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f, (double)this.uMin + txmin * (double)(this.uMax - this.uMin), (double)this.vMax + tymin * (double)(this.vMin - this.vMax));
        }
        if (tymax < 0.995 || !dontRenderFaces[1]) {
            this.setTex(1);
            t.func_78375_b(0.0f, 1.0f, 0.0f);
            this.colNP = this.colPP = DefaultPartType.rgb((double)colourR * 1.0, (double)colourG * 1.0, (double)colourB * 1.0);
            this.colPN = this.colPP;
            this.colNN = this.colPP;
            this.getBrightnessYFace(rb, bx, by, bz, rbb.field_72337_e);
            this.setColourAndBrightness(t, rbb.field_72340_a, rbb.field_72339_c);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c, (double)this.uMin + txmin * (double)(this.uMax - this.uMin), (double)this.vMin + tzmin * (double)(this.vMax - this.vMin));
            this.setColourAndBrightness(t, rbb.field_72340_a, rbb.field_72334_f);
            t.func_78374_a(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f, (double)this.uMin + txmin * (double)(this.uMax - this.uMin), (double)this.vMin + tzmax * (double)(this.vMax - this.vMin));
            this.setColourAndBrightness(t, rbb.field_72336_d, rbb.field_72334_f);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f, (double)this.uMin + txmax * (double)(this.uMax - this.uMin), (double)this.vMin + tzmax * (double)(this.vMax - this.vMin));
            this.setColourAndBrightness(t, rbb.field_72336_d, rbb.field_72339_c);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c, (double)this.uMin + txmax * (double)(this.uMax - this.uMin), (double)this.vMin + tzmin * (double)(this.vMax - this.vMin));
        }
        if (txmax < 0.995 || !dontRenderFaces[5]) {
            this.setTex(5);
            t.func_78375_b(1.0f, 0.0f, 0.0f);
            this.colNP = this.colPP = DefaultPartType.rgb((double)colourR * 0.6, (double)colourG * 0.6, (double)colourB * 0.6);
            this.colPN = this.colPP;
            this.colNN = this.colPP;
            this.getBrightnessXFace(rb, bx, by, bz, rbb.field_72336_d);
            this.setColourAndBrightness(t, rbb.field_72337_e, rbb.field_72339_c);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c, (double)this.uMax + tzmin * (double)(this.uMin - this.uMax), (double)this.vMax + tymax * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72337_e, rbb.field_72334_f);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f, (double)this.uMax + tzmax * (double)(this.uMin - this.uMax), (double)this.vMax + tymax * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72338_b, rbb.field_72334_f);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f, (double)this.uMax + tzmax * (double)(this.uMin - this.uMax), (double)this.vMax + tymin * (double)(this.vMin - this.vMax));
            this.setColourAndBrightness(t, rbb.field_72338_b, rbb.field_72339_c);
            t.func_78374_a(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c, (double)this.uMax + tzmin * (double)(this.uMin - this.uMax), (double)this.vMax + tymin * (double)(this.vMin - this.vMax));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPartInv(RenderBlocks render, ItemStack stack) {
        EnumPosition pos;
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        switch (this.clazz) {
            case Centre: {
                pos = EnumPosition.Centre;
                break;
            }
            case Panel: 
            case HollowPanel: {
                pos = EnumPosition.FaceNZ;
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(0.5f - (float)this.size / 2.0f));
                break;
            }
            case Strip: {
                pos = EnumPosition.EdgeNXNZ;
                GL11.glTranslatef((float)(0.5f - (float)this.size / 2.0f), (float)0.0f, (float)(0.5f - (float)this.size / 2.0f));
                break;
            }
            case Corner: {
                pos = EnumPosition.CornerNXNYNZ;
                GL11.glTranslatef((float)(0.5f - (float)this.size / 2.0f), (float)(0.5f - (float)this.size / 2.0f), (float)(0.5f - (float)this.size / 2.0f));
                break;
            }
            default: {
                pos = EnumPosition.Centre;
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_98187_b("/terrain.png");
        this.overrideIcon = null;
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        this.renderQuads(t, pos);
        t.func_78381_a();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    private void renderAABB(RenderBlocks render, int x, int y, int z, double minx, double miny, double minz, double maxx, double maxy, double maxz, Block block, boolean[] dontRenderFaces) {
        this.renderAABB(Tessellator.field_78398_a, AxisAlignedBB.func_72332_a().func_72299_a(minx, miny, minz, maxx, maxy, maxz).func_72317_d((double)x, (double)y, (double)z), render, x, y, z, block, dontRenderFaces);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPartWorld(RenderBlocks render, Part p, int x, int y, int z, boolean[] dontRenderFaces) {
        this.overrideIcon = render.field_78664_d;
        float i = (float)p.pos.ordinal() / 100000.0f;
        if (this.clazz == EnumPartClass.HollowPanel) {
            float hes = 0.25f;
            float s = (float)this.size;
            switch (p.pos) {
                case FaceNX: {
                    this.renderAABB(render, x, y, z, i, i, i, s, hes, 1.0f - i, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, i, 1.0f - hes, i, s, 1.0f - i, 1.0f - i, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, i, hes, i, s, 1.0f - hes, hes, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, i, hes, 1.0f - hes, s, 1.0f - hes, 1.0f - i, this.modelBlock, dontRenderFaces);
                    break;
                }
                case FacePX: {
                    this.renderAABB(render, x, y, z, 1.0f - s, i, i, 1.0f - i, hes, 1.0f - i, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, 1.0f - s, 1.0f - hes, i, 1.0f - i, 1.0f - i, 1.0f - i, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, 1.0f - s, hes, i, 1.0f - i, 1.0f - hes, hes, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, 1.0f - s, hes, 1.0f - hes, 1.0f - i, 1.0f - hes, 1.0f - i, this.modelBlock, dontRenderFaces);
                    break;
                }
                case FaceNY: {
                    this.renderAABB(render, x, y, z, i, i, i, hes, s, 1.0f - i, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, 1.0f - hes, i, i, 1.0f - i, s, 1.0f - i, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, hes, i, i, 1.0f - hes, s, hes, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, hes, i, 1.0f - hes, 1.0f - hes, s, 1.0f - i, this.modelBlock, dontRenderFaces);
                    break;
                }
                case FacePY: {
                    this.renderAABB(render, x, y, z, i, 1.0f - s, i, hes, 1.0f - i, 1.0f - i, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, 1.0f - hes, 1.0f - s, i, 1.0f - i, 1.0f - i, 1.0f - i, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, hes, 1.0f - s, i, 1.0f - hes, 1.0f - i, hes, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, hes, 1.0f - s, 1.0f - hes, 1.0f - hes, 1.0f - i, 1.0f - i, this.modelBlock, dontRenderFaces);
                    break;
                }
                case FaceNZ: {
                    this.renderAABB(render, x, y, z, i, i, i, hes, 1.0f - i, s, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, 1.0f - hes, i, i, 1.0f - i, 1.0f - i, s, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, hes, i, i, 1.0f - hes, hes, s, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, hes, 1.0f - hes, 0.0, 1.0f - hes, 1.0f - i, s, this.modelBlock, dontRenderFaces);
                    break;
                }
                case FacePZ: {
                    this.renderAABB(render, x, y, z, i, i, 1.0f - s, hes, 1.0f - i, 1.0f - i, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, 1.0f - hes, i, 1.0f - s, 1.0f - i, 1.0f - i, 1.0f - i, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, hes, i, 1.0f - s, 1.0f - hes, hes, 1.0f - i, this.modelBlock, dontRenderFaces);
                    this.renderAABB(render, x, y, z, hes, 1.0f - hes, 1.0f - s, 1.0f - hes, 1.0f - i, 1.0f - i, this.modelBlock, dontRenderFaces);
                    break;
                }
                default: {
                    System.err.println("hollow panel placed at invalid position " + (Object)((Object)p.pos) + " in block " + x + "," + y + "," + z);
                    break;
                }
            }
        } else {
            AxisAlignedBB bb = p.getBoundingBoxFromPool();
            if (bb.field_72340_a == 0.0) {
                bb.field_72340_a = i;
            }
            if (bb.field_72338_b == 0.0) {
                bb.field_72338_b = i;
            }
            if (bb.field_72339_c == 0.0) {
                bb.field_72339_c = i;
            }
            if (bb.field_72336_d == 1.0) {
                bb.field_72336_d -= (double)i;
            }
            if (bb.field_72337_e == 1.0) {
                bb.field_72337_e -= (double)i;
            }
            if (bb.field_72334_f == 1.0) {
                bb.field_72334_f -= (double)i;
            }
            this.renderAABB(render, x, y, z, bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f, this.modelBlock, dontRenderFaces);
        }
    }

    @Override
    public boolean isOpaque() {
        return this.modelBlock.func_71926_d();
    }
}

