/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart;

import java.util.List;
import mrtjp.projectred.multipart.microblocks.IMicroblockCoverSystem;
import mrtjp.projectred.multipart.microblocks.IMicroblockLibrary;
import mrtjp.projectred.multipart.microblocks.IMicroblockSupporterTile2;
import mrtjp.projectred.multipart.microblocks.MicroblockLibrary;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public abstract class TileCoverableBase
extends TileEntity
implements IMicroblockSupporterTile2 {
    protected IMicroblockCoverSystem cover;

    public TileCoverableBase() {
        IMicroblockLibrary ims = MicroblockLibrary.instance.getMicroblockSystem();
        if (ims != null) {
            this.cover = ims.createMicroblockCoverSystem(this);
        }
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        if (this.cover != null) {
            this.cover.writeToNBT(tag);
        }
    }

    public Packet func_70319_e() {
        if (this.cover == null) {
            return null;
        }
        Packet132TileEntityData p = new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, new NBTTagCompound());
        p.field_73331_e.func_74773_a("C", this.cover.writeDescriptionBytes());
        return p;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        if (this.cover != null) {
            this.cover.readDescriptionBytes(pkt.field_73331_e.func_74770_j("C"), 0);
        }
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        if (this.cover != null) {
            this.cover.readFromNBT(tag);
        }
    }

    @Override
    public IMicroblockCoverSystem getCoverSystem() {
        return this.cover;
    }

    protected abstract int getNumTileOwnedParts();

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 src, Vec3 dst) {
        src = src.func_72441_c((double)(-this.field_70329_l), (double)(-this.field_70330_m), (double)(-this.field_70327_n));
        dst = dst.func_72441_c((double)(-this.field_70329_l), (double)(-this.field_70330_m), (double)(-this.field_70327_n));
        int numTOP = this.getNumTileOwnedParts();
        MovingObjectPosition best = null;
        double bestDist = 0.0;
        for (int k = 0; k < numTOP; ++k) {
            MovingObjectPosition _this;
            AxisAlignedBB partBB = this.getPartAABBFromPool(k);
            if (partBB == null || (_this = partBB.func_72327_a(src, dst)) == null) continue;
            double dist = _this.field_72307_f.func_72436_e(src);
            if (best != null && !(dist < bestDist)) continue;
            bestDist = dist;
            best = _this;
            best.subHit = k;
        }
        if (best == null) {
            return null;
        }
        MovingObjectPosition result = new MovingObjectPosition(this.field_70329_l, this.field_70330_m, this.field_70327_n, best.field_72310_e, best.field_72307_f.func_72441_c((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n));
        result.subHit = best.subHit;
        return result;
    }

    @Override
    public void getCollidingBoundingBoxes(AxisAlignedBB mask, List list) {
        for (int k = 0; k < this.getNumTileOwnedParts(); ++k) {
            AxisAlignedBB partBB = this.getPartAABBFromPool(k);
            if (partBB == null || !(partBB = partBB.func_72317_d((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n)).func_72326_a(mask)) continue;
            list.add(partBB);
        }
    }

    @Override
    public void onMicroblocksChanged() {
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

