/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.projectred.multipart.ICoverSystem;
import mrtjp.projectred.multipart.IMultipartTile;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class MultipartHighlightHandler {
    @ForgeSubscribe(receiveCanceled=true)
    public void onBlockHighlightEvent(DrawBlockHighlightEvent event) {
        if (this.onBlockHighlight(event.context, event.player, event.target, event.subID, event.currentItem, event.partialTicks)) {
            event.setCanceled(true);
        }
    }

    public boolean onBlockHighlight(RenderGlobal rg, EntityPlayer player, MovingObjectPosition pos, int pass, ItemStack holding, float partialTick) {
        if (pos.field_72313_a != EnumMovingObjectType.TILE) {
            return false;
        }
        if (pass != 0) {
            return false;
        }
        boolean override = false;
        TileEntity te = player.field_70170_p.func_72796_p(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        AxisAlignedBB hitBB = null;
        ICoverSystem ci = null;
        if (te instanceof IMultipartTile) {
            IMultipartTile ict = (IMultipartTile)te;
            ci = ict.getCoverSystem();
            if (pos.subHit >= 0) {
                hitBB = ict.getPartAABBFromPool(pos.subHit);
            } else if (ci != null) {
                hitBB = ci.getPartAABBFromPool(-1 - pos.subHit);
            }
        }
        if (hitBB != null) {
            this.drawSelectionBox(player, pos, 0, holding, partialTick, hitBB.func_72317_d((double)pos.field_72311_b, (double)pos.field_72312_c, (double)pos.field_72309_d));
            override = true;
        }
        return override;
    }

    private void drawOutlinedBoundingBox(AxisAlignedBB par1AxisAlignedBB) {
        Tessellator var2 = Tessellator.field_78398_a;
        var2.func_78371_b(3);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78381_a();
        var2.func_78371_b(3);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78381_a();
        var2.func_78371_b(1);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72339_c);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72336_d, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72338_b, par1AxisAlignedBB.field_72334_f);
        var2.func_78377_a(par1AxisAlignedBB.field_72340_a, par1AxisAlignedBB.field_72337_e, par1AxisAlignedBB.field_72334_f);
        var2.func_78381_a();
    }

    public void drawSelectionBox(EntityPlayer par1EntityPlayer, MovingObjectPosition par2MovingObjectPosition, int par3, ItemStack par4ItemStack, float par5, AxisAlignedBB box) {
        if (par3 == 0 && par2MovingObjectPosition.field_72313_a == EnumMovingObjectType.TILE) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glLineWidth((float)2.0f);
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            float var6 = 0.002f;
            double var8 = par1EntityPlayer.field_70142_S + (par1EntityPlayer.field_70165_t - par1EntityPlayer.field_70142_S) * (double)par5;
            double var10 = par1EntityPlayer.field_70137_T + (par1EntityPlayer.field_70163_u - par1EntityPlayer.field_70137_T) * (double)par5;
            double var12 = par1EntityPlayer.field_70136_U + (par1EntityPlayer.field_70161_v - par1EntityPlayer.field_70136_U) * (double)par5;
            this.drawOutlinedBoundingBox(box.func_72314_b((double)var6, (double)var6, (double)var6).func_72325_c(-var8, -var10, -var12));
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }
}

