/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.multipart;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mrtjp.projectred.multipart.ICoverSystem;
import mrtjp.projectred.multipart.IMultipartTile;
import mrtjp.projectred.multipart.PartCoordinates;
import mrtjp.projectred.multipart.SynchronizedWeakIdentityListMap;
import mrtjp.projectred.network.PacketHandler;
import mrtjp.projectred.network.packets.MicroblockBreakingPacket;
import mrtjp.projectred.renderstuffs.RenderIDs;
import mrtjp.projectred.utils.BasicUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class BlockMultipartBase
extends BlockContainer {
    private static SynchronizedWeakIdentityListMap breaking_part = new SynchronizedWeakIdentityListMap();
    private static List lastDrop = null;
    static boolean useWrappedRenderType = false;

    public boolean func_71876_u() {
        return false;
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        try {
            IMultipartTile te = (IMultipartTile)world.func_72796_p(x, y, z);
            ICoverSystem ci = te.getCoverSystem();
            if (ci != null) {
                ci.getCollidingBoundingBoxes(mask, list);
            }
            te.getCollidingBoundingBoxes(mask, list);
        }
        catch (ClassCastException e) {
            world.func_72832_d(x, y, z, 0, 0, 2);
        }
    }

    public void harvestBlockMultipart(World world, EntityPlayer ply, int x, int y, int z, int blockMetadata) {
        super.func_71893_a(world, ply, x, y, z, blockMetadata);
    }

    public final boolean canHarvestBlock(EntityPlayer ply, int meta) {
        return true;
    }

    public float getPartHardness(World w, int x, int y, int z, int part) {
        return super.func_71934_m(w, x, y, z);
    }

    public final float func_71934_m(World w, int x, int y, int z) {
        return -1.0f;
    }

    public boolean removeBlockByPlayer(World w, EntityPlayer ply, int x, int y, int z) {
        return BlockMultipartBase.removeBlockByPlayerStatic(w, ply, x, y, z);
    }

    public static boolean removeBlockByPlayerStatic(World w, EntityPlayer ply, int x, int y, int z) {
        if (ply.field_70170_p.field_72995_K) {
            if (ply.field_71075_bZ.field_75098_d) {
                BlockMultipartBase.updateBreakingPart(x, y, z);
            }
            breaking_part.remove(ply);
            return true;
        }
        PartCoordinates coord = BlockMultipartBase.getBreakingPart(ply);
        breaking_part.remove(ply);
        if (coord == null || coord.x != x || coord.y != y || coord.z != z) {
            return false;
        }
        TileEntity te = w.func_72796_p(x, y, z);
        if (!(te instanceof IMultipartTile)) {
            return false;
        }
        lastDrop = !coord.isCoverSystemPart ? ((IMultipartTile)te).removePartByPlayer(ply, coord.part) : ((IMultipartTile)te).getCoverSystem().removePartByPlayer(ply, coord.part);
        return true;
    }

    static PartCoordinates getBreakingPart(EntityPlayer ply) {
        return (PartCoordinates)breaking_part.get(ply);
    }

    public void func_71921_a(World w, int i, int j, int k, EntityPlayer ply) {
        BlockMultipartBase.onBlockClickedStatic(w, ply);
    }

    public static void onBlockClickedStatic(World w, EntityPlayer ply) {
        if (w.field_72995_K) {
            breaking_part.remove(ply);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void sendDigStart() {
        PartCoordinates coord = BlockMultipartBase.getBreakingPart((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (coord != null) {
            MicroblockBreakingPacket packet = (MicroblockBreakingPacket)PacketHandler.getPacket(MicroblockBreakingPacket.class);
            packet.setIsCSPart(coord.isCoverSystemPart);
            packet.part = coord.part;
            packet.posX = coord.x;
            packet.posY = coord.y;
            packet.posZ = coord.z;
            BasicUtils.sendPacketToServer(packet.getPacket());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean updateBreakingPart(int x, int y, int z) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        PartCoordinates old = BlockMultipartBase.getBreakingPart((EntityPlayer)player);
        MovingObjectPosition ray = player.func_70614_a(BasicUtils.getPlayerReach((EntityPlayer)player), 0.0f);
        PartCoordinates _new = null;
        if (ray == null || ray.field_72313_a != EnumMovingObjectType.TILE || ray.field_72311_b != x || ray.field_72312_c != y || ray.field_72309_d != z) {
            breaking_part.remove(player);
        } else if (ray.subHit >= 0) {
            _new = new PartCoordinates(x, y, z, ray.subHit, false);
            breaking_part.put(player, _new);
        } else {
            _new = new PartCoordinates(x, y, z, -1 - ray.subHit, true);
            breaking_part.put(player, _new);
        }
        boolean changed = old == null && _new != null || old != null && !old.equals(_new);
        BlockMultipartBase.sendDigStart();
        if (changed) {
            BlockMultipartBase.resetBreakProgress((EntityPlayer)player);
        }
        return _new != null;
    }

    private static void resetBreakProgress(EntityPlayer ply) {
    }

    public final float func_71908_a(EntityPlayer ply, World world, int x, int y, int z) {
        return BlockMultipartBase.getPlayerRelativeBlockHardnessStatic(ply, world, x, y, z);
    }

    public static float getPlayerRelativeBlockHardnessStatic(EntityPlayer ply, World world, int x, int y, int z) {
        PartCoordinates part;
        if (world.field_72995_K) {
            BlockMultipartBase.updateBreakingPart(x, y, z);
        }
        if ((part = BlockMultipartBase.getBreakingPart(ply)) == null || part.x != x || part.y != y || part.z != z) {
            return 0.0f;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (te == null || !(te instanceof IMultipartTile)) {
            return 0.01f;
        }
        if (!part.isCoverSystemPart) {
            return ((IMultipartTile)te).getPlayerRelativePartHardness(ply, part.part);
        }
        ICoverSystem ci = ((IMultipartTile)te).getCoverSystem();
        return ci == null ? -1.0f : ci.getPlayerRelativePartHardness(ply, part.part);
    }

    public final ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        return BlockMultipartBase.getBlockDroppedStatic();
    }

    public static final ArrayList getBlockDroppedStatic() {
        if (lastDrop == null) {
            return new ArrayList();
        }
        ArrayList rv = new ArrayList(lastDrop);
        lastDrop = null;
        return rv;
    }

    void setAABB(AxisAlignedBB aabb) {
        this.field_72026_ch = aabb.field_72340_a;
        this.field_72023_ci = aabb.field_72338_b;
        this.field_72024_cj = aabb.field_72339_c;
        this.field_72021_ck = aabb.field_72336_d;
        this.field_72022_cl = aabb.field_72337_e;
        this.field_72019_cm = aabb.field_72334_f;
    }

    protected BlockMultipartBase(int id, Material mat) {
        super(id, mat);
    }

    public MovingObjectPosition wrappedCollisionRayTrace(World world, int i, int j, int k, Vec3 vec3d, Vec3 vec3d1) {
        return null;
    }

    public final MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 src, Vec3 dst) {
        try {
            double tileDist;
            IMultipartTile tile = (IMultipartTile)world.func_72796_p(x, y, z);
            ICoverSystem ci = tile.getCoverSystem();
            MovingObjectPosition ciPos = ci == null ? null : ci.collisionRayTrace(src, dst);
            MovingObjectPosition tilePos = this.wrappedCollisionRayTrace(world, x, y, z, src, dst);
            if (tilePos != null && tilePos.subHit < 0) {
                throw new AssertionError((Object)"wrappedCollisionRayTrace must return a non-negative subHit");
            }
            if (tilePos == null) {
                tilePos = tile.collisionRayTrace(src, dst);
            }
            if (tilePos != null && tilePos.subHit < 0) {
                throw new AssertionError((Object)"ICoverableTile.collisionRayTrace must return a non-negative subHit");
            }
            if (tilePos == null) {
                return ciPos;
            }
            if (ciPos == null) {
                return tilePos;
            }
            double ciDist = ciPos.field_72307_f.func_72436_e(src);
            return ciDist < (tileDist = tilePos.field_72307_f.func_72436_e(src)) ? ciPos : tilePos;
        }
        catch (ClassCastException e) {
            world.func_72832_d(x, y, z, 0, 0, 2);
            return super.func_71878_a(world, x, y, z, src, dst);
        }
    }

    public final boolean func_71926_d() {
        return false;
    }

    public final boolean func_71886_c() {
        return false;
    }

    public int wrappedGetRenderType() {
        return 0;
    }

    public final int func_71857_b() {
        return useWrappedRenderType ? this.wrappedGetRenderType() : RenderIDs.renderIdMicroblock;
    }

    public static int getRenderTypeStatic(int i) {
        return useWrappedRenderType ? i : RenderIDs.renderIdMicroblock;
    }

    public static String getTextureFileStatic(String s) {
        return useWrappedRenderType ? s : "/terrain.png";
    }

    public static void setBreakingPart(EntityPlayer source, PartCoordinates part) {
        if (part == null) {
            breaking_part.remove(source);
        } else {
            breaking_part.put(source, part);
        }
        if (source.field_71075_bZ.field_75098_d) {
            BlockMultipartBase.removeBlockByPlayerStatic(source.field_70170_p, source, part.x, part.y, part.z);
        }
    }

    public final int func_71873_h(World par1World, int par2, int par3, int par4) {
        return 0;
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        IMultipartTile te = (IMultipartTile)world.func_72796_p(x, y, z);
        if (te == null) {
            return null;
        }
        if (target.subHit >= 0) {
            return te.pickPart(target, target.subHit);
        }
        ICoverSystem ci = te.getCoverSystem();
        return ci == null ? null : ci.pickPart(target, -1 - target.subHit);
    }

    public boolean func_71877_c(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        IMultipartTile imt = (IMultipartTile)world.func_72796_p(x, y, z);
        if (imt.isSolidOnSide(side)) {
            return true;
        }
        ICoverSystem ci = imt.getCoverSystem();
        return ci != null && ci.isSolidOnSide(side);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInvBlock(RenderBlocks render, int meta) {
        BlockMultipartBase.renderInvBlockStatic(render, (Block)this, meta);
    }

    public static void renderInvBlockStatic(RenderBlocks render, Block block, int meta) {
        useWrappedRenderType = true;
        render.func_78600_a(block, meta, 1.0f);
        useWrappedRenderType = false;
    }

    public static void renderBlockStatic(RenderBlocks render, Block block, int x, int y, int z) {
        useWrappedRenderType = true;
        render.func_78612_b(block, x, y, z);
        useWrappedRenderType = false;
    }

    public static Iterable getBreakingParts() {
        return breaking_part.entries();
    }
}

