/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mrtjp.projectred.ProjectRed;
import mrtjp.projectred.crafting.ProjectRedTabs;
import mrtjp.projectred.tiles.TileAlloySmelter;
import mrtjp.projectred.tiles.TileMachineBase;
import mrtjp.projectred.utils.BasicUtils;
import mrtjp.projectred.utils.Coords;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachines
extends BlockContainer {
    public Icon[][] machineIcons = new Icon[EnumMachine.VALID_MACHINES.length][6];
    public Icon[][] specialIcons = new Icon[EnumMachine.VALID_MACHINES.length][6];

    public BlockMachines(int id) {
        super(id, new Material(Material.field_76243_f.field_76234_F));
        this.func_71849_a(ProjectRedTabs.tabMachines);
        this.func_71848_c(0.75f);
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        try {
            return (TileEntity)EnumMachine.get((int)metadata).clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileMachineBase tile = (TileMachineBase)BasicUtils.getTileEntity((IBlockAccess)world, new Coords(x, y, z), TileMachineBase.class);
        if (tile != null) {
            tile.onBlockBreak();
        }
        super.func_71852_a(world, x, y, z, par5, par6);
        world.func_72932_q(x, y, z);
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        TileMachineBase tile = (TileMachineBase)BasicUtils.getTileEntity((IBlockAccess)world, new Coords(x, y, z), TileMachineBase.class);
        if (tile != null) {
            tile.onBlockClicked(player);
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileMachineBase tile = (TileMachineBase)BasicUtils.getTileEntity((IBlockAccess)world, new Coords(x, y, z), TileMachineBase.class);
        if (tile != null) {
            return tile.onBlockActivated(player);
        }
        return false;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving entity, ItemStack itemstack) {
        TileMachineBase tile = (TileMachineBase)BasicUtils.getTileEntity((IBlockAccess)world, new Coords(x, y, z), TileMachineBase.class);
        if (tile != null) {
            tile.onBlockPlaced(entity, itemstack);
        }
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumMachine machine : EnumMachine.VALID_MACHINES) {
            list.add(new ItemStack(id, 1, machine.meta));
        }
    }

    public void func_94332_a(IconRegister reg) {
        for (EnumMachine m : EnumMachine.VALID_MACHINES) {
            for (int i = 0; i < 6; ++i) {
                this.machineIcons[m.meta][i] = reg.func_94245_a("projectred:machines/" + m.iconPath[i]);
                this.specialIcons[m.meta][i] = reg.func_94245_a("projectred:machines/" + m.specialIconPath[i]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess access, int x, int y, int z, int side) {
        TileMachineBase tile = (TileMachineBase)BasicUtils.getTileEntity(access, new Coords(x, y, z), TileMachineBase.class);
        if (tile != null) {
            return this.getRotatedTexture(side, access.func_72805_g(x, y, z), tile.rotation, tile);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return this.getRotatedTexture(side, meta, 2, null);
    }

    public Icon getRotatedTexture(int side, int meta, int rotation, TileMachineBase tile) {
        if (meta > EnumMachine.VALID_MACHINES.length - 1 || side > 6 || rotation > 6) {
            return null;
        }
        boolean useSpecial = false;
        if (tile != null) {
            useSpecial = tile.shouldUseSpecialTextureForSide(side);
        }
        if (side == 0) {
            return useSpecial ? this.specialIcons[meta][0] : this.machineIcons[meta][0];
        }
        if (side == 1) {
            return useSpecial ? this.specialIcons[meta][1] : this.machineIcons[meta][1];
        }
        switch (side) {
            case 2: {
                switch (rotation) {
                    case 2: {
                        return useSpecial ? this.specialIcons[meta][2] : this.machineIcons[meta][2];
                    }
                    case 3: {
                        return useSpecial ? this.specialIcons[meta][3] : this.machineIcons[meta][3];
                    }
                    case 4: {
                        return useSpecial ? this.specialIcons[meta][4] : this.machineIcons[meta][4];
                    }
                    case 5: {
                        return useSpecial ? this.specialIcons[meta][5] : this.machineIcons[meta][5];
                    }
                }
            }
            case 3: {
                switch (rotation) {
                    case 2: {
                        return useSpecial ? this.specialIcons[meta][3] : this.machineIcons[meta][3];
                    }
                    case 3: {
                        return useSpecial ? this.specialIcons[meta][2] : this.machineIcons[meta][2];
                    }
                    case 4: {
                        return useSpecial ? this.specialIcons[meta][5] : this.machineIcons[meta][5];
                    }
                    case 5: {
                        return useSpecial ? this.specialIcons[meta][4] : this.machineIcons[meta][4];
                    }
                }
            }
            case 4: {
                switch (rotation) {
                    case 2: {
                        return useSpecial ? this.specialIcons[meta][5] : this.machineIcons[meta][5];
                    }
                    case 3: {
                        return useSpecial ? this.specialIcons[meta][4] : this.machineIcons[meta][4];
                    }
                    case 4: {
                        return useSpecial ? this.specialIcons[meta][2] : this.machineIcons[meta][2];
                    }
                    case 5: {
                        return useSpecial ? this.specialIcons[meta][3] : this.machineIcons[meta][3];
                    }
                }
            }
            case 5: {
                switch (rotation) {
                    case 2: {
                        return useSpecial ? this.specialIcons[meta][4] : this.machineIcons[meta][4];
                    }
                    case 3: {
                        return useSpecial ? this.specialIcons[meta][5] : this.machineIcons[meta][5];
                    }
                    case 4: {
                        return useSpecial ? this.specialIcons[meta][3] : this.machineIcons[meta][3];
                    }
                    case 5: {
                        return useSpecial ? this.specialIcons[meta][2] : this.machineIcons[meta][2];
                    }
                }
            }
        }
        return null;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileMachineBase tile = (TileMachineBase)BasicUtils.getTileEntity(world, new Coords(x, y, z), TileMachineBase.class);
        if (tile != null) {
            return tile.getLightLevel();
        }
        return 0;
    }

    public static enum EnumMachine {
        ALLOYSMELTER("Alloy Smelter", "machinealloy", TileAlloySmelter.class, new String[]{"smeltertop", "smeltertop", "smelterside", "smelterfront", "smelterside", "smelterside", "smeltertop", "smeltertop", "smelterside", "smelterfronton", "smelterside", "smelterside"}),
        BARREL("Barrel", "machinebarrel", null, new String[]{"", "", "", "", "", "", "", "", "", "", "", ""}),
        INVALIDMACHINE("INVALID", "ERROR!!!", null, new String[]{"", "", "", "", "", "", "", "", "", "", "", ""});

        public static final EnumMachine[] VALID_MACHINES;
        public String fullname;
        public String unlocalname;
        public Class clazz;
        public int meta = this.ordinal();
        public String[] iconPath = new String[6];
        public String[] specialIconPath = new String[6];

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private EnumMachine(Class name, String ... unlocal) {
            void sides;
            void tile;
            this.fullname = name;
            this.unlocalname = unlocal;
            this.clazz = tile;
            this.iconPath[0] = sides[0];
            this.iconPath[1] = sides[1];
            this.iconPath[2] = sides[2];
            this.iconPath[3] = sides[3];
            this.iconPath[4] = sides[4];
            this.iconPath[5] = sides[5];
            this.specialIconPath[0] = sides[6];
            this.specialIconPath[1] = sides[7];
            this.specialIconPath[2] = sides[8];
            this.specialIconPath[3] = sides[9];
            this.specialIconPath[4] = sides[10];
            this.specialIconPath[5] = sides[11];
        }

        public static EnumMachine get(int ordinal) {
            if (ordinal > VALID_MACHINES.length - 1) {
                return INVALIDMACHINE;
            }
            return VALID_MACHINES[ordinal];
        }

        public ItemStack getItemStack() {
            return this.getItemStack(1);
        }

        public ItemStack getItemStack(int i) {
            return new ItemStack((Block)ProjectRed.blockMachines, i, this.meta);
        }

        static {
            VALID_MACHINES = new EnumMachine[]{ALLOYSMELTER};
        }
    }
}

