/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import java.util.Random;
import mrtjp.projectred.core.fx.ParticleLogic;

public final class ParticleLogicOrbitEntity
extends ParticleLogic {
    private final nn target;
    private double distance;
    private final boolean rotateClockwise;
    private double targetY;
    private double curYOffset;
    private double targetDistance;
    private final double orbitSpeed;
    private double orbitAngle;
    private double orbitY = -512.0;
    private boolean ignoreYCoordinate = false;

    public ParticleLogicOrbitEntity(nn nn2, double d) {
        this.target = nn2;
        this.orbitAngle = this.rand.nextInt(360);
        this.rotateClockwise = this.rand.nextBoolean();
        this.generateNewTargetY();
        this.targetDistance = 1.0 + this.rand.nextDouble() * 0.5;
        this.orbitSpeed = d;
    }

    public ParticleLogicOrbitEntity setOrbitY(double d) {
        this.orbitY = d;
        return this;
    }

    public ParticleLogicOrbitEntity setTargetDistance(double d) {
        this.targetDistance = d;
        return this;
    }

    private void generateNewTargetY() {
        this.targetY = this.target != null ? new Random().nextDouble() * (double)this.target.P : 0.0;
    }

    private void generateNewDistance() {
        this.targetDistance = this.target != null ? new Random().nextDouble() * 2.0 : 0.0;
    }

    @Override
    public void doUpdate() {
        if (this.firstTick) {
            this.curYOffset = this.particle.v - (this.target.v + (double)this.target.f());
        }
        if (this.target == null || this.target.M) {
            this.finishLogic();
            return;
        }
        double d = this.particle.v;
        if (Math.abs(this.targetY - this.curYOffset) < 0.1) {
            this.generateNewTargetY();
        }
        double d2 = this.target.u + Math.cos(this.orbitAngle) * this.targetDistance;
        double d3 = this.target.w + Math.sin(this.orbitAngle) * this.targetDistance;
        if (this.targetY < this.curYOffset) {
            this.curYOffset -= this.orbitSpeed / 4.0;
        } else if (this.targetY > this.curYOffset) {
            this.curYOffset += this.orbitSpeed / 4.0;
        }
        this.orbitAngle = this.rotateClockwise ? (this.orbitAngle += this.orbitSpeed) : (this.orbitAngle -= this.orbitSpeed);
        if (this.orbitAngle > 360.0) {
            this.orbitAngle -= 360.0;
        } else if (this.orbitAngle < 0.0) {
            this.orbitAngle += 360.0;
        }
        if (!this.ignoreYCoordinate) {
            if (this.orbitY != -512.0) {
                d = this.target.v + (double)this.target.f() + this.orbitY;
            } else {
                int n = 0;
                if (this.target instanceof uf && !(this.target instanceof bdi)) {
                    n = (int)((float)n + 2.0f * this.target.P);
                }
                d = this.target.v - (double)this.target.f() + this.curYOffset + (double)n;
            }
        }
        this.particle.b(d2, d, d3);
    }

    @Override
    public ParticleLogic clone() {
        ParticleLogicOrbitEntity particleLogicOrbitEntity = new ParticleLogicOrbitEntity(this.target, this.orbitSpeed).setTargetDistance(this.targetDistance);
        if (this.orbitY != -512.0) {
            particleLogicOrbitEntity.setOrbitY(this.orbitY);
        }
        particleLogicOrbitEntity.setIgnoreYCoordinate(this.ignoreYCoordinate);
        return particleLogicOrbitEntity.setFinal(this.finalLogic).setPriority(this.priority);
    }

    public ParticleLogicOrbitEntity setIgnoreYCoordinate(boolean bl) {
        this.ignoreYCoordinate = bl;
        return this;
    }
}

