/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.fx.ParticleLogic;
import mrtjp.projectred.core.utils.MathLib;

public class ParticleLogicArcToPoint
extends ParticleLogic {
    private final Vector3 start;
    private final Vector3 target;
    private Vector3 firstControl;
    private Vector3 secondControl;
    private float percent;
    private float speed;
    private final float offsetFactor;
    private final float halfOffsetFactor;

    public ParticleLogicArcToPoint(Vector3 vector3, Vector3 vector32) {
        this.start = vector3.copy();
        this.target = vector32.copy();
        this.percent = 0.0f;
        this.speed = 0.03f;
        this.offsetFactor = 10.0f;
        this.halfOffsetFactor = this.offsetFactor / 2.0f;
        this.generateControlPoints();
    }

    public ParticleLogicArcToPoint generateControlPoints() {
        this.firstControl = new Vector3(this.start.x + (this.target.x - this.start.x) / 3.0, this.start.y + (this.target.y - this.start.y) / 3.0, this.start.z + (this.target.z - this.start.z) / 3.0);
        this.secondControl = new Vector3(this.start.x + (this.target.x - this.start.x) / 3.0 * 2.0, this.start.y + (this.target.y - this.start.y) / 3.0 * 2.0, this.start.z + (this.target.z - this.start.z) / 3.0 * 2.0);
        double d = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double d2 = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double d3 = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        Vector3 vector3 = new Vector3(d, d3, d2);
        this.firstControl = this.firstControl.add(vector3);
        this.secondControl = this.secondControl.add(vector3);
        return this;
    }

    public ParticleLogicArcToPoint setControlPoints(Vector3 vector3, Vector3 vector32) {
        this.firstControl = vector3;
        this.secondControl = vector32;
        return this;
    }

    public ParticleLogicArcToPoint setSpeed(float f) {
        this.speed = f;
        return this;
    }

    @Override
    public void doUpdate() {
        this.percent += this.speed;
        if (this.percent >= 1.0f) {
            this.finishLogic();
            return;
        }
        Vector3 vector3 = MathLib.bezier(this.start, this.firstControl, this.secondControl, this.target, this.percent);
        this.particle.b(vector3.x, vector3.y, vector3.z);
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicArcToPoint(this.particle.position(), this.target).setSpeed(this.speed).setControlPoints(this.firstControl, this.secondControl).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

