/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.fx.ParticleLogic;

public class ParticleLogicApproachPoint
extends ParticleLogic {
    protected double targetX;
    protected double targetY;
    protected double targetZ;
    protected double approachSpeed;
    protected double targetDistance;
    protected boolean ignoreY;

    public ParticleLogicApproachPoint(Vector3 vector3, double d, double d2) {
        this.targetX = vector3.x;
        this.targetY = vector3.y;
        this.targetZ = vector3.z;
        this.approachSpeed = d;
        this.targetDistance = d2;
    }

    private double getDistanceSqToPoint(double d, double d2, double d3) {
        double d4 = this.particle.u - d;
        double d5 = this.particle.v - d2;
        double d6 = this.particle.w - d3;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    public ParticleLogicApproachPoint setIgnoreY(boolean bl) {
        this.ignoreY = bl;
        return this;
    }

    @Override
    public void doUpdate() {
        double d;
        double d2;
        double d3 = this.particle.u;
        double d4 = this.particle.w;
        double d5 = this.particle.v;
        double d6 = this.getDistanceSqToPoint(this.targetX, this.targetY, this.targetZ);
        double d7 = this.targetZ - this.particle.w;
        double d8 = this.targetX - this.particle.u;
        if (Math.abs(d8) > this.targetDistance || Math.abs(d7) > this.targetDistance) {
            d = d2 = Math.atan2(d7, d8);
            d3 = this.particle.u + this.approachSpeed * Math.cos(d);
            d4 = this.particle.w + this.approachSpeed * Math.sin(d);
        }
        if (!this.ignoreY) {
            d2 = d5 - this.targetY;
            d = ls.a((double)(d8 * d8 + d7 * d7));
            float f = (float)(-Math.atan2(d2, d));
            double d9 = f;
            d5 = this.particle.v + this.approachSpeed * Math.sin(d9);
        }
        if (d6 <= this.targetDistance * this.targetDistance) {
            this.onDestinationReached();
        } else {
            this.particle.b(d3, d5, d4);
        }
    }

    public void onDestinationReached() {
        this.finishLogic();
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicApproachPoint(new Vector3(this.targetX, this.targetY, this.targetZ), this.approachSpeed, this.targetDistance).setIgnoreY(this.ignoreY).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

