/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.integration.BundledGatePart;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.RedstoneGateLogic;
import mrtjp.projectred.transmission.BundledCommons;
import net.minecraft.nbt.NBTTagCompound;

public abstract class BundledGateLogic
extends RedstoneGateLogic<BundledGatePart> {
    public BundledGatePart gate;

    public static BundledGateLogic create(BundledGatePart gate, int subID) {
        if (subID == 22) {
            return new BusTransceiver(gate);
        }
        return null;
    }

    public BundledGateLogic(BundledGatePart gate) {
        this.gate = gate;
    }

    @Override
    public boolean canConnectTo(BundledGatePart gate, IConnectable wire, int r) {
        if (super.canConnectTo(gate, wire, r)) {
            return true;
        }
        if (wire instanceof IBundledEmitter) {
            return this.canConnectBundled(gate, r);
        }
        return false;
    }

    public boolean canConnectBundled(BundledGatePart gate, int r) {
        return this.canConnectBundled(gate.shape(), r);
    }

    public boolean canConnectBundled(int shape, int r) {
        return ((this.bundledInputMask(shape) | this.bundledOutputMask(shape)) & 1 << r) != 0;
    }

    public int bundledInputMask(int shape) {
        return 0;
    }

    public int bundledOutputMask(int shape) {
        return 0;
    }

    @Override
    public int getOutput(BundledGatePart gate, int r) {
        return (gate.state & 16 << r) != 0 ? 15 : 0;
    }

    public byte[] getBundledOutput(BundledGatePart gate, int r) {
        return null;
    }

    @Override
    public void onChange(BundledGatePart gate) {
    }

    @Override
    public void scheduledTick(BundledGatePart gate) {
    }

    public void save(NBTTagCompound tag) {
    }

    public void load(NBTTagCompound tag) {
    }

    public void readDesc(MCDataInput packet) {
    }

    public void writeDesc(MCDataOutput packet) {
    }

    public void read(MCDataInput packet, int switch_key) {
    }

    public static class BusTransceiver
    extends BundledGateLogic {
        public byte[] input0;
        public byte[] output0;
        public byte[] input2;
        public byte[] output2;

        public BusTransceiver(BundledGatePart gate) {
            super(gate);
        }

        @Override
        public void save(NBTTagCompound tag) {
            BundledCommons.saveSignal(tag, "in0", this.input0);
            BundledCommons.saveSignal(tag, "out0", this.output0);
            BundledCommons.saveSignal(tag, "in2", this.input2);
            BundledCommons.saveSignal(tag, "out2", this.output2);
        }

        @Override
        public void load(NBTTagCompound tag) {
            this.input0 = BundledCommons.loadSignal(tag, "in0");
            this.input2 = BundledCommons.loadSignal(tag, "in2");
            this.output0 = BundledCommons.loadSignal(tag, "out0");
            this.output2 = BundledCommons.loadSignal(tag, "out2");
        }

        @Override
        public void readDesc(MCDataInput packet) {
            this.unpackClientData(packet.readInt());
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            packet.writeInt(this.packClientData());
        }

        @Override
        public void read(MCDataInput packet, int switch_key) {
            if (switch_key == 11) {
                this.unpackClientData(packet.readInt());
            }
        }

        public void sendClientUpdate() {
            this.gate.getWriteStream(11).writeInt(this.packClientData());
        }

        public int packClientData() {
            return BundledCommons.packDigital(this.output0) | BundledCommons.packDigital(this.output2) << 16;
        }

        public void unpackClientData(int packed) {
            this.output0 = BundledCommons.unpackDigital(this.output0, packed & 0xFFFF);
            this.output2 = BundledCommons.unpackDigital(this.output2, packed >>> 16);
        }

        @Override
        public int bundledInputMask(int shape) {
            return 5;
        }

        @Override
        public int bundledOutputMask(int shape) {
            return 5;
        }

        @Override
        public int inputMask(int shape) {
            return 10;
        }

        @Override
        public int outputMask(int shape) {
            return 0;
        }

        @Override
        public byte[] getBundledOutput(BundledGatePart gate, int r) {
            return r == 0 ? this.output0 : this.output2;
        }

        public byte[] getBundledInput(int r) {
            return BundledCommons.raiseSignal(BundledCommons.copySignal(this.gate.getBundledInput(r)), this.getBundledOutput(this.gate, r));
        }

        @Override
        public void onChange(BundledGatePart gate) {
            byte[] newInput2;
            byte[] newInput0;
            int newInput;
            int oldInput = gate.state() & 0xF;
            if (oldInput != (newInput = this.getInput(gate, 10))) {
                gate.setState(gate.state() & 0xF0 | newInput);
                gate.onInputChange();
            }
            if (!BundledCommons.signalsEqual(this.input0, newInput0 = this.getBundledInput(0))) {
                this.input0 = newInput0;
                gate.onInputChange();
            }
            if (!BundledCommons.signalsEqual(this.input2, newInput2 = this.getBundledInput(2))) {
                this.input2 = newInput2;
                gate.onInputChange();
            }
            if (gate.shape() == 1) {
                newInput = GatePart.flipMaskZ(newInput);
            }
            if (!BundledCommons.signalsEqual(this.output0, this.calcBundledOutput(0)) || !BundledCommons.signalsEqual(this.output2, this.calcBundledOutput(2))) {
                gate.scheduleTick(2);
            }
        }

        public byte[] calcBundledOutput(int r) {
            int input = this.gate.state() & 0xF;
            if (this.gate.shape() == 1) {
                input = GatePart.flipMaskZ(input);
            }
            if (r == 0) {
                return (input & 2) != 0 ? this.input2 : null;
            }
            if (r == 2) {
                return (input & 8) != 0 ? this.input0 : null;
            }
            return null;
        }

        @Override
        public void scheduledTick(BundledGatePart gate) {
            this.output0 = this.calcBundledOutput(0);
            this.output2 = this.calcBundledOutput(2);
            this.onChange(gate);
            gate.onOutputChange(5);
            this.sendClientUpdate();
        }

        @Override
        public boolean cycleShape(BundledGatePart gate) {
            gate.setShape(gate.shape() == 0 ? 1 : 0);
            return true;
        }

        @Override
        public int lightLevel() {
            return 0;
        }
    }
}

