/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.FaceMicroClass;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.PartMap;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.BasicWireUtils;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.WireConnLib;
import mrtjp.projectred.integration.ComponentStore;
import mrtjp.projectred.integration.EnumGate;
import mrtjp.projectred.integration.GateLogic;
import mrtjp.projectred.integration.RenderGate;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class GatePart
extends JCuboidPart
implements JNormalOcclusion,
IConnectable,
TFacePart,
JIconHitEffects {
    public static Cuboid6[][] oBoxes = new Cuboid6[6][2];
    public byte orientation;
    public byte subID;
    public byte shape;
    public int connMap;
    public long schedTime;

    public abstract GateLogic getLogic();

    public int side() {
        return this.orientation >> 2;
    }

    public void setSide(int n) {
        this.orientation = (byte)(this.orientation & 3 | n << 2);
    }

    public int rotation() {
        return this.orientation & 3;
    }

    public void setRotation(int n) {
        this.orientation = (byte)(this.orientation & 0xFC | n);
    }

    public int shape() {
        return this.shape & 0xFF;
    }

    public void setShape(int n) {
        this.shape = (byte)n;
    }

    public Transformation rotationT() {
        return Rotation.sideOrientation((int)this.side(), (int)this.rotation()).at(Vector3.center);
    }

    public void preparePlacement(uf uf2, BlockCoord blockCoord, int n, int n2) {
        this.subID = (byte)n2;
        this.setSide(n ^ 1);
        this.setRotation(Rotation.getSidedRotation((uf)uf2, (int)n));
    }

    public void save(by by2) {
        by2.a("orient", this.orientation);
        by2.a("subID", this.subID);
        by2.a("shape", this.shape);
        by2.a("connMap", (short)this.connMap);
        by2.a("schedTime", this.schedTime);
    }

    public void load(by by2) {
        this.orientation = by2.c("orient");
        this.subID = by2.c("subID");
        this.shape = by2.c("shape");
        this.connMap = by2.d("connMap") & 0xFFFF;
        this.schedTime = by2.f("schedTime");
    }

    public void readDesc(MCDataInput mCDataInput) {
        this.orientation = mCDataInput.readByte();
        this.subID = mCDataInput.readByte();
        this.shape = mCDataInput.readByte();
    }

    public void read(MCDataInput mCDataInput) {
        this.read(mCDataInput, mCDataInput.readUByte());
    }

    public void read(MCDataInput mCDataInput, int n) {
        if (n == 0) {
            this.orientation = mCDataInput.readByte();
            if (Configurator.staticGates) {
                this.tile().markRender();
            }
        } else if (n == 1) {
            this.shape = mCDataInput.readByte();
            if (Configurator.staticGates) {
                this.tile().markRender();
            }
        }
    }

    public void writeDesc(MCDataOutput mCDataOutput) {
        mCDataOutput.writeByte((int)this.orientation);
        mCDataOutput.writeByte((int)this.subID);
        mCDataOutput.writeByte((int)this.shape);
    }

    public void scheduleTick(int n) {
        if (this.schedTime < 0L) {
            this.schedTime = this.world().I() + (long)n;
        }
    }

    private void processScheduled() {
        if (this.schedTime >= 0L && this.world().I() >= this.schedTime) {
            this.schedTime = -1L;
            this.scheduledTick();
        }
    }

    public void onChange() {
        this.processScheduled();
        this.getLogic().onChange(this);
    }

    public void update() {
        if (!this.world().I) {
            this.processScheduled();
        }
        this.getLogic().onTick(this);
    }

    public void onPartChanged(TMultiPart tMultiPart) {
        if (!this.world().I) {
            this.updateInternalConnections();
            this.onChange();
        }
    }

    public void onNeighborChanged() {
        if (!this.world().I) {
            if (this.dropIfCantStay()) {
                return;
            }
            this.updateExternalConnections();
            this.onChange();
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.world().I) {
            this.getLogic().setup(this);
            this.updateConnections();
            this.onChange();
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().I) {
            this.notifyNeighbors(15);
        }
    }

    public boolean canStay() {
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(this.side());
        return BasicWireUtils.canPlaceWireOnSide((abw)this.world(), (int)blockCoord.x, (int)blockCoord.y, (int)blockCoord.z, (ForgeDirection)ForgeDirection.getOrientation((int)(this.side() ^ 1)), (boolean)false);
    }

    public boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        TileMultipart.dropItem((ye)this.getItem(), (abw)this.world(), (Vector3)Vector3.fromTileEntityCenter((asp)this.tile()));
        this.tile().remPart((TMultiPart)this);
    }

    public EnumGate getGateType() {
        return EnumGate.VALID_GATES[this.subID & 0xFF];
    }

    protected void updateConnections() {
        this.updateInternalConnections();
        this.updateExternalConnections();
    }

    protected boolean updateExternalConnections() {
        int n;
        int n2 = 0;
        for (n = 0; n < 4; ++n) {
            if (this.connectStraight(n)) {
                n2 |= 16 << n;
                continue;
            }
            if (!this.connectCorner(n)) continue;
            n2 |= 1 << n;
        }
        if (n2 != (this.connMap & 0xF000FF)) {
            n = this.connMap ^ n2;
            this.connMap = this.connMap & 0xFF0FFF00 | n2;
            for (int i = 0; i < 4; ++i) {
                if ((n & 1 << i) == 0) continue;
                this.notifyCornerChange(i);
            }
            return true;
        }
        return false;
    }

    protected boolean updateInternalConnections() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.connectInternal(i)) continue;
            n |= 256 << i;
        }
        if (n != (this.connMap & 0x10F00)) {
            this.connMap = this.connMap & 0xFFFEF0FF | n;
            return true;
        }
        return false;
    }

    public boolean connectCorner(int n) {
        TMultiPart tMultiPart;
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile());
        blockCoord.offset(n2);
        if (!WireConnLib.canConnectThroughCorner((abw)this.world(), (BlockCoord)blockCoord, (int)(n2 ^ 1), (int)this.side())) {
            return false;
        }
        blockCoord.offset(this.side());
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null && (tMultiPart = tileMultipart.partMap(n2 ^ 1)) instanceof IConnectable) {
            IConnectable iConnectable = (IConnectable)tMultiPart;
            int n3 = Rotation.rotationTo((int)(n2 ^ 1), (int)(this.side() ^ 1));
            return this.canConnectTo(iConnectable, n) && iConnectable.canConnectCorner(n3) && iConnectable.connectCorner((IConnectable)this, n3, -1);
        }
        return false;
    }

    public boolean connectStraight(int n) {
        TMultiPart tMultiPart;
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null && (tMultiPart = tileMultipart.partMap(this.side())) instanceof IConnectable) {
            IConnectable iConnectable = (IConnectable)tMultiPart;
            return this.canConnectTo(iConnectable, n) && iConnectable.connectStraight((IConnectable)this, (n + 2) % 4, -1);
        }
        return this.connectStraightOverride(n2);
    }

    public boolean connectStraightOverride(int n) {
        return false;
    }

    public boolean connectInternal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        if (this.tile().partMap(PartMap.edgeBetween((int)n2, (int)this.side())) != null) {
            return false;
        }
        TMultiPart tMultiPart = this.tile().partMap(n2);
        if (tMultiPart instanceof IConnectable) {
            IConnectable iConnectable = (IConnectable)tMultiPart;
            return this.canConnectTo(iConnectable, n) && iConnectable.connectInternal((IConnectable)this, Rotation.rotationTo((int)n2, (int)this.side()));
        }
        return false;
    }

    public void notifyCornerChange(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2).offset(this.side());
        this.world().g(blockCoord.x, blockCoord.y, blockCoord.z, this.tile().q().cF);
    }

    public void notifyStraightChange(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        this.world().g(blockCoord.x, blockCoord.y, blockCoord.z, this.tile().q().cF);
    }

    public boolean maskConnects(int n) {
        return (this.connMap & 273 << n) != 0;
    }

    public Cuboid6 getBounds() {
        return FaceMicroClass.aBounds()[0x10 | this.side()];
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(oBoxes[this.side()]);
    }

    public boolean occlusionTest(TMultiPart tMultiPart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)tMultiPart);
    }

    public float getStrength(ata ata2, uf uf2) {
        return ata2.e == 1 ? 1.75f : 1.5f;
    }

    public ye getItem() {
        return this.getGateType().getItemStack();
    }

    public ye pickItem(ata ata2) {
        return this.getItem();
    }

    public Iterable<ye> getDrops() {
        return Arrays.asList(this.getItem());
    }

    public boolean activate(uf uf2, ata ata2, ye ye2) {
        if (this.getLogic().activate(this, uf2, ye2)) {
            return true;
        }
        if (ye2 != null && ye2.b() instanceof IScrewdriver) {
            if (!this.world().I) {
                if (uf2.ah()) {
                    this.configure();
                } else {
                    this.rotate();
                }
                ((IScrewdriver)ye2.b()).damageScrewdriver(this.world(), uf2);
            }
            return true;
        }
        return false;
    }

    public void configure() {
        boolean bl = this.getLogic().cycleShape(this);
        if (bl) {
            this.updateConnections();
            this.tile().markDirty();
            this.tile().notifyPartChange((TMultiPart)this);
            this.sendShapeUpdate();
            this.notifyNeighbors(15);
            this.onChange();
        }
    }

    public void rotate() {
        this.setRotation((this.rotation() + 1) % 4);
        this.updateConnections();
        this.tile().markDirty();
        this.tile().notifyPartChange((TMultiPart)this);
        this.sendOrientationUpdate();
        this.notifyNeighbors(15);
        this.onChange();
    }

    public MCDataOutput getWriteStream(int n) {
        return this.tile().getWriteStream((TMultiPart)this).writeByte(n);
    }

    public void sendShapeUpdate() {
        this.getWriteStream(1).writeByte((int)this.shape);
    }

    public void sendOrientationUpdate() {
        this.getWriteStream(0).writeByte((int)this.orientation);
    }

    public void notifyNeighbors(int n) {
        for (int i = 0; i < 4; ++i) {
            if ((n & 1 << i) != 0) {
                this.notifyCornerChange(i);
                continue;
            }
            if ((n & 16 << i) == 0) continue;
            this.notifyStraightChange(i);
        }
    }

    public void scheduledTick() {
        this.getLogic().scheduledTick(this);
    }

    public boolean connectCorner(IConnectable iConnectable, int n, int n2) {
        if (this.canConnectTo(iConnectable, n)) {
            this.connMap |= 1 << n;
            return true;
        }
        return false;
    }

    public boolean connectStraight(IConnectable iConnectable, int n, int n2) {
        if (this.canConnectTo(iConnectable, n)) {
            this.connMap |= 16 << n;
            return true;
        }
        return false;
    }

    public boolean connectInternal(IConnectable iConnectable, int n) {
        if (n < 0) {
            return false;
        }
        if (this.canConnectTo(iConnectable, n)) {
            this.connMap |= 256 << n;
            return true;
        }
        return false;
    }

    public boolean canConnectCorner(int n) {
        return false;
    }

    public int toInternal(int n) {
        return (n + 6 - this.rotation()) % 4;
    }

    public int toAbsolute(int n) {
        return (n + this.rotation() + 2) % 4;
    }

    public static int shiftMask(int n, int n2) {
        return (n << n2 | n >> 4 - n2) & 0xF;
    }

    public static int flipMaskZ(int n) {
        return n & 5 | n << 2 & 8 | n >> 2 & 2;
    }

    public int toAbsoluteMask(int n) {
        return GatePart.shiftMask(n, this.toAbsolute(0));
    }

    public int toInternalMask(int n) {
        return GatePart.shiftMask(n, this.toInternal(0));
    }

    public int relRot(int n) {
        return this.toInternal(Rotation.rotationTo((int)this.side(), (int)n));
    }

    public boolean canConnectTo(IConnectable iConnectable, int n) {
        return this.getLogic().canConnectTo(this, iConnectable, this.toInternal(n));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Vector3 vector3, LazyLightMatrix lazyLightMatrix, int n) {
        if (n == 0 && Configurator.staticGates) {
            CCRenderState.setBrightness((acf)this.world(), (int)this.x(), (int)this.y(), (int)this.z());
            RenderGate.renderStatic(this, vector3);
            CCRenderState.setColour((int)-1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 vector3, float f, int n) {
        if (n == 0) {
            TextureUtils.bindAtlas((int)0);
            if (!Configurator.staticGates) {
                GL11.glDisable((int)2896);
                CCRenderState.useModelColours((boolean)true);
                CCRenderState.startDrawing((int)7);
                RenderGate.renderStatic(this, vector3);
                CCRenderState.draw();
                CCRenderState.setColour((int)-1);
                GL11.glEnable((int)2896);
            }
            RenderGate.renderDynamic(this, vector3, f);
        }
    }

    public int getSlotMask() {
        return 1 << this.side();
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public boolean solid(int n) {
        return false;
    }

    public int getLightValue() {
        return this.getLogic().lightLevel();
    }

    @SideOnly(value=Side.CLIENT)
    public ms getBreakingIcon(Object object, int n) {
        return ComponentStore.baseIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public ms getBrokenIcon(int n) {
        return ComponentStore.baseIcon;
    }

    public void addHitEffects(ata ata2, beh beh2) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (ata)ata2, (beh)beh2);
    }

    public void addDestroyEffects(beh beh2) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (beh)beh2, (boolean)false);
    }

    public abstract String getType();

    static {
        GatePart.oBoxes[0][0] = new Cuboid6(0.125, 0.0, 0.0, 0.875, 0.125, 1.0);
        GatePart.oBoxes[0][1] = new Cuboid6(0.0, 0.0, 0.125, 1.0, 0.125, 0.875);
        for (int i = 1; i < 6; ++i) {
            Transformation transformation = Rotation.sideRotations[i].at(Vector3.center);
            GatePart.oBoxes[i][0] = oBoxes[0][0].copy().apply(transformation);
            GatePart.oBoxes[i][1] = oBoxes[0][1].copy().apply(transformation);
        }
    }
}

