/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory;

import mrtjp.projectred.core.inventory.GhostWidget;

public class WidgetTextBox
extends GhostWidget {
    private String text;
    private boolean isFocused = false;
    private boolean isEnabled = true;
    public int maxStringLength;
    public int cursorCounter;
    public String actionCommand;
    private String allowedcharacters;

    public WidgetTextBox(int n, int n2, int n3, int n4, String string) {
        super(n, n2, n3, n4);
        this.text = string;
        this.allowedcharacters = v.a;
    }

    public WidgetTextBox setActionCommand(String string) {
        this.actionCommand = string;
        return this;
    }

    public void setText(String string) {
        if (string.equals(this.text)) {
            return;
        }
        String string2 = this.text;
        this.text = string;
        this.onTextChanged(string2);
    }

    public void onTextChanged(String string) {
    }

    public final String getText() {
        return this.text;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        if (!this.isEnabled && this.isFocused) {
            this.setFocused(false);
        }
    }

    public final boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public void update() {
        ++this.cursorCounter;
    }

    @Override
    public void keyTyped(char c, int n) {
        if (!this.isEnabled || !this.isFocused) {
            return;
        }
        if (c == '\u0016') {
            String string = awe.l();
            if (string == null || string.equals("")) {
                return;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (this.text.length() == this.maxStringLength) {
                    return;
                }
                char c2 = string.charAt(i);
                if (!this.canAddChar(c2)) continue;
                this.setText(this.text + c2);
            }
        }
        if (n == 28) {
            this.setFocused(false);
            this.sendAction(this.actionCommand);
        }
        if (n == 14 && this.text.length() > 0) {
            this.setText(this.text.substring(0, this.text.length() - 1));
        }
        if ((this.text.length() < this.maxStringLength || this.maxStringLength == 0) && this.canAddChar(c)) {
            this.setText(this.text + c);
        }
    }

    public boolean canAddChar(char c) {
        return this.allowedcharacters.indexOf(c) >= 0;
    }

    @Override
    public void mouseClicked(int n, int n2, int n3) {
        if (this.isEnabled && this.pointInside(n, n2)) {
            this.setFocused(true);
            if (n3 == 1) {
                this.setText("");
            }
        } else {
            this.setFocused(false);
        }
    }

    public void setFocused(boolean bl) {
        if (bl == this.isFocused) {
            return;
        }
        this.isFocused = bl;
        this.onFocusChanged();
    }

    public void onFocusChanged() {
        if (this.isFocused) {
            this.cursorCounter = 0;
        }
    }

    @Override
    public void drawBack(int n, int n2, float f) {
        this.drawBackground();
        this.drawText();
    }

    public void drawBackground() {
        WidgetTextBox.a((int)(this.x() - 1), (int)(this.y() - 1), (int)(this.x() + this.width() + 1), (int)(this.y() + this.height() + 1), (int)-6250336);
        WidgetTextBox.a((int)this.x(), (int)this.y(), (int)(this.x() + this.width()), (int)(this.y() + this.height()), (int)-16777216);
    }

    public String getDrawText() {
        String string = this.getText();
        if (this.isEnabled && this.isFocused && this.cursorCounter / 6 % 2 == 0) {
            string = string + "_";
        }
        return string;
    }

    public void drawText() {
        this.b(this.fontRenderer(), this.getDrawText(), this.x() + 4, this.y() + this.height() / 2 - 4, this.getTextColour());
    }

    public int getTextColour() {
        return this.isEnabled ? 0xE0E0E0 : 0x707070;
    }

    public WidgetTextBox setMaxStringLength(int n) {
        this.maxStringLength = n;
        return this;
    }

    public WidgetTextBox setAllowedCharacters(String string) {
        if (string == null || string.isEmpty()) {
            string = v.a;
        }
        this.allowedcharacters = string;
        return this;
    }
}

