/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.IRetroGenerator;
import mrtjp.projectred.core.PRLogger;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.world.ChunkDataEvent;

public class RetroactiveWorldGenerator {
    public static final RetroactiveWorldGenerator instance = new RetroactiveWorldGenerator();
    String RetroGenID = Configurator.retroGenID;
    String RetroGenNBT = "RetrogenData_";
    private static ArrayList<IRetroGenerator> generators = new ArrayList();
    private static ArrayList<RetroGenQueue> generationQueue = new ArrayList();

    public static void registerRetroGenerator(IRetroGenerator g) {
        generators.add(g);
    }

    @SubscribeEvent
    public void chunkLoad(ChunkDataEvent.Load event) {
        this.queueRetroactiveGeneration(event);
    }

    private void queueRetroactiveGeneration(ChunkDataEvent.Load event) {
        World w = event.world;
        RetroDatabase database = this.getRetroDatabase(w);
        int x = event.getChunk().field_76635_g;
        int z = event.getChunk().field_76647_h;
        for (IRetroGenerator rg : generators) {
            if (!rg.shouldGenerateInLocation(w, event.getChunk()) || !database.isGenerationNeeded(x, z, rg.getSubgenerationID())) continue;
            PRLogger.info("Chunk @(" + x + "," + z + ",DIM" + w.field_73011_w.field_76574_g + ") has been marked for retroactive generation for ID " + rg.getSubgenerationID());
            generationQueue.add(new RetroGenQueue(w, x, z, rg));
            database.markChunkRetroGenerated(x, z, rg.getSubgenerationID());
        }
    }

    private RetroDatabase getRetroDatabase(World w) {
        RetroDatabase database = (RetroDatabase)w.perWorldStorage.func_75742_a(RetroDatabase.class, this.RetroGenNBT + this.RetroGenID);
        if (database == null) {
            database = new RetroDatabase(this.RetroGenNBT + this.RetroGenID);
            w.perWorldStorage.func_75745_a(this.RetroGenNBT + this.RetroGenID, (WorldSavedData)database);
            PRLogger.info("Created Retrogen database for dimension " + w.field_73011_w.field_76574_g);
        }
        return database;
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.runRetroactiveGeneration(event.world);
        }
    }

    private void runRetroactiveGeneration(World w1) {
        if (generationQueue.size() == 0) {
            return;
        }
        if (w1.func_72820_D() % 10L != 0L) {
            return;
        }
        ArrayList<RetroGenQueue> removeQueue = new ArrayList<RetroGenQueue>();
        ArrayList iterationQueue = (ArrayList)generationQueue.clone();
        int count = 0;
        for (RetroGenQueue q : iterationQueue) {
            q.gen.generate(q.w.field_73012_v, q.w, q.chunkX, q.chunkZ);
            removeQueue.add(q);
            if (++count < 32) continue;
            break;
        }
        generationQueue.removeAll(removeQueue);
        PRLogger.info(count + " chunks have been re-generated. " + generationQueue.size() + " left.");
    }

    public static class RetroDatabase
    extends WorldSavedData {
        private HashMap<LocHash, NBTTagCompound> chunks = new HashMap();

        public RetroDatabase(String par1Str) {
            super(par1Str);
        }

        public boolean isGenerationNeeded(int chunkX, int chunkZ, String subID) {
            NBTTagCompound chunkData = this.chunks.get(new LocHash(chunkX, chunkZ));
            return chunkData == null || !chunkData.func_74764_b(subID) || !chunkData.func_74767_n(subID);
        }

        public void markChunkRetroGenerated(int chunkX, int chunkZ, String subID) {
            NBTTagCompound chunkData = this.chunks.get(new LocHash(chunkX, chunkZ));
            if (chunkData == null) {
                chunkData = new NBTTagCompound();
            }
            chunkData.func_74757_a(subID, true);
            this.chunks.put(new LocHash(chunkX, chunkZ), chunkData);
            this.func_76185_a();
        }

        public void func_76184_a(NBTTagCompound nbt) {
            int size = nbt.func_74762_e("size");
            for (int i = 0; i < size; ++i) {
                this.chunks.put(new LocHash().readFromNBT(i + "hash", nbt), nbt.func_74775_l(i + "tag"));
            }
        }

        public void func_76187_b(NBTTagCompound nbt) {
            nbt.func_74768_a("size", this.chunks.size());
            int index = 0;
            for (LocHash i : this.chunks.keySet()) {
                i.writeToNBT(index + "hash", nbt);
                nbt.func_74782_a(index + "tag", (NBTBase)this.chunks.get(i));
                ++index;
            }
        }

        private class LocHash {
            int x;
            int z;

            public LocHash() {
            }

            public LocHash(int x, int z) {
                this.x = x;
                this.z = z;
            }

            public boolean equals(Object o) {
                if (o instanceof LocHash) {
                    LocHash l = (LocHash)o;
                    return l.x == this.x && l.z == this.z;
                }
                return false;
            }

            public int hashCode() {
                return (this.x ^ this.z) * 31 + 255;
            }

            public LocHash writeToNBT(String index, NBTTagCompound nbt) {
                nbt.func_74768_a(index + "locx", this.x);
                nbt.func_74768_a(index + "locz", this.z);
                return this;
            }

            public LocHash readFromNBT(String index, NBTTagCompound nbt) {
                this.x = nbt.func_74762_e(index + "locx");
                this.z = nbt.func_74762_e(index + "locz");
                return this;
            }
        }
    }

    class RetroGenQueue {
        final World w;
        final int chunkX;
        final int chunkZ;
        final IRetroGenerator gen;

        public RetroGenQueue(World w, int chunkX, int chunkZ, IRetroGenerator gen) {
            this.w = w;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.gen = gen;
        }
    }
}

