/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.world;

import java.util.LinkedList;
import java.util.Random;
import mrtjp.projectred.core.libmc.world.GeneratorOre;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class GeneratorVolcano
extends GeneratorOre {
    LinkedList<GeneratorOre.Evaluation> openList = new LinkedList();
    LinkedList<GeneratorOre.Evaluation> closedList = new LinkedList();

    public GeneratorVolcano(Block b, int meta, int veinSize) {
        super(b, meta, veinSize);
    }

    @Override
    public boolean func_76484_a(World w, Random rand, int x, int y, int z) {
        if (w.func_147439_a(x, y, z) != Blocks.field_150353_l) {
            return false;
        }
        int grass = this.makeLavaTube(w, x, y, z);
        int head = 3;
        int spread = rand.nextInt(1);
        int yIndex = grass;
        while (this.veinSize > 0) {
            int evalLevel;
            boolean reachedTop = false;
            while (this.openList.size() == 0) {
                w.func_147449_b(x, yIndex, z, (Block)Blocks.field_150356_k);
                this.closedList.clear();
                this.evaluateNeighbors(x, yIndex, z, head, rand);
                if (++yIndex <= 125) continue;
                reachedTop = true;
                break;
            }
            if (reachedTop) break;
            GeneratorOre.Evaluation nextEval = this.openList.removeFirst();
            if (!w.func_72899_e(nextEval.x, 64, nextEval.z)) continue;
            int pow = this.getClosedEval((int)nextEval.x, (int)nextEval.z).sides;
            for (evalLevel = w.func_72976_f(nextEval.x, nextEval.z); evalLevel > 0 && this.isUnimportant(w.func_147439_a(nextEval.x, evalLevel - 1, nextEval.z)); --evalLevel) {
            }
            if (evalLevel > nextEval.y || !this.isUnimportant(w.func_147439_a(nextEval.x, evalLevel, nextEval.z))) continue;
            this.purgeArea(w, nextEval.x, evalLevel, nextEval.z);
            w.func_147465_d(nextEval.x, evalLevel, nextEval.z, this.b, this.meta, 3);
            if (nextEval.y > evalLevel) {
                pow = Math.max(pow, spread);
            }
            this.evaluateNeighbors(nextEval.x, evalLevel, nextEval.z, pow, rand);
            --this.veinSize;
        }
        w.func_147449_b(x, yIndex, z, Blocks.field_150353_l);
        while (yIndex > grass && w.func_147439_a(x, yIndex, z) == Blocks.field_150353_l) {
            w.func_147471_g(x, yIndex, z);
            w.func_147459_d(x, yIndex, z, Blocks.field_150353_l);
            w.field_72999_e = true;
            Blocks.field_150353_l.func_149674_a(w, x, yIndex, z, rand);
            w.field_72999_e = false;
            --yIndex;
        }
        return true;
    }

    public void purgeArea(World world, int x, int y, int z) {
        Block center = world.func_147439_a(x, y, z);
        if (center == Blocks.field_150350_a) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Block block = world.func_147439_a(x + i, y, z + j);
                if (block == Blocks.field_150433_aE) {
                    world.func_147468_f(x + i, y, z + j);
                    continue;
                }
                if (block != Blocks.field_150364_r && block != Blocks.field_150362_t && block != Blocks.field_150395_bd) continue;
                world.func_147468_f(x + i, y, z + j);
            }
        }
        this.purgeArea(world, x, y + 1, z);
    }

    private GeneratorOre.Evaluation getClosedEval(int x, int z) {
        for (GeneratorOre.Evaluation e : this.closedList) {
            if (e.x != x || e.z != z) continue;
            return e;
        }
        return null;
    }

    private void addBlockForEvaluation(int x, int y, int z, int sides) {
        if (sides <= 0) {
            return;
        }
        GeneratorOre.Evaluation eval = this.getClosedEval(x, z);
        if (eval != null && sides <= eval.sides) {
            return;
        }
        GeneratorOre.Evaluation newEval = new GeneratorOre.Evaluation(x, y, z, sides);
        this.openList.addLast(newEval);
        this.closedList.add(newEval);
    }

    private void evaluateNeighbors(int x, int y, int z, int sides, Random random) {
        this.addBlockForEvaluation(x - 1, y, z, random.nextInt(2) > 0 ? sides - 1 : sides);
        this.addBlockForEvaluation(x + 1, y, z, random.nextInt(2) > 0 ? sides - 1 : sides);
        this.addBlockForEvaluation(x, y, z - 1, random.nextInt(2) > 0 ? sides - 1 : sides);
        this.addBlockForEvaluation(x, y, z + 1, random.nextInt(2) > 0 ? sides - 1 : sides);
    }

    private int makeLavaTube(World w, int x, int y, int z) {
        int grassHeight = w.func_72976_f(x, z);
        while (this.isUnimportant(w.func_147439_a(x, grassHeight - 1, z))) {
            --grassHeight;
        }
        for (int i = y; i < grassHeight; ++i) {
            w.func_147449_b(x, i, z, (Block)Blocks.field_150356_k);
            w.func_147465_d(x - 1, i, z, this.b, this.meta, 3);
            w.func_147465_d(x + 1, i, z, this.b, this.meta, 3);
            w.func_147465_d(x, i, z - 1, this.b, this.meta, 3);
            w.func_147465_d(x, i, z + 1, this.b, this.meta, 3);
        }
        return grassHeight;
    }

    private boolean isUnimportant(Block b) {
        if (b == Blocks.field_150350_a) {
            return true;
        }
        if (b == Blocks.field_150358_i || b == Blocks.field_150355_j || b == Blocks.field_150364_r || b == Blocks.field_150363_s || b == Blocks.field_150362_t || b == Blocks.field_150361_u || b == Blocks.field_150395_bd || b == Blocks.field_150433_aE || b == Blocks.field_150432_aD) {
            return true;
        }
        return b instanceof BlockFlower;
    }
}

