/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.lib;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class PostponedWorkItem<T>
implements Delayed {
    private final long origin = System.currentTimeMillis();
    private final long delay;
    private final T workItem;

    public PostponedWorkItem(T workItem, long delay) {
        this.workItem = workItem;
        this.delay = delay;
    }

    public T getItem() {
        return this.workItem;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.delay - (System.currentTimeMillis() - this.origin), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed == this) {
            return 0;
        }
        if (delayed instanceof PostponedWorkItem) {
            long diff = this.delay - ((PostponedWorkItem)delayed).delay;
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
        long d = this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS);
        return d == 0L ? 0 : (d < 0L ? -1 : 1);
    }
}

