/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration;

import java.util.Random;
import mrtjp.projectred.ProjectRedExploration;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.IRetroGenerator;
import mrtjp.projectred.core.RetroactiveWorldGenerator;
import mrtjp.projectred.core.libmc.world.GeneratorCave;
import mrtjp.projectred.core.libmc.world.GeneratorOre;
import mrtjp.projectred.core.libmc.world.GeneratorVolcano;
import mrtjp.projectred.exploration.DecorativeStoneDefs;
import mrtjp.projectred.exploration.OreDefs;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;

public class RetroGenerationManager {
    public static void registerRetroGenerators() {
        if (Configurator.gen_Ruby) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenRuby());
        }
        if (Configurator.gen_Sapphire) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenSapphire());
        }
        if (Configurator.gen_Peridot) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenPeridot());
        }
        if (Configurator.gen_MarbleCave) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenMarbleCave());
        }
        if (Configurator.gen_Volcano) {
            RetroactiveWorldGenerator.registerRetroGenerator((IRetroGenerator)new RetrogenVolcano());
        }
    }

    static class RetrogenVolcano
    implements IRetroGenerator {
        RetrogenVolcano() {
        }

        public String getSubgenerationID() {
            return "pr_volcano";
        }

        public boolean shouldGenerateInLocation(World w, Chunk c) {
            if (w.field_73011_w.field_76577_b == WorldType.field_77138_c) {
                return false;
            }
            return w.field_73011_w.field_76574_g == 0;
        }

        public void generate(Random r, World w, int chunkX, int chunkZ) {
            int x = chunkX * 16 + r.nextInt(16);
            int y = r.nextInt(64);
            int z = chunkZ * 16 + r.nextInt(16);
            new GeneratorVolcano((Block)ProjectRedExploration.blockDecoratives(), DecorativeStoneDefs.BASALT().meta(), MathHelper.func_76136_a((Random)r, (int)32000, (int)64000)).func_76484_a(w, r, x, y, z);
        }
    }

    static class RetrogenMarbleCave
    implements IRetroGenerator {
        RetrogenMarbleCave() {
        }

        public String getSubgenerationID() {
            return "pr_marbleCave";
        }

        public boolean shouldGenerateInLocation(World w, Chunk c) {
            return w.field_73011_w.field_76574_g == 0;
        }

        public void generate(Random r, World w, int chunkX, int chunkZ) {
            int x = chunkX * 16 + r.nextInt(16);
            int y = 32 + r.nextInt(32);
            int z = chunkZ * 16 + r.nextInt(16);
            new GeneratorCave((Block)ProjectRedExploration.blockDecoratives(), DecorativeStoneDefs.MARBLE().meta(), r.nextInt(4096)).func_76484_a(w, r, x, y, z);
        }
    }

    static class RetrogenPeridot
    implements IRetroGenerator {
        RetrogenPeridot() {
        }

        public String getSubgenerationID() {
            return "pr_peridot";
        }

        public boolean shouldGenerateInLocation(World w, Chunk c) {
            int id = w.field_73011_w.field_76574_g;
            return id != -1 && id != 1;
        }

        public void generate(Random r, World w, int chunkX, int chunkZ) {
            for (int i = 0; i < 2; ++i) {
                int x = chunkX * 16 + r.nextInt(16);
                int y = r.nextInt(48);
                int z = chunkZ * 16 + r.nextInt(16);
                new GeneratorOre((Block)ProjectRedExploration.blockOres(), OreDefs.OREPERIDOT().meta(), 5).func_76484_a(w, r, x, y, z);
            }
        }
    }

    static class RetrogenSapphire
    implements IRetroGenerator {
        RetrogenSapphire() {
        }

        public String getSubgenerationID() {
            return "pr_sapphire";
        }

        public boolean shouldGenerateInLocation(World w, Chunk c) {
            int id = w.field_73011_w.field_76574_g;
            return id != -1 && id != 1;
        }

        public void generate(Random r, World w, int chunkX, int chunkZ) {
            for (int i = 0; i < 2; ++i) {
                int x = chunkX * 16 + r.nextInt(16);
                int y = r.nextInt(48);
                int z = chunkZ * 16 + r.nextInt(16);
                new GeneratorOre((Block)ProjectRedExploration.blockOres(), OreDefs.ORESAPPHIRE().meta(), 5).func_76484_a(w, r, x, y, z);
            }
        }
    }

    static class RetrogenRuby
    implements IRetroGenerator {
        RetrogenRuby() {
        }

        public String getSubgenerationID() {
            return "pr_ruby";
        }

        public boolean shouldGenerateInLocation(World w, Chunk c) {
            int id = w.field_73011_w.field_76574_g;
            return id != -1 && id != 1;
        }

        public void generate(Random r, World w, int chunkX, int chunkZ) {
            for (int i = 0; i < 2; ++i) {
                int x = chunkX * 16 + r.nextInt(16);
                int y = r.nextInt(48);
                int z = chunkZ * 16 + r.nextInt(16);
                new GeneratorOre((Block)ProjectRedExploration.blockOres(), OreDefs.ORERUBY().meta(), 5).func_76484_a(w, r, x, y, z);
            }
        }
    }
}

