/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration;

import cpw.mods.fml.common.registry.GameRegistry;
import mrtjp.projectred.ProjectRedExploration;
import mrtjp.projectred.core.PartDefs;
import mrtjp.projectred.core.ShapelessOreNBTRecipe;
import mrtjp.projectred.core.libmc.PRColors;
import mrtjp.projectred.exploration.DecorativeStoneDefs;
import mrtjp.projectred.exploration.ItemBackpack;
import mrtjp.projectred.exploration.OreDefs;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ExplorationRecipes {
    public static void initRecipes() {
        ExplorationRecipes.initOtherRecipes();
        ExplorationRecipes.initGemToolRecipes();
        ExplorationRecipes.initToolRecipes();
        ExplorationRecipes.initWorldRecipes();
    }

    public static void initOreDict() {
        for (int i = 0; i < 16; ++i) {
            OreDictionary.registerOre((String)ItemBackpack.oreDictionaryVal(), (ItemStack)new ItemStack((Item)ProjectRedExploration.itemBackpack(), 1, i));
        }
        OreDictionary.registerOre((String)"gemRuby", (ItemStack)PartDefs.RUBY().makeStack());
        OreDictionary.registerOre((String)"gemSapphire", (ItemStack)PartDefs.SAPPHIRE().makeStack());
        OreDictionary.registerOre((String)"gemPeridot", (ItemStack)PartDefs.PERIDOT().makeStack());
        OreDictionary.registerOre((String)"oreRuby", (ItemStack)OreDefs.ORERUBY().makeStack());
        OreDictionary.registerOre((String)"oreSapphire", (ItemStack)OreDefs.ORESAPPHIRE().makeStack());
        OreDictionary.registerOre((String)"orePeridot", (ItemStack)OreDefs.OREPERIDOT().makeStack());
    }

    private static void initGemToolRecipes() {
        ExplorationRecipes.addAxeRecipe(new ItemStack((Item)ProjectRedExploration.itemRubyAxe()), "gemRuby");
        ExplorationRecipes.addAxeRecipe(new ItemStack((Item)ProjectRedExploration.itemSapphireAxe()), "gemSapphire");
        ExplorationRecipes.addAxeRecipe(new ItemStack((Item)ProjectRedExploration.itemPeridotAxe()), "gemPeridot");
        ExplorationRecipes.addHoeRecipe(new ItemStack((Item)ProjectRedExploration.itemRubyHoe()), "gemRuby");
        ExplorationRecipes.addHoeRecipe(new ItemStack((Item)ProjectRedExploration.itemSapphireHoe()), "gemSapphire");
        ExplorationRecipes.addHoeRecipe(new ItemStack((Item)ProjectRedExploration.itemPeridotHoe()), "gemPeridot");
        ExplorationRecipes.addPickaxeRecipe(new ItemStack((Item)ProjectRedExploration.itemRubyPickaxe()), "gemRuby");
        ExplorationRecipes.addPickaxeRecipe(new ItemStack((Item)ProjectRedExploration.itemSapphirePickaxe()), "gemSapphire");
        ExplorationRecipes.addPickaxeRecipe(new ItemStack((Item)ProjectRedExploration.itemPeridotPickaxe()), "gemPeridot");
        ExplorationRecipes.addShovelRecipe(new ItemStack((Item)ProjectRedExploration.itemRubyShovel()), "gemRuby");
        ExplorationRecipes.addShovelRecipe(new ItemStack((Item)ProjectRedExploration.itemSapphireShovel()), "gemSapphire");
        ExplorationRecipes.addShovelRecipe(new ItemStack((Item)ProjectRedExploration.itemPeridotShovel()), "gemPeridot");
        ExplorationRecipes.addSwordRecipe(new ItemStack((Item)ProjectRedExploration.itemRubySword()), "gemRuby");
        ExplorationRecipes.addSwordRecipe(new ItemStack((Item)ProjectRedExploration.itemSapphireSword()), "gemSapphire");
        ExplorationRecipes.addSwordRecipe(new ItemStack((Item)ProjectRedExploration.itemPeridotSword()), "gemPeridot");
        ExplorationRecipes.addSawRecipe(new ItemStack((Item)ProjectRedExploration.itemGoldSaw()), new ItemStack(Items.field_151043_k));
        ExplorationRecipes.addSawRecipe(new ItemStack((Item)ProjectRedExploration.itemRubySaw()), "gemRuby");
        ExplorationRecipes.addSawRecipe(new ItemStack((Item)ProjectRedExploration.itemSapphireSaw()), "gemSapphire");
        ExplorationRecipes.addSawRecipe(new ItemStack((Item)ProjectRedExploration.itemPeridotSaw()), "gemPeridot");
        ExplorationRecipes.addSickleRecipe(new ItemStack((Item)ProjectRedExploration.itemWoodSickle()), "plankWood");
        ExplorationRecipes.addSickleRecipe(new ItemStack((Item)ProjectRedExploration.itemStoneSickle()), new ItemStack(Items.field_151145_ak));
        ExplorationRecipes.addSickleRecipe(new ItemStack((Item)ProjectRedExploration.itemIronSickle()), new ItemStack(Items.field_151042_j));
        ExplorationRecipes.addSickleRecipe(new ItemStack((Item)ProjectRedExploration.itemGoldSickle()), new ItemStack(Items.field_151043_k));
        ExplorationRecipes.addSickleRecipe(new ItemStack((Item)ProjectRedExploration.itemRubySickle()), "gemRuby");
        ExplorationRecipes.addSickleRecipe(new ItemStack((Item)ProjectRedExploration.itemSapphireSickle()), "gemSapphire");
        ExplorationRecipes.addSickleRecipe(new ItemStack((Item)ProjectRedExploration.itemPeridotSickle()), "gemPeridot");
        ExplorationRecipes.addSickleRecipe(new ItemStack((Item)ProjectRedExploration.itemDiamondSickle()), new ItemStack(Items.field_151045_i));
    }

    private static void addAxeRecipe(ItemStack o, Object m) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(o, new Object[]{"mm", "ms", " s", Character.valueOf('m'), m, Character.valueOf('s'), Items.field_151055_y}));
    }

    private static void addHoeRecipe(ItemStack o, Object m) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(o, new Object[]{"mm", " s", " s", Character.valueOf('m'), m, Character.valueOf('s'), Items.field_151055_y}));
    }

    private static void addPickaxeRecipe(ItemStack o, Object m) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(o, new Object[]{"mmm", " s ", " s ", Character.valueOf('m'), m, Character.valueOf('s'), Items.field_151055_y}));
    }

    private static void addShovelRecipe(ItemStack o, Object m) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(o, new Object[]{"m", "s", "s", Character.valueOf('m'), m, Character.valueOf('s'), Items.field_151055_y}));
    }

    private static void addSwordRecipe(ItemStack o, Object m) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(o, new Object[]{"m", "m", "s", Character.valueOf('m'), m, Character.valueOf('s'), Items.field_151055_y}));
    }

    private static void addSawRecipe(ItemStack o, Object m) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(o, new Object[]{"srr", "sbb", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('r'), "rodStone", Character.valueOf('b'), m}));
    }

    private static void addSickleRecipe(ItemStack o, Object m) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(o, new Object[]{" m ", "  m", "sm ", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('m'), m}));
    }

    private static void initOtherRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(Items.field_151007_F, 4), (Object[])new Object[]{"gw", Character.valueOf('g'), new ItemStack((Item)ProjectRedExploration.itemWoolGin(), 1, Short.MAX_VALUE), Character.valueOf('w'), Blocks.field_150325_L});
    }

    private static void initToolRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ProjectRedExploration.itemWoolGin()), (Object[])new Object[]{"sis", "sss", " s ", Character.valueOf('s'), Items.field_151055_y, Character.valueOf('i'), PartDefs.IRONCOIL().makeStack()});
        for (int i = 0; i < 16; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ProjectRedExploration.itemBackpack(), 1, i), new Object[]{"ccc", "cdc", "ccc", Character.valueOf('c'), PartDefs.WOVENCLOTH().makeStack(), Character.valueOf('d'), PRColors.get((int)i).getOreDict()}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreNBTRecipe(new ItemStack((Item)ProjectRedExploration.itemBackpack(), 1, i), new Object[]{ItemBackpack.oreDictionaryVal(), PRColors.get((int)i).getOreDict()}).setKeepNBT());
        }
    }

    private static void initWorldRecipes() {
        GameRegistry.addRecipe((ItemStack)DecorativeStoneDefs.MARBLEBRICK().makeStack(4), (Object[])new Object[]{"bb", "bb", Character.valueOf('b'), DecorativeStoneDefs.MARBLE().makeStack()});
        GameRegistry.addRecipe((ItemStack)DecorativeStoneDefs.BASALTBRICK().makeStack(4), (Object[])new Object[]{"bb", "bb", Character.valueOf('b'), DecorativeStoneDefs.BASALT().makeStack()});
        GameRegistry.addSmelting((ItemStack)DecorativeStoneDefs.BASALTCOBBLE().makeStack(), (ItemStack)DecorativeStoneDefs.BASALT().makeStack(), (float)0.0f);
        GameRegistry.addRecipe((ItemStack)DecorativeStoneDefs.RUBYBLOCK().makeStack(), (Object[])new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), PartDefs.RUBY().makeStack()});
        GameRegistry.addRecipe((ItemStack)DecorativeStoneDefs.SAPPHIREBLOCK().makeStack(), (Object[])new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), PartDefs.SAPPHIRE().makeStack()});
        GameRegistry.addRecipe((ItemStack)DecorativeStoneDefs.PERIDOTBLOCK().makeStack(), (Object[])new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), PartDefs.PERIDOT().makeStack()});
        GameRegistry.addShapelessRecipe((ItemStack)PartDefs.RUBY().makeStack(9), (Object[])new Object[]{DecorativeStoneDefs.RUBYBLOCK().makeStack()});
        GameRegistry.addShapelessRecipe((ItemStack)PartDefs.SAPPHIRE().makeStack(9), (Object[])new Object[]{DecorativeStoneDefs.SAPPHIREBLOCK().makeStack()});
        GameRegistry.addShapelessRecipe((ItemStack)PartDefs.PERIDOT().makeStack(9), (Object[])new Object[]{DecorativeStoneDefs.PERIDOTBLOCK().makeStack()});
        for (int i = 0; i < DecorativeStoneDefs.values().size(); ++i) {
            DecorativeStoneDefs.StoneVal s = (DecorativeStoneDefs.StoneVal)((Object)DecorativeStoneDefs.values().apply(i));
            ExplorationRecipes.addWallRecipe(new ItemStack((Block)ProjectRedExploration.blockDecorativeWalls(), 6, s.meta()), s.makeStack());
        }
    }

    private static void addWallRecipe(ItemStack o, ItemStack m) {
        GameRegistry.addRecipe((ItemStack)o, (Object[])new Object[]{"mmm", "mmm", Character.valueOf('m'), m});
    }
}

