/*
 * Decompiled with CFR 0.152.
 */
package com.countrygamer.core.lib;

import java.text.DecimalFormat;
import java.util.HashMap;
import net.minecraft.item.ItemStack;

public class CoreUtilHex {
    public static double[] getColorFromDye(ItemStack itemStack) {
        HashMap<Integer, String> hexFromMeta = new HashMap<Integer, String>();
        hexFromMeta.put(0, "000000");
        hexFromMeta.put(1, "ff0000");
        hexFromMeta.put(2, "00ff00");
        hexFromMeta.put(3, "502800");
        hexFromMeta.put(4, "0000ff");
        hexFromMeta.put(5, "640064");
        hexFromMeta.put(6, "006464");
        hexFromMeta.put(7, "bababa");
        hexFromMeta.put(8, "6b6b6b");
        hexFromMeta.put(9, "ff00ff");
        hexFromMeta.put(10, "006400");
        hexFromMeta.put(11, "ffff00");
        hexFromMeta.put(12, "00aaff");
        hexFromMeta.put(13, "e600e6");
        hexFromMeta.put(14, "ff9000");
        hexFromMeta.put(15, "ffffff");
        double[] sums = CoreUtilHex.getSumHex(hexFromMeta.containsKey(itemStack.func_77960_j()) ? (String)hexFromMeta.get(itemStack.func_77960_j()) : "");
        return sums;
    }

    public static double[] getSumHex(String hexString) {
        if (CoreUtilHex.isValidHexString(hexString)) {
            String r = "";
            String g = "";
            String b = "";
            char[] chars = hexString.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (i < 2) {
                    r = r + chars[i];
                    continue;
                }
                if (i < 4) {
                    g = g + chars[i];
                    continue;
                }
                if (i >= 6) continue;
                b = b + chars[i];
            }
            double rSum = CoreUtilHex.formatToDecimals(CoreUtilHex.getSumIndividualHex(r), 2, 2) / 30.0;
            double gSum = CoreUtilHex.formatToDecimals(CoreUtilHex.getSumIndividualHex(g), 2, 2) / 30.0;
            double bSum = CoreUtilHex.formatToDecimals(CoreUtilHex.getSumIndividualHex(b), 2, 2) / 30.0;
            rSum = CoreUtilHex.formatToDecimals(rSum, 2, 2);
            gSum = CoreUtilHex.formatToDecimals(gSum, 2, 2);
            bSum = CoreUtilHex.formatToDecimals(bSum, 2, 2);
            return new double[]{rSum, gSum, bSum};
        }
        return new double[]{-1.0, -1.0, -1.0};
    }

    public static double getSumIndividualHex(String digitsHex) {
        char[] chars;
        double sum = 0.0;
        HashMap<String, Integer> strToInt = CoreUtilHex.getHexValues();
        for (char letter : chars = digitsHex.toCharArray()) {
            String str = letter + "";
            sum += (double)strToInt.get(str.toLowerCase()).intValue();
        }
        return sum;
    }

    public static HashMap<String, Integer> getHexValues() {
        HashMap<String, Integer> strToInt = new HashMap<String, Integer>();
        strToInt.put("0", 0);
        strToInt.put("1", 1);
        strToInt.put("2", 2);
        strToInt.put("3", 3);
        strToInt.put("4", 4);
        strToInt.put("5", 5);
        strToInt.put("6", 6);
        strToInt.put("7", 7);
        strToInt.put("8", 8);
        strToInt.put("9", 9);
        strToInt.put("a", 10);
        strToInt.put("b", 11);
        strToInt.put("c", 12);
        strToInt.put("d", 13);
        strToInt.put("e", 14);
        strToInt.put("f", 15);
        return strToInt;
    }

    public static int convertRGBtoHex(int r, int g, int b) {
        int hex = -1;
        try {
            hex = Integer.parseInt(CoreUtilHex.convertRGBtoHexString(r, g, b));
        }
        catch (NumberFormatException e) {
            return 0;
        }
        return hex;
    }

    public static String convertRGBtoHexString(int r, int g, int b) {
        return String.format("%02x%02x%02x", r, g, b);
    }

    public static int[] convertHexToRGB(String hexString) {
        return new int[]{Integer.valueOf(hexString.substring(0, 2), 16), Integer.valueOf(hexString.substring(2, 4), 16), Integer.valueOf(hexString.substring(4, 6), 16)};
    }

    public static boolean isValidHexString(String str) {
        if (str.length() != 6) {
            return false;
        }
        boolean valid = false;
        char[] chars = str.toCharArray();
        HashMap<String, Integer> hexVals = CoreUtilHex.getHexValues();
        for (int i = 0; i < chars.length; ++i) {
            boolean bl = valid = hexVals.get(chars[i] + "") != null;
            if (valid) continue;
            return valid;
        }
        return true;
    }

    public static double formatToDecimals(double number, int maxInt, int decimals) {
        int i;
        String decimal = "";
        for (i = 0; i < maxInt; ++i) {
            decimal = decimal + "#";
        }
        decimal = decimal + ".";
        for (i = 0; i < decimals; ++i) {
            decimal = decimal + "#";
        }
        DecimalFormat df = new DecimalFormat(decimal);
        return Double.parseDouble(df.format(number));
    }
}

