/*
 * Decompiled with CFR 0.152.
 */
package com.countrygamer.core.lib;

import com.countrygamer.core.Core;
import com.countrygamer.core.lib.TeleporterCore;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;

public class CoreUtil {
    public static String configGeneral = "General";
    public static String configItemId = "Item IDs";
    public static String configBlockId = "Block IDs";
    public static String configAchievement = "Achievement IDs";
    public static String configAddon = "Addons";
    public static final float oneSixteenth = 0.0625f;

    public static HashMap<ItemStack, ItemStack> getBasicOreDict() {
        HashMap<ItemStack, ItemStack> oreDict = new HashMap<ItemStack, ItemStack>();
        String[] oreNames = new String[]{"Coal", "Iron", "Gold", "Lapis", "Redstone", "Diamond", "Emerald", "Copper", "Silver", "Tin", "Bronze", "Lead"};
        oreDict.put(new ItemStack(Blocks.field_150365_q, 1), new ItemStack(Items.field_151044_h, 1));
        oreDict.put(new ItemStack(Blocks.field_150366_p, 1), new ItemStack(Items.field_151042_j, 1));
        oreDict.put(new ItemStack(Blocks.field_150352_o, 1), new ItemStack(Items.field_151043_k, 1));
        oreDict.put(new ItemStack(Blocks.field_150482_ag, 1), new ItemStack(Items.field_151045_i, 1));
        oreDict.put(new ItemStack(Blocks.field_150369_x, 1), new ItemStack(Items.field_151100_aR, 1, 4));
        oreDict.put(new ItemStack(Blocks.field_150450_ax, 1), new ItemStack(Items.field_151137_ax, 1));
        oreDict.put(new ItemStack(Blocks.field_150412_bA, 1), new ItemStack(Items.field_151166_bC, 1));
        for (String oreName : oreNames) {
            ArrayList ores = OreDictionary.getOres((String)("ore" + oreName));
            for (ItemStack ore : ores) {
                ArrayList ingots = OreDictionary.getOres((String)("ingot" + oreName));
                if (ingots.isEmpty()) continue;
                oreDict.put(ore, (ItemStack)ingots.get(0));
            }
        }
        return oreDict;
    }

    public static HashMap<String, Integer> getCardinalByBlockSide() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        ret.put("bottom", 0);
        ret.put("top", 1);
        ret.put("north", 2);
        ret.put("south", 3);
        ret.put("west", 4);
        ret.put("east", 5);
        return ret;
    }

    public static int getAndComment(Configuration config, String cate, String name, String comment, int value) {
        Property property = config.get(cate, name, value);
        if (!comment.equals("")) {
            property.comment = comment;
        }
        return property.getInt();
    }

    public static String getAndComment(Configuration config, String cate, String name, String comment, String value) {
        Property property = config.get(cate, name, value);
        if (!comment.equals("")) {
            property.comment = comment;
        }
        return property.getString();
    }

    public static boolean getAndComment(Configuration config, String cate, String name, String comment, boolean value) {
        Property property = config.get(cate, name, value);
        if (!comment.equals("")) {
            property.comment = comment;
        }
        return property.getBoolean(false);
    }

    public static int getUniqueEntityId() {
        int entityid = 0;
        while (EntityList.func_75617_a((int)(++entityid)) != null) {
        }
        return entityid;
    }

    public static boolean isModLoaded(String targetModid) {
        if (Loader.isModLoaded((String)targetModid)) {
            try {
                return true;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return false;
    }

    public static boolean teleportPlayerToDimension(EntityPlayer player, int dimensionID) {
        if (player.field_71093_bK != dimensionID) {
            if (player instanceof EntityPlayerMP) {
                WorldServer ws = (WorldServer)player.field_70170_p;
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                if (player.field_70154_o == null && player.field_70153_n == null) {
                    playerMP.field_71133_b.func_71203_ab().transferPlayerToDimension(playerMP, dimensionID, (Teleporter)new TeleporterCore(ws));
                    if (player.field_71093_bK == dimensionID) {
                        return true;
                    }
                } else if (Core.DEBUG) {
                    Core.log.info("Riding entity stuff");
                }
            } else if (Core.DEBUG) {
                Core.log.info("Not PlayerMP");
            }
        } else if (Core.DEBUG) {
            Core.log.info("Player and destination dim are equal");
        }
        return false;
    }

    public static void teleportPlayer(EntityPlayer player, double x, double y, double z, boolean fallDamage, boolean particles) {
        if (!fallDamage) {
            player.field_70143_R = 0.0f;
        }
        player.func_70634_a(x, y, z);
        player.func_70082_c(player.field_70177_z, player.field_70125_A);
        if (particles) {
            Random rand = new Random();
            double d3 = x;
            double d4 = y;
            double d5 = z;
            int l = 128;
            for (int j1 = 0; j1 < l; ++j1) {
                double d6 = (double)j1 / ((double)l - 1.0);
                float f = (rand.nextFloat() - 0.5f) * 0.2f;
                float f1 = (rand.nextFloat() - 0.5f) * 0.2f;
                float f2 = (rand.nextFloat() - 0.5f) * 0.2f;
                double d7 = d3 + (player.field_70165_t - d3) * d6 + (rand.nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
                double d8 = d4 + (player.field_70163_u - d4) * d6 + rand.nextDouble() * (double)player.field_70131_O;
                double d9 = d5 + (player.field_70161_v - d5) * d6 + (rand.nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
                player.field_70170_p.func_72869_a("portal", d3, d4, d5, d7, d8, d9);
            }
        }
    }

    public static void teleportPlayer(EntityPlayer player, int minimumRange, int maximumRange, double centerX, double centerZ, boolean fallDamage, boolean particles) {
        double[] newPos = CoreUtil.teleportBase(player.field_70170_p, player, minimumRange, maximumRange, centerX, centerZ);
        CoreUtil.teleportPlayer(player, newPos[0], newPos[1], newPos[2], fallDamage, particles);
    }

    public static double[] teleportBase(World world, EntityPlayer player, int minimumRange, int maximumRange, double x, double z) {
        Random rand = new Random();
        int rangeDifference = 2 * (maximumRange - minimumRange);
        int offsetX = rand.nextInt(rangeDifference) - rangeDifference / 2 + minimumRange;
        int offsetZ = rand.nextInt(rangeDifference) - rangeDifference / 2 + minimumRange;
        double newX = (double)(MathHelper.func_76128_c((double)x) + offsetX) + 0.5;
        double newY = rand.nextInt(128);
        double newZ = (double)(MathHelper.func_76128_c((double)z) + offsetZ) + 0.5;
        double bbMinX = newX - (double)player.field_70130_N / 2.0;
        double bbMinY = newY - (double)player.field_70129_M + (double)player.field_70139_V;
        double bbMinZ = newZ - (double)player.field_70130_N / 2.0;
        double bbMaxX = newX + (double)player.field_70130_N / 2.0;
        double bbMaxY = newY - (double)player.field_70129_M + (double)player.field_70139_V + (double)player.field_70131_O;
        double bbMaxZ = newZ + (double)player.field_70130_N / 2.0;
        AxisAlignedBB boundingBox = AxisAlignedBB.func_72330_a((double)bbMinX, (double)bbMinY, (double)bbMinZ, (double)bbMaxX, (double)bbMaxY, (double)bbMaxZ);
        Chunk teleportChunk = world.func_72938_d((int)newX, (int)newZ);
        if (!teleportChunk.field_76636_d) {
            world.func_72863_F().func_73158_c(teleportChunk.field_76635_g, teleportChunk.field_76647_h);
        }
        while (newY > 0.0 && newY < 128.0 && !world.func_72945_a((Entity)player, boundingBox).isEmpty()) {
            bbMinY = (newY += 1.0) - (double)player.field_70129_M + (double)player.field_70139_V;
            bbMaxY = newY - (double)player.field_70129_M + (double)player.field_70139_V + (double)player.field_70131_O;
            boundingBox.func_72324_b(bbMinX, bbMinY, bbMinZ, bbMaxX, bbMaxY, bbMaxZ);
        }
        do {
            bbMinY = (newY -= 1.0) - (double)player.field_70129_M + (double)player.field_70139_V;
            bbMaxY = newY - (double)player.field_70129_M + (double)player.field_70139_V + (double)player.field_70131_O;
            boundingBox.func_72324_b(bbMinX, bbMinY, bbMinZ, bbMaxX, bbMaxY, bbMaxZ);
        } while (newY > 0.0 && newY < 128.0 && world.func_72945_a((Entity)player, boundingBox).isEmpty());
        Block block = world.func_147439_a(MathHelper.func_76128_c((double)newX), MathHelper.func_76128_c((double)(newY += 1.0)), MathHelper.func_76128_c((double)newZ));
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k || block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return CoreUtil.teleportBase(world, player, minimumRange, maximumRange, x, z);
        }
        return new double[]{newX, newY, newZ};
    }

    private static void teleportVector(World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            Vec3 vec3 = player.func_70666_h(1.0f);
            vec3.field_72448_b += 1.0;
            Vec3 lookVec = player.func_70676_i(1.0f);
            Vec3 addedVector = vec3.func_72441_c(lookVec.field_72450_a * 1000.0, lookVec.field_72448_b * 1000.0, lookVec.field_72449_c * 1000.0);
            MovingObjectPosition movingObjPos = world.func_147447_a(vec3, addedVector, true, true, false);
            if (movingObjPos != null && movingObjPos.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                int x = movingObjPos.field_72311_b;
                int y = movingObjPos.field_72312_c;
                int z = movingObjPos.field_72309_d;
                CoreUtil.teleportPlayer(player, (double)x + 0.5, y + 1, (double)z + 0.5, false, false);
            }
        }
    }

    public static boolean breakBlockAsPlayer(World world, EntityPlayer player, int x, int y, int z, Block block) {
        if (player == null || world == null) {
            return false;
        }
        WorldClient worldclient = Minecraft.func_71410_x().field_71441_e;
        worldclient.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (worldclient.func_72805_g(x, y, z) << 12));
        int meta = world.func_72805_g(x, y, z);
        world.func_147468_f(x, y, z);
        block.func_149664_b(world, x, y, z, meta);
        return true;
    }

    public static int posOrNeg(int i) {
        if (i == 0) {
            System.err.print("Parameter is neither positive nor negative");
            return 1;
        }
        if (i >> 31 != 0) {
            return -1;
        }
        return 1;
    }

    public static int getDirection(EntityPlayer player) {
        return MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
    }

    public static void dropItemStack(World world, ItemStack itemStack, int x, int y, int z) {
        CoreUtil.dropItemStack(world, itemStack, x, y, z, null);
    }

    public static void dropItemStack(World world, ItemStack itemStack, int x, int y, int z, NBTTagCompound tagCom) {
        Random rand = new Random();
        float f = rand.nextFloat() * 0.8f + 0.1f;
        float f1 = rand.nextFloat() * 0.8f + 0.1f;
        if (!world.field_72995_K) {
            float f2 = rand.nextFloat() * 0.8f + 0.1f;
            while (itemStack.field_77994_a > 0) {
                int k1 = rand.nextInt(21) + 10;
                if (k1 > itemStack.field_77994_a) {
                    k1 = itemStack.field_77994_a;
                }
                itemStack.field_77994_a -= k1;
                ItemStack itemstack = new ItemStack(itemStack.func_77973_b(), k1, itemStack.func_77960_j());
                if (tagCom != null) {
                    itemstack.func_77982_d((NBTTagCompound)tagCom.func_74737_b());
                }
                EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), itemstack);
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)rand.nextGaussian() * f3;
                entityitem.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)rand.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public static boolean chance(int percent) {
        return new Random().nextInt(100) < percent;
    }

    public static float getGhostItemScaleFactor(RenderItem itemRender, ItemStack itemStack) {
        float scaleFactor = 1.0f;
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof ItemBlock) {
                switch (itemRender.getMiniBlockCount(itemStack, (byte)0)) {
                    case 1: {
                        return 0.9f;
                    }
                    case 2: {
                        return 0.9f;
                    }
                    case 3: {
                        return 0.9f;
                    }
                    case 4: {
                        return 0.9f;
                    }
                    case 5: {
                        return 0.8f;
                    }
                }
                return 0.9f;
            }
            switch (itemRender.getMiniItemCount(itemStack, (byte)0)) {
                case 1: {
                    return 0.65f;
                }
                case 2: {
                    return 0.65f;
                }
                case 3: {
                    return 0.65f;
                }
                case 4: {
                    return 0.65f;
                }
            }
            return 0.65f;
        }
        return scaleFactor;
    }
}

